<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Parametric surfaces [11.6]
</title>
<meta name="week" content="10">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>
<!--&#128683;-->

<h1>
Parametric surfaces [11.6]
</h1>
<p class="show"><img src="0g/10.5.Gehry.jpg">
<br>
<i>Walt Disney concert hall, Los Angeles, architect: Frank Gehry</i>
<ul class="else"><li>Alternate ways to describe a surface,
<li>In high symmetry situations, a different parameterization may be simpler (than Cartesian coordinates!)
<li>Eventually we'd like to answer questions like "how much aluminum will we need for that concert hall roof?".
</ul>


<h3></h3>

<p class="show">A vector function $\myv r(t)=\myc{f(t),g(t),h(t)}$ of a <i>single</i> parameter described a curve (quasi-1d object) in space.  
<p>A surface is a quasi-2d object.  So we'll use <b>two parameters</b> to parameterize such an object.

<ul>
<li>Suppose that $$\nonumber \myv r(u,v)=\langle x(u,v), y(u,v), z(u,v) \rangle$$
is a vector-valued function,
<li>Defined on a region $D$ of the $u$- $v$-plane.  (parameter space)
<li>As $(u,v)$ varies throughout $D$, then $\myv r$ traces out a <b>surface</b> $S$ in 3 dimensions.
</ul>
<p class="show"><img src="0g/10.5.uv2r.jpg" class="big">

<h3> $x$ and $y$ as 'parameters'</h3>
<p class="show">Plot the surface defined by
$$z=\frac{x^2+2y^2}3.$$

<p>For our two parameters, we could just use $u=x$, $v=y$, and then 
$z=\frac{u^2+2v^2}3.$

<p>Turning this into a vector function of $u$ and $v$:
$$\myv r=\langle u, v, (u^2+2v^2)/3 \rangle$$

<p class="todo">Try copying this code into GeoGebra to reproduce the surface below...<br>
<code>Surface(u,v,(u^2+2*v^2)/3,u,-1,2,v,-1,2)</code>
<br>
What happens if you change the numbers (ranges) after <tt>u</tt> and <tt>v</tt> in the code above?
<p class="center"><img src="0g/10.5.GeoParametric.jpg">



<h3>Example: plane</h3>
<p class="show">$$\myv r(u,v)=\myv r_0 + u\myv a+v\myv b$$
<p class="show center"><img src="0g/10.5.plane.jpg">
<p class="todo">Using $\myv r_0=\myc{0,0,3}$, $\myv a=\myc{1,0,0}$, and $\myv b=\myc{1,1,1}$, figure out how to code a <tt>Surface(....)</tt> function in Geogebra for a partial plane, such that the parameters run like this:  $-1\lt u \lt 3$ and $-1\lt v \lt 4$.

<h3>Example: cylinder</h3>

<p class="show">$$\myv r(u,v)=\langle 2\cos u, v, 2\sin u  \rangle$$
<p class="show center"><img src="0g/10.5.cylinder.jpg">
<p>It is also common to have one or more of the parameters representing some angle.

<p class="todo">Render in Geogebra the cylindrical surface ab for $-1\lt v\lt 3$.  Figure out what the starting and ending value of $u$ should be in order to produce the cylinder.

<h3>A spherical surface</h3>
<div class="todo">
<p>Do <a href="https://activecalculus.org/multi/S-11-6-Parametric-Surfaces-Surface-Area.html#A_11_6_10">A 11.6.2 - Make the surface of a sphere</a>
<p><b>a.</b> Let $s$ be an angle, such that $\frac{-\pi}2 \lt s \lt \frac{\pi}2$. Let $R=2$.  Find $x(s)$ and $z(s)$, and code those into GeoGebra (replace the functions below) so as to create the half-circle in the $x$-$z$ plane
<br>
<code>Surface( <i>[x(s)]</i>, 0, <i>[z(s)]</i>, s, -pi/2, pi/2)</code>
<p><b>b.</b> Yes, think about the radius (distance from the $z$ axis) of a point as you rotate one of the points in your half-circle about the $z$-axis.
 Think about how to write coordinates $x(t)$ and $y(t)$ in terms of a circle of this radius.
<p><b>c.</b> Eventually you'll have a cell in GeoGebra that looks like<br>
<code>Surface( <i>[x(s,t)], [y(s,t)], [z(s,t)]</i>, s, -pi/2, pi/2, t, <i>[tmin], [tmax]</i> )</code>
</div>

<h3>Choosing parameters based on symmetries/forms</h3>
<!--<p class="show">See <a href="10.5.nb">10.5.nb</a>.-->
<p class="show">Consider the points that fulfill:
$$\frac{x^2}{4}+y^2+\frac{z^2}{4} = 1$$
<p>You could solve for $z$:
$$z=\pm\sqrt{4\left( 1-\frac{x^2}{4}-y^2 \right)} $$
and plot $\myc{x, y, z(x,y)}$.

<p>Or, we re-arrange the equation into 
$$x^2+z^2 = 4(1-y^2).$$
We recognize the left side as the equation for a circle with a 
radius $\sqrt{4(1-y^2)}$ that depends on $y$.  

<p>This suggests that we write the *radius* as one of the parameters, 
$u=2\sqrt{1-y^2}$ (and inverting: $y=\sqrt{1-\frac14 u^2}$), and then we could write $x$ and $y$ in terms of a
"polar angle" parameter $v$ sweeping around a circle of radius $u$ like this:
$$\myv r(u,v)=\myc{u\cos v,\sqrt{1-\frac14u^2},u\sin v}$$


<h4 class="handout">Image credits</h4>
<p class="handout"><a href="https://www.flickr.com/photos/jimmyyeh1982/13025903825">Jimmy Yeh</a>

<?php include "../../classes/3.h" ?>