<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Triples...in cylindrical and spherical coordinates [11.8+]
</title>
<meta name="week" content="12">
<?php include "../../classes/2.h" ?>

<h1>
Triple Integrals in cylindrical and spherical coordinates [11.8]
</h1>
<p class="show"><img src="0g/12.8.saucer.jpg" class="big">

<h3>Cylindrical coordinates</h3>
<p class="show"><img src="0g/12.7.cylindricaldV.jpg" class="rightalign">
The figure shown is very approximately a "box" with volume
$$dV=(r\,d\theta)(dr)(dz)=r\,dr\,d\theta\,dz.$$

<h3>Spherical Polar coordinates</h3>
<p class="show"><img src="0g/12.7.sphericalpolardV.jpg" class="rightalign">
The figure shown is very approximately a "box" with volume
$$dV=(\rho\,d\phi)(\rho\sin\phi\,d\theta)(d\rho)=\rho^2\sin\phi\,d\rho\,d\theta\,d\phi.$$
<br>
<img src="0g/12.7.sphericalpolardV3.jpg"><br>
 
<h3>Setting up volume integrals</h3>
<p class="show todo"><img src="0g/12.8.prob56.jpg" class="big">



<h3 id="mtfuji">Raising Mt Fuji!</h3>
<p class="show"><img src="0g/MtFuji.jpeg" class="big"><br>
<span class="caption"><a href="https://flickr.com/photos/trevor_dobson_inefekt69/43847958635">Trevor Dobson</a></span>
<p class="todo">Problem 41.  <b>Total work (energy) needed to create Mt Fuji</b>
~Right circular cone with...
<ul class="todo"><li>Radius of bottom=62,000 ft ~ 19 km=19,000m.
<li>Height of 12,400ft=3780m.
<li>Rock has an average density of $\rho=$200 lbs/ft^3 = 3,200 kg/m^3. (Sorry folks, $rho$ is also the typical symbol used for density!  <b>This $rho=3200$ kg/m^3 is not the spherical-polar distance from the origin!!!</b>
<li>Force of gravity (weight)=$mg$, where $m$ is mass (kg) and $g\approx 10$ m/s^2.
<li>Energy to lift a mass:  The work (energy) $W$ need to lift a mass $m$ through  a height difference $h$ is $$W=mgh.$$ if height has units of meters, $g\approx 10$ m/s^2, and $m$ is in kilograms, then $mgh$ will have units of <i>Joules</i>.
</ul>

<p>It may be easiest to set up the integral <i>as if you were only interested in the volume of Mt Fuji</i> first, and then add the energy after that.

<div class="justme result">

<br><img src="0g/mtfuji.jpg">
<br>
Thinking of Mt Fuji as a right-circular cone, with a radius at the base (at $z$=0 m) of 19,000 m, and a radius at the top ($z$=3780 m) of 0 m, we can write an expression for $r(z)$:
$$r(z)=19000 -\left(\frac{19000}{3780}\right)z = 19000 -5.03z.$$
So, we could calculate the volume  of Mt Fuji from a triple integral, in Cylindrical coordinates, where $\theta$ runs from 0 to $2\pi$, $z$ runs from 0 to 3780, and $r$ runs from 0 to the $r(z)$ (the function above).  Translating this into the limits on a triple integral...
$$\begineq V &= \iiint\,dV=\iiint rdr\,d\theta\,dz\\
  &=  \int_{z=0}^{3780}\int_{\theta=0}^{2\pi}\int_{r=0}^{19000-5.03z}rdr\,d\theta\,dz
  \endeq$$
  
</div>

Once you have the integral for the volume, you'd like to tweak it to integrate the energy of many small masses $dm=\rho\,dV$ And the work need to lift  each little chunk is $dE=dm\,gh=dm\,gz=\rho gz\,dV$.
<div class="justme result">
<img src="0g/12.8.fuji.jpg"><br>
The limits on the triple integral will be the same as what we used to calculate the volume, So the total energy is...
$$\begineq &E=\iiint dE=\iiint gh\,dm =\iiint g z \rho\, dV\\
  &=\int_{z=0}^{3780}\int_{\theta=0}^{2\pi}\int_{r=0}^{19000-5.03z}10*z*3200*rdr\,d\theta\,dz\\
  &=\int_{z=0}^{3780}\int_{\theta=0}^{2\pi}\int_{r=0}^{19000-5.03z}32,000zr\,dr\,d\theta\,dz\\
  \endeq$$

CoCalc says this is <span class='answer'> $E=4.32\times 10^{19}$ Joules</span>

</div>

<div class="todo">
Finish the problem by carrying out the triple integral to find the total energy needed to lift rocks into the shape of Mt Fuji.  You may either:
<ul><li>Carry out the integral by hand, take a picture of your work, and hand in the picture on Moodle,
<li>Or, carry out the integral in a CoCalc notebook.  Export your notebook to .pdf, and hand in the .pdf on Moodle.
</ul>
</div>

<p>Your answer above is in Joules (J).  <br><br>A large coal power plant, or nuclear plant, has power output of 2 gigawatts=2,000 megawatts=$2\times10^{9}$Joules/second:  In a year of continuous operation it puts out
$6.3\times 10^{16}$J.  
<p class="todo">How many months or  years would such a power plant need to operate to produce the energy content you calculated above?
<p class="justme result">This would take
$4.32\times 10^{19}$ Joules / $6.3\times 10^{16}$ Joules per year \approx$ <span class="answer">685 years!</span>

<h4 class="handout">Image credits</h4>
<p class="handout"><a href="https://www.flickr.com/photos/earlg/223768314">Earl G</a>


<?php include "../../classes/3.h" ?>
