(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     40262,        831]
NotebookOptionsPosition[     39508,        801]
NotebookOutlinePosition[     39861,        817]
CellTagsIndexPosition[     39818,        814]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Graphing - adding axes and point labels", "Section",
 CellChangeTimes->{{3.5443956477557034`*^9, 3.5443956488747673`*^9}, {
  3.6470054833307467`*^9, 3.6470054931115007`*^9}}],

Cell[TextData[{
 "[From Patricia Oakley]\n\nThis is not homework, but illustrations of two ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions to help you visualize relationships in 3-dimensional plots.  You \
may copy these functions into your own notebooks and use \
them!\[LineSeparator]\[LineSeparator]",
 StyleBox["myAxis", "Code"],
 " returns graphic primitives that create an axis in the given component \
direction with the given label in the given color from lo to hi; the axis is \
dashed for negative values.  \[LineSeparator]",
 StyleBox["myPoint", "Code"],
 " includes dashed lines indicating how one might plot the point by hand and \
a label for the point."
}], "Text",
 CellChangeTimes->{{3.5443931462386246`*^9, 3.5443931949874134`*^9}, {
  3.647004908807342*^9, 3.647004916736672*^9}, {3.647005055792616*^9, 
  3.647005143974482*^9}, {3.647005502627426*^9, 3.647005518828096*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"myAxis", "[", 
    RowBox[{
    "label_", ",", "color_", ",", "component_", ",", "lo_", ",", "hi_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e", ",", "g", ",", "o"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"o", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
      RowBox[{"e", "=", "o"}], ";", 
      RowBox[{
       RowBox[{
       "e", "\[LeftDoubleBracket]", "component", "\[RightDoubleBracket]"}], 
       "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"g", "=", 
       RowBox[{"{", 
        RowBox[{"color", ",", 
         RowBox[{"Text", "[", 
          RowBox[{"label", ",", 
           RowBox[{"1.05", " ", "hi", " ", "e"}]}], "]"}], ",", 
         RowBox[{"Arrowheads", "[", "0.02", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{"o", ",", 
            RowBox[{"hi", " ", "e"}]}], "}"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"lo", "<", "0"}], ",", 
        RowBox[{"g", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"g", ",", 
           RowBox[{"{", 
            RowBox[{"Dashed", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"lo", " ", "e"}], ",", "o"}], "}"}], "]"}], ",", 
             RowBox[{"Dashing", "[", 
              RowBox[{"{", "}"}], "]"}]}], "}"}]}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "g"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"myPoint", "[", 
    RowBox[{"p_", ",", "color_", ",", "label_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"color", ",", 
     RowBox[{"Text", "[", 
      RowBox[{"label", ",", 
       RowBox[{"1.1", " ", "p"}]}], "]"}], ",", "Dashed", ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", 
          RowBox[{"p", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           ",", "0"}], "}"}], ",", "p"}], "}"}], "]"}], ",", 
     RowBox[{"PointSize", "[", "Large", "]"}], ",", 
     RowBox[{"Point", "[", "p", "]"}], ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", "}"}], "]"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.544260709698449*^9, 3.5442607186279593`*^9}, {
  3.54428111716831*^9, 3.5442811280423098`*^9}, {3.5442856744219174`*^9, 
  3.5442856853789177`*^9}, {3.5442900062835426`*^9, 3.544290041155543*^9}, {
  3.5443927636957445`*^9, 3.544392786886071*^9}, {3.544392851243752*^9, 
  3.5443928515137672`*^9}, {3.647005188098308*^9, 3.647005223652389*^9}}],

Cell[TextData[{
 "Draw a graph of the points and vectors ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 " along with part of the plane determined by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.544393214601535*^9, 3.5443933354354467`*^9}, 
   3.576924386481578*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"o", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
  RowBox[{"p", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "6", ",", "3"}], "}"}]}], ";", 
  RowBox[{"q", "=", 
   RowBox[{"{", 
    RowBox[{"6", ",", "3", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], ";", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", 
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<y\>\"", ",", 
        RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", 
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{"p", ",", "Black", ",", "\"\<p\>\""}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{"q", ",", "Black", ",", "\"\<q\>\""}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Black", ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{"o", ",", "p"}], "}"}], "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{"o", ",", "q"}], "}"}], "]"}], ",", "Red"}], "}"}]}], "]"}],
     ",", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"100", ",", "40", ",", "30"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544188998883645*^9, 3.544189003768761*^9}, {
   3.5441897207364597`*^9, 3.5441897323461676`*^9}, {3.544190060055626*^9, 
   3.54419009446349*^9}, {3.5441901254087315`*^9, 3.5441901463092475`*^9}, {
   3.544190177415721*^9, 3.5441902335381937`*^9}, 3.5441902947152634`*^9, {
   3.5441904213970203`*^9, 3.5441904708429275`*^9}, {3.544191432467061*^9, 
   3.5441914326231127`*^9}, {3.544191466267708*^9, 3.544191473633315*^9}, 
   3.5441915498818345`*^9, {3.5441915858838005`*^9, 3.544191637041529*^9}, {
   3.5441952332194257`*^9, 3.5441952922172594`*^9}, {3.544227068842256*^9, 
   3.5442270705913563`*^9}, {3.544227108415519*^9, 3.544227136351117*^9}, {
   3.54422717940758*^9, 3.544227211334406*^9}, {3.544227258272091*^9, 
   3.5442272583830967`*^9}, {3.544264576475616*^9, 3.544264578367724*^9}, {
   3.544264611410614*^9, 3.5442647285733156`*^9}, {3.5442655755097575`*^9, 
   3.5442656265276756`*^9}, {3.544265668290064*^9, 3.5442656717772636`*^9}, {
   3.5442657178929014`*^9, 3.5442657435013657`*^9}, {3.5442683095971384`*^9, 
   3.544268333300494*^9}, {3.544268372027709*^9, 3.5442684125960293`*^9}, {
   3.544271170958799*^9, 3.5442711717258425`*^9}, {3.5442792389278936`*^9, 
   3.544279242872288*^9}, {3.544279277134714*^9, 3.5442792808680873`*^9}, {
   3.5442793221212125`*^9, 3.54427934140314*^9}, 3.54428111298731*^9, {
   3.544284734286769*^9, 3.544284743923805*^9}, 3.5442855942729177`*^9, {
   3.544392168068677*^9, 3.5443921821414814`*^9}, {3.544392216013419*^9, 
   3.5443922258699827`*^9}, {3.5443922779179597`*^9, 
   3.5443922786930037`*^9}, {3.5443923417416105`*^9, 3.544392424318333*^9}, {
   3.544392455639125*^9, 3.5443925750439544`*^9}, {3.5443926174083776`*^9, 
   3.5443926738816075`*^9}, {3.5443928006498585`*^9, 3.5443928242022057`*^9}, 
   3.5443935385290623`*^9, {3.5769242218356524`*^9, 3.5769242457587357`*^9}, {
   3.5769242830939283`*^9, 3.576924283758156*^9}, {3.576924358430511*^9, 
   3.576924358828824*^9}, {3.5769243911563253`*^9, 3.576924417347826*^9}, {
   3.576924611834613*^9, 3.5769247093529453`*^9}, {3.647005345620448*^9, 
   3.647005427833434*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], Text3DBox["\<\"x\"\>", {2.1, 0., 0.}], 
   {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {2, 0, 0}}], 
    {Dashing[{Small, Small}], Line3DBox[{{-2, 0, 0}, {0, 0, 0}}]}, 
    {RGBColor[
      NCache[
       Rational[2, 3], 0.6666666666666666], 
      NCache[
       Rational[2, 3], 0.6666666666666666], 0], Dashing[{}], 
     Text3DBox["\<\"y\"\>", {0., 2.1, 0.}], 
     {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 2, 0}}], 
      {Dashing[{Small, Small}], Line3DBox[{{0, -2, 0}, {0, 0, 0}}]}, 
      {RGBColor[0, 1, 0], Dashing[{}], 
       Text3DBox["\<\"z\"\>", {0., 0., 2.1}], 
       {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 2}}], 
        {Dashing[{Small, Small}], Line3DBox[{{0, 0, -2}, {0, 0, 0}}]}, 
        {GrayLevel[0], Dashing[{}], 
         Text3DBox["\<\"p\"\>", {-2.2, 6.6000000000000005`, 
          3.3000000000000003`}], 
         {Dashing[{Small, Small}], 
          Line3DBox[{{-2, 0, 0}, {-2, 6, 0}, {-2, 6, 3}}], 
          {PointSize[Large], Point3DBox[{-2, 6, 3}], 
           {GrayLevel[0], Dashing[{}], 
            Text3DBox["\<\"q\"\>", {6.6000000000000005`, 
             3.3000000000000003`, -2.2}], 
            {Dashing[{Small, Small}], 
             Line3DBox[{{6, 0, 0}, {6, 3, 0}, {6, 3, -2}}], 
             {PointSize[Large], Point3DBox[{6, 3, -2}], 
              {GrayLevel[0], Dashing[{}], Arrow3DBox[{{0, 0, 0}, {-2, 6, 3}}],
                Arrow3DBox[{{0, 0, 0}, {6, 3, -2}}], 
               {RGBColor[1, 0, 0]}}}}}}}}}}}}}},
  Axes->True,
  ImageSize->{359.71676535633867`, 282.0788745380861},
  ViewPoint->{100, 40, 30},
  ViewVertical->{-0.14566307912137058`, -0.11048483764330008`, 
   1.5734793420963358`}]], "Output",
 CellChangeTimes->{{3.57692467474612*^9, 3.576924713233317*^9}, 
   3.647004799560679*^9, {3.647005194725133*^9, 3.6470052277103767`*^9}, {
   3.647005284229245*^9, 3.647005309143963*^9}, {3.647005348715927*^9, 
   3.64700542869049*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"pc", ":=", 
  RowBox[{"ContourPlot3D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"26", "/", "3"}]}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "2"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "+", 
         RowBox[{"11", "/", "3"}]}], ")"}], "^", "2"}]}], "\[Equal]", 
     RowBox[{"392", "/", "9"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "5"}], ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "5"}], ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{"-", "20"}], ",", "5"}], "}"}], ",", 
    RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
    RowBox[{"ContourStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
       RowBox[{"Specularity", "[", 
        RowBox[{"White", ",", "30"}], "]"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.576924432949189*^9, 3.576924573063615*^9}, 
   3.576924717311811*^9, {3.576924770071267*^9, 3.576924776733779*^9}, {
   3.576924822448132*^9, 3.576924859053269*^9}, {3.5769250103770857`*^9, 
   3.576925011227201*^9}}],

Cell[BoxData[
 RowBox[{"p1", ":=", 
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "t"}], ",", 
      RowBox[{"6", "t"}], ",", 
      RowBox[{"3", "t"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.576924880331388*^9, 3.576924883100051*^9}, {
  3.5769249203708897`*^9, 3.576924980371174*^9}}],

Cell[BoxData[
 RowBox[{"p2", " ", ":=", 
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"6", "t"}], ",", 
      RowBox[{"3", "t"}], ",", 
      RowBox[{
       RowBox[{"-", "2"}], "t"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.576924982978907*^9, 3.576925003969022*^9}, 
   3.5769250658121443`*^9, {3.6470048233507757`*^9, 3.647004827588705*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"p1", ",", "p2", ",", "pc", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "20"}], ",", "5"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.576925014155875*^9, 3.5769250518559923`*^9}, 
   3.576925110672018*^9, {3.5769251818490067`*^9, 3.576925223375805*^9}}],

Cell[BoxData[
 Graphics3DBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
     Line3DBox[CompressedData["
1:eJwlxXlUjWkYAPBbXb5kKpfqm1uKqIssOcZStvchR0R2soY2SZLGWAcVN1s3
IQalxd5EocIhPSZJSA1l0kzrLbRRabkt6h3nPH/8zs/SbdsST22JROL8g84P
Tp7Vb5/WeKa3z/O7tGhb4HTaf7rUwdS/TD4LQzyGDc9TuDJ6Afsl5nxUsnwZ
5nyt8lEp/Bjtyua9Kbx3Se6BjckOob6KA4z2Yy4emien5Tsw2KR54FpFGKMP
sBLbIw4q+WHMeeH0cakimtFhLNZ4YchxeQT6x+58uVCRyOhoFqSbPOyY/Cpm
hIY+dlakMzqRrVwVl9TYlILS3gFCjU8eo5H15UFrHS0Q5xzcqExdUcjoF8x6
8dfqZycy8eEez5Jrb0sZnct25dqz8y0vsWj1FtuAXZWMzmdiiqxUSysPZY4q
r7/gM6ML2X21Q07e1HcoK/C8N2lNHaP/Yxk+l8xW1Rfg0MG+8Uq3BkaXsVbF
NMPbWwvRrmTr6xmnmxhdwbQ7EvqZWf+LGZ2B8wsimxldySbyDfeXJhajN2Zn
pwe3Mvojyzk8PjfLpgwvuN8wNd6gYfRnNii8riP+azmOWVnR1uPZwegaVqcp
K30/Vo3lzQtzYW4Xo+vY1drHrwzCKrGtTD7WZHk3o78wA/MbDVVVVXg2Ye8m
FxfO6AYWujnVK9bqE44w1HXeHSkBupG1QUKV98HP+NA/MCEsRgvoJrZjXGaK
ybNqLLQ+Iyw+rQ30N1aWmHnirWUtDjuUP3zdBR2gm1mXT0HkiL11OHVR2fiY
SCnQLWzkDKHH63E9lvsrp6tCewHdyhwvW266K37FVPtV+s9P9Qa6je0yXz+k
Ym0Dyle8KLqpFIDWsFH1y/sWOjfiTLXkVMYOXaDb2QDDRt3MzkaMMvHWV+zu
A3QHk2Jk0tCoJgyJ3nxkgo8e0J1sy/jHRX3mfcPY3PNZYf59ge5iCXPdYtPb
vmGg35lG84CfgP7OWutM+30614yNG4f/vMpNH+hulrrUUSdiVguGd9dKS70M
gO5hB+coY1I+tWB6vWODwWpDoDmzLHH6cEXZikXWdurJVv2AlsDkSYcj5OPa
0HeEu+2Za/2AlsBai7wOrfw2fL5izb4ZFjKgtaD1lUrtH6RBu5W18UZxMqC1
4LzUdccSq3YMODS7cJpZf6C1YUBp6mXtzHYM89Lt1DrTH2ht6LU/aJn99g7M
NN/Ia40GAK0DknjXJHX/TnzaE6JjEzYAaB0IuJik6p/Rif8kO9SqZEZAS+HJ
yKO6Mr8uzB3slRV62ghoKcicAkYFG3xH1YPlcRV6xkD3guLRf+fvSfuOnkOK
XdeojIHuBXeimVWVazdKH9iajRRMgO4N65Imysx7ujFEpybn7AEToHtDoDIu
qPjPHhxsZb/RWiICLcDtavNIg/kcg/1WtOjtEYEW4Ogl5YbSBRwVEz2yFftE
oAXwWPLFOnExx9fd26Nm7heBFmBgWtodZxeOxirVrL1BItACHD+5JivUjePN
hMyImmMi0AJ4T7zQpLeHY271uAnZF0WgBRhy2GiOcJ2jqbvhTmWaCLQAPXa/
6xfe5JhuY+4Uly4CLUDRl8p31xM4un+zsXjyVARagHCX5HWz73K8FTQ7qyVT
BFoAbrPkV2UaRxa738TjjQi0AMVvT0br5HP0LKm7P7NUBFqAhyEa9/z3HPWu
dRx3LReBFiBiyvoRVz5wTPIV1u9Vi0ALMO/amJSZpRzbu4YI9z6JQAvwaPeb
l0E1HENNV7tYNohAC3Bu9ISTi+s5jlVvGjmtSQRagO3qqGWWDRzfx//GVzaL
QAswfL5v2dMWjhb2p26Ea0SgBZBqFVwN13B8JonZd6tDBFqA8tQpPhs6OXpn
31qY3SUCLUCazxXbsd0c9cMfDa3qFoEW4I9BfVs553jXJVvDuQi0AP8D/6yN
VA==
      "]]}}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
     Line3DBox[CompressedData["
1:eJwlxXlUjWkYAPBbXb5kKpfqm1uKqIssOcZStvchR0R2soY2SZLGWAcVN1s3
IQalxd5EocIhPSZJSA1l0kzrLbRRabkt6h3nPH/8zs/SbdsST22JROL8g84P
7fP8Li3aFjid9p/u5Fn99mmNZ3qIx7DheQpXRi9gUgdT/zL5LMz5WuWjUvgx
2pX9EnM+Klm+DBuTHUJ9FQcY7cfmvSm8d0nugcEmzQPXKsIYfYC5eGienJbv
wJwXTh+XKqIZHcZKbI84qOSH0T9258uFikRGR7NY44Uhx+URmBEa+thZkc7o
RBakmzzsmPwqSnsHCDU+eYxGtnJVXFJjUwrOObhRmbqikNEvWF8etNbRAvHh
Hs+Sa29LGZ3LrBd/rX52IhOLVm+xDdhVyeh8tivXnp1veYkyR5XXX/CZ0YVM
TJGVamnloazA896kNXWM/o/dVzvk5E19h0MH+8Yr3RoYXcYyfC6ZraovQLuS
ra9nnG5idAVrVUwzvL21EDM6A+cXRDYzupJpdyT0M7P+F70xOzs9uJXRH9lE
vuH+0sRivOB+w9R4g4bRn1nO4fG5WTZlOGZlRVuPZweja9ig8LqO+K/lWN68
MBfmdjG6jtVpykrfj1VjW5l8rMnybkZ/YVdrH78yCKvEswl7N7m4cEY3MAPz
Gw1VVVU4wlDXeXekBOhGFro51SvW6hM+9A9MCIvRArqJtUFClffBz1hofUZY
fFob6G9sx7jMFJNn1TjsUP7wdRd0gG5mZYmZJ95a1uLURWXjYyKlQLewLp+C
yBF767DcXzldFdoL6FY2cobQ4/W4HlPtV+k/P9Ub6DbmeNly013xK8pXvCi6
qRSA1rBd5uuHVKxtwJlqyamMHbpAt7NR9cv7Fjo3YpSJt75idx+gO9gAw0bd
zM5GDInefGSCjx7QnUyKkUlDo5owNvd8Vph/X6C72Jbxj4v6zPuGgX5nGs0D
fgL6O0uY6xab3vYNGzcO/3mVmz7Q3ay1zrTfp3PNGN5dKy31MgC6h6UuddSJ
mNWC6fWODQarDYHm7OAcZUzKpxYssrZTT7bqB7QELEucPlxRtqLvCHfbM9f6
AS2ByZMOR8jHteHzFWv2zbCQAa0Fay3yOrTy29BuZW28UZwMaC1ofaVS+wdp
MODQ7MJpZv2B1obzUtcdS6zaMcxLt1PrTH+gtWFAaepl7cx2zDTfyGuNBgCt
A732By2z396BT3tCdGzCBgCtA5J41yR1/078J9mhViUzAloKAReTVP0zOjF3
sFdW6GkjoKXwZORRXZlfF6oeLI+r0DMGuhfInAJGBRt8R88hxa5rVMZA94Li
0X/n70n7jtIHtmYjBROge8OdaGZV5dqNITo1OWcPmADdG9YlTZSZ93TjYCv7
jdYSEWgBApVxQcV/9mCw34oWvT0i0ALcrjaPNJjPUTHRI1uxTwRagKOXlBtK
F3B83b09auZ+EWgBPJZ8sU5czNFYpZq1N0gEWoCBaWl3nF043kzIjKg5JgIt
wPGTa7JC3TjmVo+bkH1RBFoA74kXmvT2cDR1N9ypTBOBFmDIYaM5wnWO6Tbm
TnHpItAC9Nj9rl94k6P7NxuLJ09FoAUo+lL57noCx1tBs7NaMkWgBQh3SV43
+y5HFrvfxOONCLQA3GbJr8o0jp4ldfdnlopAC1D89mS0Tj5HvWsdx13LRaAF
eBiicc9/zzHJV1i/Vy0CLUDElPUjrnzg2N41RLj3SQRagHnXxqTMLOUYarra
xbJBBFqAR7vfvAyq4ThWvWnktCYRaAHOjZ5wcnE9x/fxv/GVzSLQAmxXRy2z
bOBoYX/qRrhGBFqA4fN9y562cHwmidl3q0MEWgCpVsHVcA1H7+xbC7O7RKAF
KE+d4rOhk6N++KOhVd0i0AKk+VyxHdvN8a5LtoZzEWgB/hjUt5Vzjv8Dp0GN
VA==
      "]]}}, GraphicsComplex3DBox[CompressedData["
1:eJx1mXs01WkXx4/juOR+ObnHOZTcSemC/H6VdJuQabp4NaOUblISqSTJbYZM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    "], {
     {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.5], EdgeForm[None], 
      Specularity[
       GrayLevel[1], 30], 
      StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtlVWIlkEUhue31sR1bdcE10Bduxtj1bWxu7EbOy/MtVtERdQ7EUVcdUWw
E0EUFRNMMDAw7/R5mffiYc4/c74zJ+evMmZG3+m5Qgj7IDcchPbQDFolQljL
uhw6wX44DN3Yz4Regt/JsBMmw0yYCNNgKkyBGdAG3emsrRNRbgljIJu94tAB
ZutOyGC/M3SCnpa7WF+6pUKUK7KesKw127LOK9rPAJWgHeJwGAbboStsgNtw
B27BePQqsFayLBsVLF+wzVfwCO57X7o1oCSkQAH4Lvuc/bCOzvX9WORijnc+
LIB5UBUaQW3rKI4cOAvn4Aw89L1P4DE8hQfwET7BB6jGt2nQCAbzeyisCjGH
g6AHtFVeVIcQa9cTesBxOAa10BkKpZELhijLr9KWtZduOd0+H4UjisPxpTjG
Qs6LclJH+rKl+kCKapmIOgVt/yXcgBKyA++Q30CqauE6qscmua96w0pooBpw
Vt19pRqVUwwwLBHjk68DkPvBkESUB0J/mMXZXJgDHb3fARo4n4prNWfrYDF0
cf9kQAtoHuK8qMfaQMsQ56Wz7EF9vq/nu/pCH+itPeVF5yHaX+N6NYUm0DhE
/bqJWBf17Q44D4vs80J4Dc/hGYxGL4t1S4g5VJ6TYSTsZa+ydcqzloVcyHkh
j3OV7npIR+flQtzv5T6RnOzeGZ6IfasZGIecL8T6S0ejJ73u7rdN3tcbo7OG
sMIx6i7dk2Ud3S+99dZZ4rvKuE9+wj24628Va3nrqB/lk+ZaM/I7xNh3hxj/
3xDn5TOMYn+rY5RchHVXiDOiOu6BfyE6/MV2dM9uy8plqr+VjaKWtRaxLHu6
Q2/CN/gK7y2/tc/KXxnbTHUsf+CX/S+knEABGAHbQnxvX0ASv6+zTrD/hV0L
1SHH8nn3jXpGb85F619ivQo35S+/CyeivnTzh/j+qIczbCfHvSdZ53lDfK80
69mWc9wDmk29LddsX3MtP/XuLYXLtiMb6hu93ydtZ1mIc33Ffiqmyo7nnH1Q
Hna6xzSPm2Gj95Psf37HrXylQU3XfYT91/5pOBXiG6v/QM1ypnVkO8k+6P5L
rpd6UH12CA6EOOPSueq6/wfAi7Jw
          "]], Polygon3DBox[CompressedData["
1:eJxNlllsVVUUhvdu4VKhLSZigbYXe2+xQJUKFkutJVLQGFKI0gLS4kQV1EQB
NZgYFZNC4gxq4gwKKkVxQKu+iTg+GGulUSPEiTihJvjgECNQ8fuz/0Yfvpxz
97CGf629z811rW5bVRBCeBaGwUVwMVwHN8DJUAPVMMXjmr8KVsEGWA9XwOXQ
DNfD1XAW1Hpe67r93gAzvWcOtEAbLIIJUAZjIAulMB4qoQJO8f71tl3sNZqr
grX2P9e2FecaWO14s7Y9Dk6CiZCHnHOcBJOds3IvtC7SKMJoKHdM8vsavA6v
wC7o9dibsAdegBdhN7wBT8MWeBxaPbbbPuV7obXocU3mwybva/X4DnjO85vh
CXgKdsKT8JjX9HhuG2z1mrvhXtgI98H9cI/Hyx3XFtuVnUfh4ZD6Qv3wIDzg
fQ+5LrLziNetgLvgTlgJnYi2CNqhIybfm5zXRq/T+lvgZtch7zrXOg/l9bxz
ljYtzrPHa6fCNO/Rex0sgOkwC5pC6odm66y6zwj/9bV8nhZSf5e4xqptses+
Ao53/YdDkcc0p97IeLzAGkvrZ2A71Ds2xXJ6SD3e5jq3w6sh9Y96pteab3bO
O6zLOrjV+tQ49omOfad9brdG6sOXQ+q5XUbv6sOX4A64HW6E2xzrNsfRax1y
1r7beWz1nPp5CXTAlbAUDsI4hBkLJ0AWKqEChkM9tEArnApvh3RO1Vdvwaew
Dz6HT+BjWA6XwgD0w4fwEfTBD/AjfA/fwe9wLnbnw0/eo72XwLewN6R7ablt
fw0H4Bv4wusWw5deLxuypZyU2zye58XkQ74+U97uZcXe4d7e51wWxnSmdZZ/
gQUxrde+/SHpID3OhvP9Pgdme0zv58Bcj822/3meV2yyud+6T4FGiJCBmxif
xbM5pvq2u9em8ntCTHkq3wvhK+u619r0WZcBayF9ZLcQCuBoSOh9GBzmfSTP
Izz/huNi6hnd9X/An35ucA3k55Drpzr+Bv/AMfjVc3+5B7u9vwyb5TAeTrRP
7Rm0z0H/PmR7RxzjYc8PrSmJKb4RUASjYVRMOhR5XHq8C++F1KfvhHTu1nlc
v98P6d4r8bo+azdg7Q64Z4e0vCCmnlAv/Oy+VY8ddP8qrkHHXmxdjzkn5TDW
+Zf5fGVc66POVXmUxlSHUX7PuCYj3ZfqT8Uh/zPcYy0+m2dATUzj9a51E8z0
WS7wWNbnWb2jO2Cpe0hn7TLo9FlSnfVd7wrpzOk7qLtN95DuH9Wx3zqpnupL
9ae+ZXX2fQ3v14YUw7KQ7psl9lHh+0V9rX7W3ab7Tv8b9B1tiOk/gL79umv3
OIZpjE+Pye5ar5N93Yc6K7mY7rQz7b/J50oxKlbdG2N4/yCk+6jfuUyCyZCH
atuQraqYNOp07IutT95nNuNaSTt9J5d5rbTTf6MV/9OwyxpL60ZrVOg+0DdR
936Na1nnp2qp+7Y2ppwa7VcxVfkMqH7Vjr3UZ0J1kM0hW9KowZpnnWutbeVt
p8q5a7/+Z62xjlrX5VxWOodK21Nt2h1LzjrKxr81dx2Z
          "]], 
         Polygon3DBox[CompressedData["
1:eJwt09kzl1EYwPHzFs2EC8nPdqexVKqfn2TfEoVB0iLqqhkZWcfSdlNdhFKG
0Ia64arGX2BCMtRlm7hrIi2iNFNd9n3mPBefOe97lvc8z3POG36mobR+gzEm
Ed44hbO4gTZcxzDG4XGMiUMEynWsHR2oQjWa0Io61MCfuQEIgguBuEV/PvJw
G51YxRp+4jN+4Dv+YQ4f8BVDyEUOHmEQ53ERl3EJV7Cg62T9X/xBN7pQgEzc
xw64dY7MXUEYMX6kfY2XCOU9mXYAD/EYSVjGVs1vCz5pvpLjDM+z8HNsbffh
Km6iUvP8hd/4gkXc05gykIXTuIM+9Bpbtx6sY8nYPWU/2SME8/S9Nzb2YN5j
4cYxnMBxFDN2GP24i2lUyHnipIwjz7G1/4ZoRGpdAmRPbIIXNstZMPegritC
oWPr9kbP4JXWMENrno40pGqs7/BW58u6EATCBV/JA3uwG9sQgV2SA/tkIt+x
dVzT+Fy6PkjOBgc0H4nxELLwlP4xHOG5FDF4wvuIsXc7ElGOzXEjfDQWydet
dX3G86ixa2WPMq1xhe4n9/ECnmMSE/CgyNgzKEEcWvTeyvgDNEvMSNE7th/Z
xsYk/14OshGPa/odOcMXmJI6099Au5N2O1JhUODYmkmd5F87qvfCrTUoQYLk
g1js1TsbTX840pCu36ulP5m2kfacsf+5xObRO1amcf4HiEp2Mg==
          "]], 
         Polygon3DBox[CompressedData["
1:eJwtz79KAkAcB/AzsojIFxCM9lpqqjAa+mc2tbc0VYMiiCH9wZYcG3wC6Qkk
NKu9JOkJMp+iWu0j3fDhe3e/4/jewnHxsDARQkgxRY0Vlrnhmks2EiFkqVqX
KVEg42yJRfLsMz9OswPyrLJGljmznnxl2nqWGXbsuzzyQJMtnnimQ4t2vNPn
nV9++OaDO/bYDf9vbnPPG0M+GfAVO9S55YIrzqlwxCbrnHLGCUld0/GPgZGY
lDnZ4CV27sYOf7DmKKg=
          "]]}],
       Lighting->{{"Ambient", 
          RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
         "Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{0, 2, 2}]}, {"Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{2, 2, 2}]}, {"Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}},
    VertexNormals->CompressedData["
1:eJwVWHc81d8bT8qWjOzMJqlQ2h0tErKSFBHJjqK+Riqj7EiUkVJGsq5RRjce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     "]]},
  Axes->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{387.7351058814798, 388.4405839122934},
  Method->{},
  PlotRange->{{-5, 20}, {-5, 20}, {-20, 5}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{-3.378831421286965, 0.15040399567437016`, -0.10429220780618785`},
  ViewVertical->{-0.5897430745856076, 0.49264926577686813`, 
   0.6399217193593507}]], "Output",
 CellChangeTimes->{{3.576925023929056*^9, 3.5769250523505907`*^9}, 
   3.576925111164242*^9, {3.57692521307689*^9, 3.57692522395033*^9}, {
   3.647004772896511*^9, 3.647004800158062*^9}, 3.647004832693405*^9, 
   3.647005309574237*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 821},
WindowMargins->{{12, Automatic}, {Automatic, 24}},
FrontEndVersion->"10.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 6, \
2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 181, 2, 64, "Section"],
Cell[763, 26, 911, 17, 201, "Text"],
Cell[1677, 45, 2987, 77, 148, "Input"],
Cell[4667, 124, 588, 24, 31, "Text"],
Cell[CellGroupData[{
Cell[5280, 152, 3684, 72, 114, "Input"],
Cell[8967, 226, 1966, 40, 297, "Output"]
}, Open  ]],
Cell[10948, 269, 1320, 37, 63, "Input"],
Cell[12271, 308, 446, 13, 28, "Input"],
Cell[12720, 323, 476, 13, 28, "Input"],
Cell[CellGroupData[{
Cell[13221, 340, 584, 16, 28, "Input"],
Cell[13808, 358, 25672, 439, 403, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
