(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    159925,       2780]
NotebookOptionsPosition[    159050,       2745]
NotebookOutlinePosition[    159402,       2761]
CellTagsIndexPosition[    159359,       2758]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["11.2 - limits - WebAssign problems...", "Section",
 CellChangeTimes->{{3.6844976278483973`*^9, 3.684497646326383*^9}, {
   3.6845075143878593`*^9, 3.6845075233072968`*^9}, {3.684508604541747*^9, 
   3.684508607109619*^9}, 3.684508640389711*^9}],

Cell[CellGroupData[{

Cell["Next to last problem", "Subsection",
 CellChangeTimes->{{3.684508626118484*^9, 3.684508636565281*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"myf", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"x", "^", "2"}], " ", "y", " ", 
   RowBox[{
    RowBox[{"E", "^", "y"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "4"}], "+", 
      RowBox[{"7", 
       RowBox[{"y", "^", "2"}]}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.6844974486465054`*^9, 3.684497509512226*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", 
     RowBox[{"myf", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", ".01"}], ",", ".01"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", ".01"}], ",", ".01"}], "}"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6844967855796623`*^9, 3.68449690367198*^9}, {
  3.684497020370036*^9, 3.6844970465112267`*^9}, {3.684497496705742*^9, 
  3.684497502128417*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nQdYzt/7x2VvKoqQrSQpRWl9SlFpaCqlXdJQGvgmShnJTFaE7L13Ro98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   "], {{
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[2], EdgeForm[
      None], Specularity[
       GrayLevel[1], 3], 
      StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1nHccV+MXx+++95uEIiGprESRrBYppCVbpTSRElERpWWHsvdePzPZZEeU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          "]], 
         Polygon3DBox[CompressedData["
1:eJw1nAPUHUnXhS/6dvebTMbO2FbGTgYZ21bGk4xt21bGtm3btm1/g/95svtf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          "]], 
         Polygon3DBox[CompressedData["
1:eJwt13nclmMaxvGnnqd3aTGmKZ9pFY200SIVaaJQkU+pTEkMlVQKLYasLdre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          "]], 
         Polygon3DBox[{{1951, 2166, 1046, 890, 889, 1327}, {2106, 2105, 1440, 
          873, 874, 1441}, {1845, 2167, 1049, 897, 896, 1231}}]}],
       Lighting->{{"Ambient", 
          RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
         "Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{0, 2, 2}]}, {"Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{2, 2, 2}]}, {"Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}}, {{}, {}, {}, 
     {GrayLevel[0.2], 
      Line3DBox[{800, 976, 2249, 801, 990, 829, 2311, 1005, 844, 2315, 1020, 
       859, 1184, 2383, 1032, 871, 2329, 1185, 1258, 1265, 1266, 1400, 2430, 
       1311, 1132, 1436, 1434, 1478, 1435, 2438, 882, 1455, 1144, 1456, 1322, 
       1323, 2390, 1402, 1324, 1156, 1469, 1388, 1389, 893, 1168, 2376, 1052, 
       902, 1239, 2399, 1061, 917, 2341, 1075, 932, 2350, 1090, 947, 2361, 
       1105, 962}], 
      Line3DBox[{802, 977, 2250, 803, 991, 2260, 830, 1006, 845, 2316, 1021, 
       860, 2322, 1186, 1033, 872, 2330, 1187, 1259, 1267, 1268, 1312, 2413, 
       1279, 1133, 1439, 1437, 1479, 1438, 2439, 883, 1457, 1145, 1458, 1275, 
       2407, 1276, 1403, 1325, 1157, 1470, 1390, 2428, 1391, 894, 1223, 1053, 
       903, 1240, 2400, 1062, 918, 2342, 1076, 933, 2351, 1091, 948, 2362, 
       1106, 963}], 
      Line3DBox[{804, 978, 2251, 805, 992, 2261, 831, 1007, 2271, 846, 1022, 
       861, 2323, 1416, 1417, 1418, 1419, 2434, 1122, 1260, 1123, 1340, 1195, 
       1341, 2419, 1134, 1364, 1135, 1363, 1332, 1373, 1146, 1459, 1147, 2283,
        1372, 1212, 1376, 1158, 1393, 1159, 2286, 1392, 1251, 1224, 1225, 
       2290, 904, 1063, 919, 2343, 1077, 934, 2352, 1092, 949, 2363, 1107, 
       964}], Line3DBox[{806, 979, 2252, 807, 993, 2262, 832, 1008, 2272, 847,
        1023, 2279, 862, 1420, 1421, 1422, 1423, 2435, 1124, 1330, 1125, 1342,
        1196, 2385, 1343, 1136, 1365, 1137, 1280, 2408, 1206, 1288, 1148, 
       1375, 1149, 1374, 2424, 1214, 1297, 1160, 1395, 1161, 2287, 1394, 1252,
        1227, 2394, 1228, 905, 1064, 2294, 920, 1078, 2299, 935, 2353, 1093, 
       950, 2364, 1108, 965}], 
      Line3DBox[{808, 980, 2253, 809, 994, 2263, 833, 1009, 2273, 848, 1024, 
       2280, 863, 1424, 2436, 1425, 1426, 1427, 1428, 1331, 1345, 1344, 1346, 
       2420, 1281, 1282, 1205, 1284, 1283, 2409, 1208, 1289, 1290, 1213, 1292,
        1291, 2411, 1460, 1377, 1378, 1226, 2393, 1162, 895, 1054, 2291, 906, 
       1065, 2295, 921, 1079, 2300, 936, 1094, 951, 2365, 1109, 966}], 
      Line3DBox[{810, 981, 2254, 812, 995, 2264, 834, 1010, 2274, 849, 1025, 
       2281, 864, 1034, 2282, 873, 1440, 2441, 1471, 1442, 1443, 1444, 1483, 
       1485, 1484, 1249, 1495, 1496, 1482, 1397, 2429, 1366, 1404, 1405, 1333,
        2418, 1327, 889, 1229, 1253, 2403, 1231, 896, 1055, 2292, 907, 1066, 
       2296, 922, 1080, 2301, 937, 1095, 2304, 952, 1110, 967}], 
      Line3DBox[{814, 983, 815, 2309, 997, 836, 2313, 1012, 851, 2318, 1027, 
       866, 2325, 1036, 875, 1197, 2386, 1198, 1041, 880, 2333, 1317, 1318, 
       1044, 2425, 885, 1379, 1380, 1215, 1461, 1047, 891, 1472, 1473, 1462, 
       2432, 1050, 898, 2335, 1057, 909, 2337, 1068, 924, 2345, 1082, 939, 
       2355, 1097, 954, 2367, 1112, 969}], 
      Line3DBox[{816, 984, 2255, 817, 998, 2265, 837, 2314, 1013, 852, 2319, 
       1028, 867, 2326, 1037, 876, 2331, 1126, 1199, 1313, 1314, 1315, 2414, 
       1285, 1138, 1300, 1271, 1272, 2388, 886, 1293, 1150, 1301, 1277, 1278, 
       2391, 1407, 1406, 1481, 1163, 1334, 1474, 1475, 899, 1487, 1411, 1486, 
       2433, 1058, 910, 2338, 1069, 925, 2346, 1083, 940, 2356, 1098, 955, 
       2368, 1113, 970}], 
      Line3DBox[{818, 985, 2256, 819, 999, 2266, 838, 1014, 853, 2320, 1029, 
       868, 2327, 1188, 1038, 877, 1347, 2332, 1127, 1348, 1269, 1270, 1401, 
       1316, 1139, 1367, 1273, 1274, 2389, 887, 1294, 1151, 1381, 1328, 2417, 
       1329, 1409, 1408, 1164, 1335, 1476, 2445, 1477, 900, 1490, 1412, 1488, 
       1059, 911, 2339, 1070, 926, 2347, 1084, 941, 2357, 1099, 956, 2369, 
       1114, 971}], 
      Line3DBox[{820, 986, 2257, 821, 1000, 2267, 839, 1015, 2275, 854, 2321, 
       1030, 869, 2328, 1189, 1190, 1191, 1350, 2421, 1128, 1430, 1129, 1349, 
       1200, 1286, 2410, 1140, 1369, 1141, 1429, 1368, 1337, 1338, 1152, 1382,
        1153, 2284, 1295, 1216, 1339, 1165, 1336, 1166, 2288, 1415, 1413, 
       1489, 1414, 2293, 912, 1071, 927, 2348, 1085, 942, 2358, 1100, 957, 
       2370, 1115, 972}], 
      Line3DBox[{822, 987, 2258, 823, 1001, 2268, 840, 1016, 2276, 855, 1173, 
       2379, 1174, 1248, 2402, 1175, 1176, 1192, 1352, 2422, 1130, 1431, 1131,
        1351, 1202, 2387, 1287, 1142, 1447, 1143, 1480, 1446, 2442, 1445, 
       1463, 1154, 1464, 1155, 2285, 1296, 1250, 1302, 1218, 1261, 1219, 2289,
        1254, 1232, 1491, 2446, 1233, 913, 1072, 2297, 928, 1086, 943, 2359, 
       1101, 958, 2371, 1116, 973}], 
      Line3DBox[{824, 988, 2259, 825, 1002, 2269, 841, 1017, 2277, 856, 1177, 
       2380, 1178, 1179, 1118, 2373, 1119, 1193, 2384, 1355, 1356, 1201, 1354,
        1353, 1432, 2437, 1361, 1362, 1209, 1450, 1449, 2443, 1448, 1465, 
       1466, 1217, 1384, 1383, 2426, 1398, 1303, 1304, 1262, 2405, 1221, 1255,
        1234, 2396, 1235, 914, 1073, 2298, 929, 1087, 2302, 944, 1102, 959, 
       2372, 1117, 974}], 
      Line3DBox[{826, 1170, 2377, 1171, 827, 1003, 2270, 842, 1018, 2278, 857,
        1180, 2381, 1181, 1182, 1120, 2374, 1121, 1194, 1359, 2423, 1360, 
       1203, 1358, 1357, 1396, 1370, 1371, 1210, 1452, 1451, 2444, 1410, 1467,
        1468, 1220, 1386, 2392, 1385, 1399, 1305, 1306, 1263, 1308, 2406, 
       1307, 1256, 1236, 2397, 1237, 915, 1241, 2401, 1242, 930, 1088, 2303, 
       945, 1103, 2305, 960, 1244, 1245, 1246}], 
      Line3DBox[{961, 1104, 1243, 2360, 946, 1089, 2349, 931, 1074, 2340, 916,
        1060, 2398, 1238, 901, 1051, 2375, 1167, 892, 1048, 2427, 1387, 1222, 
       1321, 1320, 888, 1045, 2415, 1319, 1211, 1454, 1453, 881, 2431, 1042, 
       1433, 1204, 1310, 1309, 2412, 878, 1039, 1264, 1257, 1299, 2404, 1298, 
       870, 1031, 2382, 1183, 858, 1019, 2378, 1172, 843, 1004, 2310, 828, 
       989, 2307, 799, 975, 1169, 1247}], 
      Line3DBox[{968, 1111, 2366, 953, 1096, 2354, 938, 1081, 2344, 923, 1067,
        2336, 908, 1056, 2334, 897, 1049, 2395, 1230, 890, 1046, 2416, 1494, 
       1326, 884, 1043, 1493, 1492, 2447, 1207, 879, 1040, 2440, 1441, 874, 
       1035, 2324, 865, 1026, 2317, 850, 1011, 2312, 835, 996, 2308, 813, 982,
        2306, 811}]}, 
     {GrayLevel[0.2], 
      Line3DBox[{1498, 1759, 975, 1497, 2249, 1670, 1499, 2250, 1671, 1500, 
       2251, 1672, 1501, 2252, 1673, 1502, 2253, 1674, 1503, 2254, 2146, 2306,
        1504, 983, 1505, 2255, 1675, 1506, 2256, 1676, 1507, 2257, 1677, 1508,
        2258, 1678, 1509, 2259, 1679, 1510, 2377, 1760, 1680, 1761}], 
      Line3DBox[{1512, 2147, 2307, 1511, 990, 1513, 2260, 1681, 1514, 2261, 
       1682, 1515, 2262, 1683, 1516, 2263, 1684, 1517, 2264, 2148, 2308, 1518,
        2149, 2309, 1519, 2265, 1685, 1520, 2266, 1686, 1521, 2267, 1687, 
       1522, 2268, 1688, 1523, 2269, 1689, 1524, 2270, 1690, 1525}], 
      Line3DBox[{1527, 2150, 2310, 1526, 2151, 2311, 1528, 1006, 1529, 2271, 
       1691, 1530, 2272, 1692, 1531, 2273, 1693, 1532, 2274, 2152, 2312, 1533,
        2153, 2313, 1534, 2154, 2314, 1535, 1014, 1536, 2275, 1694, 1537, 
       2276, 1695, 1538, 2277, 1696, 1539, 2278, 1697, 1540}], 
      Line3DBox[{1554, 1771, 1770, 2381, 1553, 1768, 1767, 2380, 1552, 1765, 
       1764, 2379, 1551, 2321, 2161, 1550, 2320, 2160, 1549, 2319, 2159, 1548,
        2318, 2158, 1547, 2317, 2157, 2281, 1546, 1699, 2280, 1545, 1698, 
       2279, 1544, 1022, 1543, 2316, 2156, 1542, 2315, 2155, 1541, 2378, 1763,
        1762, 1863}], 
      Line3DBox[{1568, 1745, 1772, 1744, 2374, 1567, 1743, 1769, 1742, 2373, 
       1566, 1766, 1864, 2402, 2213, 1565, 1781, 2328, 2218, 1564, 2217, 2327,
        1779, 1563, 2326, 2164, 1562, 2325, 2163, 1561, 2324, 2162, 2282, 
       1560, 2089, 2088, 2436, 1559, 2084, 1420, 1558, 2080, 2323, 2243, 1557,
        2215, 2322, 1778, 1556, 2383, 1777, 1776, 1555, 2382, 1774, 1773, 
       1775}], Line3DBox[CompressedData["
1:eJwNzTlOQmEYheEPE6clODQXBBTUXneANIa4AmKtldorY+0KbIyt1KJBiRqH
YHBYiXEIDU/x5pzz/l/uTar7lb1UROxgfSpiMB3xhn/9Vb7gaDZizX7Sn/Gn
P8ptvjsTsWrf2w/41Q/5vn6Hot2Tt/jRD7zd6Nco2Feyi0X+2/7CCs58d4H7
1JdR0SfcpZC3W/ammw209Rz3gYJdxOlkRNZ+R9Y+cZOXOSxxQyT6MZ+RaWS4
CznPlf2njRbS/Dk/x2/ZTTSQ8LtcTa+jhA4uMfI2BkNMLNE=
       "]], 
      Line3DBox[CompressedData["
1:eJwVzrkuhGEUxvEjwcyH2MaE1h2IvTH2G7CEhGKoaEaiIArRkeAKaO3GNyJu
QGKrbbX70PhN8c9znvM/efN2r27MlGoiooie+ohsNiJBBr3YSyLOqvtMRL8+
gD48Y5875xJuSB/GIF5wwF1wDdwHZuvcyk908Zdcpyzpa24fzE3mIq64Rvlo
t85tmpuxgmtuwf4Ju9yf3ReW9VxtxJI80X+xw9+4PzWXcYdWpG7muFuuRd/C
NtpR4ea5Mtemf2PR31P5U33DPicL7g7dvcoRjCLlOrg38xE3LscwgQqX597N
x9ykzGMK99y0/AfLZS27
       "]], Line3DBox[CompressedData["
1:eJwV0TkzQ1EYxvETSYTCR1CYUdr3Jb6BBp1SZ0kwYgaFTofYl15FgYlEhDEa
hcaMyncxtt8p/vMs73vPuXNvy8ziZD4RQihgrD6E00wI9Q0hnNFxfOIL0+kQ
subHfNr8hGbwjm55qzGEZzpq51CX4o/iWajwU+Zv/AZG7OzTpP4gnoc583X6
ijUM29mjdXZa3Z3iV/GCAobMV2gRec+W7SX5KzziEoN2avpm83N5QC7yTfyo
PosLZ/frl3TLCFhELd5jt2Snz3xBTvA5+ic/8RPmXfRB16ubi8/L8/Q3vp95
le/U3dMe3SzdRc7sVv+jq8gdfDl+S3kn3oFNOw/6b92d3M6X4nlylV8w/5W3
4z/S3dA2/TX9wD8I6jr6
       "]], Line3DBox[CompressedData["
1:eJwNzMcuIGAUhuFfInoneu9uwhJjMiQW2Ei0xEKiJUr0snQL6szEbI1eFlyG
LuoGd0DiWbz53nPO9/8l3YMtAxEhhHHURoWwGh1CXUwIazILK4gzj2IwNoRM
8wXqzZcyB6e81S1e/vdHtt0VGszXMg997t0ywW5HJ5ff4If5Vr7JAtmDRL6r
k8/vcI8J78/si3gvkvieTiE/5P3ujXLKXIx/SDbv62zxEfd1OWY3xDtkJ7qQ
i5/IigyhRGcaMyjDtn2bfoo88Fep3SweMIcKDLtvyFSdQ51yPo9HLODdvkpu
Io0f6VTyRSxjCR/2v+RvpPNjnWp+zif9/8mf0IQ/yLA/0anh7e7P8gsvaMZf
ZOqc6rzyb1j2O90=
       "]], Line3DBox[CompressedData["
1:eJwVz8kuQ2EYBuDPwnQJEiG2agqR2HEBhvZUm4joSYhhISxJWFhL3AQWxC2w
cRPGvbmtsew8Z/Hkff/v//6TtmdxM9loioiU8ZaIl9aIV670fvnAVFvEo9xp
j+iTTzxzbWdQrjdHTNt50weoUuPGfV7ueleXM3be5RAffHJoVqWgf5HXv+Uw
PzQ4MquR6Oe+OSLnfPNWv6DovOQ8KrfszesT5h36NnvOk7JCyp27Tnnpdyfy
xLt7sy79wG5RznJqfizrdFOizIL5WfZfsj19mRUqWfe+V5ZYZY00uzfflznK
/FLw/k+O8Q9ZdzeM
       "]], 
      Line3DBox[{1602, 1757, 1879, 2169, 2375, 1601, 1758, 1881, 2170, 2376, 
       1603, 1841, 1883, 1053, 1604, 2220, 2290, 1726, 1605, 2394, 1844, 1727,
        1606, 2291, 1728, 1607, 2292, 2171, 2334, 1608, 2172, 2335, 1609, 
       2075, 2173, 2433, 2136, 2077, 1059, 2137, 2242, 2293, 1729, 2138, 2446,
        1846, 1730, 1610, 2396, 1847, 1731, 1611, 2397, 1849, 1732, 1856}], 
      Line3DBox[{1625, 1859, 1858, 2401, 1624, 1736, 2298, 1623, 1735, 2297, 
       1622, 1071, 1621, 2339, 2177, 1620, 2338, 2176, 1619, 2337, 2175, 1618,
        2336, 2174, 2296, 1617, 1734, 2295, 1616, 1733, 2294, 1615, 1063, 
       1614, 2400, 1855, 1884, 1854, 1613, 2399, 1853, 1882, 1852, 1612, 2398,
        1851, 1880, 1850, 1857}], 
      Line3DBox[{1627, 2178, 2340, 1626, 2179, 2341, 1628, 2180, 2342, 1629, 
       2181, 2343, 1630, 2299, 1737, 1631, 2300, 1738, 1632, 2301, 2182, 2344,
        1633, 2183, 2345, 1634, 2184, 2346, 1635, 2185, 2347, 1636, 2186, 
       2348, 1637, 1086, 1638, 2302, 1739, 1639, 2303, 1740, 1640}], 
      Line3DBox[{1642, 2187, 2349, 1641, 2188, 2350, 1643, 2189, 2351, 1644, 
       2190, 2352, 1645, 2191, 2353, 1646, 1094, 1647, 2304, 2192, 2354, 1648,
        2193, 2355, 1649, 2194, 2356, 1650, 2195, 2357, 1651, 2196, 2358, 
       1652, 2197, 2359, 1653, 1102, 1654, 2305, 1741, 1655}], 
      Line3DBox[{1669, 1862, 1244, 1668, 2372, 2208, 1667, 2371, 2207, 1666, 
       2370, 2206, 1665, 2369, 2205, 1664, 2368, 2204, 1663, 2367, 2203, 1662,
        2366, 1110, 1661, 2365, 2202, 1660, 2364, 2201, 1659, 2363, 2200, 
       1658, 2362, 2199, 1657, 2361, 2198, 1656, 2221, 2360, 1860, 1861}]}}},
   VertexNormals->CompressedData["
1:eJxcW3c81+33NjIzG8hKouxISOQgUdlKQmYTKRkVDdFQShSZqYxEGYWQdZvZ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    "]],
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["z", TraditionalForm]},
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{366.7985106821627, 345.74370544563664`},
  Method->{},
  PlotRange->{{-0.009999998571428572, 
   0.009999998571428572}, {-0.009999998571428572, 
   0.009999998571428572}, {-0.005086547741481438, 0.00509563893963782}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{2.4105812747177744`, -1.0005788718025959`, 2.1535876669600147`},
  
  ViewVertical->{0.024089485911877345`, 0.1769398873626633, 
   1.9326431601460954`}]], "Output",
 CellChangeTimes->{{3.684496850267737*^9, 3.684496870596444*^9}, 
   3.684496904861617*^9, {3.684497029737183*^9, 3.684497047067528*^9}, 
   3.6844975125429153`*^9}]
}, Open  ]],

Cell[TextData[{
 "For the limit to exist, any path heading towards (0,0) must have the same \
limit. ",
 StyleBox["\nWhat about approaching (0,0) along the line ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontWeight->"Bold"],
 StyleBox["?",
  FontWeight->"Bold"],
 " \[LineSeparator]\[LineSeparator]Try plotting h(y)=f(.1,y)",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"h", "(", "y", ")"}], "=", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{"0.1", ",", "y"}], ")"}], ":"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"]
}], "Text",
 CellChangeTimes->{{3.684497332492239*^9, 3.6844974322121477`*^9}, {
  3.684497715158358*^9, 3.684497781725305*^9}, {3.684507450620969*^9, 
  3.6845074719240723`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"myf", "[", 
    RowBox[{"0.1", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.684497518718305*^9, 3.684497541591976*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwVyWk8FAgDx3GkQpJEN7m2VIgKqchIig4iGkc0lpEj920cuWJEKHIlmyts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      "]], LineBox[CompressedData["
1:eJwV1nc41e0fB3A9EqlUHqmMkFVIEkqqd6VQRqhUZmWU0PkeZGSPyF49Qsso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      "]], 
     LineBox[{{-0.00016232254314194923`, -0.01589664743497509}, {
      0.00015392962580495476`, 0.015369839732333565`}, {
      0.00018917230476225375`, 0.018726190778347175`}}]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-1, 1}, {-0.01589664743497509, 0.018726190778347175`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.684497542308022*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Last problem (polar coordinates)", "Subsection",
 CellChangeTimes->{{3.684507550916432*^9, 3.684507573130992*^9}}],

Cell[TextData[{
 "How to evaluate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", ",", "y"}], ")"}], "\[RightArrow]", 
      RowBox[{"(", 
       RowBox[{"0", ",", "0"}], ")"}]}]], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], ")"}], 
     RowBox[{"ln", "(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], ")"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "?  \[LineSeparator]\[LineSeparator]Converting to polar coordinates, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "=", 
    SuperscriptBox["r", "2"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ":  "
}], "Text",
 CellChangeTimes->{{3.684507602883439*^9, 3.6845076055221567`*^9}, {
  3.6845076813871307`*^9, 3.684507861223056*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{
          SubscriptBox["lim", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"x", ",", "y"}], ")"}], "\[RightArrow]", 
            RowBox[{"(", 
             RowBox[{"0", ",", "0"}], ")"}]}]], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}], ")"}], "ln", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}], ")"}]}]}], "=", 
         RowBox[{
          SubscriptBox["lim", 
           RowBox[{
            RowBox[{"r", "\[RightArrow]", 
             SuperscriptBox["0", "+"]}], ",", " ", 
            RowBox[{"any", " ", "\[Theta]"}]}]], 
          RowBox[{
           RowBox[{"(", 
            SuperscriptBox["r", "2"], ")"}], 
           RowBox[{"ln", "(", 
            SuperscriptBox["r", "2"], ")"}]}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.684507886110758*^9, 3.684507949454324*^9}, {
  3.684508477667989*^9, 3.6845084828884363`*^9}}],

Cell[TextData[{
 "This suggests plotting ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "r", ")"}], "=", 
    RowBox[{
     SuperscriptBox["r", "2"], 
     RowBox[{"ln", "(", 
      SuperscriptBox["r", "2"], ")"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ".   Try it for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "r", "\[LessSlantEqual]", "2"}], 
   TraditionalForm]],
  FormatType->"TraditionalForm"],
 " !\[LineSeparator]\[LineSeparator]In polar coordinates, ",
 StyleBox["you only need to consider positive values of ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox["r", TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", since we can reach all the points in the x-y plane with positive ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " values, and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "\[Theta]", "<", 
    RowBox[{"2", 
     RowBox[{"\[Pi]", "."}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"]
}], "Text",
 CellChangeTimes->{{3.684507992606635*^9, 3.684508075356435*^9}, {
  3.68450816442843*^9, 3.684508436836418*^9}, {3.68450852722303*^9, 
  3.684508557127309*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 879},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"11.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 28, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 250, 3, 64, "Section"],
Cell[CellGroupData[{
Cell[855, 29, 108, 1, 44, "Subsection"],
Cell[966, 32, 408, 13, 32, "Input"],
Cell[CellGroupData[{
Cell[1399, 49, 675, 18, 54, "Input"],
Cell[2077, 69, 141657, 2324, 361, "Output"]
}, Open  ]],
Cell[143749, 2396, 812, 24, 91, "Text"],
Cell[CellGroupData[{
Cell[144586, 2424, 284, 8, 32, "Input"],
Cell[144873, 2434, 10483, 186, 239, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[155405, 2626, 120, 1, 44, "Subsection"],
Cell[155528, 2629, 983, 33, 74, "Text"],
Cell[156514, 2664, 1298, 38, 38, "Text"],
Cell[157815, 2704, 1207, 37, 93, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

