(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    555056,       9784]
NotebookOptionsPosition[    553427,       9728]
NotebookOutlinePosition[    553779,       9744]
CellTagsIndexPosition[    553736,       9741]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"myT", "=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"2", " ", "x", " ", "y"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myCP", "=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{"myT", ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", " ", 
     RowBox[{"Contours", "\[Rule]", "40"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myPoint", "=", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Black", ",", " ", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", 
         RowBox[{"1", "/", "3"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myBound", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Thickness", "[", "0.05", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myQuad", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"t", "^", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
  "myCP", ",", " ", "myPoint", ",", " ", "myBound", ",", " ", "myQuad"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.685110660950158*^9, 3.685110842218524*^9}}],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJyEfQVYlM/zOGAndmB3dweOLQa2Ynd3t9jdmIgFBiImIiIlndLdF9wdHMcd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    "], {{
      {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1ULtOAgEQnByaeHJyELgPMOETfHTS0dH4CRJa/RA7+AXvG0xAaqKtJso1
YKKFpYkUNIaZzFJsZrM7Ozu7pzd317cJgC6jxqinwJb4w5gcA7/EQQ68ZEBF
Yq0FLBP31zC3wZlPYp4618wXeSviYxvIUutqftkxryKeFa5Ju0xd34SedKUz
PAEW5DyR896x1nlhzkPsLSNXTV41N6b3JLz+N61dBqdHzuwAuMo9V8bey8I8
efyIXdqpeek808Or7jkC5plR9f0f6nG7MItc/Sr+pRt0y6jhmniq77Vmbf9L
f7un/ynzt0Pgr+lQ/s2b+oX9XhB3UYhFdQ==
          "]], 
         PolygonBox[{{3685, 711, 1211, 3903}, {2700, 224, 2311, 5330}, {4355, 
          730, 729, 4354}, {5429, 2316, 730, 5428}, {5051, 2060, 224, 2700}, {
          2706, 241, 2316, 5336}, {4581, 1492, 223, 4580}, {5338, 2319, 241, 
          2707}, {5330, 2311, 1492, 5050}, {3273, 729, 2060, 5075}, {2699, 
          223, 711, 3427}, {5430, 245, 2319, 5431}}]}]}, 
      {RGBColor[0.18832000000000004`, 0.35240000000000005`, 0.57776], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUbtKA1EQnUSN+8hr2d1OUL/BF1bptcsHWPgotEhs/QELtVL8D0EUH71E
CAhGJYrZZEVBBCt/wHM4t7jMzJ0zZ87MzK63m62imS3jjeEVI7NsAj7sGj4C
z+wOgOtY/hVsB3EI/7RglsPvjJsNYfdLZr7DPybCHAVme77ZDp4Hvp+66tqh
csTcgnMb+Rn4I9TexPonB7W8431D2yT+SsD1EDdrZr/4W4HtAT+N3H1Z9eQh
/iyRlgFm6cOvoPYYPfuIB8ifo26jojkPA8X8PwjUM/DFc4K4Dv8t0Yzk5AzU
Qk0ZMJex/ItYtdTDPc2nmm0BtoWZPexqsyqs52q7bqcfkXZJnZzDqBNchUia
qK0B+5JI2zNsBzNPgWcu1Q1YR828A+eiVuapiT2eYnGSO4+U5544H3vzntRF
ndS2WhNvt6wcfe79r647vEbqzR4PsW7MWxO7G2pPvDlvkrk7LqXCLKbC546T
uoZO/2ekXX/BNmrSs1WVxpHT8Q98RWV0
          "]], PolygonBox[CompressedData["
1:eJwtUUsvQ2EQPb1tua/Sm9u7k2DhH3jssJIgNn6ARbFg0dr6AzZ2xE/xbG2l
pIlFPVpxS4XExoo1zuR08SXzzZw558zMeLm6WnEATPDl+LIR0M0DYy5wEwJL
w8AX8y8ELTP+YH1vADjKAD9F4KkEFD2gx3qH8QoxjZxyhz7wS8xzXpwOe++J
8T3l/lhbJP4Tyj2UxGFc2/zPJMABOQqeOI27GcpLyv67GHgk/tURps24xlxA
7w3mLol9ixSb351AmqY9YhjWywVgLQvUyT9P/s0hwM3pX2e9w/4W8Sk9thlv
9Osu+2usVwNxX1GjF2kn9jcPF/QyxRm2PHk0r/u+9DzWT1k/4/Nd5czLLD10
IY05xrdx3yv7m7FmsniUuVYsD+ZlkO8k1s3sdqY5Se3pRLvc5VtIpGnadsP3
SDPbrKZX4SzHsbhs5m/Okom0a7uR3eo6lLbt0G5rO7J+879O/2mkXdhM5+T6
BwU/Wao=
          "]]}]}, 
      {RGBColor[0.21856, 0.36920000000000003`, 0.6060800000000001], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFUssuQ1EU3aWVtrd63ZxrokmTfoakpFMkJOYGGloDWlNDr4EYEp9BaAk1
9IhBi4pHUa96/IA51s46icHJ2nfftdfee52TyhZHC20iksZpx8lFRD7CIndI
toALHSIniKeQ/8R3A/Eq4h7Ey/j36oksAV+AbzYuOqzR2vWASLaTuG9Ebn38
C4oMuCJ56JwGqak9c1a3gtwYhjlGfs9Q6zCGWugfId6ERiJMHZ3zCpwkvuvA
jPvfsxdxEzutRFmvOhNxkbMY6367RL5w1sCfdthzI8S++k85N+g1jz1CYfb+
tvxdw5knI+TNOMyrnuYS1sNHjz48AIe76d0IMBOlv1vQH3LpwyDwGrop5Ksx
5tSjH+hcgrcInWeP++ssc+iVjXNH3fXAkPMETsPj3PceecqvQLNsuOc4/Kn7
vMN3jx6pTj9wx+du2z77673rDCWfcdneYdK+B0V9HxrXgpxb+Yopy9G6vOWo
lzqDzjTrcIaWnVdz6mPa5TvoA1YN38UFsOlxR/VD35DOEUCu4PDe9f5rhv6f
A/8AQLB3gg==
          "]], PolygonBox[CompressedData["
1:eJwtUUsvg1EUnFbbfP1U68vXbkgkXfkBtsRrR0LSvYV6xIL6DV4blsTf8GgJ
3VIkWlRo6x1FYm8v5mQsbjL3zpwzc85NZxczuSCAbp4QTzEGnPBhogUo+MB9
EqjzXiJZI55vBTYD0tQ84JKamSjw6QD75A988SXyh8RTceCU+Jm9s8Q3fJuj
vov6W+KAp94NC0HckwJmo/K8YJZrajocvRl3xXunI0/zno7La4ueOWar+upt
Pc9jOoatpkJu0AU+iFcizES/vaSym8eQqwyWJc37HfU75JuOPOrkyjFxZ+w5
mgBGEsIVngxxnjVh8kvs3/BUY7W2kwXme+N9NaIMlqXA/l+OdmK7eSS/HJHn
gKtMlm2D/Bjnf/GU3ep3Wbvu6q/M07z7mKEY0s5t9/3kt8PSmLbJ+rWIepap
n2wTZzW9rB2m5jeoTHn2f/33s/1+twNHvrC9HfvKYFlspndqHzzNbvP+UD+e
UnbzrCbVw+ptxidq/wALtGRd
          "]], 
         PolygonBox[{{4331, 4330, 2927, 1668, 4576}, {4579, 1669, 2928, 4330, 
          4331}}]}]}, 
      {RGBColor[0.24879999999999997`, 0.386, 0.6344], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUztPVGEQHXFf3F129+a7FBQU/AljeCQILdFAsYVgYHdbhIpAaBQrEzoi
b62NFeFRLFZCMJqwuwIFJEAAQ0yMhkdv4zk5X3EzszNn5jtnZratND4w1mBm
ffge4vuVN6vGzXZDs8EmswKCz2HvkmbxRrM6cjfwY/Br8F8nUAf/B2q3nFki
ZfY5I8wtvgPEZ+OKzz0w24jMWuDvO/W48ZiewOwQdh35D07vvYdtTYnDEXLD
WbMz2Mc5YCPxedZs9g/5vZjZMYS8DYTpgv0CDXX479DnT1I8yGEGGneAncwr
R8wM8Bvwh9BrBHorMfnEfYpUOw18MasYe5TgJ4ErZ6V1KiEtnN+rhPqeh4o9
Qf9yWlz7gT8OhRlF7GmztHMGP1N6i7UHXv+W18qZEEd77/12zGIbHDpy0sC6
R7A1p3l8y0gnOW/DP/I92Zt7IB/iVp12sQK75LTPN4H2RFzdaQ+sJb7stXfh
3bNQt/A7r37Ek9vLtO7jJNQs53lXDeLL3/SpgzXEc368L86LvPnOId79ivoJ
5Jad5sj8JWIfM9rrAuIv0sIQ2x2I/yn8zUi30xsoT57MkTtnwnvgPfFmeDtX
oTj8hZbOnPJF3MNIWvy+h6qt+HreXcHPkPrZ/8LvlrvkPhadboL/Lc6CM1mL
9L+hX/Xv8d3rUP02Y+L9H79hlIo=
          "]], PolygonBox[CompressedData["
1:eJwtkjksRHEQxsfagz14L7sKhUKvljijVBEKhSPsKl2VBA3RiU7ipnYUhN3C
qhCFwq5dhQJxREJIHL3Gb8wWk/fNf76Zb45XnRjrHPWISA3mxVIxkaoSkWtw
EtwcFFn0ifQWi8yBXx2RS/wZv8hISKSWtyzced524O/HLHbFWwux2aDh4lK+
xDrKRH6p9ROAHxa5cEUm4H/hb+M/4Geo5YWfg/+Cn8X34efx3xyLj5PTh/6t
a/X17Q78iOXEcp7A745h1RiAP+VYrx/obYVtJp3tiOHrykUasDT4jKUM0Otq
1LRUYwV85tr8OvOJazmaG8AS8DfgfAdMU7Xz+Deewk7Bu2gm4Xah2RNBI2L6
qllPrVbs3Gs7GqTf7ohx9U1jk4X+n6m3F7Metdc7+ukHp6l/6rGah+gNU2Pa
bz3r7XTnunvtcTNqO/7fNfn3zLMUtd0sFIkMhUxDtbTGjWs31FtqvWW4Wayy
xGbMgOMRy/XzlsI/gJ8X4xzG7MZ6609snfhx2Lg6k87WXlG4NTlt4KZy263W
bASvRS1X763/gvaoMZ05zvx/iXFyZA==
          "]]}]}, 
      {RGBColor[0.28026, 0.4022, 0.65432], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUssrxFEY/TAemd/85jf95h+Q7EVZsFZShFIYzGCpKFmxIAuP2cn7tTXj
kbzyWBHCRtZSymoSf4RzOndx+7577/edc75zb9XweNdYsZk1Y5VgFcrNsqVm
y0VmP4HZIuJuaNYbM+tGQQ/iH2p+sc7QmML+EvHQM8v4ZqURs6a4WV/UbB69
1chT6FsB5j3qdoB1jpj3VHuNdYf9RBn4ytXz7XgHgXGYFE8bsIexX8J5DTAn
A/VdAWczlKYtxMeE6tm3FgpzHzUH2H9WmDVUQkdCfA+IaaeZ2keBX4Z8HX0D
2EeQzwbiI+9QVPNQYy/yPDA/gJlLqm8VM77Bw9NQM6djwqCn9HM6kFcdwK4D
zjnu6uPyldpOi4WRdTiMxGfe4jT0AbM2rrNZzHIM7gv0vWCWo6S8fUKeicpD
vuGgm4Uz0W9qo3fkJzd5bzy9z0koP3hPzdzz/Br3OU+1U8D8wlrAfQo8M+4t
+CYj7o2odyCqmkKgPnpE3UO+cvrNGSMV4jrwNEunLzxq5jl9pOYzaGn3VcO5
G+O6z8T0nzj7K2Zv9cVDn54TOqc3Bad5m38wFO8t+vqdTs7Ev/Pr/uF7Uvkc
fN4LxUuNG6HOeZ92PvPP/gPOlHpt
          "]], PolygonBox[CompressedData["
1:eJwtkskuRGEQhQvdiNvdunO9gL0ViQjxAoQgkdBttiexITaGhWkn5mmHZkcT
w8o8bDyAWAvCQ/hOqhd/UueeqnPOX/+tHBrtGCk0sypOhHOfMhsrNpsrMPtM
mtWWmX2UmnUWmc1QP8GfMjAP3xuYZSvM3uGXomYT9E9yTgp95hiuOeH4De0m
6ppys1zEv4lr55xRL6I3jN4r+jnwAngAPF3ms/I4Qi8TuLcyPNA7g98q3sVo
DqK1HzP7KuEu4D7wbuha8tij7or7XZShmix9gfPyfEZvO3R94R3qdNyznYMz
1C8p19JMP7NtCefUM6S8Sfe+4dsUdUvCs2qfafiLmHMZMpyg/5i/rzx74BvI
FGV+GVxf7jtX3m/utEp/I3gl6vML1Acx59TTTb7BwLMoYyve40l/G+1Iu7qm
P5J/L3F3+feWhrTq8LyMeIb+hL+perVT7Vae8laPetdD373eMws/C/9L7x9n
E+409P5b+Cv4rdA57UT/ku4kb2W4Tfk/p11JYwOuO3D8A14DH8a8Vr+yD8R9
V7pTDv4f0Pxo2g==
          "]]}]}, 
      {RGBColor[0.31782, 0.4154, 0.63224], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1U01PU1EQnZa2FN7j9d08+AH8AF3UhfEnIBWIIdECwdCFxmgUoimwQNiY
uIQSQly4kgIbKCRA2CACxo+EvQnhY6X/AL82ek7OdfEyc+fOnDlz5r7OytPb
T9JmVsbXhO+jM6vmzIYDs9O82S8E3yO+kJj9hF9GvLMgvxSZrbab9cOfaTU7
ySveAGC5TbYeml0itg7/GDirGbPfOL/BeSOj2jX4e052GXgTsfJX4D8Hl1SL
2YGphrWH8Icj5SwB/1lOXMmT9+d55RCLmFXgjeXEj5x6IuWNYJYi/NeI1UL1
Yb/PWWGM54Rz3K76fXBMtyj+JSttWMu+1OwsL56cdzMjfj/8fC9Twmh4fxf9
mpC/CV3HEvWZhIbfms1eAXs2pVpqxPpaVnFquIXaCngUO8weJuo/jtp5+N9R
X4O9H0uvEvbwNhTuXCK9yIsaU3vmE59c/jarb7EgjndR+wJ5c+g7BXvgxH85
1F7pM3alIF7TrcJIA+sE5wb6Gfxtz5d3jNMyzl6cKeX9jUT+DvJ7sZc/4PcA
fR8n0nUC+NcjaUXNRhPt4QI5p7HnHEj7fv/mpmNpNwPbFWk3VwvaIXdJrKFA
e/+AWerY9VdwWILtjrSDa8h/lOhdnMWyfHPUnTtnLfmRB/lsO9mqj79z2j3f
0XyoN1P08/F/4J4qgc59iHe1KYe5R069BnF/JxB/zjEQ6P3dgn/T8yTfekb/
IOv/c10Hxr1AM39y0pwzcmfEYA3zt5z4Uu/FULxuAHPNaVa+Nb4nxnn/D+21
qtg=
          "]], PolygonBox[CompressedData["
1:eJwtk0lrVFEQhatfosb3Ot3v0e0PCOJS0YgE/QeKEyKYOCTYCwUFB4yJIphs
RBcuTMSFC1caDWp3EojDxlkcQN0KIQZc6D9w3Oh3OFk8uHVP3TrnVNXrahzf
dSyJiE187XyjecT4kogPnA9UIrby/WqLmOuI2JBGbCP+TTxPfLce8bqIGFwa
8YX4HvF9vgXOf8jZXvGdsCFy3pDbrEX8WxbRWB4xW444Q80XcJWIP5I7kpr7
M28miAc6I66UwImneTvOm+uJNXVVibn7Tr3dxHvIfQSedJijBbYTDX/BLuPp
HN6OZK4X5EyBPyy79iXwwdye5O0Uel+h91bdWoSfzt0D9eIk+FPwIe6aiTVc
rbmGctXDEc698F0oOedJ4RrCv5F/s+wey28LvJ/zaGov0wxjLf5ukzO16Pda
zR6Fz4CvA39WWIs45qm9irvJdntuwN2fuffv4fyau6Zq/wTfAl9f5toT3K0E
e1A4VzOZLTwTzeYdd0fhP5h5tuIQV2txnm305HHZmqTth+ZBbqvw2+fUa3Lu
XuHZzxFfxOtwakwz3Yy39VVrk59uzhvReAPsJTk9FXuQvmE8DVB/IXd97eD+
zDVVe4y782BnU79N4PyEl5matWoHtFu9neZSj/s4r6lau2ayWv0oe1fkUbt7
p+5ZaQaTnA/n7rU0HsrNIS5pPEH+vsy7JI3Sqh6r1/qH9oK9LexF/4z+nbGa
d0P6tKs9qXdXHDvw/x9nw48s
          "]]}]}, 
      {RGBColor[0.35538000000000003`, 0.42860000000000004`, 0.61016], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVM9LVFEY/dJJ613fNI87/QGuy2jK0KC9P2ZCMMhoJWKaE6kRaS6yTSUu
0rSIaJMxKdbkRKDLp4t+KVbrgpYF7XXVqnM4d/H87tzv1/nO+a7NA2O9o3Vm
NoivHt9l/NnExfwBsz84VzJmW7h/mZgNNJhd8WZPmsyeI+Y97pqPKGYRd6vw
/Ws0Kxw1O4b7XeRNR2at+GYOmt3MmV1DzDZivuXNzkSqXcqiH/KfomY//B/h
t8NmX5BzNfwehh1H/x+HgA/u78jfxf0Uaox5nUdhK6jzFnVuoVcZv4uYoTNG
PnI/I+ZZnc60U5hxJtLMp4B5CPH7jAeePdh3GdVaRq8L+H03EgfERQzLieos
NGlOznsadgi97yBmONgScj/A1xULzyRiOkKP4+BpPODnTL9yqr+F2jdwvo/z
nJcm5Ja6dMTiipydBO6fqP0ANQuodQ/+PvjX4UsRs+bF2WzAXAb+nUbpRw2o
xW3kfs2Jj6JTbcazFrGvZIT/oVf/ESeM1IM1l/KqVwXmMnz1iF/w4o+8kUP6
2Ys9yDF7sH4LMNcQdwL2ohMn5IZ5vxFfRdwjr/O8115wH7g3aSIMl5zuPoX7
zUSW+9XlpBn390VeelG3vYCLmnFXeH4FfzHWzN2xOCW352CrYbe54+SU3G4E
jrk/5KXPaSbqwLfBmckNcfEtERO53w78T+eUyx3kbnI3iK8WeOPs1D8N75H9
uQfEdN5Jy+vk2Ytzcr+WaL9rsI+9dJxAn/VE8Ruwg166TUTKSwMP1JV93sBf
ctKKe9GTlf5tiG/D+S+wnYXtcTq3Z7VznH0Rud1O8xayes/Uei68S/Zjr9fh
7VCTSl5zct85M/eDtdIwP+M5B+sQN/+X7Ad+/gPcD7Qd
          "]], 
         PolygonBox[CompressedData["
1:eJwtk8tvjGEUxo8ZNXTG95l87R9QsXNtSRB/gE5nkiYkJZYNHepSl6R0UTZE
LOiNEtuhwtBuatnpwj36BxDsSOxZWfk9eWbx5jvnPbfnec739gyPHbmQi4hD
nPWca50RHwsRnzjnsogfWyIm1vnuLP4Zznvs+oaIV+WI48WIi9gfOiK+k1sn
/rZg/xv+Kfxh4i16n8S+wt1tYk2GXsbenUYsMfhPPmKIXhPM/0z9GucS+XVy
Jsl/Q/1gErFXcexb3DW6IqZLEe8Knnma/Hv48/T+S78R/EnqW/gn8K9j36D+
KPYiM3cy+yp+NW9O4ta/2f4T4ltTYxCW39ztT8xJ3MSpAt4mGjzOWaMa/gKY
vmy0JivEXoNnhXiefkvClxn7FPl3sXu7I/7R/yuc9mD3MuNX3pzEbSZz7Ut6
NEreiXYzSv9l+u9IrZ002Y7dn5i7NN4Ht/FOay9NDsPtIT2e0a9GTg3/fOZe
4nCf2BT+z4I1GiLe18YjPeaIb0tdLz0G4bsG39gUscqnBZ55chba/avUv8jM
VRyb2DPEH+Ws8Sj+rtS70P9QSay5ZmnmQNEz5Su/Qr9a4lkN7npS/0OqFebp
zJw0W//MCLEDibFqhw/Uq8tait9T7HFy7nR4Z9rdQLteHMW1r9v/jna4TH21
6F2Lw3P4Lpb9FnSntzJbMjbhl3biJHw3iR+j9mAbj/prF7OZY8IwlxmjsOoN
jGXegbDqjeitrJb9/0lzaf8fHimJfQ==
          "]], 
         PolygonBox[{{4320, 4319, 4533, 1642, 2893}, {4974, 1995, 4976, 4319, 
          4320}}]}]}, 
      {RGBColor[0.39294, 0.4418, 0.58808], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVM1LVHEUvc0486Z5M808fq9NUFBEm4I0JYL2Oo19gAshhEqdMQvUKKio
doVRak6gtSgtUqoZjUqX5SJd2MciaNGmRV/QH9C6RedwfovHvXPfvffce859
s71vpGs4YWYVPEk80zmzBwgc2GTWnjebgj+B2N6C2fUNZt2ILTizf4FZA/Z8
0Ww0ZXYBdhl5b5E/j/g3/L6E/NPwe9Nm9xP6PQ17Ki0/0aQ+bxCbjRSfgd0G
rD8Ypg0z/ML7LvgN5JxJa7YrqK2g7zu8qzr17se7y4gfCtWb+DWn2ThjFc9D
5O1HzynM+RG1Q3g/F6n2CezfpPblnj+KwhlGzhjyezaa7dqMXWCPJzXzZEo7
0N+CmS8ivwP4N1LqVUf8Q2w2gP6L6H8ir9pF9Bwqqu41eh/Mqtc1xF40aV/W
MreWEqevUD+IPi8jcVhOCm8Ne6wE8vdlhX0OfXYUxEcJmM9RU0XtM9hPsXhc
ht+R931QtxP5V5FfRmw9lmaPkVP3tZ3Y63egfakF+SDuCm6mMy9u72GXMSfN
xp1uhVxOwp9wqr8D+yUjfanliJPl3TV7fltgP2ekC7WlhtSFWNSNPFCbHqf4
OGoH/R3U4B8J9Z4a8ka4IzmroG49EC+8UfK6lNN9sw/7LUXihzxRh++BtGjL
Cr+E+3kUiR/ydBs1P5FzC3Y+EsZ7xBuRdKf+uwvSdU9B9807n0X8cKicBcSO
huJ/K3JuOuGO+v24P3kkT+SNed2hYvwuOefXjHSZi+W3Yt4B1K+S85x045wN
zxG5asEuZ504uZuTnqteU+7MGyYG+VvzN1Z3ukve8jE/M2+HO3P3p54/asx5
yRO1JN5MLB2agVsOpQPvtN8Jqx3xPqc5Tjp9S8TshV/yPr8z/i+Qh1bY/xIk
qYg=
          "]], PolygonBox[CompressedData["
1:eJwtk89vjGEQx6er7fLu7mvfvPZI4iKhPbQqIuGqXStImpAICdtqtZJ2iShB
XMj60WorqTigLUXtllA90gMOml6Kg6uoxB/g7ODzzezhSeZ5ZuY73+/MPJu7
Sp2DCTPby6nntIVmf9aYfV9r1hyY5bkv8v4padYbm53kLGJ/5oylzUa4r2JX
AbmFPcr5Xbufy5rd5v6LewLw42BtXG92pc5rbMJeiMz6G80u87ZC/AiYE+T+
xd9NbpXzr5bfnzKb3AAH4u8T8xj7Jf73CY+Zi72GYscazHbDv43zAy2d4F3D
Hk27FmmQFmmQlgL+jozZMhwuwaWbGjNwKxPzM+n5hzPOQfjSeBffC2JONXqO
cu+B9yXpb8/x5TPu09sZ4rfCYQU+RfxT+C8E3l9pbie2BEYl4TVvEt8eei9u
oGc7sXPk9JL7DYxp9L8i5ij+D+QsUHuA+3LS+3kArlez3gv1aEA2/uv4yryN
xz4zzUozuhP7zDV7zeQdtYYC781HacJ/mnOR/Afk9GF3hM5XmEeoNxh77Ye8
lbB34n+U8JkfTPmM5e8D/y3457PORT3YQa1mduJ1vWMKez7yWGmaSPtOia9m
OoP+cuD6i+vMWnJmraFzU88L1JtPu3bFVOBzora/x4gfxrcrdK7idyjlM9Ps
voI/BX4h4z5p2I+9LXCfYp4RWwRvqM4xu7CnI5+terSUdQzF9/BWwbeH/PEG
5yPuTYHPUjOtRj5T3aVZ2nti7732/Qn3s1nfBfVHu9ISuk8c8imP0V3193F/
U+ufMFVLf0C7rB430estOe+F+q9dFGfl6o9NkjsbOXdpkHb9AeXrzw/DrTXn
vVeP9RefRv53tOPa9f+WDpyT
          "]], 
         PolygonBox[{{4301, 4300, 2891, 1637, 4520}, {4524, 1638, 2892, 4300, 
          4301}}]}]}, 
      {RGBColor[
       0.43049999999999994`, 0.45499999999999996`, 0.5660000000000001], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVEtIVVEU3X2e93Xfe/UuR4cFDQrSqOgLVpalZgSCVgRhSr5hH51IUA1K
M781sGFp+fw8DcHfSCl1FCFoo6BRBAmNm9SglNZyHWhw2Pueu79rr312NzTW
3N1sZg9wtuCMBWY1eWbT0Ecjs4WY2XLaLAejnzBo2WS2EjdbhT4Bm4uQi/Bp
xv0s5ALOO9x/C+RD+4zTfU/S7IZTnPLtZt8h53H/Ana1+F6CXyf+D+FuGGfS
lKdvq9lj2DQ42d+EfIRY7bgrgl9lQnaHoFdB/wH9OPQZ2KzDfhz2ZTgj0M87
9cO+xtFfWQr+sK/DfRX6no8p7yXo72PqkXgsxoTJh3yzeny/gu+BArMvuGsL
lecXznP024W8vajtGmIupRVzBPaXkasaua5ANofCbi9ifEor/gxsauEzhzgd
iJHF+Qq9zQnbOY/z9W36Js4f06rzDXwLEXMKd7lItfz29bDvXKB/u3aYDQDP
nZDVecKB94XEC7ISuYoT6vkZ4pSmhDPxLklpDvehX3CqeQX5B53yHSyQP+M0
oZajCeHYijjHEsK3A3pRKCwnoJ9IqI4e6PtD+R5BLR1OHOqB3BdqJtlI2C/H
xZmToThD7qzF1Sd7GQ3EY+a4g/paUOfDtPiWDf73QFmC+H/j4hxznHWyOQN5
ymn+jaE4RdyIRYVTjnLIRsRtRfwmyHOeu6WQ63HZbHAmrblVJMT9Xr8XL30/
5BQ5zvpY02AkzpA7/ZHmyzlPRsKcfOlOCoN6p/2b9dxgbNbD+Ks+Hnsg77iP
xOtwKO5UALe+fO1zf774Sv/OpGJQ37BLiavk7C3/FmQgu/yMOKt7MWFEfLgP
3ItiyM9x5WbeYSdOTnhecy7kJ3ed3CD+5Cn5wDnuCRW3DrmmI3GDHOGcOW9i
RLw5P2L0xCkX94ycI/dO4+51pNjkEXed+8O+hiLP/VCz4sy4D3ybOKfbyPs2
0gzJ2asp4frUqXb2xr6o//G71u6EHXnR7WRPv4zHbSApSdzoy/lzjpwdd2gt
EHbkOPnAf2NO8af8u8IeWD//bcwFvuX+HeN79g+Mgd9x
          "]], 
         PolygonBox[CompressedData["
1:eJwtlEtIlWEQhsdLHvOc7Px8tQkKWhRRlFFa0MWy8mgEgtLKSskIgsrcRIts
kV28t6hlaXm8h+BtVZS6ylRyF7SKoKB1m1qU1vM2Z/HBzD8z79ze+bc23Khp
zDazKl4ub3eBWfMas+85ZiWFZk3o03z/m2+2uMFsf6HrrQQVIzcmzVrw/xwz
SyfMuoLZF+SWLLNO5Iq42VewegDftN6sjm+V6I+J78C/OzKryTMbJeYO+sPg
sffAbEWu5z3BdwZ7A/LZdWbVxH+knjT1dBFfTfww9mbiy/EZQZ4lfonaxrFP
Ue8c+gTydOSy+lki/gb9jWO/S45SsOeJeYv9DJjF1L59o9npHK+hE/wh4mew
rxD/nvgi7D/J9wmMPci9fFvOd8wefOfR/6BPoD9Hr6W+V/jXrqU/8F5Enk8+
8t3LTL/lOEYPenvCZ/WDbxeCz0izUo+p4D2qV83gIPUuJ70/zfQQ+rlMvjle
N7ELSa+/CnsJ9hTvJvN+jf188JpUm3ZUzjwGgve3ypvGNhZ5vlXqW6C+toTH
/u8J39Lgs0yjH0d+hn99nud4R+4p/FdijinsFP2+YTaz6JfQJ7H/jjmnruPf
lXCb8NXLseDY4lQRsc0Z/i2CcZhdXgzOFdnFvTp6eJTlmKPBOS1u3yJmW4HP
RLPRjlP4Xom7/y++DeI/nnBZ9fajPwjOdfnIdwcYH/K9x6f02of/cLZz9D6+
m+F8X67nrIp7zapNMYrdVei3pJvaiTwMxqT5jEcivzHZhbEFrDIwB2LOGXF1
LPhuVI961U60G3H+ZeQ3p9sTpyrjzllxVzkGsLdFzoVBMG5Tezpyrooj/ZFz
WFxWvt7Ib0a3o3qn0NuDz1433xH8BnWLQ7xTwW9Ut6od6V+xmIkXRyuC51Ru
9XQCvSnpty9O7GM+R4Pfomo4gnwgsz/9oy7jezJ4LtUrbl9L+q1oB1eR65K+
a82wjPn8AxKHwXM=
          "]]}]}, 
      {RGBColor[0.46806, 0.4682, 0.5439200000000001], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVElPlEEQLdYZZoaZ+fLNePGgaIgGosQFEEQWWYwGYmI8ACIxnlAIeOCg
AWSRYXNJPLgkEAGJSzAuB4MiXDQKQY13SfR/KBff8/XhS1fX9/pV1avqzrvY
c6Y73cxG8GXg6wibpWWapXyzJ75s+tqzze4C+BKYIawnsb+UZjYfMPsbNBuE
rwL4OeyPYS3FmU78/xY3O4H9IvxfE2YDEbNRYG97ZvW54hyH73BYfOtxcZKv
A/viqNlbxNwXQlzwbOLfLPDP8f8n7GFgUuBqRD6jnvzMecP0f9NhysHfhfUH
+FezVA9rqUEOdSi8Hf7HCZ0/C99KXPEP4twG7MuwaxH/N7AvwJkCbltMnEeA
6UNOI/BNeKqBtdQAX+J0+BiXFrTr4b8K/CPwlMMe9JVrYdKsH/4b4LkFnjZf
eTaAYxr7V8h3L3Q4D/8K8JPAPoX9B/YzX/pS5ysh5Ueb+S0EpCnrqQirhu0x
9W3Wac34rJ26DSPWKcT9BL4ypxtrvYd9L7Q7hzr6sP5y2haHpQ91KoiKvxBr
q6/+TiDP7rj4qTHrO50tLQ6FlRf1nvLkn8Q6hq8J9mfg+zz1qsyXbz0ojiFP
cziI9X5CdTSyj24+GJO9WnT92gldvuDsA2CP++oX+0Y+xiVng6/55JzW+fKx
Jwuwl2G/hl0UVS+q4FsLavbINepLk/mI4jA33pUBT7kxxwMhadwKjj1R5dWG
PPOiivswIS5yUtNqX72rxNoMXe9A9w8OR/xNT3euNkOxdiXV06PAD7hYjDmc
pZ6tmO4b+8L+LAH7Dl9vmvJgPruj4iIne9PsC5PCucpc+XvAuRrQeZ6dimjf
7iv+VlD3jDG/BxWXWM4t7ZYctzfVtZQpfUtjsktiypHzxt4XJFULa+Jccj5H
UPuFHJ1fdvd+2c0w/7M31PJ9QHlwVqvdfa/C2h0S946Q5oyzNQ7OmYRynnbz
/j+PNM0f8Ty35t6RGU93kvPAuZh17yH3c7569Ybz4PD9nv6zp8TsT6qGIqzX
I9Kfc5Ef0rvH94/3mzWSazQi7fKTqmM2U7jOuHrcFXfapOsNYq8W3N3fcved
ccci0qXF153hfF5zbxJrZr1N7k5wDv8BasrT+Q==
          "]], 
         PolygonBox[CompressedData["
1:eJwtk8tL1FEUx89kNuXMODP8dFVQGm4UCnpomflIxx4UQg/TTIlqUSnZwkVl
OaPOmNoDWkQLJTXpQVFtwh4a0UIjiPYF9X9Emz5fziwunHse3/s933Nu2dn+
o5dXmVkbZzUnFzV7FzZb4LQHZtmk2eE1ZitrzcqKzMo5X7GP4BsjtrXU7Mw6
sw+AzJOfoX4WoJYCs6aY16j2EPnD5HcVe+4COTVxs4clZsvEM/iGiOfI7yhw
zC1gHwNjOGT2Gz5Z8D8nzC6FnFOO/Bne+0XsJydNPI3v4BrH3ATWF/J7yW/D
N0lshff+EXtNr1Pc56KOPVhodo7cExF/T5gZ8DbEvZ8/cKoj9ibq/EP4nhBv
xdcD9hL1K9T34FuidgCMFrh3x7yfv/ieEruVdO3Ug3qpjrsWylHuZvTJgd9H
fHfENZE2F7hv595HzTBvLcI/RW4q4m9pZh3gfyJ+MeQaZKitxfcoz0e5ndzf
h71H9SqOit3njRT2roi/neVeBn5z4FxHubdgpwLXU/FW7OvoMQ9eM/zrqb/G
PU1sBl8589sWce7y3YRPU+D8Rrjvw65lRvcKvX/NPk39TH5/GsE7n/DZiPMY
sfGoc5Xmp6k/GfiuSvNJYlfAeIH9knOA2I+E9yPf/sB9immelfS3l/ts2DUe
hd900mepHdGunCLnm/nMtbv15M+FvWf1vpH3XhEfoOZBie+Q+GpGvdi5wHfl
OfWPya8q9re1U/orDYHvojAbse8kXWtpXIN240nXSjPYGXGO4ioNd3A/HnNs
zVN/ZSLpu64/qr86UOS78p37NPyqSv2vqKdK7IaYay0+2vX+Ip+lNKmDT0/C
42/JryA2VeJY6lGzGUn63xYf7V57fh6d/N8s/XUlXBvt4FXuzwL/Cx/hPIt9
I6+3NBzErij1WnEWd+247EVquslfH3f99EeGwLub9F3UjGvRYyLqueKg3dgT
+C7qjWW43M7nS99q8v8DQQil3Q==
          "]]}]}, 
      {RGBColor[0.50562, 0.4814, 0.5218400000000001], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVclOVFEQvTLYzevH6355dEQZm0EDauLIoCQYRXEHmkgYggsjQiI4gcaJ
ZsaoUVg4JKKCGnDDxo0oiVPUxD8wKiu/wGjisNJzPHfRqXp169ZwTtXtxKHj
+4+lGGOu45eKX2HcmHnIHseYwXQoacbMwWFDxJgjy4zZGhgzge9T6fIbDBnT
Ab0TZ+/C0qdhn4TPE5z1wv4+pvPtuDsC2yh+D+CzEwmTKYo75hvzDHdfxRSb
OXiXuVnDNeiD8FnA2Qv4FCLWIxx1OcrZlKEcKwLl74A9x+ZbBbkFvzvQE3Hl
pM68g7B/Qx0H0F8j5Dxyzaaof/aX56gX+iziuz1TtVREjRl3dXYY9dwLqZ9+
fH9NVf28z2/amWsUsT7CVg25OyK/bchfDf0L9GLPmBbbfxXsRZ7sJZDtsI8j
Vhn0Nk+YtEKucVTXLk91sJ6pLGFPnWcHM9Qb+/qbKkzZwwXguWe5MRchb+LO
W/BX4Khe6sQpNxAvLxG7CHXWwr8P/glHHI5C3wz7XtiT0CuII/Sr0Ivg8xA+
l6H3IsYni08BfGrgcxL2fYFqbYCsX64ZIn87MtXvADAuRJwZ2AZ88Za02P4I
qR/28hnyQ1gzUZ+q3jk/7I85ORvZyPEUdSyilwo7D5yLdXHxQn7OB8JnxhXn
sxbDSeCziPgTkF04G8bdlfAtwO85Yr4mPnHN4TmcV0bFEbli39wT1jDqajaa
cO+Kr7tvYprhRdt7cVw5e1FPXiAMO6EPBeq3GTFvZGlOOC/Enfjfhi0a1axx
X9krMWXMfl/6pohmnb21IN64r/jkqgb2HtzNRYylkGaGWCxBTqXpLDsq/YTF
gDySG9cT9tzL7yFxQ16m7fd69DQXyMYdIgesr9vW/jOsOEm7P+S3OZDOXZmx
cR4H6p84tHjilvgS21tpmgPWcT9NdbPmjfbtIjYJTz5VEXFALsZc8UcuzqCe
8qjegTLIAstfPmRdRDPViHvDgTAagVztKVcp5JCvveB+NNjZLkHvA4FmadpV
H79DmrnTFn/yTNxZby3wOeqLN75nd7M0032OcCJexI7Y8z0kbuVx7fnauPbv
j90F3uHdUr57rnDJieqcfuy5MlBfdXa/ue//dzukb+pnXXHTBpx+hfWu0s4Z
4f8E56TbFQdZUb3RrG3Y114yF+vJd/QWtMa0m3w3ySHffea95Cs2cyzY/wHW
z/p67VvHN+8f+3veLQ==
          "]], PolygonBox[CompressedData["
1:eJwtlElL1WEUxl/T1O693nv//L1hmVNqodXCIocUjIpsUWAuQi1aBA6R2mBG
k3odoyJ0USZZaUW2cVGbBovAVOgbRMOqTxAFZav6PZy7eOGc9zxnfM77Fpw4
3dC1yjnXyEnhbIs59zPNuU/IW5FPhpwbRh/iZPvOfch07k+6c4+wD3jOtWGP
Y/uc7FxeGD3g3GNsK2AWwS5z/iK/WY3dtzvZXqNvQF9K6PIZJV4e/ovoe4jX
hVzGiYOtR+9FXofPIPlmwLei16N3Jzn3grvDyNc9i6V8N5CHPatV+UaQC/Hp
Qf5KvI3Ueyxq+jf0zej9nsV+xV0ceb1vvUt/B7YavY18R9bgz3ye0/9Kms1s
BtulkNlawB8E/8w32y18ZpGveVaLelbv6kH5fqMvoLejP3E2M80uB30O/Rw+
tzMNI+xL9CzizZHvVyL/tGbjWa3iSFy9j1q+2lTqDTo3wd0Stjr0XrCd+E9C
/Bf6z6f/hajNrh57OfiisM1KGGHXRkzWXRX25rAtjjgSV2fATKXYPDdha8gw
7r5R3yD1XfAsvjjqQX4btV4OkG9H0DgW/jgzLI3ZDmgXHuBf5RsH6q8GfB74
KfoZZ4HrwNxHzqS+iRSbYYj8+zhPsc9xV4rtpme9fWQGk+Cvou9PNU6XiV2Y
6Fc7od0YoZ8x/L9z10j+u5lWqzjLD9jOqNeHxO8DO8OZBf+PuwHw1dTYmWQz
ySJ/dsSwuqvBVhKx2tSzZlWbYbZRYuxG7vBsPtPkO4V8KGq7pTent5cbtrfX
zV1uwHpSb+KzAFtRzN7GPP6FyDnc9RK7lRxl5N8etF1QDnGx0zfbPXzKkceI
N59uOZV7l2+z6CPGRfIP+cater6MvCVm3Gnm/egtAatdMcaJ1cTdj2TjbDRk
nIpbcXCF/o5GLbb+gDvgi2PGrTgYBt8ctV7Vg3qZDlkuxYz79uZUq3Zcu14Z
tFloZ7W72nHp2pEOfM979jb0x+mvO+vZbumPaUcvj9jb1Y5XIDeFjVu9Ob29
krBxJc7EdaVvb1V/UgVycWI/tE/6e/aGjQvVrN0siNms9cbzkf8Da7C9qQ==

          "]]}]}, 
      {RGBColor[0.54318, 0.49460000000000004`, 0.49976], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVVtLVFEUXjnq6MyZM3M6Z6IyHU0LjOxuab50w7dALemmBIGO10y6PKhR
FhU9aFfooaiQ3rpRIAVJURH00ltaED34B/IfRN/Xt6OHzdpn77XX+ta3Lqfq
2FDb8QIzu48Vw7oXN5vHZgyHK5NmHYvM3mbM1mbNjpaa1UHuKDa7DL0B6FyF
vILVCb0HodkrnD3xzBqg86bErA/fnyLp9CTMsli9RWYtsLkC+pdw/hH37bC9
E35Hob85ZdaI/SbIKodhGvpB2qwJ5/Up2d5eLPtlsNMP2evJFm3m4afIF8ab
kfBecpgnsRZg5zzsTuKuB9/5wGyPr/PdkMPA+M3hIa4PJeKEi/w8BldN8D9T
It83Iu2DhO5fwtcEOYStR9CtTggH/Z8MxBG5OoT7HGI8AiwziDF0+hnE2u+J
3yrENwv5y2HeF2q/E7r7sZ/GXXsovsjbEuxHsL7i/CLketjvwrs6947x0w7z
8BPfw/juLJX+Z/jOF8gOa2KoQJwT03Sh2e+YcDc47g/DzlhC7zZAzsXEHXmb
RZyvIZ8ijoOw3xwTJwMJ8VeW+M8v8fF+pEj4+jLydQAx3o6Ld75h7olni4u1
tVQ4K7K6p23mczvuDsHm9Uj7roRywDhW+arlAy6WpWnx0ASe2lLiphZna9Kq
B9bFOLj7ARwPEcuaUJhyWdmYKFKc5I954nvufzg+51wdMca9iKsX+2usu0BY
WYNljpM6+LoQygaxnIsLP/XIzYLLXzn0vmN/GPbaQp1dBLZnnrCQ+3nH979a
ZZ2yzviOOSZvI3Hh4f5dJL0TeHs7Us2XA1d5Ulw+z6gn7sYVT6Wv+hj0NBNY
25wD1Vnluyar3I652BtSqrUhT7XLWtwFeatQdvOuv8htl/NHvyvgv7FYHLDe
WkP1VwtkTVI+i5Grt5GrS+DP+YorD1+rffk9gf3WUPjrIYcCxcu4WXtTheKr
N5Ad2rvnqTdqEUtlWjo5yBcZYamA/wFPPJAP4vjLAc5zoeYe5x97tNnlrjKr
eVcFmYXOWdxFkKcD8XgGcluoWdwAmUqLD/Yxa4FxkRfyyLgi+L1TqL4gjv5A
fA0Eqm/2Eetw0OGs8TVrWAvLQ81WztjKpGqD+WAuvsRkl286Uqr1qVCSs4C2
F+N7lPnylEPGwrfrXI+wVyoSrkd94WJNM5cbnb9ylyvWIuNizxNzPqkZwzlP
rN2wMw6dZbB5PND5YKB3o+4t9anD3HR7whJC3/MVTwQuezzpDQf6Z7AvTmG/
OimdlK9ZwJlQi32Zrx7206px/kfI1/tIvohrudOhLmuO8bDXl4bSoS5nFbGS
iz+Uy+HN
          "]], PolygonBox[CompressedData["
1:eJwtlMlvjHEcxn9qGZ3OvDOvt2NtZ1qKVlSIrfRii6u1oWiIqK5UbYki9u1Q
S0gcrGncJBKkIYiIk4ubLREH/wD/gfg8eebwS7779/luv/q9A5sPVoQQ9vDG
8ZqiEH6NDeH4+BA68iEUq0LYMSaEboy64xDakhBGUyFch98M3YusZYJtnmNf
h/0u6D70h9H181aU9W/QH4Jvhd8J/xJ+emJa9jOgC7kQ7gLkMxjmEGs7eD6B
6yc5z6E/jv8q/Dvw+YD/rCrT/fiPxzYb2fcq9r2ZEI7Gji1MM7Hdh2xTJZiw
WZwN4QQxv2Dbgew+uoa0a1cPGon1ANnXlG1k+zhjLOKH4FdgP4z9NuwvQi/A
Z5h8I9RQRy1HYmNT/nrybwRzD/aDyFrIXyTGFWJd4/UR+0IZz1nsz0PniHGb
WD+Ivwj/ueQYwn89/BHoZvI9Dc6p3DXIBtF/Qz8d/kLGs/oDv4V4g+DprXDP
S8TbkNj3BTk3QTcU6HmlZdIdyhir+jEVLAvx+T7WmIStGpvTKctqIs9Ysz6H
bCq6KbwzKe9AH7lr8G9HfxLZpMQ+8hVmYW8s7596VEh7hpqleqRercP/N/r7
8MsT74DmL30JvpZ3OeUdOUa+7rR1ilGHbkfevXxIz4rouniXUvaRb8LrqnBN
BeimnGfxF5950Gsj05qBZjE58S7JZz9YNybupTAKa0tirKfQt5P7fd67oJw1
iW9As1gJ3oPg7cLnH76j9Hdpzjul3drNTOYzmwOxbd9ODCGPrjPjXg7xYuKV
sLmT8k4UoRemfT+K2UuukcTxXoPnGb5L4e+V56fZLoE/WWHZMuhi5F71ICtF
xiRsirGL/Z2N7EnwjsyBro5MS5ZAr4m8e7oh3VID/EBZPxP6RrVjr8TmJnQt
eD9S22r4A9BNBd+majiVdo2qVTesW24uuDeviPEocY/Va8W4Q7x69G2Vrkm1
HS7/B+/Q30LfFftv007WUn91zv+HMPZnvDPaHcky4F2b9e3pD9yKLp9zLa3I
YuhmZJ1jPIMF0FHOtyhZFnpJ1rb64/TX1Se+fe1wQ5VrVu3CXAf2OG2s+jMH
Ys9cs9ef2wM/LfGt6aa7M/4ThE83PAv/zrR7qxvULbZH7pX6qb+1lPNfJR/V
9h/7Tau2
          "]]}]}, 
      {RGBColor[0.58074, 0.5078, 0.47768000000000005`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VU1sVFUUPs7fm7438+a9uR0XpJY2FiOhNGiFskDTwEpN1JRpbGgp0sCg
NbRNTYyDWBPdgDWRAjWSWBdVVybEMmy6cI+wAYSEnewFLKXd8318l8XknDn3
u9859/y97onpoamMmS3jl8VvLjA7jd/IC2YHymazkFsrZl86s98A/KVk9ivk
Q4BXgb+Vmn1VMLsNOZ03uwt7E+dbYrMlnHeE4IV+DfYMZD84Gzg/Bp69sB3L
CJcAtwB5MpWNeMbQ4Xna4f9v2P4qml3A/8uJ2Z/wdxD4D8H1Xc4sV9H5WwVh
ToHnflZv6Iul74Sch/1fb38V/38Htgf+Z/LCnPLxMc4UfscQ8/fA7gb/LPy9
Cf6uyKw7kq/PYNtdEP4HUz6YK95ZRzx7Cor1U3CehL0TnPeQ4/ezwu0F/z7o
HySKi/4Z26THlxHjBM6a4DgKuQN8K9DPwdfr4LoErn6nHDBHfHtvLK6PgF9o
V8yM/RXEPA7uGt5SbzMb9PXKx7r7Ms4T6GyK9xL5v5HVnW3+bhvu1pz6xEG2
xcIUIRt56c/fScl3HEmU92HIVl7xnDflb9PX9DD4xgP1wZZQ/TQC/P9VnT2C
fFKUTsxj/D8CfQ1yoyidnJuQcwXlnz32eaCeipz0EPJOKsw/kCne1Qd9DPqA
r8UeyOMZ3Wf//ez7vom7D+FvFDwPIP+rquZHQ/lgTohn/x7yc8SZ+CIQ32ZV
b50IxTEWqI6xE6bMvDr1EGeL56w3MQOQq0XpVdRgEfV2kFWn/uuI1BcDHr/q
e4/6dKrcpPBbicQ5Atthb1+vKvfMA3PrUMubiLs9Vu+Sn+/8JNU553Uw1h6o
g+/jVH47I9WHdWIs9L/uYy4j1vOIOYa86vtgPFUeiKGfoVR+mNchvKuFs2HI
J77WrPlaWTlkLl+K5ONEqnP2wRXwdFU0y5x7co/6PP+RU8ys5eWSemXZqeaX
ctoFK4lin0xVb2KXgA0r6m32O+eHs/BGWTVn7Vnrs5i1Ffg7A1nB3SbOEv+O
q4F2JueecZC3F2eLrDFkPa+7fP9BJ/y3Jdkbnv96VjPGufqmpJnajxg2qson
88p++zHQXHO+F73O/cWZOIGcNUra9S86zeS858v4Xf1uov6lb/rtieS7G/hC
LD2A7HPytdNpX3BvRL4vuK/4Xu5Qxn8c/FOp6tNK1L/sMd6hvJiTzjNiZjib
FdmTinI473cj88rZ5EzR1vK5XfJzuj/WXhz0+5R9d9fj2ePkX/Dfp2ffqVh1
+TqvnVwL1Qv8PryTqL5vJ3oHc8IanQ51Z3sN8+p3+pzTPuNeYz24g38KFMNk
Iv5doeLi94b2utOb+L3trGkvb4V8zenuLsin51PvNg==
          "]], 
         PolygonBox[CompressedData["
1:eJwtlMtvVHUUxw9tZ+4wtzP33rkdjeCDBjUobyrgQgyyUxdKO6aNliKNlJdt
CSbGasGFGx9EQxUjRk0UXRmBAi5Y+Fj62BiRxJ3+AaKNlD2fL18Wv+Sc3znn
e96nf3x6cKorIiZ5PbyHGhFjSyL0uRk6aUb80h1xHOFIb8S3ecSFSsSj1Yj+
NGKav4+RPYLOw+ivRf9v6MPoLK9HnEf/PPQ69Av062XEywm66GxE/3HkL3T5
L0XWQecqsq/BXJVF3AHeFfhpMJaBd3tmf7/xtwrd9anlc/w1kA0Sz7Ng/cRf
N7Y5mDPwe/HRCz0Oxvvkeb0W8WNfxN3YbyW2efDnieVO+M3w5+DP5q6BavEB
+AX4Q+CPgvcc72or4uncuX8FZhvsEh+zyI7xJtAdyR37DBjD0BvQeR3+KWxm
oQ8Xrs8i8fxAPFfgj+H/OvZnsG+hM1FxD6rk01+angTvEPIaf792W0e6OxvG
/hP7o+h+URrrOD0dbTgn5bYFH3eRa545N9WzBGuY92WXYzyI7iTxnAjHOAXd
B96n4Rzb0FPEcOpW/7eCfw94R5Z4BlZA/47N0ar9L4DXwOaVxD1TbzdhM4Js
Ap8D0P9S012J+3EO/T28mYpnYjv6R8jxUvhvHNneXtuqZ63SM6fZ247+i9B9
TeemmdGsNpqunWb8fvL/nppfqznHA8Q6VLg+78EPQveg/zP2b2M/jP2DpXv5
ITGug17PexX+I/iN0HPgfVezTQXb1fydTBzPNvLbUFr3L/g1yAfgTyXGENba
0tiqj2b7s173QzWcLT3zyuck8bSo7wA16FQ885r90cK7NgbfgR8rvK9z5LNL
s1V6NoT5GvSWhnun+mi30qbnXfW5L/WOale1Q1npHJSLYt5UusbiO0vZpXbE
N/hcTDzDmuUR3uqqd0a7s6fu2s5To7eo1bu8SzXv4H503+yzTDkpt5cK3xrV
VLXdV3h2ZSNb7ZT6oRqvIZ6i7ly3oXMC+YrUtGqg2/Vk7tugm/NE7hugWyD5
IrNXzXzrtGP3pt5J7aYwpwvfQMnVX81GM/Pt0X1ZDl9m7o1qmMPfVvoWaMY1
6ytT2wpDvhbwuTvxfulW3uxZ4h34D9nSzL3Qjtcz3zD50g41of9vOTZhXIP+
p+XbpBk+k3uHtEvqQYbv53PP3jtg7IZ+BowLiXe2A3351v1RDz8vnZP8aeeX
Qb9BfBcT2wwif6zpfdTfUOmbrdutG6RbpJ3X7gvzD7B3oH+6yzay3dFwLOK1
2w+0bSudT/DVk3n3dLMXdF/anjX1XLu4LzW+5lm362DhfLXT2u0b9aLSNw==

          "]]}]}, 
      {RGBColor[0.6183000000000001, 0.521, 0.4556], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VU2MFFUQLnZmp4fp6e7X/cYYvHlQZnUSYElYEyUYiIkC+z/sDCDCjnvQ
BFfdqGuCwA1FDJhoYkIIySaeOMAGPGlM5MRFSYANePRiUAPuioQTB79vv+fh
5VW/rqpX9dVX9Z7uvTsx22dm32GVsAYSs0EITez3sH+Bn8fXmD1XMbtSNZvA
97rU7Bx0E2/2StB5Hzrz2JfwPQP5+4bZetiM52Y/NGTfgTxRNxuD3mZn1oKf
C/CzEX7e6Te7WtV3D/+vwU8Hfpqw2xuZjeKsAv2v8b+omWWQr0Mnxf5EbPYj
5EeF2Z9YXej/VcjPfKRYb8L/DazbkJvQPwjfT2ZmK4lsy5CriOND6K/FfgTr
NuRj2DcghkOQJ+GvjTUNeQT2v1Xllz4nkdc4/nWRY7sunF6H/G8h2weFMOD5
bthWkMMi7D8FNqlXnHUfMIPOLugsePm+BT8nobcJcU7DbiIXLpPYL0WqAfFf
6FPM12BTg14Hsb0AnH/H3Ruhsz7R/S3YDkN/qCSMiE+vX5ivYob4v4KfAdz/
B2w7kO8WoSbMvU93kR/kxovwuw3yS9jnaopnO+QDubB7A/ss/L8Z7loHncP4
biO2QaxhnI/jzqk+cY813h4rp1+das/cd+I78+LFpkRc+yCS3xa+u9j3wc+p
svzQ39m6Yh1LxM9vInGsmSn2diwefVkWJ36GfKYsX6zDQEX1Ilf4fwv81DLp
rMUeZ7I9gHtKqbhNjpODxJxYnXeKPcFdi07+/i6U17MV1fqyU01WcH7R6exe
obzpk/bkxuWq4vKxOPgYd+axbOmDmBCPmfCPOkWs/iJXiGkayx/jGs0Vwwj2
PbnybWMvA+c56JfI/5o49QvOt6Wq+9tO/KEOObPBC9vN2COvulSwn2qoZ5ZD
n/Uife+ph16Cz58a6qke7vm8oT7bj/Nu4ESEOwe9ctqaqEeHQp77cvF5by5+
Em/ygzxgDR8m6iv2lyN3gs8yfJZQu5Oo3VRdsZE3///jzvuficWJGGdZrNqx
huQXbVfnUeAG58oMeY51Gucu1OVb6B/14ts44pnKNQs4Fz/uV23ISfYQOUp5
CHrvQZ5FDEu5ZteKUx69kGNWU9++6oQFMWF/vZxqJk/j/H4iPInrU7XQf6n6
hz5qXjWZDnVpefVqB7ZbU/UOe4i4E//nw1xcCO9C7JXva058Zy8z97FcfOU7
sDvX+YmG6kO9VXzCDPeZOLUYKe6DTrgccrKhLecE5yW5yr7hbGNdWOOmF3ac
QzudarDL6Z1gfarMN/CTPB11wrbA+VtOuTBX5jES4uebw97jXT2nmTYX5tZS
qNM/TvP/gRNexK3rxGliSe4fCb3DHmL9WMebud4/9vVnDc1I1oi9OuKFw7DX
DCY32LOMfT70Nd/hVnhLrgduLMPfcqEzvj/DYWYwF+bE3FjvSSc/H0HnE9xx
B37P1zVnec8OcPZ+oRmz+qYlqjPnZTNgz9nEt5qYk6sPC/GHfcw7xwKG5Mmd
8B5xbg2Et41cJVbM5T+1lvNL
          "]], PolygonBox[CompressedData["
1:eJwtlEto1FcUxm9mJjPJzPz/839Y0O66sCY1YFTQLgSLUqyPxLwnvk0UW0Gt
im0EtYKbKhUrKAiliBVXgq2oWxeu3FghKnbrpmrrI77X/j6+LC6cc88533l9
9342/v3AnkIIYQenxIlqIaxqCaGHyzVpCHOiELqLIYxWQvgvC+FSgg17VzmE
9djfcLcV2zz0Teg3sPdiH+PuHbY54G1BPw14rRHCe+7Gsd0E8xXYc/MQtmPf
0wom8nPsq9H7yf8C+TVnsOAcbxVbNbYwhPVjPYQJ7EvB6yC+SQ1fUMsaMC6q
Fs63YN/FnsQh5FXrd9Cr6OeJ/wesh5xDxPer57JruEBsqeFaR8jRxHeMu5PI
X3M3jvzzjBCutoWwlrseYkdT1678DXr/kDl+iLth4oeJ2U3+g5wtyBvxHyh4
pin+b5nJWfZwgnkVyT2IvWO6nj/x7697N9rJv2AvpOZzFc9wAfJI3bELsHeC
NUn87eAeD2NvBfOXkmv6hHzLOfta3NNv+C6L3Ntf+B+r+0hWzap9c+pda8fa
9ZecJrZR4ruIbQf/15LnOxvsVnJuw3YAjApyVnOsdvoC/4wd7C2YI+JKH3d/
FFzzIXa1NfGsLqN34bsT/XnRPt8h12Ln0k61a/WgXq6Sr5d83eAtxv4Depvm
Mz3/M+gT9HYf/4dgT3L3ALknd6xyLAW7I/IsNTPNboya5qOvw+dZ5p1r93oz
MfW/izwL7VC7nIq8e/WcY/8pN9eOoh9B7iX+87I5VAZ7SWQu30I/A7eGsHdi
v4ZeqZrT4pbuhlNzVNwQxtrUPvIVh/vQV2PfTm+nqKdAP1OJe73HeY08mvjt
/Y79U2JXom9rdcwq5A2pdyV+JtTfhs/1Nr+xEWz/Z/4bevF5jFzOvesH9DCT
fOtS/xWKUeybxLkfoV+hvwT/Cfybei+536T2KU5Vq8YQ1i70WejV3L6qsYYc
x37b2r/e9qLIXBKnFiO/zDwvvbGpzDvT7vSmBqitCMb+ijkirrSAd1tvG7wG
eCuod7xgnxK+7bm5JE6L25vq/ttUQ4PYV5lnpZnp72qPzQe9iSr8uZd6/uK3
3mZ3bm7rDc/PvXPtXhwVVztzc1VvdJnmH5tbwhT2UM1cEue/Qj9OfF/BHD0h
/iSenf7IwcQcEBfkU0SuxP7bhFmOvUPtsknOp8hPMsuaiWaTN9yrZpwh/z39
v6inu8hRbi5ppzHyN4lnqRlqlh8B+gK7DA==
          "]]}]}, 
      {RGBColor[0.6558599999999999, 0.5342, 0.43352], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lUtoXVUUhndzm9ybe++5OY9cm0IdqIlpfdCCKKXkoVa0mjRtTRNpbDBN
RJRCHVRsIaLWIg40DhQV7ESqqBHUiYio4Kgd2EeqLYh1bH2maVV8FdHv598O
Dnudddb+1+Nfa50rph++e09LCOEjnhLPc50hjKGYzkJYTEL4BGVeC6HcEcLc
8hB21ENoRd6yLITVfL8jDWFXawibOK8qsCmHcHkzhFHed6PfztnVCOEQ2G18
r3F3AcxeMJehn0P/XR7CDSXjv8T749z7qeSYPuU8iP5mYhrD9wz4v2P/YGq7
hzjr1RAmkPuRr02MdQ3nK+RwBP1X6BvYTCHfjnyc+x9j8zM2TWIdag/hsqZ9
KN+D+B1qsc2d5PkH9vfj90/OYfRrS457oOE4R8llCv1R5HHs+7Dt53kSm6UK
uMhPyZ5zkOdAsO6WqD+T2+ckMZ7KbbfAuYqY5tHvRr81870y8mLFPoR/vmJ7
fas2XL8Cmy9z+/iC81fy/IzYfuMsdViWrlkzj+JzLe83oW+Bo1vR72wLYQ3y
YMM8bEbup/7rwfw8N3/iMed7UTNPS2DM4nsEeSvy+cT6Xmo+yN0N1OgYd8d5
34/8Ir32F/Yr8NVPfh1gTaCfxHa8bA5Uf/EvXsTPBHbvwOMbqTlXDLpzY+q+
Vf+qH8WTOPo+N9Y5zjWJbcbB70t9byfyexVzLX97y+ZSPF6ZOGbFrh4R78I9
nTuG18HYTDw9xP8Mfrcgv43+NfQ9qeO9jbv7qN1pcPdzjmEzj83h1P0yHH3J
/4aYr3pNHClWzZNqpT4QP4pNs7Qu8b0SmGeIf5YYDvPta+GCf5bzH2q7Cv1G
fO4t/P0Q8YwgT6J/Ff1F8B9D/pBvywvXTjP9N3e70A9gcwl5JfIg8nVxvtan
nqejMaZGzXVQPUZbncsTxLlMmNonde+DXTH+cuFatxbub+XXVXWNhyJ3slXO
sj+beEY0K61Vc/Z0p/tJvgbAT4nhemK4lxhO5p6RE7lrr55U/tJpft4ilo6q
/WgPjWeexQq6mbp9K3bxo5qo1qqRavUs8sXU51Lccy+AO8P7qcw2C5l5m4v6
1YVtHq273+Vf9Xm307i/gHN17Bn1TmeczTdVZ7DWcee+uM/EnWbyg4rzVV00
H3qXvK9u35qzqdjTqmG16v2gPaE6b2p3rY9V3DPC1E5Sz6gW2m36Jr32gXzP
xx2kfbOdeC7EGDQP2g3KTXlpBjQL2zJjH4n4D9Rct8XU3O6J8zYda76C2LrB
eL9inHNxfn/MHZf8/M+Tzh2Ze1rcHs+8U5R7X+Jdq749EHtLsb8ceVE+es+a
rkPK2Vb1Th3JvL/V/3rXDIuXbxItV8f8L/FUCveFZlGzJF421nxPueuuanMh
8qK5GCt7xpXfaOwB/dPEr/gWH8pXfXky81yfyNyzPbFvfsiN0Rv3k3D0rm/d
sf7aa9pvlxLvGu2ce8BZWXUv6J+seqt31Z9F7I0G+uHMOEnN86n+aS/8P9H/
TFjf5s5lW93/H/2HlHMndbyLehZN9/7zsf+7C8uP1D2L2lniTPwITxzpfTbO
l3JVzqqhdowwNYv/AfzgBMs=
          "]], PolygonBox[CompressedData["
1:eJwtlFuIlHUYxt92dvbbnZlvdr5vZjTBLipztdNGUUjt7K5GYWm72robbi65
GmEEdqGkYHSyAyTbRVCBkdGBSi/qpiJU6CovSl3LoLLr6KibER20qN/DMxd/
eN//e3re48WbHrxza0dEbOd18t6qRYxeEHFNV8TGLKIP/nAhYhilxdCb+Bvv
sE6jHDGXWv5Bd8SeRkR3b8RzOPqYv3nIb8VmY5GHzS3Q59B/gTgz6CToTlTs
T/oF+L/yiHsT/12P/t3Euwos7+P/WfwPYL8T2Wbi3wR9LTpj+H8P+dPIW/CT
8JPoDED/U43Y3WmMdfCsrzj2dfBXYD8f+XTb39XIbybeQuItB8MKdCcrzkf6
V6L/Bj4PFK3zbyliaT1iQ5cx7UD3nsy1Uz16kG/gPUq+NyK/BPvXsN+P/QJ0
ziP7g3w3J65nk/iD2F+IrMXfMP7Op85FNVPtWsjnI1+GvIV8DX8jYDsAxr3w
Q5l9DyFfXvGfZD+j0yLXvl7zshnF9ilq9i5YVxHjSejBirEeRH40d01V20X4
XI3vleCfBv8MeHrB/xX8J/BHeN9AT1WMdxb7MrG+bstVoxXk923qWdqN/Sno
Huq3DawT5N8N3cG7odDuCb5exf6domtyjnivwL9ddA3+hj8Mvl+73ZOT4D0I
fwb+cfyvAe+LvP1hDC9B34H/j+CnsB+BPsbfLugvsenH32n87wHLw/ydQDab
mT4Lxn1110i1WtkTkTWZl7J9yb9yrTUt6yeHxeQ3VnbtVXPV/iLkM4kxLYTu
wufL4Rok0KdqruVn4NlLrGPkNJA4Z+Uun/K9ihhN7C9PPZuaUe3eUfC+3uEc
7iu754r/CPZbau65en8SnzuI90vqXmsGiuT/ae7Z0sxqduc1HWs1PnPo+2v2
pRoO4fsQGOewfQJ+gtj72v25jJpUib8O/oGic1yAv5/wP4H/28D3I/Sb7X3S
jtfQX5J6F7T/S6Fz/g4VvMPa5azq2dKOV/AX8EcKvjHVkm+OboluyJ/4n27v
o3ZsnHn6PbVc9dJup2XPtjAL+3/YbE08g/2pb5Zul/6Cei2rud7ax1LJO65d
1305k7pn6p1qPgi2BvItRWMW9kLds64d6qz7pum2KcfTqWdQs6ge7Sr5psq/
clAu6zPXWjWbhH6m4Vo/xl8X+usyz75uzDj0VMm7ph3RrtyVWaaeqXdrM++X
dka7M5LZl/5Gobfr/iWe2UvBu1b3OvHN1e39PvctUE9/gH4I+fOJez5W843W
bdXfEuyrVddON6IX+jd0PmzP61novN1f1Wy05psse2FYhH1f6tkRhu9y3zjd
ukHeCfg6M3p7j2dCs7Gz7lnXTmyr+6brtg/zvkD/89y0aqLbrJur26udO557
5jX78tmAns0dS/XRbZpr3wvdkOPU63+wNONT
          "]]}]}, 
      {RGBColor[0.69342, 0.5474, 0.41144000000000003`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lktsFlUYhk+LdOj8/7Qz0/8HY2QhIjVcqiRegF4opaLCQhQREQXFqDu5
KGhIRBNhQ5TEBYgUMIqoicW4UHRhiNFoIkGKBUTAlbpSJMGF3MX3yXtcTM6Z
M9/1/b7vPXPD8hUPPNsYQvhTzwg9h8sQunQwqxpCjw52XBPCGr0fLkIYGhnC
X3kI47IQJuvbo2kIo1tCGNZ+SiWEF9pCWN8Qwn36vqDZ+ugeiet22Z+gb/dI
Jq+HUEh3q85qsnNjm2Wel9/ntD+UhPCi1pv0rNX5Gp1365mufbdiWR1lbpad
W2RzoWxeVexPSmaVzhvj92E938nHe6NCuFcxvab9z5L7SLnsUS4t0r9buhXF
v0KySxttK9X5S5JdotgGpdsv3RkNxgV8ZiqG8dKfKzs/yd446fZq3ymZr5Xv
Isnc3+B4wYrzLZJ/VzKTpfuVbD7S5Nze0vsS7bdp7c0dwxPyE5TDMsnfpbNp
OpsuH+t13Kn3xTq/KL+dwvAP2e/S+q3WuTH+PaOcM7ntluxmxd/d4HWXntXY
kezr2q/S/nbZXCi587K5S36P6WxI8eyVzW7J9TRYdmeUZ49+l84/Thz/Jmot
/T69f1lzbuS4EtwqXo/Kz5uFz7cW1lkSZegb+qe91bEPNLtXOhPnDoZ7db6j
2TXh+44o8/87NaOP6En6jVptjvluzY3FVPkNLe6FNupcM16t2h9T/L30kure
UXHvjpHsndLdr/3ZzDWfk1jupN4/0fkprUcz43Uscy0eTFwPHuqAP3T7db4h
9iR+iZk8BmJe19c9P2O1nmmxn39T12efvm8Mrv8ziXuMfqF3yZe+4b0j83zS
eweUU3Nqn8uUe0+jazRTuhdK27i24v4dkP2VwTOETXoJX08lntUTuWt1XOvY
Js8RdpFdGWPAP/mj21d1/8wujNPsxP7nJcZzfoN7in5iNsiRb5xT8xmx5+ES
ZoaeGsyNZ1UxH4i8dDr3fIMp/XCiNE5LlXdjq3McUzGPYGNL4dkG+8vSOxXl
f81cY2L7O7MfbFK7s1qnxpzXNdkv3DIQ/WKruW6uqGi9GvugL/c8gPlj8vlq
6vmalnoW6U/68vHCtt+X/MXMPHJJ67nSeIxW/GtrrtEarb+X7rHfSmMHhszj
/sg/6FBTOIjZOZO5VvTCG4kxBYtzqbmtqpivyMYHsv+y7PfDRdKfrXVW5CX4
6Z3cfPCj/D5dMRYHFfvF1Bzzdu45pZep3Su12HOF80QGDrmQOt6dkj8fY+iU
zPaaeeFk7vmdmNgfM0089NgXpWf6YentK21vkfa3Ft5zBi/CTZsiB2AL3/Tp
kcgPl1LbJqcJbcalXeunpefgodR8BC8tUK6DI8z14DmpsAyyZd39N7oe+T7K
9MeZpjfonbNxfqkXuaM/XHpGmBVyJU5yO1i6/3t0/qH0rmuyHDnAveR5PDO2
YHyo9Hlv1fNAf57JPXN9ce7Gtzl3uG1S5j5ZLPnPYg9xR8Fh+MNXLeZFfuRB
jajpUGJ8wYU7Co5jRqgfMvTUBNmap2/tWv+Jvu7Q/vPSfQAfEysx9xTmwL1x
fke1un8nSm9kap+nte9rNkbgwzop9saswvj0as3iDDKLjRXzVH9hvmSm4IL2
umd3XeqHfUfqeOdGTptStb+muv8P4AK4pyV1rtwhtYrrurwwN7Onvtwf8Db8
vaHmvDbWzLP4h5P4PwFHMOyKd3p3bizBFP68Ld7Lv5SeY+aZngF7+hrdpNV5
wRlwxPyIX0+LZZgn/uOG438YPEwv9EaOnRb5oV439vyj8d/EXIMLGNMT4My9
hz6632SuA7PInQbO4Eb9sUnNjmSemWGtRd04gMf6eOdy9zL/zMIPslNNfc/w
b8h/DzjMyc1J2MFuR6zX98L8cup7bFtu7gb7E3Ge6Ae+dcX/MHCDm5ifIclc
ibq74//VYPxP+w+B7FTH
          "]], PolygonBox[CompressedData["
1:eJwtlUtsVGUUx09bhsHpTLlzO5eHgYW8SiggJIDQdoY+JoAtCxEqLymkgC5I
aEEoxoS6UDaEDQt5iLKAoCSAcSNs0BiMJjyL0xYQ2MGKAAku5FEe/v45d/Hl
nvOdc/7fed93Ors+3FpuZl2cYZxVKbPtfI++ZdYemT0KzPoSZl8MN/uk0mx1
2mwlBhcqzJIjze6FZiuSZn/Cv8mYFbNm49EtcteC7ktwdoN3YoRZb85sMnit
4LVxpkB3otONbhenrNqsBMZpsH5E/xW2A+C3IPuZu9vIFmGzHtt9YFbh60ec
bugj6PeA/zF4n6K/Gp0GdG9z9uJvd5nZP9Cjq8z6K/xNvf1lzt+aj04Dvtdy
NyHpPvTz3kz4WvhpnPP4UoRflPQYFMtxzkKwm7nrRz4v8Pz8hv17geegGOtP
gr+S9VyWuDuiXOL/Nvz/nlhXkO8G/HuAbR/yw8jXpRxbOVAuCtzVQS/gXIY/
BN5a8H6CX0r+FiKvh54OxgT8/5y7a/C9+LgLejQ1XFbmPv6HvA/7QfMaX4ee
Grn+X9zVQDdy9zb4J8nRa3wcynjtlWPl+lAcv3Sa0L2YdVvhXcp6TpXbOnSe
Ect6+K+Rn0K+AbqDuz3wT8D/lVpMA/+D2L9a6PH4sJx3d8JPVHzChC6gM4Rt
Ab4ePg//IuU9pF7axtmIfy3I8+Xu4yvkefgFqjX885T3uHr9OP6cI5+XQs+d
dPLYB8iXoHsG/7LQM/GpA9m3+LwJ+3TksRXByEReA9VCNaynlntybtuLfgL9
F6H3pmrwPPSYFbvycQu+E/9mk8uz3O1DlqZei9Ft5c02ZDvSngv18CTeeoZN
e8Jz9hR6IPBeV08cRv8AZw307+CN4f2bsVx3B7NeU9X2DHgDxJYP3L8D+JtW
7wU+24q5Cfpu/J5qdgd6LDvgOxZHAZ067Ksjn833wc1F3tPq7WPY/BJ6z6p3
1aPq1RDMxoTPnGZvMOO+aOY0eyMj3x3KQVXkOVAutHPug9WKTlvSfZoD1vJK
73XNfIH8P473l3r8K+L5N+OzKRvZ/hB47pXzHLYzOKUKj0mxaeY1+83EMAP9
hxmvpWbwCrItKY9dPToO/77Bv5543zSBVV7tvdgO/y62NfD7k64zGXpnzneX
cqBcKIfCk84U5M3gFeL+fclbs7Peq9oZs6BbsOlIuM+jiPdEHI92cDnv3wh9
9zRiPwhdGXmvaienoO9kfLdqp2m3aedo92gHbK/2HVWK+c/gawLf3Zrhx9i+
Tjm2fLwJPyry2mtmIujhkedO/5Q/kL8JPRfa4QZeX+izq5m+Dn019NnUTF8L
fcY0a4qxGPhMaDZU77nw07PeW/oH1EL/Hfpu0MyXQu959b5yqlqtJZ7N8f+h
Hvv/AbqB2L4=
          "]]}]}, 
      {RGBColor[0.7309800000000001, 0.5606, 0.38936], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVltsVFUUPTPTmTu9M3d6z50ZiCFR2pnpFEofJraE0oBteWSKCDQVrVab
kOKHUYgt1JgQ/TDxQ00wGmM1JsZEjcYIKiGND4wEDYg/KhRBSYwUjU2IHyQ+
UKCuxTofk7PvPvu59uNM447dQ7vixpjz+CXwuxIZ86BnzL84L+eM6YuBmTHm
QNKYxpQx+/B5MKnvZ0E/VjCmGQY6rDHHodMF3XTRmEtpY5ZA/k3IxTOy81Zo
TM7xJqG7APuH4TSJ+/nAmKfBuwbeOfw6If+rb8y7zs4e3MWcHcbVC3+LwH+y
IB3qjkHeh+/19QgZ52++7NDe64hxHr5mIDcJ+jvQO2LyzRjm4L8nJ5kh8BYC
5TeHnJpSype5d2aNmapDfpAdg53bcDcMO18FivFzyLeA/0ZCvv8E/wvQsQbg
aiW/E+eSjPRmgMmBhPKk/qAVzj7uV8blm343U6ZOeRxBzhuB8wPIrwz9teAN
IK6L8F2C/CbYaE1IfxV8DOJuAPRlxFLzpEscBz3lzrtR5FeLK+cCbKzA/W7Q
zbgvg9+G71OB6FbY64Dfo7i7At4vkXS3gL8cv6Wwewi81ZAZAf8+8KqecCEm
RyL1wMuhsGT+zP2mBtWkDbl/gxweRxxTeWP6wX8G/J3gnw7UO9dR4x8C6V4H
Dn85nBdDporaj+K+pSgsiEkW/Dvyqv806xAqb2KzNav4mccWR49D5pWs8O5F
rU2Deox92uNy/xv06pxs0jZjYmy3Q/eki/9rnO+HmpkLsP8UYv0W9B/kwUYt
qfp9HAmjT3HO4FcBfRfiP8yagh4GvRI62yHfjbMOtkuuLn34vh/8fpzdcdWe
db/XV+/8h7jWJnVHfimU3wXwZ0F/CfpMKPxon3mejdQn7DXqUX8X+M+DNwLf
7xjF8GpacfQEqh1ruAy49cF2EjE/DPmuhHq95vqM9EO+bCzGuS6UzDjoCfib
hs1HcW4LNatrQvUUY2D8PCnDeCYh1wSZpcB5vSdMiWeTw4Y97CHOCr7bY4qV
Pc27Y4HmNIU4zwbSPYezxdOeYi0rqOt+fFdx5iC3EXk1FJXLQbcDiffbac3b
EwXRVyF3rV7+v4fNYk47ZyhU37B/OEMXfM3ah8B7PKM+Z79vDjTzdwbChfi0
B5rNYkq5c//xmz5akH8KdBVnO371oNus8iWfuROH19LCYqogHLb7qv+xpPqY
fTTq8ppzsd1iVXPKsGY3e/LLGC5CpgMyz4WyS7/8LkEnAbrJqhakifnJtPzR
F3PiDmU/cL9yTuk3AL4bgF0WZ3tWe2M2cDvEU1345nBG6Iv3VcfnzJB/j6/e
YrwvWPVpys0Ma97sycYa12MT7NmM8nzJao9zJ434yoHx7ynofWOdOVfMl7NJ
bDO4L3vi8Q1hnsyReNe7/qMP+lqFXD6JtAv5Rp0A3Q3d3qzwJl6saZ/Vnpzm
3POtBP89yHzm3hhiw37kG8GYjgbKiW8ye5azyvw3ZLX3f4z0NrJfOdP7Cnpr
+ObcwMTtZ2JTcfhc9fX+9nMfWvXAacTT6Kl/iKdXFB7cN+VAe7UGnz9FemPO
40w77IlV2Wp3VKx24c9p5caeYm8RA+4P0uwx7j7ifDfs/+5rNrusdjxnhDua
uO53+S5yb/MA4nzE05s75vZB2WH7osvlFGRmI+2OMzjbXL8R44yrG3uMtumD
O26Z1Swtt5pF9irx/MfXTPK/CWeIu2/YzQ9z4qy3WmGxwmofjDmb/M/FncD3
kpgQD+4C9lTJ9dXevHjcE+xD9gz3YadVrLc626zNjT2Xl23uZtbwkvuPwV7p
crp8y4lJFOo/BHfnOpcXcyL+vKPMXvTLRF54823k/5F5h/9Hker1QaS8iDtz
+x9a+BpO
          "]], PolygonBox[CompressedData["
1:eJwtlX1o1WUUx5/dO3d3X37b797dWSCEc9vdfJlOcLM5QedrCxY1ajWyJCn/
iFJyblTYCwQRFRSFNSMIoSKptLe1LILEorJ/qrmpJQTOoGAIBc0sc32+fO8f
D5zznHO+5/U5T8OO3f27EiGEJzmVnCuZEA4nQ3gQ5kJNCG35ENJVIbxaHcLF
dAjPxiGsqPDdcmS5+hC2cF8PfxHbLPxm+E5A09BL0ElJF5sS9JVCCPenQvgB
H/XgL+OuuizfD/btYCxNGiOD/Z3wW9G/jnMG2zfQ6anw3Wn4TDaEBuwPzwvh
bWTN4FXCt6HTAL2Sk61yzC/FxhDWGD7ORehhvwPZduKdTzzX4u8Xcv0evCeg
Q9b+1iE/i/4gd3u5nkHnaDGEVmLcRqyvId9TF8LL+Hgd2xp8/obucs4Eun34
e1g8GB3Q9xHDXbkQbuFuF3ij6OwB72DR+g9h/13eOSm3I5x3oR8oWncdfB6+
F4yNCeczV+OclXsS+0boYeTP4+s5TnOde6ReFTndyN8p4y+Cz5LrPPLpSTsm
xaaclXsvOo3ojmIzjuw4/AHoFzhvlfkXoVdwSgnX+zz2LfBVYL9CzLPgbs65
/urfKXqxKW981TiB/7U1rqV8dEP/i82+4B7vI/eROtfmafSHoRdivwj9ZfDT
+DsZO5ZBdHrAmyjzX3ImoVvqXAv1vAS9Hvuh4J715B2TYuvlbMm5R+rVNuTr
Y8+wZlU5tUJv4O4OZM+AMUetfiWG9grX4Bj8P+DtxH4QvhvdvUX3RjEPFV1z
1X4redZQ+z8iv8UBMFfH9inf8tEDXY1OR8o1SUE/AsZqsN6kvo9CH+CcgP6d
eVij90X8rei3cI4SyxRnc8o1b4r9pvW29UYXk8+HyBci7yKHWXK5nDa23qTe
5oXYb0P1n4Hen3etNWOatRsiz7pmWLP8WcG+VZNPoR/jbj76u4n/P7BniHGk
0m/qK2ynYvdKOSiXjrzfknJQLpohzZLeeBOytdx1plyTr8Hvj71bhsjvJugc
9W0s7wfN+p+R34tqrFp/hE1DyjtoKXhdkW010/eS793c9cLfTPwLwJouuNfC
PA/9CaeE/UF8Ho9cM9VOMX2D7KeCZ0nzXYH9+wXP6jXcfVDwTtJbaYYfh78V
+0boJs7HBR/R2mHtee9IzZ90xpDdlrGtYlAsZznXp5zjqtg7R/3QjmphXqYi
73fVvJ3aJWpDeAr6GHdXZ91T9VZv7ETeO1y7XDs+gr4UWVc2fdhXYP9F0vUM
0OcK3lWq2Y3IH6eHh6rt8xS2/VnP5iHsS7XewdpdivlnbL/N27fmR7tTMcmf
3tAl5LX1fiuaec3+HDpHkp7pSeRXZR2P4lNu2pHalZrpJcRzJrK+/reV8KPl
fb0An5cz3onajZrRvzPOUVjC/Avbe7Kuzxj+B5jdAXRKSc+QZmlD3ljKWbm/
V3CvtVMXgzVdzlc7ULtwGJ2mhDFGoH+M/DZ0NxG5RqqVetgX+c/R36OYPwe7
qt6z14p+W85/tnJTjqrNeOzZXUVMO4ltLu1dLvlp8LZn3DvNSxN8V+xdpZqv
iV0j4al/mp3JyL60M0+qHnlj60/X374x9l+qP24TdGfsXab6zaL/P4xZAdI=

          "]]}]}, 
      {RGBColor[0.76854, 0.5738, 0.36728000000000005`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VltsVFUUPdPO9E7v3BnvvZ0aLdhpQ98PoEADbTCKhvqAEhjEFx9QEKM1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          "]], PolygonBox[CompressedData["
1:eJwtlXto1WUYx99zzs4529k5Z+d3dlak5GbbcpvOeZmow7KMtIuVzjKqP5q3
CANXNhO6/NOVWgWpZYMyQQhqWGlWzmpWEBpRaVJkEJLr5qo/CgZJrfX59j1/
vPA873P/vs/zvFPX9nZviocQ+jkVnEmFEPYnQmjn8jzok7kQpkNvQfYNdDEb
QjKNLmdbMYSeTAhPIBusDOGhEnZRCGvhX0iGMBO6v2D6LOcEus3cxVMhrEGn
CfpozrHk/wj0s/isxHdDLIQv0b+kOoRe6MfR2YF+Bn4p/Dz4q+Df5fTi7xg2
fbUhjBDvgZjv3pMcf63IpqE/BP0ZPqfEXMN2+DZ0kinn3Ao9A/9rkPehfy/8
JPg5yA+Q/9v4frJcT4a7H/B1ouD8boTfjn49ZwJ5DH4E+W/5EPYkjOEssNsW
WfcweJ2L/FVhimwd8V+BXk+8f9A/Tn5bqOck9rfzMLu5+wn9JPHmJ21TAf0a
NdRDv1wVwuq6EC7m7hbkGzkroe/kTXYSawo6vdDriT+X+N34v458NnP607aR
7RDnLeiD2DyF/mjebzON+L9C/02cPcja4G8mnzeI34DvenzsL/pN9DbSuR/7
W9FpR/dhahjHfiE1XpRwTMWO1YTwGLLLsRlD9iY+BpFPhW9DvipvPIbRGYYf
Redg2d+yrHtQvdhFXhH8tch3x90D10B/XXDv6I2+gn4m8tuKXwzWHZHf8kXy
3Uq+DZHfbgD+bvh9RdcWuDtNLXeVnFszOWyGPidyb6fRKRG/u2DsBzCpI/e+
kn31wF+A7nP4q0q7hzQbE1XGdx/+GuFfR96U8Ju2ZO1TvlOcHUX3gHpBPX0I
/qOcefXEH1XuUfXq/28I/XzRvaWYA9A7uZtN7TPg34cf5rSn3aMf5zxDmiVh
3k3+cXqqATpLPrXkclPGtrKR7QfY7Eq4x8aI/yPylxLuWfXuJ+jMR3dI/YPu
COdSfC3RDIL/PbXudb3Zp+CziBidcffAUWzPlN9bPRLoldPcrUp7B+wt2Kd8
d1NvBbEbc+63R9C/Al+h2tjeB/8n+VyY9SwI4wpqS1Q7F+V0KuceUC+ohg/h
/6KmXZXGWFgHbBZVuWbV/m/eseSjAl/HM95defzVUc8cTjZlH/L1dBl/3c1F
FnFyce+kz7FdCF+bMmbCboy7BcjOx/ZMyTtDu0MztDHjGdWsan4X47uZnJbF
vZO1mzVzmhVhKCw1M+KFkbASJsJGOz9G/gsix1IOXdClyLXUk8Mx/HXCt8Zd
w8/wleBxWZXf7Aj5bojc++rB27QLS+4dYRZD9xB3m1KeT+1qzaxmVz1WIp8N
5DBenvclNd5p2m3CQFhohjRL+kMaoa/E/tFyPU3Yf1t0LXrPpcimRf5rtONb
Is+wZlk7Wrt6JjmsSHr/tBeMobC8A/x7sL8+73wOEKOzxjtTu3Ml53vtO/p3
b9o1DUX+o7RvdHc1snmR/x7h9Qux3ynPp3bwZGo9XPTsCdMOfE/OedduJd7v
ec+8Zl9/Yh3y8aJz0x81vdo7WLtYb5AGqy8yfiv1VG1kH/KlGKPIZhc8K+qR
WdBnc65dGHQUXJNq04ytyHpG1dvCeAJfD5b81+tPXBd5J+uthNENyLur/bbC
oAt+MGvsJF+d95tKX/tFf93yrOOrP08VPYN6u+Xk00I+IWNab/odsmSdd6/+
nFZs/wMA+ggU
          "]], 
         PolygonBox[{{2571, 1368, 4154, 3575, 3576}, {3576, 3575, 4143, 1360, 
          2563}}]}]}, 
      {RGBColor[0.8060999999999999, 0.587, 0.34520000000000006`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV1tsVUUUnT5ue++597TnnN4WLRRFA0HEoi1QkCggICgoLyX6AUHQBBIV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          "]], 
         PolygonBox[CompressedData["
1:eJwtlltsVlUQhXdpS/vfyn9OTwu2VMQErYpFqdwkCkqJSMtdjTEB8ZaIiaAx
XILGGC8BE4UIiIBR8AFRE/VBg5RLgAgq9QpifAIx0SgUg7WFFtui38r6H3Yy
66zZs2dmz8w+wx9cMnfxgBDCZlYJKxuF0F0UQsTamw7hWD6Eg6Uh7IR7EtxW
GUJ1Od/ZdDgbQgP8LPhV8MXwW+MQbgM/An4b+VAuhGvRHY290/A3oj8H/mmd
B96CTrYshCvhfwKfQf929KeAyzMhXKoI4dNif5vGeSn8uwCXZ+1Gf8qgEPbh
eBv8fvjl2GsfGEIMvwx5N/ptBf9bkUs5fyz4YXBHilj4Noi9w9H/EXs18E3w
y+BP4Msh8G7wDvAi+FbwfPTnob8L+XXO6Cm1jSrO7wc3DbTOQnBLVQirU87Z
EXLXTTzPltj+19j/EP1a4q9j1aM/OrJvb2GzEXkHOnlsjQEP4LwifJhR6pyc
gjuXMrcWvB38eyF/0rkG/TpszMfeNvDlyN+y/x/kDlYevDNybpSjz5C/hz+P
3MWKwWsix64aWIs8nXhWpRyTYlvOt03BOVqB/BXnb8eXlcTYSDxd2BtHrhrx
aRz8uQrHXo/O38gj0G9AnkX8M9EfmPHdKwbFUly4L9XIYPjanGtJNTUUeTw2
Y/I9FP50EsLxtGtJOVPuNsa+W+E3kJ9hdaI/Fv97Oevzwv3qzq4DV7KnDv0M
+glynLWsnK1n79FCP9yD/iT0Kzj/L/BZcA/4IjE9V+L7KQEnefdDA/6NwtbY
rPlP4E8qvoxlfdPePPwEfBvH6iOeOWn3Ujv1swv8DXhokXUuga9Gf3LKNaRa
qlG/wU/iWwn3c1XW8kb2L0H/t7zvWneou1zBt63l9lG+FvPtVrj1fBvB3j3E
dzhYvxnu8cSc7rQTX+bh8xHy8zL8DPgnEp+1gD3n+RaqLE9ELkLuSdy7jeCL
yC2yAf8ne3aCOypcO6qhs5oH4KUF/CWx/ZpzbpUv5bIm416chg8PRd4j3VHk
40DsGpQ91dsw9t7PGS9y1hjO7864hlRLOqO9wjWv2r/A+gFbq8nJllL3+DHw
uzn3Whf33cf+NXn3ag78R9o9pd7qZH0HDmnXu+64Ht074IehOxWf3wOvy7s3
31F95X3nuvvxrEFZz0D1w0zi+YV4FsGvKXePVmKrJWtOM/h69teC4zLfZyW4
WTOowI8EDwHnytxTJeDHsLcWe93gKuwtBL9U7hwpV0+h/wr6U/F5JXwz8cwK
1nkAfgH8IvhHWb2xe1i9rBl/A/ZP8W02+BDx9+f8Bqh/5eM2uP7EsWpGzYZb
Vci3emo/eEiVbWvGDEaeEPntaGXPfeCPY89O1bxq/2Dsu9edVmNrf+ze05ln
0q5h1bJ6YG/kO9BdXEF8d4IHwN+S8gzQLPgvce3qWyWxfcC3dcXOoXIpH+SL
ZtDNkXtAvaCemUs9TYtsWzlQLqo1Twr512y7lHNulEPlchM66TKf8T5cb+JZ
pR5ZB74Lm8eDe+5u5L6832K9gf3IE7OetaqxL7C1Ie/a2sB9LcZWDf70ldoH
+fJR7NmpGaJZsiftt19vbAbd5xP3lmb0C8hR5NpWDaoWD2T99vazmniLk8i9
o5pSbb0WeVaqhlRL+9J+m/WPkYs8A9UbehPHZN2j6lW9wZfh+02Re0szSrNK
M1yzXDnaHHvmavbqzV8ae4ZolqiGVoD/TdzrmpmanZqhmqXq2Tdj97B6WW+C
3obplX4P7wU3I0/OWNbM1+yvK/inmaJZpZwqt5qZmp1H0+4lna/Z8WphPijn
P8ONzLiX9Obo7elOPAvVUxfgTsbuVfX8CeT/AUqKNcg=
          "]]}]}, 
      {RGBColor[0.84366, 0.6002, 0.32312], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV2lsFVUUni6vrzNv3nsz03m0UHbjjyIJoogmxg0wgiCyaWIkgsaYGBSD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          "]], PolygonBox[CompressedData["
1:eJwtlllslFUYhk9Lp+1MZ9qZ6V9K2USMJkWMGy7RaCKgSMTIZqKRCwRjYkSM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          "]]}]}, 
      {RGBColor[0.88122, 0.6134, 0.30104000000000003`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH1s1lcVx2/f+3te+rz0eda1nRtlLEKJszBC1AQi0vmSCJNiwZdEjcEs
Mp0x8Z+5MuymcRKM1H+AqGGlRKUS4z+6mYWAijMREHBiYjqglG5jboGCG2OM
qd8P32P845d7e++55557zvd8z3na98WvDT3cmFL6RkNKTRo/157SaS08r++N
QkoFLa6vp7Q7l9K5lpSOSW6mltJtWUrTGodbU9qo+a919oBk2rX/RDmlRdr7
tHSt1tk+7Y1IZp7Gb1VT+pH0fE8yY5K/pLULuutdkl8n+VWS/5C++7X+7aLk
de6gvp068zvJX9b4qHRclm1fkPwSnZvOa03zT+ncWsmu0TckO+7RuEBfRbrm
Sind1NqXJD+u851tKe3VeJf2V+sNq/T1ZX7Pen0j0jeju+7T2QGd+bz+vqQ7
H5ANd8onVdnWKsXTkmnW+E3puiH9b8mWTZK/pPWS1l/vkK7mlP6lcbLJ83sb
7RvkeedvNL6ptfnJ/s7rm9N8WcGyx3VXk9aa9b2s9R6t17T+K61/X/bMaG2q
0bHDTs5e15dJ/vlkfVno3Knxy80+zzvaNfY0OOboJ+74FV3Mj+p7NvMdj2eW
/XhyTIjNyVZ/+AtfvU+2LdGZ2aJ9vz9z/Bdr7M/8xqe196DGs/LJu+W3o9J5
t/6uhwzzk4rX7fLhqZL38fNSrT+lM6tk/3iH19jjXsZjMd/Ubj/y3hWKxzbF
+jXFZJHmmzX/p+Zvys6SZIbqxjF4niVu8ucy6bku/ePSs6/JtvZFnLB/our1
VyV7Q+c+Kjv6hOcrNcto+xZ2pgM/M43GOFj/W6vtPxE+J07EdGHVGH9cerZI
Z7P235tsB/bMKzrG6CBvKrq/HHFF/1WtSywtajHOhzU/I3uq0jVVszw4eF3r
5/LW3yKdE9rfm1nvyWb7BLnrsuOU9B4pGHuNTf6b+7AZ3/4i53e2VYyRpwIn
2HIrryO3se+49PxS8rOSH9ZbN+jbrfl3ysZZU+jnnqbAOXEjF3+aHDdydGfy
GnkK51zT29bgw5r3V4c8+bQ48PZIxev9eeccuXdR4yLZsEz7g7JrPOyXOak7
eKS3bvxOZo4pHDMQmD+SN+bAL/GC3waS549F/HZUbOfKvLloMvjo6dBxX2Bq
f+gnF9+RTxY2mGuRQ+YufXuCPw+HnXDaV/TmO3RmTEbvrxqn5BYcsCl4AL/j
/9Odyk3pHNP6hogPcSdGc5nx0iWl3616f2fR9x8MW7lzT/hno+6dlY17Oowt
MHauZl3jIYOPPxN+5t7/SMcCzftrXn+1YJ3PxlvGA4fgZ1vV8s0hMx7rH6w7
Xg8VXQdebjd/Hgyfkj/g/1qr7yVeo5lr0ungR3wyGm9cA5fLniHsLJiv4e3D
OWOT+SB1TfLdwl9fwT44FLHozsyJ8CG4wibsoY6hkxwfyoxjMPn1vN8Kp/4P
60eCB4ndet17ocHnT0QdxfZ1uv+8ZB5Wfk53mMOZdwU/4xvqwKmia8wNyaxu
sc1wx2NV++TfeeP6gcx5BE63BG4f0v5XW23PHRXjsLdivLzdYn8daLMceXcs
MAo+n6n47DryK3gD/hgJ/fAYnDTXYpztitpBvEZjzjvJUfyFr/DD1szx7qm7
nr+n6Nq+Nuxnjb+fTNaxNfTAkxPZ/zE+EfhBZjTw/I+c8fgCdSRzbWmpGFvc
CTf8pWScg/f2smvmgaLvwT7uIlfJwc3xRvAH9uiJ8Be+6mox7xPTcpvzgbtf
irz7uXT2ZMbTymTOqkTd3J7ZX/iK+gyO4UZ4+kSz+fyTsvWv9C1V27Y9/DYZ
9RfO2Vg1Nj+SM4ccinwmd7lrifZey8yl+4rmT7hpb979Ql+T339Tex/WOCqf
TOTNscjeL98t1fio1pc3eP5I6FoTPA2PgYV7wYzs6NXZl7TeW3af8+ei+QBM
kyc7NB8Ln4Cv423G565449bAFnLoHGywbeABjFMzwAncCv9urLvvI3/IHfoM
+o2rsmFF6OEu+ireSszfyQd2S+7DsBN74fexuJ/xh3EWfME7YKwS9QffYvut
eqp5a9kYeFKGfSD6pYtFxx8uwRb4jPwi7vXoiZaG//Aj/ENsiBF9B1i7O3N+
8m76WuphV9lcMFk1D9HjUj/plbFzuOY8BWsD4UP8R+z+nnPudysYF2vG6Is1
94CfTbYVOxbE+ULJOdmdN74OB7fDkU9kPvdW1ODfdhgn3LM5dBwKeXKKNe6g
VwLb5Bu2vBL163zeuUmO0uvRu9C3gEswMFl2zaP20RfxGwa5awXnUVP0uvQq
M9FXcRf33OLe4Hawu1i61uru/rK5ZCo4l/y6J2o3vyvAyTMd7o/IU2oN+UeM
8M/yirmCun0o8hL/3V7xb6JtZfej5PbRgt9Tip4ti36Pfp4cI79+LPmpnPE8
1eF+lL70uaJ7iYURpzMdzt960ToqoZO/WR/KuT8GH/M7zbPEkXiOBMax82zN
WD4XvukO//A7Ynu771wZdREMk2/4Z67mnhtc3pSznivY92+X3YOSS2cUzys5
1683OtyP14OX6Rl3Ry0eK3p8MTOvgoHBsAnbztfMp8PR16DjttijrhJfuJE+
biTyFHt74i385oQn4Ut6oA3RL+TDb8SBfOK3ATUbnsCH8PlSvWtAb/x91X3L
4eDYP1b9Lt7XHzbBC2ej9r4gm7sLrg0/qRq/Q5GHlyK3P9bpt86GH+h9Lodf
KsHjA1HjdgU3/qnTvLMr7MJu+oFXoqaDuRuRj/x+JYbUfeI4F/v48Wdl80Im
2R1l4+oHZf8+6wp7sI05ucOb4Sj6wN7wLbjYF7z7YNRl+roL0UvQS9NTw6U7
AnOsEX+470rJtfVqyVyLHLipR2znB3+viPpCni0PHiFXBoNr9sdbeFMlfEZu
1su27U75al7ZnPz+gjkLf5BHf8jZL1v4H0bZ+neXzbvUJ7h3d6xfzfk3MHrg
+As1v4Ve4xN5x5TY/hfDQjOT
          "]], PolygonBox[CompressedData["
1:eJwtlUts1GUUxT/svF/MTKeWabEyqAnURKEhBhcStUVhgdCprdGFGENi1Ihh
qUDjI74aEqkbJGi04obauDAx1p0vMNGYUjVGhUpbSqnBtlgoJqU+fsfTxc3c
+7/3nu++p/Lo09Xd14QQ9kMR6GIphJuSIRTg96RDuBX54UQIj0CzmRC21oXw
Ivpt6P/gdwtyN7/rkH/jtxX5QWw3I98NP4l/I983SQ/eC/kQDkVDOAMdToXQ
js0b6CPL+Ia+E/u9+CeQB9D35UK4i8B+jIUwjn4C/bXYt4B3Fv4l8A6DNQF9
iH0SmzZ8W0hqM0m0F411FqrCf4LP7+Afwf455DPIRfDWKz74HcRzIOkY16Bf
X3LuP4B3gvyfRO5F3og+ztsR3hiFH4c+4P1NyoFYK2BMYztWMrZiHod/tWjf
Lr69Aj+3PIS1yJ3Ik9gMI69AbkPuzYbwDvlPEPsQdBzsvfjMol9AXkAeRL8I
PwWdQz5dci+U0wj8Beh6+CfivJN2TIqtB/kO5AHeKJHbjfj/TPzz8k+6B6Po
v0F/C/oN6KfR35tyb8+j/xjbbSnnopqqtl3QvoQxhDUL3QA/wHs7wIsXXCvZ
yHYnNd2O/j6oTO2bsWmNOWbFfr7kWWtAnoIfoj71UdfopGpFD1rh14HfAtYC
9eivoebEvBH5WXz6EraR7aqsc1FOFfgy8VyNuqfqbWfRs6SajxFLBZ8tUeOt
gr+a9ywMQwvw+7G/GHUP/sb+BJjv1/hNva0ZUb/zxFcmng7q9Rj51ONfj+2n
OfdS/ZvEfw821aRr8Ayx5ZAblnnntHtt+G8InlHN6vxSvv/3CNvnoQeSnsGD
+C8W3XvVWLVeXeve6w29tbXWvZGPfF8n3jXKhZhX4n8K/EM1npEG9NPYHSC3
Jr5tT3mntdvaYe3yVxnX5jswvwa7sWAs+ch3JO1d7166Hf1F90Y1OQb/D/or
Me/En/T3rbx3+TZ8jsC/mTH2U9gMgl1f8O5on1fAn855livENwL/LfbL4U9y
QzrAu4KcQd5FPJfhowXfEu1wDH5K9UfXDl1H/9rTfkszrFn+jJxnor45LxNP
NeW3Hgf/V92qOvuqR3fCf1H0bGrmZrA9V/Is6yYOIs8hN8PfDB1NG1PY2vHP
0b+Hf23c81KH7u2iZ0k5/iK8pG+FYtoF1lzKtVqpmhW8o9pVYXbh21jnXati
0wB/e8azrRk6jr6ctu4evi0yn00Zv62ZPlp0zVS7ndpxsGcy5vUfof8K3Sjd
KtWwqeSbrdutndXudoDxfcw3/d2cb7Jus77dD/9R1vOmnPuQi1nPmnZAu6Ad
0a5oRrrR9+cdq27+sbxvmGrzL/oe9JGMee1gDH1v3rXRjB+E78l7dnQDfsL3
tSVZO/1lyjdCu7WPeC/n3GP1WjEq1gvgP5Twf97akm+w4tO35pJnTrOnmZvH
dirreuumrOatS3wbinhG/4IfBX/3Ev4p3r+U89vqz3DWN0P9kM0Yugo+5bh3
qD7vG61Z07cB8v8PtEQKDw==
          "]], 
         PolygonBox[{{3559, 3558, 4130, 1352, 2554}, {2562, 1358, 4139, 3558, 
          3559}}]}]}, 
      {RGBColor[0.903, 0.6275, 0.2993], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVVtoVFcUPc6MY+bOvXemNzcNiq9YSxKNFlHBRym2ttWfUmvRCi0KIoFq
oiYfaisBCYhG8EPEVlvaQkVjVdSPJJNKUaiJpXFSaCUiBrQSfCM+UIMlAddy
7eLH4ey7zz77sfY6+1as3rB0fcI514WVxHqOj1IIsyFXZpxrzUhfjb0Kq9T0
lCPIP2d1NpiQrtJsuqB/C3JxhHNTYPhr2rmp2I+YT97l4p1HsXOflemMOp5T
/gZ3UxaPOUzjORSTIf8HeQv2W4Fz3bg0c5Rzc33n1kE/qcS5Zzgbm3fug5Go
CbqvLTf6WwX7Kugf5BSLcej/Gb4d6kjCzwTcXQSbLtiew5oNm4eeczex96GW
DPbh15TPV6i1PZZ+kSc72t8JnXsdPs6a/axI8h+wb8T6Frq/fGFErFhXOer4
DsmMRh5rsPfibMgpF9ZIvzvgZxh+dmI/hVhbYLcC8hXIb+K8iLhXE8LgLlZD
VjU+jJVPU4n6uz7Q/gPs3wP+m5HDQuxzsOohv439TFp3aHfNU26dgfKZMUo9
OJ+V3Uzk8Aa+OyBXQv4TdodhHwLLi+aHONRk1EvWOz2j7++hv+/Jvgf3DsJn
AbrHyLkB5x1YG41n1caxp2n1sQx2tagBpm4ucp4O3d6kerkJtrVJ8boN8m8Z
2fXju4i121PdxHAooZiMQf8OvXmOGM2oZUFKPoiDn1d/JuJ8ICGs98DPdeQw
CX7KA3GC3KiD7npW9S+Dn3ReeaV85cC77BH7T9yIyQXLje9yCeopQP++Jy5Q
Jh8OeNqb8+oV66rLiNPE5ItIPvrN/2VPmBxHbu0Wi71i3ZfS4nXRbBmXmHWm
FXNFrPNm3O1FPftwdjIQTsSLvWJv2gzbOpN5Rj3jMdaCMvXjXeyBYUgse1Ka
OcSXvN5uvWuzntMP8203nvTaOyf2p+19ELd24wltOiwu7x/KimdPkNzfvnIk
X+YZz8n3VpsPnD9LU+LCh9YLvh2+IfZqwN4V5wnfL3lyPBJvyd9jkd4I30qY
1H3i2e2prv3A7YSnd7AdtQ9nxeOmSBy6aj1jvTX2RhqsDub9P6bEc3mkmcPZ
UxWJG+QLOc1eMvb8MuXJebMNNoOwKcD+Hegb4ecfX1g1GG7cG03+3dPbWol7
O3PCuhV+sL2csX0o/kZWeHUCz602Zzlj2RPONeZPHhWMS4zNHD6C7x9D9X3Y
F2cKhuc5i9uS13znjElAVwjVk8WQx8d6k92I/2WgWbkrp2/qfwr1dhmLvogF
+8FesofkD/tI7vcZ/y/mtJPvfEMtJYpXY++FmBy2HJhLuXG4wlcNrGXI19zn
nH6APHdFend8fy2GIbGsjsWxe7BvicQNcmQWvpuQ/9NQ8+O0Ycge1tnc+zxS
Dsxlov2nKvKaAW02B36J9C85Gklfb/wpjng1P8Yg1lrE6A+FS5DUf5A7sSJv
+d+utf9QvflmLgPZV5jxf0LMORvHwWc95Guhds5D/pMqjRulNnMu2Buj7x6b
rTzfav7Zz00livtxLPkSzu5kNN8Hc8oxsJ7yP0H+8F1MicVJcrPf/on/hsKS
fln/uFgxbxsG+yxPzm7m/CnufZJTnktymne0ORGIF/TPHrwAUyM6Bg==
          "]], 
         PolygonBox[CompressedData["
1:eJwtlGtoz2EUxw+bXf63zW+3XMamZJtbYmluuc8bucUUIaEwEy9mpYVFzFu5
NKHkPsYrGy/IPeO/QrywckmJvDCXjWmLz9f5v/j1O+c55znf77k9hWu3Lq7q
a2Zr+JL5puSYbUk3O9rHbDJyRWD2KsWsJslsb9SsM2ZWi2Mp9m8hszrOPiKn
811BnxgxG5dqVt7PbGimWYzvHHcHABJFvkS8vFTX89D/hs1+E/8X3y5sewLX
93HnKLHfgTec2MPQ3yMvCblcCYc36D+yzUbBdwzfWWLND3ksxVCsejBy+vjZ
bvQWYjYk7g+G62X0Q+hl8E3D92vIc1OOXcSfQQ2qid0N33ywCiLOXTEaibc8
8NqoBh/AP4DeC5bhk0K8Cu7UppnlEr8tAxzuj0/UpwD7KTCmJ7uPfMVJ3JRj
btRzlC68ZvR29E3JXpN2uM7jmwtcj/Cwn4fDTWwBPr39vSfqzW04TYBbD/Gz
iNWKfQF89mW6/SX2ZdgPcrYuyWPUI5eT/850n407/L9EHGsxByXwPRb1Xqne
6mVjop5jyO8z/o/Cjq3848RLjnht5HNQs4VPdZpjbuTuSM5u4B8H/yr+J8i3
1JzzSeTykHPVTGo2vyX6pZo+QP8U8V6ppkOyfabU+271BFsHZ0fwvwBuBbl1
85/Tz2f0MfgdYBahd+LfG/aeifsL9Pdhr7Hyf0L8RRk+M5qdw9y/hq0p6rLO
vhO7AX4bkjynEvEFv4jzYr7TxKuMea9Go59BX5jhsTVT17jbGnVu4jgIrKWB
c1HPmkK+k/Ldwf2ZOV4z1U41XQDWqsDnXzmtDpyj+GmGBkZ8xjRrW9Dz0Qsz
fTZrKNcfYt4PXFeN7yEXa4dSPKfN3F0PRn2ax1ftkhL91UzU4zsrx7mpZsXa
hcBrK0734P80sd/iFEdui/jbo5nT7FVTk+Po29GnobfEfPaEKeznEbdt45uK
/W3Mc1HM1yGfOfXvFpgPw/6miJt2dH/gNVft9YboLfmZ7W+JMIVdmNh39eAy
/mVg4PL/jZyEXBf4bCmfuyHnIC7yeaZdDxxbM1wF9srAa6WdXRH4jGhWtA/a
nRGcXcd/rGof9h3VrqremqXmxPulN/Ri4D2QTW/UdLBnyyfFe6Re1dHPHvOz
Iu1Chu+metSF/DKL/lPLzdyPw/cfuzPMNw==
          "]], 
         PolygonBox[{{3830, 1149, 3124, 3533, 3534}, {3534, 3533, 4123, 1349, 
          4124}}]}]}, 
      {RGBColor[0.909, 0.6425000000000001, 0.3179], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VVlsTVEU3e17fe279917X6+2KjGGStQYhKjpA+GP+kGMkUgUqRjSLyFp
JQ0JX4bG9GOqiOmvhkQMIURblVBjJGiFn4pKRSnWso6Pl7PfOXuvvffawx22
dvPi6lwzO4lfAr/hBWYfcdGQY3YpMkvlmY2OzT6lzZbg/Xxg9tXJFyH/gE4u
9CPIu6D3G3Z/fLMxkK+lzCbgfJox2wab2cXAAl5dQnotsGmE3BOaDcJ9LeTP
uN8M3XTSrAO4Q7LAwDkVGFOBdRuYD4F/D7826DbD/yHYVcC+BHrrILfgvs+E
R3/0dRq2MyD7Wf0oN+JuPGOG7jEPPrPC6Yb/mXnSWY+3j7AvBZaH8z38tiOG
pbCbmG92LqH4ymP5PAIcH7FXpxU/YyQPU0w5fcAdYO0BcG7xHnavcM5LKvcw
Kf5BlQ3IU770W1EszGk4K5OKh3FVuXyZQy44+gn93cAchTo25QjnKs4u2JzA
eSNHNS0zcZWfJ/vLkeR2+HgaCXtZkdmXpGypT+yx5BlvJYH4Hgifp3z52hTq
P++b8P4urbq+AF6QFachzrueMK6x7k6feM3Q74av/ZF4JJ8LId9xXN+NFQvz
YTwLi5QL+5T9xz5MAa8q0Psz4B0M1G8HAvUB5RLHA/Onj391SqrnyfnOAtVr
Nfy9Qc6rYvUSZdZoYFZ9y/4lR+SqDvIHXzL5a8uojjNRgOeR7D7hPRWodgs8
+alJyFdnoVk98LdDZ0ugu7HwW+jyZe3YL4yPb+1OZm9ML9bMzMB52tWiG3Ht
iVS/vZHyIz5zrI+EOQc6t9LqyfmwHedmlrPLuNi79NU/Kb7K3Jyw1/aHqhU5
5Fub60W+XfYU1yL4meywLri56HC7hXUl978yiq3DzcVw/N+K/52h+OM++t/D
/V0fMsY21/NngD8S8htPM8TZYA3O+LJhruzZ3pR21mPglwHzeT/sqUJh7oDu
rGLNXg3kuUXifQNiGJzVjLcGyoG51EJ+EGg3/EiLO3LYAuyXnvbRW9i2hort
Ne4qI9Wd9V8ZK9YW+GqGzhrIj0LF+Tul/twXiddzvjgY4XhocjuCMu2Jswx4
e2LZJjLav+z1Bvha7vbLili50fYb8quLxUkO9KsD1W5SLC7IyS9wYxnhcK+T
C3KyMdTM3XA7lvFw17A/WUPuONbxtqeZqYVteYFsqdPeT7m0ZjSrnNljgb4P
o1yOjGV2UnuJfcY6H/VUY/JJXk+E0jkeak+X5uuN++FwSr44e+yhJ/DTV6j7
s76+Geyf+5B7XH98x7muQL3I+Nkj5L3BzRLz5J4jnu92BeMtd7nzu8j+4reR
3zPuhy7EeyVQP/RG6iH20uNAPU4d9tD1UHvpoNNlP5CXm67HToHD87FyHIpc
/gLiwAlf
          "]], PolygonBox[CompressedData["
1:eJwtlVlIlWEQhkezU+ec/5yjf2oF2UIZZFTSYntdVNBdC0FFK4WVFUoZQTdd
aFAGdVOUYHmVlgQtELRCtFPYYtFuCGWJ3Si0kaX1vIwXH8z3z/bOvDPfP2JD
2dLSdDPbyMngtMTMRqeZDepndjY0+xY1m9HX7Fgfs4sJs4a42Q30AzH+l2V2
iW+56W4TzTR7mzLLQ/6KzRvkDuKdwXcX9u1Js2ucXHSVfLuO3Eb8sdhXcD9C
rK2cYuRv2D9GNzxwLLOwCYi/mJgx4cNmCfIrbPLBHUG/KNtsO/5P0PfjfgH9
E/xbwRcl3k6wfyHnTuQt+NxM+DfpyogzM8fsddR9hUFYNmPPZxvVH90As1Oh
+wpPHfJdzkTwFZJjWKbXqFob8O+k9knoS5CbwHSfXCvAuJdYg/F/Ab5N2Mex
b8O/CaxXevspDsRFNfeeNO/ZPe7NYBiDfzk4X2L/PHDfJDHmAPQ0OY5H6Dv3
A8R/Gjj2kZxX+G4jXxa6At3RtcedqwV8WwPWZfg0IRejnwLWE+RPJ/5yaq5B
PpxybjQDh5APcjoznIMS9LNyvJef8ZmW4z7y7QJTJfHn5jh29VS9TQtcN45+
/Eg5JmFTjap1YayXa3Jcxn475wq5azl7wL4ydOxt3Fu5jw19FrqJX4C8mvM+
4jV2EP9B3LnYTczJofdIvVINVcjPU87NLXweYluRcFtxJu7EgbjoQV8VekzF
/sB9HfdnCedeMzCKWs711q8enkdeG7qt5v12zGdaszSbk0Begf51xGf8Qsx3
QrbaqY/0rSXpu6gZySP++Zjb3sZnKr7dgc//XPLXYvso7jrVpNoKsbnGvQdM
E5DzMn12hXkocp/AaxMfP7H/m+W7fpWY9cSal+2yZmg+8j5i/Il4T+7GnCNx
JU7qkd/AYT69q0ZfHvcZ1Czq2zNyVSacO9WgWopC730R+HagGxe6LMzjQ++h
erle70PScyiXOF6F/nu274JmpI580xm00qjvmHZNM6nZ1LcZyI1Jj6WeviP/
r5TXLs7aselKuU45f6d8Z9VLcfSJ+DUx76V6rrdHnIt7vXmN3P8GPovSi5tk
pnOtN+ShuA2dX+24oT8T+jxo/+uRjyb8rdQbqbdSb4q40ptzB/3vqMdSviHE
3gWm/RHfYe2ydkS7ojehO8t3TPWJs/TAORE38vmC/mTSZ0dvVim5m3v/B5o3
vfWqSbn0ho7E/z9IAtrS
          "]]}]}, 
      {RGBColor[0.915, 0.6575, 0.3365], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VEtsjGEUvX1NZ+aff6b9ZzRSpai0NrQk1aWF11akCyQWmqhH6xWSLixE
vAXxinguSjUkEoRYmGJjoeLRtNpOq4iqPkIsiAVpcE7P18Xk3u/O/c4999z7
/bPqtq/alm1mh/HLwe98yOx7rllzltnphNkT2Nue2VPf7CoShuNmn6LyB+H3
J80qwmZdMbMe+MMAexOT7QTOJdwfQHwM5x7EzzhMYjcDczVqPgfOM2AeAOaB
wKwBdgnudiHvvK/4R+Sncf7huLV64jpeaFYfVi0c7S1qzMX5HWqOIqcfwbXA
XJbS/R2oNR/nNOLzYB8A/wLwB1B/Hc4DiI954lsOnCJgluFucR6wwaHdE69O
+I9D4tqBcxv8Tc5fEOi/hYF4UQtyG8LdDJw1iIfBcz3+ew0+74H1Dfe+4v/K
QFhVsE05qlVj6ol8qOcr5HXDzgYv3+EzPhIxW4Hcc+jpWlz3lqGvO1Fh7Ud8
BHodAX6Tp37Y10zgDLq7Z33NvyosnalfSZ7qfXA8yZd9FLs451Obq//ScfmP
YE8kNK+TsB0418GPoO/SlLidimsnqHUD/FL4U+G3+dKNPNlXPfKPgc8oOG71
pfPZhOoy/g85O33NYhF06wVOJeJD2IGWuHbpOmwmoV76YGcUmC2HPx32PvTZ
g7tHgfEZeZvBrRaxaIH4PHS7vws403CeE5PtQHw0rvgIbJmLv0S8GrGNOdp1
zq3C7VKjr/jlqLS5GJLO99xb+BmRHr57Ozc97e1xcO5NKr4xrhltd5h7w5ov
NeVOcZ+Jxb2IunfBWTGvxs2Ys+a+HHfvavJ9lCC/nHcLdXcX6te4XeQetcIv
ygcv2OyYtP8FjMvAPIycK7605C6wxoZAZ2r8KiLsLcjpCynOnKUp9bIENjsQ
h32e7IR+pnmyZ/bLGDVkfH+guqzfDl1K4MfhRwqkA983+ZFnFvkWSvNbnvRP
O3zuHGfNmd9NCL/R7RS/FXzXX5J6F5mYZjy5C/wW8J2+AGaH+/bxWzgeEjfW
nuznb6H2nnPgGz0YKO9QIL0vZmle3PFq139VnvriTLm//Ebx3XW7t8Pva21C
d3d7utsUFueJfQ9JZ86SNTJJzYB990a0T9yrxVO051PypcWNQH4L7O+EePxJ
SF/y8X3t9pj7/lSnxIFcVqbEIQP8/w4z5XY=
          "]], PolygonBox[CompressedData["
1:eJwtlElI1XEQx8eX2tv+vXw9JUuyEqpDpQXpsYMt1wiDFCISskXKosKDQQdN
K8hDi7TYIbIy6NACHbLlEpRFKZn4NCkKc6HoUF2KsD5f5h3+MPObme9s3/kv
qm3YvD9kZjV82XyjUbMLM8xqUfpmme3lK+C9IWy2LmX2MmY2kGXWiE9F0uwz
9ivIcwEpjpu9QN+KfxFvvchB4PJ28F6hv59jtgysS2AcAWsYfUnY394R/yth
9g/bKfQ68j2nnjbi/+aaHSdfGv8oWOPk68f/NhhP8C/iLYT9ADl60K/yNWEb
w7807D3swdYG/nd8O8C7gX0IvSjHbAR9En0QfR56Gn0MvYr8e4idT75CevkZ
8f40o8hss5O8NSEP4z+B/2TEa2/hrQPbeuIrzGc2Tb3Ngc/uGD7V9FeZ8tmq
JtU2nee9qIdu8LLiPg/NoJn+Fqa8PmEWI3fzVjDT5x+jnmv0WEl8Pf5XyN0X
eP0biFmAvTXpsxSmZt2O/xr8d+PfGfUaVaswurC90UzQR4nZRmwZ3yPkft6W
I0fizhXN4z65VvP2OGO/B/4K9J5cr+cg9vKky8rRG3MM+cpnJfKDwHtRTzfR
u/jyZzrHnmKrp6apkO9T3LwFxkVif1DD6YRzStw6oX0wy795vmvx4Si2CWIO
ZTvep6i/ySaMf/ieTfgsxKkzyB8Tvstv6B+QG2OO/RaMLeg1SeeOZvQa29p8
OJ/tNQ7GfSfqRz1cx3dxyn21wxLk/sC5pR1pV+KQuCROipvKoVx1cKQc/6mY
70L2NLbqpHNVmNqVOCVuCV9cHqCGpWG/Md3aYc0rK3ND9Ps15r2JwzuTfiOa
rWJG8E8TX5bhZyt4nYFzUfeci+0c+kZzjPPIb4jfke03cjXwG9R8hfEFvPaE
72oJ9tfcynDm/oTxGb0l6fMWP0PgD0XcdxdvdxLOUe1HHCxNOsfEn0bwN6W8
BtVSpRuilvHM/0kzLgHv4Sy3KcezqP+T1It60r9GPUnXPysB1uWo59aN6FYK
M/sShybR0xHPrZr2BX5z4rduYBX1/aG+shyfx13sfXH/d4kjQ3N8ppqt/lFD
cb8h3ZJmGI57DapFGL/x/Q+OVcz2
          "]], 
         PolygonBox[{{2782, 2781, 3791, 1122, 3792}, {4775, 1814, 4774, 2781, 
          2782}}]}]}, 
      {RGBColor[0.921, 0.6725, 0.35509999999999997`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVE1LVFEYfscZp5m5d67OnUsmLUZz4aI2fbqPgpZl2SIIyihIsJlNFETL
hGrTB0T5QVhC0RdYEdkfSIsiStKs1AllRgaKoCJaaM/DcxaX8973POc578fz
ntbuYueJOjM7iy+Ob3dklqo3e9xgdtIz8xNmn/Nm3aGZF4M/Y9YJTA/AxaxZ
FYc/ADOEPR/ndsD+B9/zBq1LvtkT8HTAvxUcw0nxt5vWW/hfgd2YEBd5irAH
wN8Oe29KZ8k1lBH2dmA2GQgzhhiOIZ4N4PqFO//iiwHbD/9T2O/BsQf7H2Gv
BaacFo74vlDx0r8E3M2szpLjC74C/EeAmYXdAnsO60xaeY7BnnYxvMiqFqxJ
CeunvKsLcq8Bvxn4FeCrnu6Zgn3aU67VnNk53NEE+yXyq+BsE3Isgns7Yovi
yqEG/xbUYgack774ec8Z8KwGrgT88UB1XIC/C3cM4twp10Paq0zn+E+7kpPN
Ps9nVO8pcMzCvoF77yCuxaRqtcuUB/0JcJQdvgJ8a6Qesc9rkH8bMIvw14Bb
n1I+SznpZH+DfDXX64v4/8neI+YpX/4++C7j7jiCvIR1Pi8sazYSqCbL1FVW
saRZj0D3NsN3Ia6z3GNcrCNrOOz23gL7xlPvD4TSOrW4CXZvVtqcRt8mMsK/
Av4+8AOoRQyYiuvjeWCP4r8Mfw2+a1nVqYqzBn8//Pfgfx2ov1nsX08q35GY
uA8mpLm7nvaWc7rnt8OMBuI8BL6HgWZwNKN98jNW8pVcnQ+H0i31uzHUvHBu
3gXqHXvL+rLO067ejW5+C5HmrSUSH3VFzh6nQXJRE+R5hlwmAsU/jnXcE4Yz
x7p2pTSzM3nxU5vNThv7EMNiXvzUL98U5sX8OBusLWtc8PUWfAuU72BSNaGG
qKWOSHNZcPrkyl6Qi5qtJFX33lD2D3DWheJ54OaG+TPHR57epjT2v+al0TLW
755moAf+hUCa56zMOQyxVxDPH3BddXFxxjhffBf4PvCt2hZpBruc3jnLzCXl
S6fUMjmYJ3vaFqmG6yK9kewB61/vSy98q/hGMPbZvOaBc7Ezo3eEeVN37Enk
zv4Hc2DUrg==
          "]], PolygonBox[CompressedData["
1:eJwtlEtI1FEUxs+MM9OMM/P/6zhk0MLXwkVtetGiXSS0LKtNEJSRC8Gcndta
JPRYjAVRagvNICoKiSKhVYvQoIiUFCPNUhwZKKLHooX2+zj/xYVzz+O73/nu
ubelq6/zfNzMjrISrItZs/GY2UjKLF4wy+fNGtnHSAqwHxAfIvaH5HJoNlFr
liW+zhog/oT4GPF0khjxcmC2n9xjabOmolk3Oe3mGAb+coPZDmJ3qP+CfRLf
oYTjVcBaxNdonrOEvQRmM9iH8d0E6yVruMasj5qmnNlZ6puSzqkLe4C1M+k9
XMLepH4P+wT9bGBPwe8UtVfAGAVrMsI7QM7vDLrA+QO1Pfg6sZ8Rv13jGFXi
g6Fr8Zd1PfSe1fso/T2Gf3PRe//HebPEYnAYTrnGF4jfCL1WmvSCfTnvvYv/
U7QtwW8r8RIYHWBVMt67eupmP0/P1bjnrKLPCqsu4b45YqcLni9NzmB/DVyr
dvCXwZ/P+NnifAS8Sfjkks73BfZGvdmtiK9m4zg1bfRfAuMbWG8C107zkeS8
u+w3wSviG8euwOdnwu9wrcE1EPYJ+mnjvH0Fnw9pPAX+WuDcdEYFu0y8Zouf
Mc3Z10LHE6f75LcWHUsz8zbrd6q7Vc0gtauBYwlzBbs159zl24bWHbXO9SC+
MeJz0fmagXnsTM7xdOfv2fcIM+WaTrB/Hs2D5qW2Dk3Rc3vS+dxT//U+2zOa
6XrPUa7wNbuaMe2Fodma4bxK3O9wAb2G8q6t5vc1XD/hyyU8Z5bcd5H+4phm
v8Dam3aNroY+Y7o7+aoN3qN6leZ6m+IorrrzBbj0kz8S8zPW4Ftlv5zy+fkM
3u6Cz4rueBf2r9BnUZp8z/qMlqLzdVfl6H1o5h8S/6E7TnmNatWTepOvF7xS
3t+a/hD9JZmCvyXNqP6Ogeh9SOOPob8RvRVxPKdZKrrWXL+9yvifJf30xqcD
70G96A9ZxF7P+TxKjxZqH2X97xNnve3/jY+yCw==
          "]]}]}, 
      {RGBColor[0.927, 0.6875, 0.3737], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlM1LVWEQxse8Xr0d7zl27hEs21ibFtXCiOw/aNMiaVNCpGVK3636oEUr
MywyqE1krdokFBZBLgy7StgHQUQZBppp5fWSLXIV9PEbnrN4eefOmXnmmeed
uU0dJ1qPrzCzTk4l50vBbHON2Rz3ImcLdom7PzIbqTC7F5hVxWYDWeK56zOK
+QFIOWe2B4zHebNN+CK+LeIvrTK7RPwC94uVZg3g9JMbVJntJq5YISzHrObu
i4Q3VWt2n3qjfB/Ct4hdxv6EPUWtFmrdDc3Gs8JynGZuqxaPB2nuSfh8p4dm
ai1wjxKfS+PnwFmPPQ9mX6zcaur+jYT1LxKGc9vA50eRclcn1Od0gzkGRl2d
2S0EHKGWgdOOfQj7LRx2oMMgPAsZaXIHvPf4d2IfJHYi1eQZMUWwusDcBnYD
+WvQYR18hkLFHyZ+HvsU9tdQfY9lpUVDIo7n8bfE8r+izgz3uUppVwXWPnJf
htLO82Zz8vVWiodjey9euynRG5XImwik3Vawj3F6iHkO98FAs+EzksX/G8wb
+F8Hepvtsfr2GfDe2xLxuUh/t/OqO8DdwzmLPUTuR7h1kTMZSj/3O1d/C9fW
a9TCqZNv70LVc99p7CXqLhH3K9Jx+2eg9/d59dlyjVyrDNzKzEQj/gvEtPN7
Gp77Y+n9Lav8a7HmwediMqN4xymG4u99eG3ncB0uTyK9zXCkPr3f3rzyljPS
qyPW2xxI92hjjfZlpiB7mvtoLA5HuK9Gyn2Tk+6u/828eDtuRayZc31ysfa4
Pt1B30nfiWVyx3PqoQ28tYnm2efa98Axvd+HgfajMZEOrkk53QN/A+/zcqx5
8fn1ufeZeZrWH0ljWsk/A49difbWMfZify7oP2K2oN12TN/XD5He2mfBeXmu
v9OfdB+vxOrBexnOa666U93+AzZtrfQ=
          "]], PolygonBox[CompressedData["
1:eJwtlMtLVVEUxtete69er+ccO+cElk2kiYMeYET2H0QQkURRQpQZSmkWTsx5
YVhU0KRIHDRLCrSgHBRmDnoR9BSkfKQ9VLJJgwiifh/rDjZnrb3W/tb3rb32
qW3ubDy5wsx2s7KszsCsjm93uVljalaIzY6sNBvNmN0pms1HZutzZsv4c9jX
yT9HfDN7v/Ef4d/AbwUsqDT7lJgtUmADeNPYc6xN5b63n/wFcvbiFzn/AP8u
NcYyvldL/anEz64GrzM0e8s6hn0AjjepdYv8hxnnaHDdkzr3Anj3wBskfwf5
DYS7yP+Cfxp/LfWr8Z/jH8KvBuNZhVkGjJqsYw6CfSpw7XWl3lwkXp/z/AvY
B6nxA6wt0gTXj/hLxKbycFI8db8Hfk3Yh2OP7aLGELUXEj8rfT3U+xc5vvQt
Fcy+rzI7T35EvLvomqRtlL2n+BOh91o9n4H/UfCn815TXLSnmDTPk3s89tq6
v2XON5EzkXUN0pKNXWs/GDnsbXBuhd8A+fsiX7LFaQFuUZX3UjWqsHsD17oT
zDfg16R+n+K8LnWN0qoZ+Jy4JmnbiD+DP1npXHQHS/htoccTVgf2bOK5mh/N
VktJj/QugtUV+llpGqd/P4uuVTPaQe5V+vHH/H5b4Dpb8Nk4Q/xD5DMmfvXU
+JZ4jnJ/sXeJ+KuC26qhWsMVrlc9bwZ/O2s875qHqT0S+WyrxiRnr5Xei97Q
HH5Z7L0Wpzz27dB7J0xh642J/1dy2om/APNJ3jHvRz7TwtZeQ+xvSr1pg38D
/d4a+6yIj97W2cC16k28FlbBc9Vj9fpx6LPdS85Y6DVUS5peFv1OxU8Ywhqq
cFt74j4Q+Fm9qRx32V/y9X9Y1Dwn3lvdcR/YI4HPut70O86XccbK/A38JX45
dj7yr2CvSX2WNKPVqf8DdF5n+mL/B6mWaoqLaspXz9X7E7H3UjPzHi3/ASFM
r3s=
          "]], 
         PolygonBox[{{3085, 1127, 3800, 3514, 3515}, {3515, 3514, 3796, 1125, 
          3084}}]}]}, 
      {RGBColor[0.933, 0.7025, 0.3923], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVE1LVGEUPjNe58M7995pvIFZhElSv0Acg5aFG4laVOMiE1PBNMJNtamN
0IflphYG1VALw2jTpkVQ9LUqIms0plU4kThMEK0iinqenjdcvJxzz3s+nvOc
895tQyf2TybNbBynCedTymxrs1k1YbbSalaGPOObTYZmsWd2EnIMJwPf51mz
O4HZDALfw1aGfgH6WmTWAd8j0OcRfxbx7fj+gnwTLvZfDvh/w/133PfhfiP8
P+C7kZR/G/zaY7Mu6Bfh09gg+/98zE2fj5Ewd8H3GvQnsO+BPhYLD3HN4fTB
tw7MlwrCTOxt8OkHoE2Qj/CdQu0gZ3bfVx7mK+Eso94AZA9iJxA7FQjXzZT8
mgvSPcjZSL0Pw2cAec8hfwlyDvYfyL+aE6fkdg2cTAfq+x1svbF4Jt+3E9Lp
9yKrXqdgP44anei3FokD1uIdeVt2/nuRZxD2Y8h9APppYKgix85YXJGzoy5+
EPJuKP4t0D0xF009MP/VFrNkWrw1JYWt4mmW1ZxqH450P+KJxxHgXAEnDfT1
FrV/wn4dPou++mXf5JKz53e9VfjJN2fAHI8D1WG9ssNKzNO+doIzyBQ0D+a6
hz66PfVbgd/DSPKVL+7I05useCE/Q7h/4Cum6HglZu7Kkq93MA77qUB8zIea
E/Geh217LDvvf0fiJp3TbJjrM+QvZx+Fby2r3NxH7h3xcydSqHELddNOEhv3
ajXSG+Fb6cXdS9ztgqw4bDuQM5HWnrNGTyy+DkY61Gvgte7rbQ9z9wuKuezy
kTdyxNlzBxZCzYEzJV+v/XUuv0KvIWYUsfm82W70GOW1p/TnjMjlvoz64k7Q
XgSuLbHsm2Pl6HT/GXLJukX3PsnPDTefDvfOF9x+/gG3i9BL8OlvUd+HvPX/
COUMYp+Fsj9lL6F2cinUDnY7znNux/jurxS037OQfwGyj6s/
          "]], 
         PolygonBox[CompressedData["
1:eJwtk81LlGEUxa8z44wzYzP6zhuYRVQk9ReEGQRtCjcStYlcVBIa9EWrCAra
RIWWm1oUpNHGoNoUtKvoCwIjitSQNjETiWLQMqKo3+nM4oX7cZ5zz7nP864f
OrnnRCYidvDl+EaSiEY+Yr4lYqYccTRxvKE14hjx2IqIH+T9YEeJt1LbwsEZ
am/Bj1ec/+J7X4y4KAzY820Rg2nEBTBTYLvpL3fSo7aMgJS8j/gS+E8tPqOz
m1LPX8v8zcSPq551Br695Kv4Boh/wvGIXqNGH67bYOrEs+gZJh/LRkyXIu6R
H896xge0dDIjnzFmjt4T8v3M3s68jg7i1No1/zP8h/H7pbmfWc7PF61FnuVd
GqRlN7U1nF2dOlb/IfjFmrXNkS/VvEPtsg7nMNyDVfe6qL2Cexu113l7lvfl
srG6jzp5T2pt2tdG4ndFnz2Ax3H6AyX7kUd5nSzZvzj7EnOIS3f+He6dcDxj
1kEwu4gX6V/O+s4XiG819SqfIH7a3J9maHcL7fbfg4duzk9VrG0lHHeJvzbn
iaOB1jcl87cUuCP0PAezL+eaet9qzbcC5zzcbYm5pfFB2Xequ81w/iq9Aphs
xrVR8o8Vx9LYTu9m1W9TGm8QT5e9W+2kF3yObyLvGWc5e63kXa4jP01+veTd
TILJgx1PPFszf8N3JbEX5X/Ih6rG680fIn6JZ57D/zfam/pN6f70ppbK3ql2
qx28YN6piv+NO9TO0f/b7l32U7tPr5BYi/aRTaxRWjVTWkdSa9E+j6TGCCuP
rYk5xCX/ehvyLO/6p7rA/wOmRY0T
          "]]}]}, 
      {RGBColor[0.9390000000000001, 0.7175, 0.4109], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1k09IVVEQxiczed2r7/LOvUEGLgStXLrM9koRCQXpwohE/LMpzQha2K5F
GLppU5uCF5RWYBvbSLqujUgG2qoIJXsvdz7MoH7Dd1scZs7cb7755szc1sGb
l27UmVkv5zDnTWz2rMGsEMyqqdlmvdm1xGyR+BzxQHz1qFkH2Nmi2XST2RSJ
D7GdR7gXzM7z7UNk1nzIbBL8aKb4CLYKT5X4Nzg/5pj1oupMw1/m/hy7z30e
fwr8cfwJMF/qhWuGv0zuOHXvUrdSUu59sDNBnM79NhZXTCzilPEXiHWhYww9
Z7Al8lvguRippmO8t4NE/dwK6tNjG/T9iHgNXI23GQ7q3d/A38i17RK/nkjr
ILafs44/gI3gewW/oW+bezv3H9gV+PvALGPjRrMh/DX8riDs00hv7/mu41gQ
zzt6GcX/jj+GvZwJswjnBTj66fGA4Z7O5J/CPk7U5xPsTJNmtUSt8SDfY23g
roBvx57g9OJvNyrP/flck2t7Te7JTLPwmWyA6wSzlUqH6zkbVMP5z4F5id8N
1wvsn/ydZ8FczaR7oag3niho1j2Z/O5M3xyzQt4q/ffgzxH7FCs+EqTd9Xjv
v1Nx+dxcq2v+m2v0ufi+/SzJ/z8r3w1GbcuJON4n2lff2wp19lLpugPf7SD9
vi8+N98l3z//5pgK2Hux6uyU9G/V8t3+XBTed9Bn6LvkNb7mtQbo91eqXOd4
ECtvP5Um17ZDL/8AgQ+JeA==
          "]], PolygonBox[CompressedData["
1:eJwtkjtoFWEQhSeahHt3c/fG3RVUsBB8limN2CYooqDgAyJofCRpYmIstBCx
sNCIVoJaiKAgiQhaRMvY2Nj4wAiJlSA+4o2ChcEH6Hc4t/iXmZ0zM2fOzJr+
E7uHl0TEVl4r72Eacac94hfO9XrEId4c9jveYez5ZcRbImbwv2J/6ojYVTH+
BvGBMmIcv6st4i9+X93YKrWf8fmCv47YdvzbtYh/5Af1esFMZhHTvH3YZ5dG
TCURlRwcfCbBXEr9ZKvnKnrdA98DfgT86ZprqrY4DBK/Rr/FVtd4QO4Y9Va2
mN8p7C28pM0curG3Jc4Xx8/kXq6Zizj9IP9WYux96i0H/yS1rRpT4M/DZ1NY
w4R4o6BfWMOFwppKq7vEH5Gbg5lod45yE/Q4Qnw1PTvp/ZGcroo1Pwd+APwO
1cJfwN/MjEMVa3yA2sOZtda/7tIaiv8HegzmxgirmrP0msP/wwHsx98Ifmfi
3uLwKjMH+UfxU/CLhfXUTD+x++u+DfnHwN5szqd5XlbNWdzH6d/gXr4X1kL/
vhXemXa3l/5r6X8y9260gxHsUTisaN6PZttQmqs0eEPtNLeWuomL+BdS91IP
3e5Q7tml13vdXulemlmzz3fYFof1xGar5q597sFvpM6VhsepdabJVzf3IvXO
hdUOH+P3lcaL30Hsicy3rZvR7UgjaTUKh17irzNrq5t8Tnwmsy3N32I/rbuW
OE5L28Kzage/sXtK15KvW7/a1E81rmD/BxNWh0g=
          "]], 
         PolygonBox[{{3337, 3336, 3058, 1111, 3776}, {3023, 1094, 3752, 3328, 
          3329}, {3329, 3328, 3754, 1095, 3024}, {4072, 1317, 4071, 3336, 
          3337}}]}]}, 
      {RGBColor[0.945, 0.7324999999999999, 0.4294999999999999], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkjtolFEQhWfzYvM/suv/r4WVBMTCXguTiKURsRDUJlrYJAFRWdOIIARs
ok1IZeULUmilRRSEmAjaCBKxECUI2uka1yj4BMHvcP7iMnPnnjkzc+YOnzp7
5ExPRBzm9HLaQxHb+iJmsGtpxOtaxIU84mXl1/Cb/RENzl7wn7dEXBmI6GCf
JxFXIXlF7scGPPjjifmEWST/dm5Ml/djfcZkxMcL813ifYH8GrGb5N6n7hP8
a+AHc+PF/Z4zTA8HydsFz134n4JrFfZL7O8yYjtvl+FIKtws3D+4fwc7n/tN
mE2wj+DM4VwfZAbOP+I3iI22PIO0+QJudz1iA3u613jpcj3x/Q6YJrz9iJpk
Ed9Sz/mY+HLDuu0v3If6KfCfUesN/kQ104sBa3KSexeekZZ1Vx3t5FBhzFv8
NHMt1ZR20nCU96XEHCvSsmnNpf1F7juoNQ33FGeT3EnsSsN7XcVuLTyLZnqQ
Wtcl4qtD1l97mEvNk4L9UPU9jX8r8e60w2XOUWkLdqNhzVNy9xXGCDtSr/Tv
sZW2mlk44bUr7V5/4B7+DLkdZj+P3VP3XoTfiUbHuXcy96qeH6bua7ZuXTJy
FsnNsX/Z3xjxP9huaa6v2BMt4yewP0v396v0rMKrz7HCe9Q+JysN32WOqQfN
NlVYf+1B/0h6qiftQf1rtgPUaINfY//nwH8i3i5cS3HNvJ55Pv0F9a4/o/h/
QpN8oQ==
          "]], PolygonBox[CompressedData["
1:eJwtkjtoFWEQhefqJiZ37+4mu5silQTEwl5Bk4ilESvBRxERrBIQxWsURBC0
U5sUgp0KIYVWEURBJFGwCoiSQpQgaGmM8WrhE8HvcG4xMOefxzkz84+cPHPo
9KaI2I0l2IEyYqQnYg/+BH4b+9Qb8b0R8beI2MBubDZex/9ZRYz2RXRochO8
lEe0iA2T8wx/mrdtieNT+Glp/JycB2nElsy5R3j7Br4IfkOsgc01IzLy53ud
f4v6RaxA3wC2VPhNsTYa9tdwFo5J/0Juk3+F+HHir/qdKw2XiN1tmkuc5+Fe
zK1FMzwkNt3dh/AU/iwadyTW1AJ/Zf5d9NtgvhNwTzQ9z2FyntJrsja3enws
nKPcnbx9ofYYeJ7e1+n3eTBiX+n5pGkvfid1L/XUri6Dh5MuZ2WN0vaS+oPk
v0vti+8DvddaEUf73FO7m+vOq7ftaLvN2wvwfWpq6kdr6xPHWO2b6nbj5P+B
bzbz7fUnzpb+E8Jr4BnwudK+/sgyXCu5/R56pGhZSH0v7bCp3EHPLj7N1oFj
a2INq+Q/Tq3vFD2GSt9It8qY5wnc71vWp5pf1I6VvrfmHce/kDumP/qD+Exu
Lu38Kr1jwNqksYG/Xvk2qlFtVXo30qvbr/abW3ramU3+P+IrxO7lxtL4mvxJ
NL7t8unWvyvvUv/vGvE7hWs1o25RluYSfkT8P9d+ek4=
          "]], 
         PolygonBox[{{3471, 3470, 3772, 1109, 3773}, {4721, 1769, 4720, 3470, 
          3471}}]}]}, 
      {RGBColor[0.951, 0.7474999999999999, 0.44809999999999994`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1kj1MVFEQhQ8s4sLuvqdvtzKhsCKxNlHiaiQ0Ala2RgtJjFAs8S8kYEIC
HY0YCzqwgkoqaPixMS6FhYk2kI2iiYWFIAgFhYXfySzFzZw7d+bcOefeiw9G
79RaJfWxcqxGUbqSlw7KUrUijYCvEedS6aRNKmXSPPgfeIF4j7UDHiL2c/ax
XRogXmfVwVXiDdYW+Cbxc4d0iXuelKSH9Hyj95i76ol0F/whCY6nDNNokV6z
7yG/UeAsjdw2eJz8BXgO6Z2Aa5v8OucTzfwn7nkPHgQPdEqz9LylpswM35s8
O+R+g7vPSPvEVnT2ofcHHpyF8w81B9T05kO7ee2N9S5yVoPrF7OOEv+WQ4s1
3Wb/gvlXOiNO5YPLtZO5wOawt5TocRb5We68X4n6n8x/4jcAfy0Gt7HvPSpH
nGa2lnPSZeYXcZX9EnekWXhhT8bgrDf12j+f++3shTVZr/HprO+S8N5v5/7d
trjb2r8UIme/i1n02dfBLHqW4Ng/H9r8LzaT0PWS+t1i+Cjro6eLmmdJzLLY
Hn+iksXe/yvJIr9C7aM05hgmrrO/Cn5F72EhvPRb+T+Zo9ERvtifPWa5VQmd
/r/uq+Wi7nkp8BtmnimF9q00NFjLMvxradS41hqsxW/1H19uez0=
          "]], 
         PolygonBox[CompressedData["
1:eJwtkj1IlXEUxo92e7nX9973rffeSWhoCloLKryR0lLm5Co41FA5XKGEoKJA
gqAlbXALxcGmmpKg1M3r4BDUYkhZINGiaR/g0NDv4bnDH87Hc55zznP+x6+O
D7e6I+IUr8SbqEW0DkWcxXmXRmxWIk6GY2/ziFdZxG3sja6Ij+RrRcQB2Jf4
Veynqe2L5YjuRsRNarbI98Jxj9ogNlC2fxd/kJr1hD7UfAU71+Ne56h5Rn4j
dU49r4D9DuYn/iQco3DdAkNJjOE38fsatj9RPwr2EfUL4JvEDuoRM7nn1Qxb
1Yjtirnuw/+E3XN6vEi8g3a5Dv5LyTvcwP5cNZdiyv2p21aP39jXcvfWTG24
p+B8CPcIsb/wfataG82gWXZ5Jw6zG/h5sGu5Z9HObex+5llLrPcy/mpmLnG+
oclzYv9KnnkR/r3U+ii/DHYlM59i++SmM99WN32MPcE71plXWo7T70divLSu
F9ZCPRqFe4pbmBb++4pvqX0uof1sZx7xfyDXBNNOfL8H7LdfN16a/cLe450p
Wz/dain17fUH9BdVo1r9kcuFZxb3An6G/zq1rZ7SQhpJK/U8X1hTaXsajbuO
8N967EvzHd2q87+k0VDhP6P7aaZNbrVz1LMptot9p2Z+3eQC+P8GR3x+
          "]], 
         PolygonBox[{{4077, 1319, 4076, 3339, 3340}, {3340, 3339, 3061, 1115, 
          3782}, {4671, 1735, 4670, 2721, 2722}, {2722, 2721, 3730, 1081, 
          3731}}]}]}, 
      {RGBColor[0.957, 0.7625, 0.46669999999999995`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkjtoVGEUhCcbI9ls9l7z321MIYg2VraK+MZCgw8sLSwU26ygoljZKSKI
iHY2EiGVNj4K00VXCxtJY7Gg4qOLYoy93zBb/Pznnn9mzpxz7tZz/dPzLUkH
OOOcz9PSGomHtTTdlWZJrhJXRdq5QbpZSft60hbiK8Q/eNs+IZ3g/TL4wZi0
1JFOleT9/oizTP45+TG42+DeIn7flr4RX+T9bC/4n8SvO9Gx3iZ0FjdKM9zH
OXvweIO8wPbHg2vB3YHOXXgvOqnlmtZ23v38baTdk9J6E9/2f61Kb+7x2FQ8
2du/Jj7sp0/No+hfgvsRvw25MhEfS54L8bAdj56Paz9Bq8X9YFTnDm+LfF+v
oq9evNpbjf7+kl6udsMxdwGNlXb6XKDOoZK6y8QD8kO45+vsw3Xvcd/uxtd3
3u9X0XyMzpCd/mYGF+p8O++ac5wPePuEl18z8bnKPUv+GfHmEo/u3X2tgJvj
++mopjGev3Wtv7eX3djDQbjr4M+AewP+JXW7YE+WzGDXZDjeiWfkeL4E82oq
vdpba/Tt/Fv3VGefX+hpUGcf77gPl2A9e9f0Ts3xvKx1pOSfNveruVUw/sfX
mvj5w/0fyP9kYQ==
          "]], PolygonBox[CompressedData["
1:eJwtUj1IW2EUPYlJifl5r3kvSzMIYpcudrVICyoOGrTSrQU7VHA0hYIWJ0Fw
EBcRnLoZMJMutkvc0kaHLsXFIWCLXVVM4u45nAwf3P9z7rnf8Kfqu5UkgFG+
FN9hFkgmgN9PgEoEvOUr0H+eBhZo/x8ExmH/Ywl4xtgxa1+yeT8HtJkPmKsO
AKsFYDEE6uzfYc1tEbjMeXbEml/M7QbubbGmwdxBaFszy5wNYoww3yHJqzww
ERlf/ZO0b4qePcSaTfb/zbtWPYmSY8q9ygDdmJiB9ymTX4t2l/n3KftZ8p3N
2lasyXwvdu8dZy6T2xlfnDaHbdZ/o9/kvC+smSFejT7S3kG7SBPtVyfHp+Rb
6+tbYeyY80PGXqQ84ztrq5G1FccV2vN9X3hztP8MGks9G+y/J7+xjPddD7yD
+H+g3+O8r4H31w226C+RU7vv6zZHgbmIk24/HVlb+VORMYR1zXdO7IfYWNKj
nbcmssWhw9y/vv7qSVKPz6F7FauGvrnmS8MW7bWC/4r+TCP0n5EvDS+Id5qz
lortkcvrkvG00xvaJzlrJ40D8v0ZeHfp94P7FCNrrxrd6hEjz1xx
          "]], 
         PolygonBox[{{3759, 1099, 3027, 3451, 3452}, {3452, 3451, 4027, 1294, 
          4028}}]}]}, 
      {RGBColor[0.963, 0.7775, 0.48529999999999995`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFkr0vQ2EUxk9Vmra37tXbG4LJ7B8QQqKIGHzEnyAmkpaBGERZmGx0YdOl
CWFqSITFgAgRg6VNxGpAMPn8HaeJ4c157/M+53mf87y3dTw7lqkRkXZWmNXg
i+xERA4ckbU6kUXAS09km/VTK1KgluKGn7oinymRB/AMeBF8FnwAjbOYSAt6
S3DS+o1mD/UN3ZeQSBztO/bn4H3guxHT3+esQp2KinD8p6Way/Bv0WwDm2Nf
cg3XO8sJkQ7473g5pqmD/nXOL/BUQS8M/9CxOxrR+4JXBF8FW2G1wp93zZN6
ewVbYD+D/p5rs15HTGswEPmAv4W2V91vsm/2zb/mpD3aW4ibV/Vcxvuobzoj
1OekzTnhmV/lK6/Xt0z6qd2B5dBFffTMh76JZq2Zf6dsNvVVdiwD1dTZ1J96
S6Kz4ViubmB96ej//Fqf8DIE74p7h6mhwDj3CcM0Z70jz1yd9J849q76vjcx
m1v/GfWfrXqb9iwX9ZBAL1/10OTbzOpzkuoEppNDr943jnJzVf0PZjzyLB99
k1+4LmUY
          "]], PolygonBox[CompressedData["
1:eJwtUk0rRGEYPcN0M5/X3JkIq1lY+Qcjip2Fj/wEZUMZFlOyEDsLS/MHZKMo
q4kSG2WSSMpqpqRsWKBYja9zOrN467zPPR/P87y3OFeeXeoAMMgT5zlPAcME
K53AWgaYD4Em76UuoJEG3nLAfsy1d+LVLFAkpgwV4lYeGCB+Yu2beJf6P+LD
ADghaaHtJ/5lgp4ETfpVmFej/pj3g8AaabdZG4JrPRGww3sp7pq+TbF2E9jj
mfy7hPNb5EwUgBGexS5napYLataZ9UH+J7OuQ9+lvyJOF6yVR4r4K+/ZNfNW
yhni3jJzhtm5yPwj1rojc8QdpyZG/V57fvV7z95+896NOD/EvZF3I32V2unI
3uqplqQ+6bfQm1TZ+2Pa3vIo03sj491pB5PUjvHUA9f0rZFwtjxOyX8JPbv8
X0O/md5COxplv9mCe9FMIfFy6Czto57wPyEvvcEZhX2R+Zqxn3iz3Y96eOD3
fyZSW3E=
          "]], 
         PolygonBox[{{3030, 1736, 4674, 4035, 4036}, {2726, 2725, 3733, 1083, 
          3734}, {4036, 4035, 4677, 1737, 3031}, {4676, 1737, 4675, 2725, 
          2726}}]}]}, 
      {RGBColor[0.969, 0.7925, 0.5039], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUjsvBGEUPeySnZ3dmZgZj9ZKRCUSrViFrFcj4hcoJUg07CYKjQoV2yko
FHReQUFDyEaLRBCFigKJzvPcnCm+nO+799xzz70zzWNTI5PVADp4EjwNAdCZ
BBY94MwH7qqAGxd4zAAfJE4wduEAT+SM++IZf4XoRkBfCsgQN9PANAV7qZfl
u42cZeokahS/pG6e3FxSuq/UamXuhThEfjvjC9T8CcX7DdVnt1a1lh9g/JO1
RU86c8RZX7EZ4ih1SuQ8OHpb/Jlz+JFqPeIRPZ1Tb4P5Ck89PVz58mqe/9i3
7MmzzdQTqZf1vHY0z5avvPWyfRU4c4U++wPty+bLs64lkP8ccYf1Xdx3Ia2d
WS/zZ9idUs17HbBE/hvxgPxh5u7pq5TVDk5d+Tb/h7yfuIpbfs3VvprY6zie
cZ3c71D6X6HmMP3t+Bub93nW7se99oi3cdz+Bfsetvci76uu7o2BdE1/kDP+
AxH8U2c=
          "]], PolygonBox[CompressedData["
1:eJwtkD0rhnEUxs/zQrjfct+3lxUlk8UqDPJ42eQTyGR4lAn1JJNBz4ZFPgBG
CwZKKWGVUmSwGVA2r7/TZfj3P+dc1znXdU7X7MJ0tWhm3bwy77XVrN5ITrIe
mO0lZpcFs0NqPanZOfk9+UqT2UwOLxU2AH8X/ij5Ykmcu0AzfNYw/O+Mn573
omojxD+ZMK9VmT3HOyjIwxtefsH7ysIfQ7Md8A/iCXoS+h+a5cU1a5HZJLUL
+vvpmSLuSBV77Rgva5G8XTG/AjaeKvaa73YUiOv7tIM9h9JzDxHzlhPN89pS
Is/ubQgPX3jdJy816GZ+uzp6g9y1l9pLIo/u1Tm3eK/FuoXvvIH2aiytCvMC
9MJcsev57vO8p3++32ozllfXO6V/rEV6bcy/Bj8LhLnmNtzOVHzf8QTsJhHX
e9xrnOu2vuMW+Gem3dyTe/sDnN9L3w==
          "]], 
         PolygonBox[{{3332, 3331, 3036, 1104, 3765}, {4043, 1301, 4042, 3331, 
          3332}, {2730, 2729, 4679, 1738, 4678}, {3764, 1104, 3766, 2729, 
          2730}}]}]}, 
      {RGBColor[0.975, 0.8075, 0.5225], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUT8vQ3EUPdrXKq/t856nkSiJf53EV9BJGgaJ+AQmCSEREoZuNj4CiZFG
LNXFpkazSUgkwswHwDk5b/jl/jv33Hvub3pzb303B2CRL88XVIAanacIOKkC
deVT4JLxbwDE9F9CYI1+l/UK41YJ+CgDcwmwQPwWOR6IjwvAfOK+g5K5Zhnn
mL+OjBN+grnPwDw3A8Bh5HiQ3Nv03+nv055zbpf1MeaX2ZOn3xkGNlLP6hNz
FZl/ivWz0Hzfsecp36G9yHhmiDml3yB/m1oKqfHqq6XeW7rr2c7iHkmtQ7fR
DXQr7fFG/U3u/zcKPA9ZV5v6bovm0bzJxFY6+tl9Wok1iOOOnD+x9Uq3/kD8
y6z3qvb1P6up77lC+xX4VtpJ89UrDU3Wdhgv0R5Fxh1nM3tFz7sPvd84dwhS
8+j2jcSYx9B84ilneqTrlfr+AfhlREI=
          "]], PolygonBox[CompressedData["
1:eJwtUb1KA2EQnOQuMT/mzjvPIBiFaEzlO5gqBAUF8Qms/QERNIWtpW9gYSci
FsY0dmLlA9goCoJorQ+gzjApPpjdnZ3Z3a+5tbexmwfQ5Av5nqvAGkE9API1
YDEFkgKwxFqL+DJmfhQ/lYFzxr/kXxeBO/YGGdBg7ZO5kPg7Aa5ywDvjH+Lj
CGgTj5PTJ96PXVP8SL251PoD9swS74zqnRLwRtIte4Kc5xtG1lDvNusd+i1n
xupR7wrjg5Jn1Kx9vq/QM55E3lFa68y9cP5uxbFucMP6Yexd1HNEPIjM1QwX
FWtISx6r9Eoyeyk3QfzB4Xola0jrgR7Dom96z3g+9a7aeYF4OvUtlTsj97Xs
W4u/mdlT3tJok9sb/Y9yXeLTqu8tzxr5Y5m9lSsQ/036lorFnUmtL/8G8VRm
b+1QJ/4HEvE+aw==
          "]]}]}, 
      {RGBColor[0.981, 0.8225, 0.5411], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkD8vRFEUxMfueqy39tmXR+NPSJZO4zPQyGp8BHoSUSMSjUIiCo1aNITQ
KlBs1kdAhw+AqDR+k/OKmzn3nJm5c8/M2ubqRkVSm1PlzOXSNsXFkNRfSEuD
0gC4k0m/ED8b0gj3Zfot8Jx+t0/qFKGx9rYpvTdCm9A/475O/5T57nBwrtDV
mc3XpAPml9yf8flD95pKb9QVuGNwOviMgiucBfiHzXjfWmfaK7M5o/X2eUyD
Z/5+Fmgf8+6SyGOeM7me5t/fLemI2Rd4k4SmW+Zwnhc8J/OYTYE/Jf+Y/kka
efynCWbX9MfBdh7vzYI1ZotkqIK9LPbgfdyn8Y53+VDu4YleUe7H3r269EG9
lUVe+1vzD+quO0o=
          "]], PolygonBox[CompressedData["
1:eJwtULuuQVEUHI/cSA42J4fGIyToNL5BJTQ+gUZF4wNE+AuFUkMI7S3uVXj8
ApXEJ+jNZJ1iJbNnzZo1a1cHk/44CiDHirOOaWAaA54R4OGRD4BuAmixufKs
hA8/QMkH3kngQ4MmuUBa1iVimh5xltVJmGbtgGXatG1yL85ene3Szhvxmf73
8N2g/yLUyyNDrwK5PXcP2R+lrIRP5Grs/Yfz4lac3TnzErcl3jjLJ48i9XNn
WZVvRlz3zUv6P74rvnlp5pfeZd9u11teukmz+qM888UCu02Zlf0LFswuhQ==

          "]], 
         PolygonBox[{{3958, 3957, 5127, 2117, 3299}, {3948, 3947, 3954, 1252, 
          3953}, {2957, 2956, 4593, 1678, 4595}, {2961, 1678, 4594, 3947, 
          3948}, {5126, 2117, 5125, 2956, 2957}, {3298, 2116, 5124, 3957, 
          3958}}]}]}, 
      {RGBColor[0.987, 0.8374999999999999, 0.5596999999999999], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtjr0OAVEUhAe7smvFxrqVhq0U4hUkGo2fwiOo/URBjUSp0Il4BVvoNSo/
rScgKuU2dObm3GIyJ3O/e+aE/XFvlARQpFLU1QeUDVzoNj1gWGNesYChA8SE
Tx5wTAPlADgYLqKvPeHSCnCoJvkMfZeTPd8sMCf3IbOklwLZE9KrlvyNEsDM
l54n+a35++Mc54XRPXvmdc5nTzjNr5h12Ddlb5uuqBbnN98bSu6/uUDB5AH9
Zf7qTt2hu/S9d1fuXDDvmp0PZhNfbhz4Ij1veMMfzVcquQ==
          "]], 
         PolygonBox[{{2506, 2157, 1063, 3710}, {3717, 755, 2118, 5129}, {3010,
           1086, 786, 3323}, {5130, 2118, 755, 3956}, {3320, 786, 1086, 
          3739}, {3455, 45, 1300, 4041}, {3323, 786, 1285, 4013}, {3735, 45, 
          786, 3736}, {3956, 755, 2157, 5185}, {5126, 1063, 755, 3299}, {4014,
           1285, 45, 3455}, {2961, 430, 1063, 4595}, {3710, 1063, 1067, 
          3714}}], 
         PolygonBox[{{3739, 1086, 3740, 2711, 2712}, {4007, 4006, 5196, 2165, 
          5198}, {3967, 3966, 3301, 2123, 5139}, {4641, 1714, 3005, 4006, 
          4007}, {3723, 3722, 3970, 1259, 2507}, {5138, 2123, 5140, 2963, 
          2964}, {2964, 2963, 5129, 2118, 5128}, {2516, 2165, 5197, 3722, 
          3723}, {3969, 1259, 3968, 3966, 3967}, {2712, 2711, 4640, 1714, 
          4639}}]}]}, 
      {RGBColor[0.993, 0.8525, 0.5782999999999999], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUDFOAlEUHHAlu3zcZdffCtl7aOEFKDyCB4CGGgItBWuCcYGCUFlyBltt
vYIJsVZC3MZ5mS1+/n/zZubN+/nj6GHYBNDjueD5CoBlCzg0gG4IrPi+If7m
gDv21jHwROw7EGecSNP2wG8KFOytyd2SV1F37gAbJ82J/ZL4LfkvvKeJfGa8
d06z/shZxJr5GQEfkd6G9TN5lm2gcQk8t1S/Jqpz9o+B8lwRr1Jx9vS+98It
r2W03cx35bRH5jXffAwPvXDrX3vltLyTWN7vkbCi/h/LZFls759Uf1hSO6/5
pht4+Vvef5qYNKU=
          "]], PolygonBox[CompressedData["
1:eJwlUDsOAQEUnBU27C7L7rYiexCFCygcwQEodBKFE/gEsduIQu0OSlpXkIga
ERozecVL5r03b2by0v6wNygAiFlFVhoBTgn4EbeI3w1g4QJHB1j6wCgEbiTe
WWPiL/cr7utl4BQAG89u15z9uNv7hqV5IH/LfuaahrQy9nP2D/aT0DjiSnPn
m6e8dfOk3rUCNGGcbgJ4iWmJUyb+BObf5iyvWSZlk8eL99PQvKRxoVZWM65u
lP3MWRWm2Uksk/j6Qc4sUWJemsXEfwTOL1Y=
          "]], 
         PolygonBox[{{3008, 1084, 3736, 3321, 3322}, {3322, 3321, 3738, 1085, 
          3009}}]}]}, 
      {RGBColor[0.999, 0.8674999999999999, 0.5969], EdgeForm[None], 
       GraphicsGroupBox[{
         PolygonBox[{{3009, 457, 3322}, {3964, 1068, 3715}, {3965, 434, 
          2969}, {4601, 434, 3963}, {4005, 437, 2977}, {2710, 866, 3737}, {
          3431, 866, 3973}, {3972, 437, 5057}, {5057, 437, 2976}, {3962, 433, 
          3955}, {3266, 718, 4602}, {3955, 433, 2968}, {4341, 718, 3721}, {
          4596, 1068, 2962}, {4597, 718, 3266}, {2971, 434, 4601}, {4012, 866,
           3431}, {2962, 1068, 4598}, {3322, 457, 3008}, {2970, 434, 3965}, {
          3715, 1068, 3720}, {2975, 437, 4005}, {4603, 866, 2710}, {3725, 718,
           4341}}], 
         PolygonBox[{{3973, 866, 437, 3972}, {2977, 437, 866, 4603}, {3721, 
          718, 434, 2971}, {4011, 457, 866, 4012}, {2968, 433, 1068, 4596}, {
          4598, 1068, 434, 2970}, {2969, 434, 718, 4597}, {4602, 718, 437, 
          2975}, {3720, 1068, 433, 2967}, {3963, 434, 1068, 3964}, {2976, 437,
           718, 3725}, {3737, 866, 457, 3009}}]}]}, 
      {RGBColor[1., 0.886, 0.63], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFUDFOAlEUHGUxBHQ3y35aE6yVSMIJTLyANRUHgANopyRaSGNBQWLstaRU
MRptLcQb0JhgDaUzmZ9Y/My8tzPvzdtmb3DS3wSwx1fiey6AnQrwSBzXgMME
uEyBhwxIysA98Zb96QawyoFz1ktqjgJwRv5Dfhp74rRiVlgv382W+6qFy8i7
3PlL/skwHeI3dy3obSf2SPMV3BtVrZVnl/Vxw3w/WK/80gnbcf4HM9RZvxIv
MvuHme+U7qXwXPmeCmeQXnneto3v7OcVf1OtGXnUXKfu3/HGde679G8mNWe4
Sn2TuHYoqzK3gjNp1zwYO1FzEP73/wH2Yj3+
          "]], 
         PolygonBox[{{3963, 1257, 1683, 4601}, {5166, 2140, 719, 5165}, {5061,
           719, 2066, 5062}, {3715, 14, 1257, 3964}, {2976, 1076, 2065, 
          5057}, {4341, 1493, 1076, 3725}, {3973, 1261, 30, 3431}, {4599, 436,
           1260, 4600}, {5053, 228, 2061, 5054}, {5332, 2066, 228, 5331}, {
          3721, 1073, 1493, 4341}, {4601, 1683, 1073, 2971}, {5056, 2061, 436,
           5055}, {5444, 30, 2140, 5445}, {5057, 2065, 1261, 3972}, {3720, 
          1072, 14, 3715}, {5186, 1260, 14, 2508}, {3431, 30, 1284, 
          4012}}]}]}, 
      {RGBColor[1., 0.9051999999999999, 0.6659999999999999], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNUbtOQkEUPBEv2WsIj+z6ATQmxmijX0CgUwp7Ch41NpD4Gcb/8QVipYkJ
xPgTJGghdDiTOQXFzZmdnTNnzt567+Z6uGdmx/gK+Cb7Zl+ZDiE36+P7hOC3
BBzMLpI0KYg/x7kH/IP7aTSLwCfgWodmt+hton5n6qH+Cvdj8H/AK/RkmNOu
mL0Af4C7BO4E6Znhvqge6rqolR3Mueyh38g931GH4BtJHDF55h34LszIvbbA
dwfKt65KTy/O5H1wzZFznMt75uH5EfuWgR9QlyVpW8j/FJXzGfUtavbMOXrR
Z1OTx7qmvrLvwrnR33aelGGR1Nt1TZ5Lz76+8/R89ffnfxh4fvqcJr3pmfvl
vtc/qCNAdw==
          "]], PolygonBox[CompressedData["
1:eJwlkLtKQ2EQhAfjkXM0eJTzi2BnY+OlUJ9ASCpjkT6F0To2Fvb2Kj6AT+I1
XjpBUMQnsAuoRWKn37DFwP7/zszO7mL3oN0bk7QAxsHFlLRUSGUu3VTScEZ6
gVDxfuD9CBJ1H/J9XTqZlAr4OXhN0hro0FdNWqFulNIf+mdwB3+dv136e+CH
9yn69yz8mmVorD3CrzEnjZj/kUUGZxnNSucTkdFZncFaz1xFe4zHYRGcX7h9
8u4Xkfmpihnm2/OM2fNoWvSG+H/idQVnOo+dvNsO/KwWHHO3QC+PGZ61XcZu
Xf426C2nuJV3HuD3luI2zuAsmyl2t+cX/dsqbm2PS+rvenj5Rr6V/9xzpmvq
f3OlOg8=
          "]]}]}, 
      {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
       GraphicsGroupBox[{
         PolygonBox[{{732, 243, 239}, {3302, 1225, 5143}, {243, 732, 235}, {
          1223, 774, 732}, {3312, 1230, 5172}, {732, 774, 235}, {5170, 774, 
          3313}, {247, 1495, 239}, {3265, 1217, 3909}, {1217, 732, 239}, {
          5060, 1495, 4342}, {3309, 2139, 5163}, {5143, 1225, 3918}, {2704, 
          229, 3910}, {3314, 774, 5170}, {5171, 1223, 3916}, {774, 1230, 
          235}, {1217, 1223, 732}, {239, 243, 15}, {247, 239, 15}, {1495, 247,
           229}, {3910, 229, 2703}, {1230, 1225, 235}, {2139, 1217, 239}, {
          4342, 1495, 4343}}], 
         PolygonBox[{{3313, 774, 1223, 5171}, {5172, 1230, 774, 3314}, {3918, 
          1225, 1230, 3312}, {3909, 1217, 2139, 3309}, {5059, 239, 1495, 
          5060}, {3916, 1223, 1217, 3265}, {5163, 2139, 239, 5059}, {4343, 
          1495, 229, 2704}}]}]}}, {{}, 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2703, 3910, 2704, 4343, 4342, 5060, 5059, 5163, 3309, 3909, 
          3265, 3916, 5171, 3313, 5170, 3314, 5172, 3312, 3918, 5143, 3302}]},
        
        "0.912`"],
       Annotation[#, 0.912, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2508, 5186, 3971, 4600, 4599, 2974, 5055, 5056, 5052, 5054, 
          5053, 2702, 5331, 5332, 5058, 5062, 5061, 3267, 5165, 5166, 5164, 
          5445, 5444}]},
        "0.864`"],
       Annotation[#, 0.864, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2967, 3720, 3715, 3964, 3963, 4601, 2971, 3721, 4341, 3725, 
          2976, 5057, 3972, 3973, 3431, 4012, 4011}]},
        "0.8160000000000001`"],
       Annotation[#, 0.8160000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3008, 3322, 3009, 3737, 2710, 4603, 2977, 4005, 2975, 4602, 
          3266, 4597, 2969, 3965, 2970, 4598, 2962, 4596, 2968, 3955, 3962}]},
        
        "0.768`"],
       Annotation[#, 0.768, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3714, 3710, 2506, 5185, 3956, 5130, 5128, 2964, 5138, 5139, 
          3967, 3969, 2507, 3723, 2516, 5198, 4007, 4641, 4639, 2712, 3739, 
          3320, 3738, 3321, 3736, 3735}]},
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3953, 3948, 2961, 4595, 2957, 5126, 3299, 3958, 3298, 3717, 
          5129, 2963, 5140, 3301, 3966, 3968, 3970, 3722, 5197, 5196, 4006, 
          3005, 4640, 2711, 3740, 3010, 3323, 4013, 4014, 3455, 4041, 4040}]},
        
        "0.672`"],
       Annotation[#, 0.672, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2505, 3954, 3947, 4594, 4593, 2956, 5125, 5127, 3957, 5124, 
          5123, 3716, 5136, 5137, 4000, 5142, 5141, 2972, 4637, 4638, 4008, 
          4636, 4635, 3432, 4644, 4645, 4033, 3011, 4646, 2728, 3763, 3035, 
          3330, 3034}]},
        "0.624`"],
       Annotation[#, 0.624, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2955, 3709, 3705, 5184, 5183, 3949, 3294, 5119, 2958, 5133, 
          3300, 3959, 3960, 3961, 3718, 5195, 5194, 4001, 3002, 4632, 2973, 
          4642, 4643, 4009, 4010, 2517, 3453, 2525, 5204, 4034, 4680, 4678, 
          2730, 3764, 3765, 3332, 4043, 2630, 3762}]},
        "0.5760000000000001`"],
       Annotation[#, 0.5760000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2503, 3946, 3940, 4592, 4591, 2951, 5117, 5118, 3950, 5116, 
          5115, 3711, 5131, 5132, 3995, 5135, 5134, 2965, 4631, 3001, 4002, 
          3000, 4630, 3724, 3732, 3006, 3450, 3007, 3734, 2726, 4676, 3031, 
          4036, 3030, 3457, 4679, 2729, 3766, 3036, 3331, 4042, 4044, 3469, 
          4075, 4074}]},
        "0.528`"],
       Annotation[#, 0.528, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2950, 3704, 3701, 5182, 5181, 3941, 3292, 5109, 2952, 5121, 
          3296, 3951, 3952, 2504, 3712, 2513, 5193, 3996, 4625, 4624, 2966, 
          4633, 4634, 4003, 4004, 2515, 3446, 2524, 4028, 3452, 3759, 2724, 
          3733, 2725, 4675, 4677, 4035, 4674, 4673, 3456, 4685, 4686, 4069, 
          4688, 4687, 2742, 3780, 3060, 3338, 3059}]},
        "0.48`"],
       Annotation[#, 0.48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2502, 3939, 3933, 4590, 4589, 2947, 5107, 5108, 3942, 5106, 
          5105, 3706, 5120, 3295, 3990, 3297, 5122, 2959, 4623, 2997, 3997, 
          2996, 4622, 3719, 3729, 3003, 3444, 3004, 3731, 2722, 4671, 3447, 
          4027, 3451, 3027, 3758, 2727, 4683, 3032, 4037, 4038, 4039, 3466, 
          2532, 5214, 4070, 4719, 4718, 2743, 3781, 3782, 3340, 4077, 2634, 
          3779}]},
        "0.432`"],
       Annotation[#, 0.432, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2946, 3700, 3698, 5180, 5179, 3934, 3291, 5104, 2948, 5112, 
          3293, 3943, 3944, 3945, 3707, 2511, 5192, 3991, 4621, 4620, 2960, 
          4627, 4628, 3998, 3999, 2514, 3442, 2523, 4026, 3445, 2720, 3730, 
          2721, 4670, 4672, 4029, 4669, 4668, 3454, 4681, 4682, 4064, 3033, 
          4684, 2740, 3774, 3057, 3335, 3056, 3773, 3471, 4721, 3472, 3061, 
          3339, 4076, 4078, 3490, 4097, 4096}]},
        "0.384`"],
       Annotation[#, 0.384, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2501, 3932, 3928, 4587, 4586, 2942, 5102, 5103, 3935, 5101, 
          5100, 3702, 5110, 5111, 3988, 5114, 5113, 2953, 4619, 2993, 3992, 
          2992, 4618, 3713, 4626, 2998, 4021, 2999, 4629, 2718, 3753, 3024, 
          3329, 3023, 3449, 2723, 5158, 3306, 4030, 4031, 4032, 3760, 5213, 
          5212, 4065, 4713, 4712, 2741, 3775, 3776, 3337, 4072, 2633, 3772, 
          3470, 4720, 4722, 4091, 4724, 4723, 2762, 3794, 3083, 3344, 3082}]},
        
        "0.336`"],
       Annotation[#, 0.336, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2941, 3697, 3694, 5178, 5177, 3929, 3289, 5094, 2943, 4588, 
          2949, 3936, 3937, 3938, 3429, 5191, 5190, 3989, 2989, 4616, 2954, 
          5146, 3303, 3993, 3994, 2512, 3727, 2521, 5203, 4022, 4667, 4666, 
          2719, 3756, 3327, 3754, 3328, 3752, 3751, 3448, 5156, 5157, 4058, 
          5160, 5159, 3028, 4711, 3053, 4066, 3052, 4710, 3467, 3468, 3058, 
          3336, 4071, 4073, 3488, 5224, 5223, 4092, 4751, 4750, 2763, 3797, 
          3798, 3345, 2638, 3793}]},
        "0.28800000000000003`"],
       Annotation[#, 0.28800000000000003`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVz7suhFEUhuFPHCaYMRMUhMZdjHtQaSQznUwhcSqmkIhWSBANhYJGqaNQ
CIlDISESRKUzGv89SDyKN+9ea39rZe+p+dXZla4kM1geShZw35/UR5O5atIZ
Sb6wPpj8cIGGfhMPcm35F95XtyrJwUCypnfIfcNJCd3oRQ823I3ZPY4LM5M8
gXP7p90/86X+E9fVbTvPzLyqN53feJu30DTXwKd8od+S/+BFXkJH//v/D953
JF/wMZ/gzs5bPHrnruwefmVL5WTH+VTm3X1ZfeVc4Ru+Rq2WVPEHVpwuHg==

          "]]},
        "0.24`"],
       Annotation[#, 0.24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzjkvhGEUhuFHoRhrLIV2/AfxO4xEbUkUEkapVGk0o9WoNAQZS2KUCkEt
iFhmEmImEgoKFS7Fnfs7zznnPV9xulxaaEsyjtNCMjqYTPQmrb6kiaXOpD6Q
NPCAJzyi3JO8chOr5u+6kjffy+bb+pNtrsi3OOrZ7qTAu+qqfI8XZWWU3BzD
ofxcPmLugIuylneP5bX/G/5v090GX6tX7FY7kh3ZPk/bm8G93hRPoqo3x+/e
+5R/8Lz6zPy6/W/ZBre7c2n2Ql7RX8OP3i/e3Dsy88U1vjJ3wrd8g7qdZ37B
kHzYW38BKTwc
          "]]},
        "0.192`"],
       Annotation[#, 0.192, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNzjlLg1EQheHRykQT18YqLr9AC/9BehEttBQULNQ0wcLKwoBg4QJ2Fi6g
RSoDVvYqoggG4oIRN76AbergUxzeOTNn5t7h+dWplbaImKXvbMR0OmIwE9FQ
J/TJf2GuK+JKP90TcYlnfRF1s0ezlFlFrwMf+CP1Dd5SVp2hO/W1/Ka9EjW7
IxYHvJOKODD/4Ov0Tn+dEQsyFfkts4Sv6TdwTv8eR+yOUlV/CHO0441jyttr
+cup+oQO+TF743QhPyn77N1lt/f5PdqlsrvtMhvY6o04x239vHzBnXX+t9+u
2yX9Gv7wS2av+MS/YBXfsCifuLOGM/IT7vwDTPw7wA==
          "]]},
        "0.14400000000000002`"],
       Annotation[#, 0.14400000000000002`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNz70vg2EUhvFTg8RnfY4kwuhrwWjgLxBLBwOLpIQIo43EpAumdkSYkJgY
LBaCNhJtJbWIVMxiIBJ+w5XrOec5537et2dueWopERGz6GqJ6Ea+KaKAvsaI
O+7lanPElfN+W8QBGswd8SFe6u24r/C5mTp3n3URZ84/yYhvJJ1r5eQ4iw17
CfWXuxreVF/bv5BziT0zu3iXs8Ov/Gy2jI+GiBnzD5ziN37ST3XINXsiZ0z/
Vv9R/4ZH1SvuBngQ/RjGEHLmM97M8qKZUzsl76Wd7zmj3saxnL/WiHX+5UPe
0p/w7iTSMhZQ9D+Vdt/E450R83oldV5d5AKXedV+Vc4aT8sZkfEP0rs/fA==

          "]]},
        "0.096`"],
       Annotation[#, 0.096, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzrsrxXEcxvGPlHI5bmEirIyUu5XNZVJEGUSJMiiTMjn+Aikml0EuG6t7
ylEog+UMpjMdIVLEy/Du+X6e5/N5fr/68dnBmZyImMRJfkRPZcRtUcRcYUSH
dyda0Y42TBRH3Mm7vO9pN523+14RsUXf6CadtrdAf8oiduhySUQSK5hKRDz6
Vp/dA3NjeUQD1gp45m+9P9jQsY4Z+03ySz0p+RVtNu/ZX5IN6XngP/OH+If8
fvMA8uS95iM92xiWjyArG6OjOP3voeGbi/RXz6q7C37SnMv/sP+JjP/elb3S
fXqAlN4bPNlP0xr7VfxqekzT/F09deai0ogEinEt+9JT7X3r/eE2azdDX+iZ
m3PUylvc/gFA70Fm
          "]]},
        "0.048`"],
       Annotation[#, 0.048, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzbsrBQAUBvBDkjd5pIjcDFyzxeZVJiXi7sqkyB+gEHmUwSSTYqKbLGLn
Lrg2pW7JTaKkUFJK+RlO3+uc7yQmZ0dnCiJiyvzjbV1EtiLisTBiqywiBzfh
FZwrj3ivj0g1RNTa/cD3eN+yffhJt/M7hBf0tcIdt0s1EZ28EXeDdBKfrozo
pftMi7sXP1thxt1ulR/4TXVEnh63f+RuRc8EfiIbolP4sp5+HQMmyX/V0wWf
3J3pmcLf9fzS8/bP3a3rWcBPZcP0Ir6tZxWumWJ5kZ4N/E6elpXwjmETP6c3
x3+AedPIH6Pv8VP8wN2haXSTsJ/G3+SXsmZeFnbzv+x/8DPyHrrtf9/8lEY8
2ymU/QG/1j1h
          "]]},
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0D1I1XEUxvETZGKZlnXRmyHplhK9DBFCbUFOda8VboG0FUVjCoEEDS3p
VmiQGdjb1HTbKsKGhnIJKq+WLzdJvZVv2U2iz3/48pzzPOec/49/Y+fl7KUN
EZHDUmXEb2RTEW9pe3XESqL6VbqMAzsjinQ//UEP0hH6d1tECWt4rX+zI+I2
zW2PyGwxa+4ULdI2WY+sV3aMt8A7Sudpk+yK7KqsmTfH20u/0/WaiHOytPfU
Yxf2bY2o9M60mXV1j7nH3vAIw6jgH3ermz+g78cdLG6OOMy/yO/T9+IWdvPq
sVARcdJMjZtVvtnmW/O8B/pVO98wixnkzBXouG9lzE3QMnN5ekI/bm9Mnsdn
TCSzifK/0kl8wTSmkppf5g2bsBFP3C+nZ2UrSe5uh7tn1E9l1707499kcRrt
uFcVMYhJs+/8n/cYRZ93zbh/3m61my/s37D/knbbK5nvon/oc/sFek3/j/6y
v4iC/Yfu/KS1btThphsf3EirL7hdrk/7b3ftfuSPuZVHyl5W/0n9TD0ov4+U
+QbzQ+o5+Yisy506/iH+K36Rv2Zvj6wRy+oljKpL9Ii5aXUrnaVNdgu0hTbj
PyIcd+s=
          "]]},
        RowBox[{"-", "0.048`"}]],
       Annotation[#, -0.048, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0DtI1XEYxvHXDmTeNUujUGgwCFqrwUmMzMtQbS1ZOjWoNJgKjUJTCdZ0
lGrRWlrTrl6wmzVEGE6Kig6CZFJ46Zwjfc7w5Xnf53l/7+//+59s67ramRMR
I2gujDhTGrF4OGIBuQURqeKIg3StKOK0LCc/Ykm9jHPmF+lZumPuq3qT/ka1
ugpb6g1nJu2bQoUdfUciZmTr/Ke8E86X85+oH+OFbJhekY+bHVLfl8/rj5fZ
YT6hr6RJ2U/+J/fM0WfOHpBt5nmTehRp33/XXCr7HvsGeX36FvMv9b3qe85M
6Ivt3zXXzevBHbzn98vf0SJ5uzOF9K0+n76hBbSNn0df6w/RV3SXt4cdbNvb
zLupvoHWrM/7R7/x92mpN6VpCc3Qy/xf3lJlXzUGfcdDPEKnPHE0osbsNdqh
/2M+KftLz5uvlX30hovqBjyXNdJLWOJn/It9XDeX0h+zpxLt2beix1wvpp2b
wS1eBR7wBvCd9wO3eaey/5M3hhXeKprsasGX8ojPmMUHd+3J0sigriSiHhP8
BjpJL9AN+h+kp2aS
          "]]},
        RowBox[{"-", "0.096`"}]],
       Annotation[#, -0.096, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0btLFmAUx/GjvoFpF99b6JsQEZqQmaaDuuiW2GWwy+AkNtWgQg7RWIsQ
CqWp/QkK6iaaUaKDNZi3ORwaolcaHAQbND8OP77n/M75Pc8Dz9Xe/q6+gogY
p9KSiMPzEUVYVxZxk+6di9hNRRSXRuTN7uivYQceX4hI8P9hEe7ya2RC/qc6
p66gK+pG+99wjfL296hSfZn+qvMyX91zy15G5mUmoikZ8Zs/om9U36bDsxEr
Mvt4hp+gcplp3hRNOuMjTdA4vTXfccYl2Yy9MV4WP+A2f8h8C7Pmz92ZwU19
Cjcwjc/4SfyhL8N1HJVPOec9Jk/f7O40FWZR/1+mQB20zD/w3gFeP1WbJ/g5
/px8jX4Gr+MsPjE7cMcfu83ua6VuXgt+N9+TS5g3eHs9PZCr4vXw3si8pqd2
c/5k3nyBFmmY34Y99o+cc8N8VV+Lr+y/4L/DNv0Wvx3H9HfTEZ20qP5Ev8w+
n/retISDZl3+8L7+IX5xzmN8RE0XI04AkhFMXA==
          "]]},
        RowBox[{"-", "0.14400000000000002`"}]],
       Annotation[#, -0.14400000000000002`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0T1I1AEYx/HnhkO77MVMHBry8rq8o9IGhzukQUhIqOygoJYgrgYHpbOX
xd3FqYZwdD4CtSEyFBpCoTGyTlq6q0hwCjqJSPvc8OX3vPye5/m/pO9OlSYT
ETGLakfEzcMR9w5GjByJKNNHXRGP8b4zYuF4xNVDEVeQ1S/pF/nn1TePRnzE
BzzjfYqeVMQECvwVuy/qXUcJ3eb2jrnFdx+v1E7YVxZf4/2qN07r9IVeFSn9
Mf0Z9/4eiLhtd1t3RDvW+Yb5N2hT/SXNyzvNPeCv4IZ6kjenvqi/jCXU1U/a
26C9dJr3IU6J+5DGaWTQdPcM7UcWeeSwq36Onsecm9/sGhA/seet9/8ur3nn
H3TFzTd4jbOeZYjvp/pzc6utuplb8jXxO7M75gb5NsUXaI1+xr6bfWa+iMO3
+cWXoFvmRvk+0Uu0oZ9U39e/LM/I79j/T77dmvUvE/jd+rf6f+iAvbu0SAv4
D5CxSyc=
          "]]},
        RowBox[{"-", "0.192`"}]],
       Annotation[#, -0.192, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVkTsvQ3EYxh8dJO05bSmKUYJKqieVCOJ06G3CJG5JEwkxk0hqkJQmPkOl
/QC2jmgHJhMjrUuYMIqEwS2lfmf45b08z/P+e+lb3Zhdb5GUhwmPtAevbdIL
XLRL52Cx24ZQlzQEmx1SyZRiPsmGGeYivhLUyCUMqUCfxTOAFoJBmPRKvX4p
gh4kl8KbhjVuW2gr+ONOHpLQZPcUkJ5hmnsmuTJ7g+rjc/gh1yntQMMtZbjj
YWeAG7xgwid7m/wXNUbdxf+L/5L7VxDm3QB3s+y3YAHfIW+G8Q5DAe2IeY5b
i2jH9FH2I7CPVmGeR1tCq9KfcbOVOcLdE2aLWmdXgz/ejZNLQJFsg0ySPs+7
N47u/P78Nk1qnew19ONLcSONz8V3P2C+ZX9KZhnfHf0j2XvqA4yiT+F/Z/cG
48xj8EHfTd7Ff9BD/cb7AzZaBv8/CvVFrg==
          "]]},
        RowBox[{"-", "0.24`"}]],
       Annotation[#, -0.24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0MsqhWEUgOFFyfmwt20zYOBcFCMztrOpYqSItjJRDCgugJkxRUjKVbgC
p+1Uwi1g6pR4DN7WWu+31vq//2vMLk8s5UXEKlIlEYmKiDKxryqiF9NlEd/l
EV8orIyYUnfKO1CkTpdGvCcjPtCjfysVkU3YxZ+o5+SzKLbzzUw714ZWjNj1
zD3h3vyMnlPzd/Jj5z/qYbND+m65Gxzx33w/P8hfczkc8l98hh/gr7hL7POf
///D9/Fn3LS6yTf71efqjHghvnAFzjbdYQOJmogqtPE1YhpJpFCN8FYV+sd8
YxRRHfFrT7f+fPm8vXliVqzV2+VNWtSr6maxwY56LNpRh2133MGDXY94wq57
ZMxOmm333uN2r5ldxwr2/u9uZsH5q/5reQ4Hzv4AjAw63w==
          "]]},
        RowBox[{"-", "0.28800000000000003`"}]],
       Annotation[#, -0.28800000000000003`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0Lsvw2EYxfGncWmVXrQkjCYkEmKSIBIGBrdSFRUDE4tuDHYSRptBRKz+
Af4GZv+AayLiEpPBp8M3533OOb/nfduerdrSbiIialjIRxSyEb2tEa25iI22
iJw5i2I6Ik3TdERvIBNRlf/QbzToV8z9zn1oMnfa81uIWOFvtkecdER8yIr8
P7sK9N18zF+X581Xdled15ByV4XeylfppWyFlpGULdIbWYleyBboPJplR/w5
56yd57IMnTUf8ofNJW969LZe97/SNzzhBc9IeF/OnhndaTQW/UYM6adoC5qQ
RDO69Lv1y7rL2LO/jz+qP4ZT91b4+/X/iD/pPQ/mKXpWfzdvDhP27PC3Me58
pr/o+wO7B3Gne48P+Se+cG33P00fMaY=
          "]]},
        RowBox[{"-", "0.336`"}]],
       Annotation[#, -0.336, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0DlKg1EUxfHrgJrBjIJoZyEIBhwCWglip4JgEkkKp6SyimDrUFjpJgQ3
ICIuwC047MIpTr2/FH/Od8877953v4nWYaXdExEHaKcjFocjFjCajZhKRRRo
EblMxEYuIkUn+QleEgn1EArJiAE6iIY+/bTeVZmOfn+FiJbMw0jEr+97vXbz
ETv4Vv/gCx3cOcubse2spscn7wO3/Cy/wa/y33lvuOFXeRW8qpvmXJpzgbKz
imyf9/RiXb2G1e4uRTtgzvuyNIc0MhjGmPy4Xg3ZOkq8aSzJz9MyZrr3MYuS
/L7cHrZwbu6K7JEeLXUTyzI1O0z5L5vOTt07wzGu5E/ooz2e0JF/oc+45v8D
xrYuwA==
          "]]},
        RowBox[{"-", "0.384`"}]],
       Annotation[#, -0.384, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNzz8vQ3EUxvFjYECrV3sNWv0TjSBpCZpY8QakiMUkqhSt1CSx2SXMLHZE
xMqr8H58hm+e3znPuc85t3Y8aPdHIqKD+njEYjYipbu5iM1MxGAyoqCXR24q
IkFLfwOp98JERIbXM1fOR1zQGq3rj/Hn6Sj/qRBxk/DU37KrdKh+1E/sG3j/
el/TL36fXiHHO6c/vB795JV9e+b9oNelc+oP/RKdtrvjhoSe0HV3rmFGfarO
0xQFlNxVkj9Li8i6N4MVOQ1+E8uopHbi0mwRDbNNVM1WsCN/39wB2ri3Z49u
mdnGi/pW/UyX5NzJWEXPzYf8rn0tOUdyXs29m/vzX2/0H+3oJPE=
          "]]},
        RowBox[{"-", "0.432`"}]],
       Annotation[#, -0.432, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzskuA2AUxfFrSylRUUPnIm1ISIyx1K2gK5WwkNCK1hDDws6wZ2HPA3gC
ESHivfws/rn3nnPu/b7C/mn9pCsi9rDSHfGA6aGIGbwMRrwlIhp9Edu4Nb+a
b9R73KHeG1FJRlRRk1nDlBsXKLlRxobcFjZR64lYUpfR6I94TkVkZDvIyxYw
z1vEAmblk27PqRm3d+xkZbP6HJr+s057dOcJB7xhe8cDEW2889Lmb94hb0Tf
snPOy7n5wR+ljeGIfkkv0j/p47Qfe017Gf0V7xpfvJz5l9f6/7c+4S8p/2y7
kdd31LJaRElmQp3EGT0tt+qNinnXrT/qsCUv
          "]]},
        RowBox[{"-", "0.48`"}]],
       Annotation[#, -0.48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwN0MsrxGEYxfFj6y6XDcWMpFihMCg2dlaKXDeyHhsLYgyaIaxdimLF1l4S
8X/5LE7f9zznvE+/31vY2VsuNyRZoWpzstCSzFNfWzLXlPTiiflwa7LVngxi
ybzHfBoL/ENXctORTPLfOtfOV1RsTC7wV36JX7I61qggO8Mf2Tl+yk6xSgOy
e/MT5wk7P2TjWOHvzJf4Q99U7E5mO5M//lh2RCW+7H4/3epuyg50Z8wX7VjD
Or+KNRyyY1/3SfeRdvUvzNflK/qn+MxXcVR3hCr6Y7Th3zdpyltM0rZ3e9V7
oxd6d+8fhjUpvw==
          "]]},
        RowBox[{"-", "0.528`"}]],
       Annotation[#, -0.528, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzk0rBFAUxvHH1luED2ChRNiY1MQwzAw7hVJiFmwUzVh7KcVkiE/Axsja
tyCUz+Q3i3/PPf97zr1n/LC51ehJsomZ3qQwmEzI+lBSHkiu+5NpbgobI8mZ
u5/RZN35T0+xL3kaTq701bgqfvkF/pG/5CvcGr75At/mL/hVrowvfp6/4ZfU
i2j6p+T/c30l9QqWMWePSXfPej/t8dJN8zXz++7b+vfknayar6CuflDvynt5
0N3TO6fmTnCEV/6W39a/g463G3yHb/HH3n+XH+q37h5jySxadiniH6TfJt4=

          "]]},
        RowBox[{"-", "0.5760000000000001`"}]],
       Annotation[#, -0.5760000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3250, 5028, 3251, 5036, 3422, 5033, 3249, 4205, 4220, 2619, 
          3676, 5001, 5002, 5000, 5004, 5003, 3413, 4998, 4999, 4207, 4208, 
          2610, 3654, 4963, 3212, 4955, 3213, 3398, 2677, 5414, 3211, 4959, 
          4962, 4961, 2887, 3866, 2888, 3632, 5277, 5278, 4509, 4510, 4296, 
          4512, 5319, 4511, 2601, 4514, 4515, 4298, 4518, 5320, 4516, 2602, 
          4519, 4520, 4301, 4524, 5321, 4522, 2603, 4527, 4528, 4303, 4531, 
          5323, 4530, 2604, 3635, 3636, 3870, 3869, 2894, 3638, 4197}]},
        RowBox[{"-", "0.624`"}]],
       Annotation[#, -0.624, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2620, 2694, 5424, 5425, 5032, 5035, 5034, 2921, 5005, 5006, 
          4209, 5283, 2611, 2686, 3883, 3884, 3655, 2902, 3887, 3414, 5007, 
          5008, 4210, 4211, 2612, 3656, 4966, 3214, 4960, 3215, 3399, 2678, 
          4964, 4965, 4513, 2889, 4315, 4967, 4968, 3216, 3633, 2890, 3874, 
          3400, 4970, 3217, 4517, 5279, 4521, 2891, 4300, 2892, 4523, 5280, 
          4529, 3220, 4973, 2893, 4320, 4974, 4975, 3221, 3640, 2895, 3876, 
          3402, 3403, 3222}]},
        RowBox[{"-", "0.672`"}]],
       Annotation[#, -0.672, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2615, 3663, 4199, 4198, 3404, 3223, 3641, 3639, 4977, 2681, 
          5326, 4976, 4319, 4533, 4532, 4972, 2680, 5325, 4971, 4317, 4526, 
          4525, 4969, 2679, 3401, 3219, 3634, 3218, 3873, 3660, 2613, 4542, 
          5324, 4543, 4316, 2904, 4541, 5286, 4214, 5011, 5010, 3415, 3889, 
          2903, 3657, 3886, 3885, 2687, 5285, 5284, 4213, 3235, 5009, 2922, 
          5039, 3253, 5037, 3252, 5426, 2695, 4222, 4221}]},
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3255, 5038, 3256, 5041, 3423, 5040, 3254, 4212, 4223, 4224, 
          3677, 3678, 3236, 4216, 5287, 5288, 2688, 3888, 3658, 3659, 3891, 
          3890, 3416, 3417, 3237, 4545, 3238, 5013, 2905, 3875, 2906, 3661, 
          5290, 4547, 2907, 4318, 2908, 4548, 5291, 4550, 2910, 4321, 2911, 
          4551, 5292, 3662, 2913, 3877, 2914, 3664, 4219}]},
        RowBox[{"-", "0.768`"}]],
       Annotation[#, -0.768, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2621, 2696, 3896, 3679, 3680, 3899, 3898, 3424, 5042, 3257, 
          4215, 4225, 3681, 2923, 5014, 3239, 4218, 5289, 2614, 2689, 5012, 
          4544, 4546, 4325, 5015, 5327, 2690, 5016, 5017, 4549, 2909, 4327, 
          5018, 5019, 3240, 4552, 2912, 4329, 5020, 5021, 3241, 3665, 2915, 
          3912, 3418, 3419, 3242}]},
        RowBox[{"-", "0.8160000000000001`"}]],
       Annotation[#, -0.8160000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2622, 2697, 3897, 3682, 3683, 3901, 3900, 3425, 5044, 3258, 
          4217, 5294, 4566, 2924, 4326, 2925, 4567, 5295, 2624, 4570, 4571, 
          4328, 4574, 5328, 4572, 2625, 4575, 4576, 4331, 4579, 5329, 5455, 
          5454, 2626, 5297, 5298, 5067, 5070, 5069, 3271, 5073, 5074, 5072, 
          5300, 5299, 2627}]},
        RowBox[{"-", "0.864`"}]],
       Annotation[#, -0.864, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2623, 2698, 5043, 4568, 4569, 4339, 5045, 5046, 3259, 3684, 
          2926, 3904, 3426, 5048, 5049, 4573, 5296, 4577, 2927, 4330, 2928, 
          4578, 5068, 5071, 5427, 3272, 4351, 5333, 5334, 3913, 4353, 4352, 
          5076, 3276, 3915, 3914, 3922}]},
        RowBox[{"-", "0.912`"}]],
       Annotation[#, -0.912, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3902, 3903, 3685, 3260, 3427, 2699, 5047, 4580, 4581, 4340, 
          5050, 5330, 2700, 5051, 3261, 5075, 3273, 4350, 4354, 4355, 3274, 
          5428, 5429, 5335, 5336, 2706, 3917, 2707, 5338, 5337, 5431, 5430, 
          5446}]},
        RowBox[{"-", "0.96`"}]],
       Annotation[#, -0.96, "Tooltip"]& ], {}, {}}}], 
   {GrayLevel[0], PointSize[Large], 
    PointBox[NCache[{Rational[1, 2], Rational[1, 3]}, {0.5, 
      0.3333333333333333}]]}, {{{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxFxW0w03EcAPCNdZRrjMr9adxE5SlOUlKpuMhDneHk8nRCWk/InXR1WrdJ
nua6nZTnh5R2jGyuMnHsdDnPo1GzMUtj83RndnRZ9cL39+JzH0r8XWqiHg6H
C/7n/wGJypGu+fAz2xN8LFJkmLv39kcrS8paMV84cED8vhwLgyMStB3PsQR4
yuWpTwGWDlftvZydizFgumHroWcYG74SWc1dWa2DjXT0KD8rLmwXsqTsyePB
GYOe3iVrH2FzHkmKx3fCbXKf/qFT3XA3rdwyUi2ENQdPGzfe/gLrbXBMLO36
YA9dXFtoUz/cz3Af7HUYgq2LVBsNS8OwSiuTjruOwnUL7X3EQhFMJL9ZVijG
4Pwb/KQq22/w+lmOIjlLDKe7CXn7eiZgWZMwb4TyHf5NGyu1f/ADdjxnsJXU
LoH9aijXW8ylcAY51mYmSgY7qcONxMHTsJnxiqFwE03oLOUeKJuBb7q3T+4M
lMOci/FVn9fRGpWFyVzxLMwP9dNn+yrgLH9mJW8OTZkKmKhl/oRPHmewMbc5
OMpqaAMvQmv6CuQp9F9wCSEmnWqrhM2k/Bo9IXrHI3qYZ+o8jGuI4cpNF+C0
V9wC0250h2OOIemOCiYFpDk9IaphifOwKFOAbq7wtlXELMLRXA8SeQv9mFlN
l7xbghuV5FJi0DKcU86Mk15CJ1AX7ZpC0PsFgubgCHQu62pvfjw62ePl6q5M
tA1jj79BPXrrxMPd4rfoycXZ0XoOuiiiNfpCC1rnQL3HFKAlI6wKfRH6Q7b2
mmgczfaKta+dQAe+PsI7L0V/uj/wlT6PLnY+xgpRo1PlZWGUZfThoFuyrjU0
AT9WV6RFT/O9aHGbaAGt1sX1D/qFtZFGp0P/BaO4ekM=
       "]]}}, {}, {}}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJxdlnk0lG8fxkkyUgqlLC2WhFJKpRRXZKlkTRtGIUneJFlqqFCS5SfiR6KS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      "]]}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.685110845252075*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "c.)To estimate the coordinates (in Mathematica), right click the picture \
and choose \[OpenCurlyDoubleQuote]Get Coordinates\[CloseCurlyDoubleQuote].\
\[LineSeparator]\[LineSeparator]d.) \n\[OpenCurlyDoubleQuote]the cat moves in \
such a way that for each change in its x direction of 2 units, the change in \
the y direction is \[Dash]1 unit\[CloseCurlyDoubleQuote].\n\nCall ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["u", "\[RightVector]"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"2", ",", 
      RowBox[{"-", "1"}]}], "\[RightAngleBracket]"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". We need a unit vector pointing in this direction:"
}], "Text",
 CellChangeTimes->{{3.685111325834095*^9, 3.685111370336969*^9}, {
  3.685111485560788*^9, 3.685111528256714*^9}, {3.6851116239626102`*^9, 
  3.685111669344891*^9}, {3.6851136744951897`*^9, 3.685113675191765*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   OverscriptBox["u", "\[RightVector]"], "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  OverscriptBox["u", "^"], "=", 
  RowBox[{
   OverscriptBox["u", "\[RightVector]"], "/", 
   RowBox[{"Norm", "[", 
    OverscriptBox["u", "\[RightVector]"], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.685111722754012*^9, 3.685111784298916*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["2", 
    SqrtBox["5"]], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["5"]]}]}], "}"}]], "Output",
 CellChangeTimes->{3.685111785406584*^9}]
}, Open  ]],

Cell[TextData[{
 "\[LineSeparator]\[LineSeparator]\[LineSeparator]\[LineSeparator]Now we\
\[CloseCurlyQuote]re ready to use the expression for the directional \
derivative: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["D", 
     OverscriptBox["u", "^"]], 
    RowBox[{
     RowBox[{
      OverscriptBox["\[Del]", "\[RightVector]"], "T"}], "\[CenterDot]", 
     OverscriptBox["u", "^"]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " if we first calculate the gradient:"
}], "Text",
 CellChangeTimes->{{3.6851118219944353`*^9, 3.685111923320737*^9}, {
  3.685112424217301*^9, 3.6851124247290993`*^9}, {3.685113743189896*^9, 
  3.685113782944689*^9}, {3.685114159814535*^9, 3.685114163756131*^9}, {
  3.685114443009569*^9, 3.685114443402577*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gradT", "=", 
  RowBox[{"{", "   ", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"myT", ",", "x"}], "]"}], ",", " ", 
    RowBox[{"D", "[", 
     RowBox[{"myT", ",", " ", "y"}], "]"}]}], "   ", "}"}]}]], "Input",
 CellChangeTimes->{{3.685111746952113*^9, 3.685111749856195*^9}, {
  3.6851119267849627`*^9, 3.685111959841118*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "x"}], "-", 
    RowBox[{"2", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "x"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6851119606348467`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gradAtCat", "=", 
  RowBox[{"gradT", " ", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1", "/", "2"}]}], ",", "   ", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "/", "3"}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.6851120883327227`*^9, 3.6851120915050383`*^9}, {
  3.6851139329531927`*^9, 3.685113938777264*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "3"], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6851120785931683`*^9, 3.685112092030713*^9}, 
   3.68511395525679*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"gradAtCat", ".", " ", 
     OverscriptBox["u", "^"]}], ",", " ", 
    RowBox[{"N", "[", 
     RowBox[{"gradAtCat", ".", " ", 
      OverscriptBox["u", "^"]}], "]"}]}], "}"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.68511199044694*^9, 3.685112054964161*^9}, {
  3.685113947953539*^9, 3.685113952377274*^9}, {3.6851140637697*^9, 
  3.685114082858567*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    FractionBox[
     SqrtBox["5"], "3"], ",", "0.7453559924999299`"}], "}"}],
  Background->RGBColor[1, 0.9, 0.8]]], "Input",
 CellChangeTimes->{3.685114094425434*^9}],

Cell["\<\


Visualizing these vectors...\
\>", "Text",
 CellChangeTimes->{{3.685114135898027*^9, 3.68511414391047*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myUhat", "=", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "  ", 
      RowBox[{"Arrow", "[", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "2"}], ",", 
           RowBox[{"1", "/", "3"}]}], "}"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "2"}], ",", 
            RowBox[{"1", "/", "3"}]}], "}"}], "+", 
          OverscriptBox["u", "^"]}]}], "}"}], "\[IndentingNewLine]", "]"}]}], 
     "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mygradT", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "  ", 
      RowBox[{"Arrow", "[", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "2"}], ",", 
           RowBox[{"1", "/", "3"}]}], "}"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "2"}], ",", 
            RowBox[{"1", "/", "3"}]}], "}"}], "+", "gradAtCat"}]}], "}"}], 
       "\[IndentingNewLine]", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
  "myCP", ",", " ", "myPoint", ",", " ", "myBound", ",", " ", "myQuad", ",", 
   "myUhat", ",", "mygradT"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.685112212562958*^9, 3.685112364097329*^9}, {
  3.6851138519295797`*^9, 3.68511391346628*^9}, {3.685113991594557*^9, 
  3.685113996018098*^9}}],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJyEfQVYlM/zOGAndmB3dweOLQa2Ynd3t9jdmIgFBiImIiIlndLdF9wdHMcd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    "], {{
      {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1ULtOAgEQnByaeHJyELgPMOETfHTS0dH4CRJa/RA7+AXvG0xAaqKtJso1
YKKFpYkUNIaZzFJsZrM7Ozu7pzd317cJgC6jxqinwJb4w5gcA7/EQQ68ZEBF
Yq0FLBP31zC3wZlPYp4618wXeSviYxvIUutqftkxryKeFa5Ju0xd34SedKUz
PAEW5DyR896x1nlhzkPsLSNXTV41N6b3JLz+N61dBqdHzuwAuMo9V8bey8I8
efyIXdqpeek808Or7jkC5plR9f0f6nG7MItc/Sr+pRt0y6jhmniq77Vmbf9L
f7un/ynzt0Pgr+lQ/s2b+oX9XhB3UYhFdQ==
          "]], 
         PolygonBox[{{3685, 711, 1211, 3903}, {2700, 224, 2311, 5330}, {4355, 
          730, 729, 4354}, {5429, 2316, 730, 5428}, {5051, 2060, 224, 2700}, {
          2706, 241, 2316, 5336}, {4581, 1492, 223, 4580}, {5338, 2319, 241, 
          2707}, {5330, 2311, 1492, 5050}, {3273, 729, 2060, 5075}, {2699, 
          223, 711, 3427}, {5430, 245, 2319, 5431}}]}]}, 
      {RGBColor[0.18832000000000004`, 0.35240000000000005`, 0.57776], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUbtKA1EQnUSN+8hr2d1OUL/BF1bptcsHWPgotEhs/QELtVL8D0EUH71E
CAhGJYrZZEVBBCt/wHM4t7jMzJ0zZ87MzK63m62imS3jjeEVI7NsAj7sGj4C
z+wOgOtY/hVsB3EI/7RglsPvjJsNYfdLZr7DPybCHAVme77ZDp4Hvp+66tqh
csTcgnMb+Rn4I9TexPonB7W8431D2yT+SsD1EDdrZr/4W4HtAT+N3H1Z9eQh
/iyRlgFm6cOvoPYYPfuIB8ifo26jojkPA8X8PwjUM/DFc4K4Dv8t0Yzk5AzU
Qk0ZMJex/ItYtdTDPc2nmm0BtoWZPexqsyqs52q7bqcfkXZJnZzDqBNchUia
qK0B+5JI2zNsBzNPgWcu1Q1YR828A+eiVuapiT2eYnGSO4+U5544H3vzntRF
ndS2WhNvt6wcfe79r647vEbqzR4PsW7MWxO7G2pPvDlvkrk7LqXCLKbC546T
uoZO/2ekXX/BNmrSs1WVxpHT8Q98RWV0
          "]], PolygonBox[CompressedData["
1:eJwtUUsvQ2EQPb1tua/Sm9u7k2DhH3jssJIgNn6ARbFg0dr6AzZ2xE/xbG2l
pIlFPVpxS4XExoo1zuR08SXzzZw558zMeLm6WnEATPDl+LIR0M0DYy5wEwJL
w8AX8y8ELTP+YH1vADjKAD9F4KkEFD2gx3qH8QoxjZxyhz7wS8xzXpwOe++J
8T3l/lhbJP4Tyj2UxGFc2/zPJMABOQqeOI27GcpLyv67GHgk/tURps24xlxA
7w3mLol9ixSb351AmqY9YhjWywVgLQvUyT9P/s0hwM3pX2e9w/4W8Sk9thlv
9Osu+2usVwNxX1GjF2kn9jcPF/QyxRm2PHk0r/u+9DzWT1k/4/Nd5czLLD10
IY05xrdx3yv7m7FmsniUuVYsD+ZlkO8k1s3sdqY5Se3pRLvc5VtIpGnadsP3
SDPbrKZX4SzHsbhs5m/Okom0a7uR3eo6lLbt0G5rO7J+879O/2mkXdhM5+T6
BwU/Wao=
          "]]}]}, 
      {RGBColor[0.21856, 0.36920000000000003`, 0.6060800000000001], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFUssuQ1EU3aWVtrd63ZxrokmTfoakpFMkJOYGGloDWlNDr4EYEp9BaAk1
9IhBi4pHUa96/IA51s46icHJ2nfftdfee52TyhZHC20iksZpx8lFRD7CIndI
toALHSIniKeQ/8R3A/Eq4h7Ey/j36oksAV+AbzYuOqzR2vWASLaTuG9Ebn38
C4oMuCJ56JwGqak9c1a3gtwYhjlGfs9Q6zCGWugfId6ERiJMHZ3zCpwkvuvA
jPvfsxdxEzutRFmvOhNxkbMY6367RL5w1sCfdthzI8S++k85N+g1jz1CYfb+
tvxdw5knI+TNOMyrnuYS1sNHjz48AIe76d0IMBOlv1vQH3LpwyDwGrop5Ksx
5tSjH+hcgrcInWeP++ssc+iVjXNH3fXAkPMETsPj3PceecqvQLNsuOc4/Kn7
vMN3jx6pTj9wx+du2z77673rDCWfcdneYdK+B0V9HxrXgpxb+Yopy9G6vOWo
lzqDzjTrcIaWnVdz6mPa5TvoA1YN38UFsOlxR/VD35DOEUCu4PDe9f5rhv6f
A/8AQLB3gg==
          "]], PolygonBox[CompressedData["
1:eJwtUUsvg1EUnFbbfP1U68vXbkgkXfkBtsRrR0LSvYV6xIL6DV4blsTf8GgJ
3VIkWlRo6x1FYm8v5mQsbjL3zpwzc85NZxczuSCAbp4QTzEGnPBhogUo+MB9
EqjzXiJZI55vBTYD0tQ84JKamSjw6QD75A988SXyh8RTceCU+Jm9s8Q3fJuj
vov6W+KAp94NC0HckwJmo/K8YJZrajocvRl3xXunI0/zno7La4ueOWar+upt
Pc9jOoatpkJu0AU+iFcizES/vaSym8eQqwyWJc37HfU75JuOPOrkyjFxZ+w5
mgBGEsIVngxxnjVh8kvs3/BUY7W2kwXme+N9NaIMlqXA/l+OdmK7eSS/HJHn
gKtMlm2D/Bjnf/GU3ep3Wbvu6q/M07z7mKEY0s5t9/3kt8PSmLbJ+rWIepap
n2wTZzW9rB2m5jeoTHn2f/33s/1+twNHvrC9HfvKYFlspndqHzzNbvP+UD+e
UnbzrCbVw+ptxidq/wALtGRd
          "]], 
         PolygonBox[{{4331, 4330, 2927, 1668, 4576}, {4579, 1669, 2928, 4330, 
          4331}}]}]}, 
      {RGBColor[0.24879999999999997`, 0.386, 0.6344], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUztPVGEQHXFf3F129+a7FBQU/AljeCQILdFAsYVgYHdbhIpAaBQrEzoi
b62NFeFRLFZCMJqwuwIFJEAAQ0yMhkdv4zk5X3EzszNn5jtnZratND4w1mBm
ffge4vuVN6vGzXZDs8EmswKCz2HvkmbxRrM6cjfwY/Br8F8nUAf/B2q3nFki
ZfY5I8wtvgPEZ+OKzz0w24jMWuDvO/W48ZiewOwQdh35D07vvYdtTYnDEXLD
WbMz2Mc5YCPxedZs9g/5vZjZMYS8DYTpgv0CDXX479DnT1I8yGEGGneAncwr
R8wM8Bvwh9BrBHorMfnEfYpUOw18MasYe5TgJ4ErZ6V1KiEtnN+rhPqeh4o9
Qf9yWlz7gT8OhRlF7GmztHMGP1N6i7UHXv+W18qZEEd77/12zGIbHDpy0sC6
R7A1p3l8y0gnOW/DP/I92Zt7IB/iVp12sQK75LTPN4H2RFzdaQ+sJb7stXfh
3bNQt/A7r37Ek9vLtO7jJNQs53lXDeLL3/SpgzXEc368L86LvPnOId79ivoJ
5Jad5sj8JWIfM9rrAuIv0sIQ2x2I/yn8zUi30xsoT57MkTtnwnvgPfFmeDtX
oTj8hZbOnPJF3MNIWvy+h6qt+HreXcHPkPrZ/8LvlrvkPhadboL/Lc6CM1mL
9L+hX/Xv8d3rUP02Y+L9H79hlIo=
          "]], PolygonBox[CompressedData["
1:eJwtkjksRHEQxsfagz14L7sKhUKvljijVBEKhSPsKl2VBA3RiU7ipnYUhN3C
qhCFwq5dhQJxREJIHL3Gb8wWk/fNf76Zb45XnRjrHPWISA3mxVIxkaoSkWtw
EtwcFFn0ifQWi8yBXx2RS/wZv8hISKSWtyzced524O/HLHbFWwux2aDh4lK+
xDrKRH6p9ROAHxa5cEUm4H/hb+M/4Geo5YWfg/+Cn8X34efx3xyLj5PTh/6t
a/X17Q78iOXEcp7A745h1RiAP+VYrx/obYVtJp3tiOHrykUasDT4jKUM0Otq
1LRUYwV85tr8OvOJazmaG8AS8DfgfAdMU7Xz+Deewk7Bu2gm4Xah2RNBI2L6
qllPrVbs3Gs7GqTf7ohx9U1jk4X+n6m3F7Metdc7+ukHp6l/6rGah+gNU2Pa
bz3r7XTnunvtcTNqO/7fNfn3zLMUtd0sFIkMhUxDtbTGjWs31FtqvWW4Wayy
xGbMgOMRy/XzlsI/gJ8X4xzG7MZ6609snfhx2Lg6k87WXlG4NTlt4KZy263W
bASvRS1X763/gvaoMZ05zvx/iXFyZA==
          "]]}]}, 
      {RGBColor[0.28026, 0.4022, 0.65432], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUssrxFEY/TAemd/85jf95h+Q7EVZsFZShFIYzGCpKFmxIAuP2cn7tTXj
kbzyWBHCRtZSymoSf4RzOndx+7577/edc75zb9XweNdYsZk1Y5VgFcrNsqVm
y0VmP4HZIuJuaNYbM+tGQQ/iH2p+sc7QmML+EvHQM8v4ZqURs6a4WV/UbB69
1chT6FsB5j3qdoB1jpj3VHuNdYf9RBn4ytXz7XgHgXGYFE8bsIexX8J5DTAn
A/VdAWczlKYtxMeE6tm3FgpzHzUH2H9WmDVUQkdCfA+IaaeZ2keBX4Z8HX0D
2EeQzwbiI+9QVPNQYy/yPDA/gJlLqm8VM77Bw9NQM6djwqCn9HM6kFcdwK4D
zjnu6uPyldpOi4WRdTiMxGfe4jT0AbM2rrNZzHIM7gv0vWCWo6S8fUKeicpD
vuGgm4Uz0W9qo3fkJzd5bzy9z0koP3hPzdzz/Br3OU+1U8D8wlrAfQo8M+4t
+CYj7o2odyCqmkKgPnpE3UO+cvrNGSMV4jrwNEunLzxq5jl9pOYzaGn3VcO5
G+O6z8T0nzj7K2Zv9cVDn54TOqc3Bad5m38wFO8t+vqdTs7Ev/Pr/uF7Uvkc
fN4LxUuNG6HOeZ92PvPP/gPOlHpt
          "]], PolygonBox[CompressedData["
1:eJwtkskuRGEQhQvdiNvdunO9gL0ViQjxAoQgkdBttiexITaGhWkn5mmHZkcT
w8o8bDyAWAvCQ/hOqhd/UueeqnPOX/+tHBrtGCk0sypOhHOfMhsrNpsrMPtM
mtWWmX2UmnUWmc1QP8GfMjAP3xuYZSvM3uGXomYT9E9yTgp95hiuOeH4De0m
6ppys1zEv4lr55xRL6I3jN4r+jnwAngAPF3ms/I4Qi8TuLcyPNA7g98q3sVo
DqK1HzP7KuEu4D7wbuha8tij7or7XZShmix9gfPyfEZvO3R94R3qdNyznYMz
1C8p19JMP7NtCefUM6S8Sfe+4dsUdUvCs2qfafiLmHMZMpyg/5i/rzx74BvI
FGV+GVxf7jtX3m/utEp/I3gl6vML1Acx59TTTb7BwLMoYyve40l/G+1Iu7qm
P5J/L3F3+feWhrTq8LyMeIb+hL+perVT7Vae8laPetdD373eMws/C/9L7x9n
E+409P5b+Cv4rdA57UT/ku4kb2W4Tfk/p11JYwOuO3D8A14DH8a8Vr+yD8R9
V7pTDv4f0Pxo2g==
          "]]}]}, 
      {RGBColor[0.31782, 0.4154, 0.63224], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1U01PU1EQnZa2FN7j9d08+AH8AF3UhfEnIBWIIdECwdCFxmgUoimwQNiY
uIQSQly4kgIbKCRA2CACxo+EvQnhY6X/AL82ek7OdfEyc+fOnDlz5r7OytPb
T9JmVsbXhO+jM6vmzIYDs9O82S8E3yO+kJj9hF9GvLMgvxSZrbab9cOfaTU7
ySveAGC5TbYeml0itg7/GDirGbPfOL/BeSOj2jX4e052GXgTsfJX4D8Hl1SL
2YGphrWH8Icj5SwB/1lOXMmT9+d55RCLmFXgjeXEj5x6IuWNYJYi/NeI1UL1
Yb/PWWGM54Rz3K76fXBMtyj+JSttWMu+1OwsL56cdzMjfj/8fC9Twmh4fxf9
mpC/CV3HEvWZhIbfms1eAXs2pVpqxPpaVnFquIXaCngUO8weJuo/jtp5+N9R
X4O9H0uvEvbwNhTuXCK9yIsaU3vmE59c/jarb7EgjndR+wJ5c+g7BXvgxH85
1F7pM3alIF7TrcJIA+sE5wb6Gfxtz5d3jNMyzl6cKeX9jUT+DvJ7sZc/4PcA
fR8n0nUC+NcjaUXNRhPt4QI5p7HnHEj7fv/mpmNpNwPbFWk3VwvaIXdJrKFA
e/+AWerY9VdwWILtjrSDa8h/lOhdnMWyfHPUnTtnLfmRB/lsO9mqj79z2j3f
0XyoN1P08/F/4J4qgc59iHe1KYe5R069BnF/JxB/zjEQ6P3dgn/T8yTfekb/
IOv/c10Hxr1AM39y0pwzcmfEYA3zt5z4Uu/FULxuAHPNaVa+Nb4nxnn/D+21
qtg=
          "]], PolygonBox[CompressedData["
1:eJwtk0lrVFEQhatfosb3Ot3v0e0PCOJS0YgE/QeKEyKYOCTYCwUFB4yJIphs
RBcuTMSFC1caDWp3EojDxlkcQN0KIQZc6D9w3Oh3OFk8uHVP3TrnVNXrahzf
dSyJiE187XyjecT4kogPnA9UIrby/WqLmOuI2JBGbCP+TTxPfLce8bqIGFwa
8YX4HvF9vgXOf8jZXvGdsCFy3pDbrEX8WxbRWB4xW444Q80XcJWIP5I7kpr7
M28miAc6I66UwImneTvOm+uJNXVVibn7Tr3dxHvIfQSedJijBbYTDX/BLuPp
HN6OZK4X5EyBPyy79iXwwdye5O0Uel+h91bdWoSfzt0D9eIk+FPwIe6aiTVc
rbmGctXDEc698F0oOedJ4RrCv5F/s+wey28LvJ/zaGov0wxjLf5ukzO16Pda
zR6Fz4CvA39WWIs45qm9irvJdntuwN2fuffv4fyau6Zq/wTfAl9f5toT3K0E
e1A4VzOZLTwTzeYdd0fhP5h5tuIQV2txnm305HHZmqTth+ZBbqvw2+fUa3Lu
XuHZzxFfxOtwakwz3Yy39VVrk59uzhvReAPsJTk9FXuQvmE8DVB/IXd97eD+
zDVVe4y782BnU79N4PyEl5matWoHtFu9neZSj/s4r6lau2ayWv0oe1fkUbt7
p+5ZaQaTnA/n7rU0HsrNIS5pPEH+vsy7JI3Sqh6r1/qH9oK9LexF/4z+nbGa
d0P6tKs9qXdXHDvw/x9nw48s
          "]]}]}, 
      {RGBColor[0.35538000000000003`, 0.42860000000000004`, 0.61016], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVM9LVFEY/dJJ613fNI87/QGuy2jK0KC9P2ZCMMhoJWKaE6kRaS6yTSUu
0rSIaJMxKdbkRKDLp4t+KVbrgpYF7XXVqnM4d/H87tzv1/nO+a7NA2O9o3Vm
NoivHt9l/NnExfwBsz84VzJmW7h/mZgNNJhd8WZPmsyeI+Y97pqPKGYRd6vw
/Ws0Kxw1O4b7XeRNR2at+GYOmt3MmV1DzDZivuXNzkSqXcqiH/KfomY//B/h
t8NmX5BzNfwehh1H/x+HgA/u78jfxf0Uaox5nUdhK6jzFnVuoVcZv4uYoTNG
PnI/I+ZZnc60U5hxJtLMp4B5CPH7jAeePdh3GdVaRq8L+H03EgfERQzLieos
NGlOznsadgi97yBmONgScj/A1xULzyRiOkKP4+BpPODnTL9yqr+F2jdwvo/z
nJcm5Ja6dMTiipydBO6fqP0ANQuodQ/+PvjX4UsRs+bF2WzAXAb+nUbpRw2o
xW3kfs2Jj6JTbcazFrGvZIT/oVf/ESeM1IM1l/KqVwXmMnz1iF/w4o+8kUP6
2Ys9yDF7sH4LMNcQdwL2ohMn5IZ5vxFfRdwjr/O8115wH7g3aSIMl5zuPoX7
zUSW+9XlpBn390VeelG3vYCLmnFXeH4FfzHWzN2xOCW352CrYbe54+SU3G4E
jrk/5KXPaSbqwLfBmckNcfEtERO53w78T+eUyx3kbnI3iK8WeOPs1D8N75H9
uQfEdN5Jy+vk2Ytzcr+WaL9rsI+9dJxAn/VE8Ruwg166TUTKSwMP1JV93sBf
ctKKe9GTlf5tiG/D+S+wnYXtcTq3Z7VznH0Rud1O8xayes/Uei68S/Zjr9fh
7VCTSl5zct85M/eDtdIwP+M5B+sQN/+X7Ad+/gPcD7Qd
          "]], 
         PolygonBox[CompressedData["
1:eJwtk8tvjGEUxo8ZNXTG95l87R9QsXNtSRB/gE5nkiYkJZYNHepSl6R0UTZE
LOiNEtuhwtBuatnpwj36BxDsSOxZWfk9eWbx5jvnPbfnec739gyPHbmQi4hD
nPWca50RHwsRnzjnsogfWyIm1vnuLP4Zznvs+oaIV+WI48WIi9gfOiK+k1sn
/rZg/xv+Kfxh4i16n8S+wt1tYk2GXsbenUYsMfhPPmKIXhPM/0z9GucS+XVy
Jsl/Q/1gErFXcexb3DW6IqZLEe8Knnma/Hv48/T+S78R/EnqW/gn8K9j36D+
KPYiM3cy+yp+NW9O4ta/2f4T4ltTYxCW39ztT8xJ3MSpAt4mGjzOWaMa/gKY
vmy0JivEXoNnhXiefkvClxn7FPl3sXu7I/7R/yuc9mD3MuNX3pzEbSZz7Ut6
NEreiXYzSv9l+u9IrZ002Y7dn5i7NN4Ht/FOay9NDsPtIT2e0a9GTg3/fOZe
4nCf2BT+z4I1GiLe18YjPeaIb0tdLz0G4bsG39gUscqnBZ55chba/avUv8jM
VRyb2DPEH+Ws8Sj+rtS70P9QSay5ZmnmQNEz5Su/Qr9a4lkN7npS/0OqFebp
zJw0W//MCLEDibFqhw/Uq8tait9T7HFy7nR4Z9rdQLteHMW1r9v/jna4TH21
6F2Lw3P4Lpb9FnSntzJbMjbhl3biJHw3iR+j9mAbj/prF7OZY8IwlxmjsOoN
jGXegbDqjeitrJb9/0lzaf8fHimJfQ==
          "]], 
         PolygonBox[{{4320, 4319, 4533, 1642, 2893}, {4974, 1995, 4976, 4319, 
          4320}}]}]}, 
      {RGBColor[0.39294, 0.4418, 0.58808], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVM1LVHEUvc0486Z5M808fq9NUFBEm4I0JYL2Oo19gAshhEqdMQvUKKio
doVRak6gtSgtUqoZjUqX5SJd2MciaNGmRV/QH9C6RedwfovHvXPfvffce859
s71vpGs4YWYVPEk80zmzBwgc2GTWnjebgj+B2N6C2fUNZt2ILTizf4FZA/Z8
0Ww0ZXYBdhl5b5E/j/g3/L6E/NPwe9Nm9xP6PQ17Ki0/0aQ+bxCbjRSfgd0G
rD8Ypg0z/ML7LvgN5JxJa7YrqK2g7zu8qzr17se7y4gfCtWb+DWn2ThjFc9D
5O1HzynM+RG1Q3g/F6n2CezfpPblnj+KwhlGzhjyezaa7dqMXWCPJzXzZEo7
0N+CmS8ivwP4N1LqVUf8Q2w2gP6L6H8ir9pF9Bwqqu41eh/Mqtc1xF40aV/W
MreWEqevUD+IPi8jcVhOCm8Ne6wE8vdlhX0OfXYUxEcJmM9RU0XtM9hPsXhc
ht+R931QtxP5V5FfRmw9lmaPkVP3tZ3Y63egfakF+SDuCm6mMy9u72GXMSfN
xp1uhVxOwp9wqr8D+yUjfanliJPl3TV7fltgP2ekC7WlhtSFWNSNPFCbHqf4
OGoH/R3U4B8J9Z4a8ka4IzmroG49EC+8UfK6lNN9sw/7LUXihzxRh++BtGjL
Cr+E+3kUiR/ydBs1P5FzC3Y+EsZ7xBuRdKf+uwvSdU9B9807n0X8cKicBcSO
huJ/K3JuOuGO+v24P3kkT+SNed2hYvwuOefXjHSZi+W3Yt4B1K+S85x045wN
zxG5asEuZ504uZuTnqteU+7MGyYG+VvzN1Z3ukve8jE/M2+HO3P3p54/asx5
yRO1JN5MLB2agVsOpQPvtN8Jqx3xPqc5Tjp9S8TshV/yPr8z/i+Qh1bY/xIk
qYg=
          "]], PolygonBox[CompressedData["
1:eJwtk89vjGEQx6er7fLu7mvfvPZI4iKhPbQqIuGqXStImpAICdtqtZJ2iShB
XMj60WorqTigLUXtllA90gMOml6Kg6uoxB/g7ODzzezhSeZ5ZuY73+/MPJu7
Sp2DCTPby6nntIVmf9aYfV9r1hyY5bkv8v4padYbm53kLGJ/5oylzUa4r2JX
AbmFPcr5Xbufy5rd5v6LewLw42BtXG92pc5rbMJeiMz6G80u87ZC/AiYE+T+
xd9NbpXzr5bfnzKb3AAH4u8T8xj7Jf73CY+Zi72GYscazHbDv43zAy2d4F3D
Hk27FmmQFmmQlgL+jozZMhwuwaWbGjNwKxPzM+n5hzPOQfjSeBffC2JONXqO
cu+B9yXpb8/x5TPu09sZ4rfCYQU+RfxT+C8E3l9pbie2BEYl4TVvEt8eei9u
oGc7sXPk9JL7DYxp9L8i5ij+D+QsUHuA+3LS+3kArlez3gv1aEA2/uv4yryN
xz4zzUozuhP7zDV7zeQdtYYC781HacJ/mnOR/Afk9GF3hM5XmEeoNxh77Ye8
lbB34n+U8JkfTPmM5e8D/y3457PORT3YQa1mduJ1vWMKez7yWGmaSPtOia9m
OoP+cuD6i+vMWnJmraFzU88L1JtPu3bFVOBzora/x4gfxrcrdK7idyjlM9Ps
voI/BX4h4z5p2I+9LXCfYp4RWwRvqM4xu7CnI5+terSUdQzF9/BWwbeH/PEG
5yPuTYHPUjOtRj5T3aVZ2nti7732/Qn3s1nfBfVHu9ISuk8c8imP0V3193F/
U+ufMFVLf0C7rB430estOe+F+q9dFGfl6o9NkjsbOXdpkHb9AeXrzw/DrTXn
vVeP9RefRv53tOPa9f+WDpyT
          "]], 
         PolygonBox[{{4301, 4300, 2891, 1637, 4520}, {4524, 1638, 2892, 4300, 
          4301}}]}]}, 
      {RGBColor[
       0.43049999999999994`, 0.45499999999999996`, 0.5660000000000001], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVEtIVVEU3X2e93Xfe/UuR4cFDQrSqOgLVpalZgSCVgRhSr5hH51IUA1K
M781sGFp+fw8DcHfSCl1FCFoo6BRBAmNm9SglNZyHWhw2Pueu79rr312NzTW
3N1sZg9wtuCMBWY1eWbT0Ecjs4WY2XLaLAejnzBo2WS2EjdbhT4Bm4uQi/Bp
xv0s5ALOO9x/C+RD+4zTfU/S7IZTnPLtZt8h53H/Ana1+F6CXyf+D+FuGGfS
lKdvq9lj2DQ42d+EfIRY7bgrgl9lQnaHoFdB/wH9OPQZ2KzDfhz2ZTgj0M87
9cO+xtFfWQr+sK/DfRX6no8p7yXo72PqkXgsxoTJh3yzeny/gu+BArMvuGsL
lecXznP024W8vajtGmIupRVzBPaXkasaua5ANofCbi9ifEor/gxsauEzhzgd
iJHF+Qq9zQnbOY/z9W36Js4f06rzDXwLEXMKd7lItfz29bDvXKB/u3aYDQDP
nZDVecKB94XEC7ISuYoT6vkZ4pSmhDPxLklpDvehX3CqeQX5B53yHSyQP+M0
oZajCeHYijjHEsK3A3pRKCwnoJ9IqI4e6PtD+R5BLR1OHOqB3BdqJtlI2C/H
xZmToThD7qzF1Sd7GQ3EY+a4g/paUOfDtPiWDf73QFmC+H/j4hxznHWyOQN5
ymn+jaE4RdyIRYVTjnLIRsRtRfwmyHOeu6WQ63HZbHAmrblVJMT9Xr8XL30/
5BQ5zvpY02AkzpA7/ZHmyzlPRsKcfOlOCoN6p/2b9dxgbNbD+Ks+Hnsg77iP
xOtwKO5UALe+fO1zf774Sv/OpGJQ37BLiavk7C3/FmQgu/yMOKt7MWFEfLgP
3ItiyM9x5WbeYSdOTnhecy7kJ3ed3CD+5Cn5wDnuCRW3DrmmI3GDHOGcOW9i
RLw5P2L0xCkX94ycI/dO4+51pNjkEXed+8O+hiLP/VCz4sy4D3ybOKfbyPs2
0gzJ2asp4frUqXb2xr6o//G71u6EHXnR7WRPv4zHbSApSdzoy/lzjpwdd2gt
EHbkOPnAf2NO8af8u8IeWD//bcwFvuX+HeN79g+Mgd9x
          "]], 
         PolygonBox[CompressedData["
1:eJwtlEtIlWEQhsdLHvOc7Px8tQkKWhRRlFFa0MWy8mgEgtLKSskIgsrcRIts
kV28t6hlaXm8h+BtVZS6ylRyF7SKoKB1m1qU1vM2Z/HBzD8z79ze+bc23Khp
zDazKl4ub3eBWfMas+85ZiWFZk3o03z/m2+2uMFsf6HrrQQVIzcmzVrw/xwz
SyfMuoLZF+SWLLNO5Iq42VewegDftN6sjm+V6I+J78C/OzKryTMbJeYO+sPg
sffAbEWu5z3BdwZ7A/LZdWbVxH+knjT1dBFfTfww9mbiy/EZQZ4lfonaxrFP
Ue8c+gTydOSy+lki/gb9jWO/S45SsOeJeYv9DJjF1L59o9npHK+hE/wh4mew
rxD/nvgi7D/J9wmMPci9fFvOd8wefOfR/6BPoD9Hr6W+V/jXrqU/8F5Enk8+
8t3LTL/lOEYPenvCZ/WDbxeCz0izUo+p4D2qV83gIPUuJ70/zfQQ+rlMvjle
N7ELSa+/CnsJ9hTvJvN+jf188JpUm3ZUzjwGgve3ypvGNhZ5vlXqW6C+toTH
/u8J39Lgs0yjH0d+hn99nud4R+4p/FdijinsFP2+YTaz6JfQJ7H/jjmnruPf
lXCb8NXLseDY4lQRsc0Z/i2CcZhdXgzOFdnFvTp6eJTlmKPBOS1u3yJmW4HP
RLPRjlP4Xom7/y++DeI/nnBZ9fajPwjOdfnIdwcYH/K9x6f02of/cLZz9D6+
m+F8X67nrIp7zapNMYrdVei3pJvaiTwMxqT5jEcivzHZhbEFrDIwB2LOGXF1
LPhuVI961U60G3H+ZeQ3p9sTpyrjzllxVzkGsLdFzoVBMG5Tezpyrooj/ZFz
WFxWvt7Ib0a3o3qn0NuDz1433xH8BnWLQ7xTwW9Ut6od6V+xmIkXRyuC51Ru
9XQCvSnpty9O7GM+R4Pfomo4gnwgsz/9oy7jezJ4LtUrbl9L+q1oB1eR65K+
a82wjPn8AxKHwXM=
          "]]}]}, 
      {RGBColor[0.46806, 0.4682, 0.5439200000000001], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVElPlEEQLdYZZoaZ+fLNePGgaIgGosQFEEQWWYwGYmI8ACIxnlAIeOCg
AWSRYXNJPLgkEAGJSzAuB4MiXDQKQY13SfR/KBff8/XhS1fX9/pV1avqzrvY
c6Y73cxG8GXg6wibpWWapXyzJ75s+tqzze4C+BKYIawnsb+UZjYfMPsbNBuE
rwL4OeyPYS3FmU78/xY3O4H9IvxfE2YDEbNRYG97ZvW54hyH73BYfOtxcZKv
A/viqNlbxNwXQlzwbOLfLPDP8f8n7GFgUuBqRD6jnvzMecP0f9NhysHfhfUH
+FezVA9rqUEOdSi8Hf7HCZ0/C99KXPEP4twG7MuwaxH/N7AvwJkCbltMnEeA
6UNOI/BNeKqBtdQAX+J0+BiXFrTr4b8K/CPwlMMe9JVrYdKsH/4b4LkFnjZf
eTaAYxr7V8h3L3Q4D/8K8JPAPoX9B/YzX/pS5ysh5Ueb+S0EpCnrqQirhu0x
9W3Wac34rJ26DSPWKcT9BL4ypxtrvYd9L7Q7hzr6sP5y2haHpQ91KoiKvxBr
q6/+TiDP7rj4qTHrO50tLQ6FlRf1nvLkn8Q6hq8J9mfg+zz1qsyXbz0ojiFP
cziI9X5CdTSyj24+GJO9WnT92gldvuDsA2CP++oX+0Y+xiVng6/55JzW+fKx
Jwuwl2G/hl0UVS+q4FsLavbINepLk/mI4jA33pUBT7kxxwMhadwKjj1R5dWG
PPOiivswIS5yUtNqX72rxNoMXe9A9w8OR/xNT3euNkOxdiXV06PAD7hYjDmc
pZ6tmO4b+8L+LAH7Dl9vmvJgPruj4iIne9PsC5PCucpc+XvAuRrQeZ6dimjf
7iv+VlD3jDG/BxWXWM4t7ZYctzfVtZQpfUtjsktiypHzxt4XJFULa+Jccj5H
UPuFHJ1fdvd+2c0w/7M31PJ9QHlwVqvdfa/C2h0S946Q5oyzNQ7OmYRynnbz
/j+PNM0f8Ty35t6RGU93kvPAuZh17yH3c7569Ybz4PD9nv6zp8TsT6qGIqzX
I9Kfc5Ef0rvH94/3mzWSazQi7fKTqmM2U7jOuHrcFXfapOsNYq8W3N3fcved
ccci0qXF153hfF5zbxJrZr1N7k5wDv8BasrT+Q==
          "]], 
         PolygonBox[CompressedData["
1:eJwtk8tL1FEUx89kNuXMODP8dFVQGm4UCnpomflIxx4UQg/TTIlqUSnZwkVl
OaPOmNoDWkQLJTXpQVFtwh4a0UIjiPYF9X9Emz5fziwunHse3/s933Nu2dn+
o5dXmVkbZzUnFzV7FzZb4LQHZtmk2eE1ZitrzcqKzMo5X7GP4BsjtrXU7Mw6
sw+AzJOfoX4WoJYCs6aY16j2EPnD5HcVe+4COTVxs4clZsvEM/iGiOfI7yhw
zC1gHwNjOGT2Gz5Z8D8nzC6FnFOO/Bne+0XsJydNPI3v4BrH3ATWF/J7yW/D
N0lshff+EXtNr1Pc56KOPVhodo7cExF/T5gZ8DbEvZ8/cKoj9ibq/EP4nhBv
xdcD9hL1K9T34FuidgCMFrh3x7yfv/ieEruVdO3Ug3qpjrsWylHuZvTJgd9H
fHfENZE2F7hv595HzTBvLcI/RW4q4m9pZh3gfyJ+MeQaZKitxfcoz0e5ndzf
h71H9SqOit3njRT2roi/neVeBn5z4FxHubdgpwLXU/FW7OvoMQ9eM/zrqb/G
PU1sBl8589sWce7y3YRPU+D8Rrjvw65lRvcKvX/NPk39TH5/GsE7n/DZiPMY
sfGoc5Xmp6k/GfiuSvNJYlfAeIH9knOA2I+E9yPf/sB9immelfS3l/ts2DUe
hd900mepHdGunCLnm/nMtbv15M+FvWf1vpH3XhEfoOZBie+Q+GpGvdi5wHfl
OfWPya8q9re1U/orDYHvojAbse8kXWtpXIN240nXSjPYGXGO4ioNd3A/HnNs
zVN/ZSLpu64/qr86UOS78p37NPyqSv2vqKdK7IaYay0+2vX+Ip+lNKmDT0/C
42/JryA2VeJY6lGzGUn63xYf7V57fh6d/N8s/XUlXBvt4FXuzwL/Cx/hPIt9
I6+3NBzErij1WnEWd+247EVquslfH3f99EeGwLub9F3UjGvRYyLqueKg3dgT
+C7qjWW43M7nS99q8v8DQQil3Q==
          "]]}]}, 
      {RGBColor[0.50562, 0.4814, 0.5218400000000001], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVclOVFEQvTLYzevH6355dEQZm0EDauLIoCQYRXEHmkgYggsjQiI4gcaJ
ZsaoUVg4JKKCGnDDxo0oiVPUxD8wKiu/wGjisNJzPHfRqXp169ZwTtXtxKHj
+4+lGGOu45eKX2HcmHnIHseYwXQoacbMwWFDxJgjy4zZGhgzge9T6fIbDBnT
Ab0TZ+/C0qdhn4TPE5z1wv4+pvPtuDsC2yh+D+CzEwmTKYo75hvzDHdfxRSb
OXiXuVnDNeiD8FnA2Qv4FCLWIxx1OcrZlKEcKwLl74A9x+ZbBbkFvzvQE3Hl
pM68g7B/Qx0H0F8j5Dxyzaaof/aX56gX+iziuz1TtVREjRl3dXYY9dwLqZ9+
fH9NVf28z2/amWsUsT7CVg25OyK/bchfDf0L9GLPmBbbfxXsRZ7sJZDtsI8j
Vhn0Nk+YtEKucVTXLk91sJ6pLGFPnWcHM9Qb+/qbKkzZwwXguWe5MRchb+LO
W/BX4Khe6sQpNxAvLxG7CHXWwr8P/glHHI5C3wz7XtiT0CuII/Sr0Ivg8xA+
l6H3IsYni08BfGrgcxL2fYFqbYCsX64ZIn87MtXvADAuRJwZ2AZ88Za02P4I
qR/28hnyQ1gzUZ+q3jk/7I85ORvZyPEUdSyilwo7D5yLdXHxQn7OB8JnxhXn
sxbDSeCziPgTkF04G8bdlfAtwO85Yr4mPnHN4TmcV0bFEbli39wT1jDqajaa
cO+Kr7tvYprhRdt7cVw5e1FPXiAMO6EPBeq3GTFvZGlOOC/Enfjfhi0a1axx
X9krMWXMfl/6pohmnb21IN64r/jkqgb2HtzNRYylkGaGWCxBTqXpLDsq/YTF
gDySG9cT9tzL7yFxQ16m7fd69DQXyMYdIgesr9vW/jOsOEm7P+S3OZDOXZmx
cR4H6p84tHjilvgS21tpmgPWcT9NdbPmjfbtIjYJTz5VEXFALsZc8UcuzqCe
8qjegTLIAstfPmRdRDPViHvDgTAagVztKVcp5JCvveB+NNjZLkHvA4FmadpV
H79DmrnTFn/yTNxZby3wOeqLN75nd7M0032OcCJexI7Y8z0kbuVx7fnauPbv
j90F3uHdUr57rnDJieqcfuy5MlBfdXa/ue//dzukb+pnXXHTBpx+hfWu0s4Z
4f8E56TbFQdZUb3RrG3Y114yF+vJd/QWtMa0m3w3ySHffea95Cs2cyzY/wHW
z/p67VvHN+8f+3veLQ==
          "]], PolygonBox[CompressedData["
1:eJwtlElL1WEUxl/T1O693nv//L1hmVNqodXCIocUjIpsUWAuQi1aBA6R2mBG
k3odoyJ0USZZaUW2cVGbBovAVOgbRMOqTxAFZav6PZy7eOGc9zxnfM77Fpw4
3dC1yjnXyEnhbIs59zPNuU/IW5FPhpwbRh/iZPvOfch07k+6c4+wD3jOtWGP
Y/uc7FxeGD3g3GNsK2AWwS5z/iK/WY3dtzvZXqNvQF9K6PIZJV4e/ovoe4jX
hVzGiYOtR+9FXofPIPlmwLei16N3Jzn3grvDyNc9i6V8N5CHPatV+UaQC/Hp
Qf5KvI3Ueyxq+jf0zej9nsV+xV0ceb1vvUt/B7YavY18R9bgz3ye0/9Kms1s
BtulkNlawB8E/8w32y18ZpGveVaLelbv6kH5fqMvoLejP3E2M80uB30O/Rw+
tzMNI+xL9CzizZHvVyL/tGbjWa3iSFy9j1q+2lTqDTo3wd0Stjr0XrCd+E9C
/Bf6z6f/hajNrh57OfiisM1KGGHXRkzWXRX25rAtjjgSV2fATKXYPDdha8gw
7r5R3yD1XfAsvjjqQX4btV4OkG9H0DgW/jgzLI3ZDmgXHuBf5RsH6q8GfB74
KfoZZ4HrwNxHzqS+iRSbYYj8+zhPsc9xV4rtpme9fWQGk+Cvou9PNU6XiV2Y
6Fc7od0YoZ8x/L9z10j+u5lWqzjLD9jOqNeHxO8DO8OZBf+PuwHw1dTYmWQz
ySJ/dsSwuqvBVhKx2tSzZlWbYbZRYuxG7vBsPtPkO4V8KGq7pTent5cbtrfX
zV1uwHpSb+KzAFtRzN7GPP6FyDnc9RK7lRxl5N8etF1QDnGx0zfbPXzKkceI
N59uOZV7l2+z6CPGRfIP+cater6MvCVm3Gnm/egtAatdMcaJ1cTdj2TjbDRk
nIpbcXCF/o5GLbb+gDvgi2PGrTgYBt8ctV7Vg3qZDlkuxYz79uZUq3Zcu14Z
tFloZ7W72nHp2pEOfM979jb0x+mvO+vZbumPaUcvj9jb1Y5XIDeFjVu9Ob29
krBxJc7EdaVvb1V/UgVycWI/tE/6e/aGjQvVrN0siNms9cbzkf8Da7C9qQ==

          "]]}]}, 
      {RGBColor[0.54318, 0.49460000000000004`, 0.49976], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVVtLVFEUXjnq6MyZM3M6Z6IyHU0LjOxuab50w7dALemmBIGO10y6PKhR
FhU9aFfooaiQ3rpRIAVJURH00ltaED34B/IfRN/Xt6OHzdpn77XX+ta3Lqfq
2FDb8QIzu48Vw7oXN5vHZgyHK5NmHYvM3mbM1mbNjpaa1UHuKDa7DL0B6FyF
vILVCb0HodkrnD3xzBqg86bErA/fnyLp9CTMsli9RWYtsLkC+pdw/hH37bC9
E35Hob85ZdaI/SbIKodhGvpB2qwJ5/Up2d5eLPtlsNMP2evJFm3m4afIF8ab
kfBecpgnsRZg5zzsTuKuB9/5wGyPr/PdkMPA+M3hIa4PJeKEi/w8BldN8D9T
It83Iu2DhO5fwtcEOYStR9CtTggH/Z8MxBG5OoT7HGI8AiwziDF0+hnE2u+J
3yrENwv5y2HeF2q/E7r7sZ/GXXsovsjbEuxHsL7i/CLketjvwrs6947x0w7z
8BPfw/juLJX+Z/jOF8gOa2KoQJwT03Sh2e+YcDc47g/DzlhC7zZAzsXEHXmb
RZyvIZ8ijoOw3xwTJwMJ8VeW+M8v8fF+pEj4+jLydQAx3o6Ld75h7olni4u1
tVQ4K7K6p23mczvuDsHm9Uj7roRywDhW+arlAy6WpWnx0ASe2lLiphZna9Kq
B9bFOLj7ARwPEcuaUJhyWdmYKFKc5I954nvufzg+51wdMca9iKsX+2usu0BY
WYNljpM6+LoQygaxnIsLP/XIzYLLXzn0vmN/GPbaQp1dBLZnnrCQ+3nH979a
ZZ2yzviOOSZvI3Hh4f5dJL0TeHs7Us2XA1d5Ulw+z6gn7sYVT6Wv+hj0NBNY
25wD1Vnluyar3I652BtSqrUhT7XLWtwFeatQdvOuv8htl/NHvyvgv7FYHLDe
WkP1VwtkTVI+i5Grt5GrS+DP+YorD1+rffk9gf3WUPjrIYcCxcu4WXtTheKr
N5Ad2rvnqTdqEUtlWjo5yBcZYamA/wFPPJAP4vjLAc5zoeYe5x97tNnlrjKr
eVcFmYXOWdxFkKcD8XgGcluoWdwAmUqLD/Yxa4FxkRfyyLgi+L1TqL4gjv5A
fA0Eqm/2Eetw0OGs8TVrWAvLQ81WztjKpGqD+WAuvsRkl286Uqr1qVCSs4C2
F+N7lPnylEPGwrfrXI+wVyoSrkd94WJNM5cbnb9ylyvWIuNizxNzPqkZwzlP
rN2wMw6dZbB5PND5YKB3o+4t9anD3HR7whJC3/MVTwQuezzpDQf6Z7AvTmG/
OimdlK9ZwJlQi32Zrx7206px/kfI1/tIvohrudOhLmuO8bDXl4bSoS5nFbGS
iz+Uy+HN
          "]], PolygonBox[CompressedData["
1:eJwtlMlvjHEcxn9qGZ3OvDOvt2NtZ1qKVlSIrfRii6u1oWiIqK5UbYki9u1Q
S0gcrGncJBKkIYiIk4ubLREH/wD/gfg8eebwS7779/luv/q9A5sPVoQQ9vDG
8ZqiEH6NDeH4+BA68iEUq0LYMSaEboy64xDakhBGUyFch98M3YusZYJtnmNf
h/0u6D70h9H181aU9W/QH4Jvhd8J/xJ+emJa9jOgC7kQ7gLkMxjmEGs7eD6B
6yc5z6E/jv8q/Dvw+YD/rCrT/fiPxzYb2fcq9r2ZEI7Gji1MM7Hdh2xTJZiw
WZwN4QQxv2Dbgew+uoa0a1cPGon1ANnXlG1k+zhjLOKH4FdgP4z9NuwvQi/A
Z5h8I9RQRy1HYmNT/nrybwRzD/aDyFrIXyTGFWJd4/UR+0IZz1nsz0PniHGb
WD+Ivwj/ueQYwn89/BHoZvI9Dc6p3DXIBtF/Qz8d/kLGs/oDv4V4g+DprXDP
S8TbkNj3BTk3QTcU6HmlZdIdyhir+jEVLAvx+T7WmIStGpvTKctqIs9Ysz6H
bCq6KbwzKe9AH7lr8G9HfxLZpMQ+8hVmYW8s7596VEh7hpqleqRercP/N/r7
8MsT74DmL30JvpZ3OeUdOUa+7rR1ilGHbkfevXxIz4rouniXUvaRb8LrqnBN
BeimnGfxF5950Gsj05qBZjE58S7JZz9YNybupTAKa0tirKfQt5P7fd67oJw1
iW9As1gJ3oPg7cLnH76j9Hdpzjul3drNTOYzmwOxbd9ODCGPrjPjXg7xYuKV
sLmT8k4UoRemfT+K2UuukcTxXoPnGb5L4e+V56fZLoE/WWHZMuhi5F71ICtF
xiRsirGL/Z2N7EnwjsyBro5MS5ZAr4m8e7oh3VID/EBZPxP6RrVjr8TmJnQt
eD9S22r4A9BNBd+majiVdo2qVTesW24uuDeviPEocY/Va8W4Q7x69G2Vrkm1
HS7/B+/Q30LfFftv007WUn91zv+HMPZnvDPaHcky4F2b9e3pD9yKLp9zLa3I
YuhmZJ1jPIMF0FHOtyhZFnpJ1rb64/TX1Se+fe1wQ5VrVu3CXAf2OG2s+jMH
Ys9cs9ef2wM/LfGt6aa7M/4ThE83PAv/zrR7qxvULbZH7pX6qb+1lPNfJR/V
9h/7Tau2
          "]]}]}, 
      {RGBColor[0.58074, 0.5078, 0.47768000000000005`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VU1sVFUUPs7fm7438+a9uR0XpJY2FiOhNGiFskDTwEpN1JRpbGgp0sCg
NbRNTYyDWBPdgDWRAjWSWBdVVybEMmy6cI+wAYSEnewFLKXd8318l8XknDn3
u9859/y97onpoamMmS3jl8VvLjA7jd/IC2YHymazkFsrZl86s98A/KVk9ivk
Q4BXgb+Vmn1VMLsNOZ03uwt7E+dbYrMlnHeE4IV+DfYMZD84Gzg/Bp69sB3L
CJcAtwB5MpWNeMbQ4Xna4f9v2P4qml3A/8uJ2Z/wdxD4D8H1Xc4sV9H5WwVh
ToHnflZv6Iul74Sch/1fb38V/38Htgf+Z/LCnPLxMc4UfscQ8/fA7gb/LPy9
Cf6uyKw7kq/PYNtdEP4HUz6YK95ZRzx7Cor1U3CehL0TnPeQ4/ezwu0F/z7o
HySKi/4Z26THlxHjBM6a4DgKuQN8K9DPwdfr4LoErn6nHDBHfHtvLK6PgF9o
V8yM/RXEPA7uGt5SbzMb9PXKx7r7Ms4T6GyK9xL5v5HVnW3+bhvu1pz6xEG2
xcIUIRt56c/fScl3HEmU92HIVl7xnDflb9PX9DD4xgP1wZZQ/TQC/P9VnT2C
fFKUTsxj/D8CfQ1yoyidnJuQcwXlnz32eaCeipz0EPJOKsw/kCne1Qd9DPqA
r8UeyOMZ3Wf//ez7vom7D+FvFDwPIP+rquZHQ/lgTohn/x7yc8SZ+CIQ32ZV
b50IxTEWqI6xE6bMvDr1EGeL56w3MQOQq0XpVdRgEfV2kFWn/uuI1BcDHr/q
e4/6dKrcpPBbicQ5Atthb1+vKvfMA3PrUMubiLs9Vu+Sn+/8JNU553Uw1h6o
g+/jVH47I9WHdWIs9L/uYy4j1vOIOYa86vtgPFUeiKGfoVR+mNchvKuFs2HI
J77WrPlaWTlkLl+K5ONEqnP2wRXwdFU0y5x7co/6PP+RU8ys5eWSemXZqeaX
ctoFK4lin0xVb2KXgA0r6m32O+eHs/BGWTVn7Vnrs5i1Ffg7A1nB3SbOEv+O
q4F2JueecZC3F2eLrDFkPa+7fP9BJ/y3Jdkbnv96VjPGufqmpJnajxg2qson
88p++zHQXHO+F73O/cWZOIGcNUra9S86zeS858v4Xf1uov6lb/rtieS7G/hC
LD2A7HPytdNpX3BvRL4vuK/4Xu5Qxn8c/FOp6tNK1L/sMd6hvJiTzjNiZjib
FdmTinI473cj88rZ5EzR1vK5XfJzuj/WXhz0+5R9d9fj2ePkX/Dfp2ffqVh1
+TqvnVwL1Qv8PryTqL5vJ3oHc8IanQ51Z3sN8+p3+pzTPuNeYz24g38KFMNk
Iv5doeLi94b2utOb+L3trGkvb4V8zenuLsin51PvNg==
          "]], 
         PolygonBox[CompressedData["
1:eJwtlMtvVHUUxw9tZ+4wtzP33rkdjeCDBjUobyrgQgyyUxdKO6aNliKNlJdt
CSbGasGFGx9EQxUjRk0UXRmBAi5Y+Fj62BiRxJ3+AaKNlD2fL18Wv+Sc3znn
e96nf3x6cKorIiZ5PbyHGhFjSyL0uRk6aUb80h1xHOFIb8S3ecSFSsSj1Yj+
NGKav4+RPYLOw+ivRf9v6MPoLK9HnEf/PPQ69Av062XEywm66GxE/3HkL3T5
L0XWQecqsq/BXJVF3AHeFfhpMJaBd3tmf7/xtwrd9anlc/w1kA0Sz7Ng/cRf
N7Y5mDPwe/HRCz0Oxvvkeb0W8WNfxN3YbyW2efDnieVO+M3w5+DP5q6BavEB
+AX4Q+CPgvcc72or4uncuX8FZhvsEh+zyI7xJtAdyR37DBjD0BvQeR3+KWxm
oQ8Xrs8i8fxAPFfgj+H/OvZnsG+hM1FxD6rk01+angTvEPIaf792W0e6OxvG
/hP7o+h+URrrOD0dbTgn5bYFH3eRa545N9WzBGuY92WXYzyI7iTxnAjHOAXd
B96n4Rzb0FPEcOpW/7eCfw94R5Z4BlZA/47N0ar9L4DXwOaVxD1TbzdhM4Js
Ap8D0P9S012J+3EO/T28mYpnYjv6R8jxUvhvHNneXtuqZ63SM6fZ247+i9B9
TeemmdGsNpqunWb8fvL/nppfqznHA8Q6VLg+78EPQveg/zP2b2M/jP2DpXv5
ITGug17PexX+I/iN0HPgfVezTQXb1fydTBzPNvLbUFr3L/g1yAfgTyXGENba
0tiqj2b7s173QzWcLT3zyuck8bSo7wA16FQ885r90cK7NgbfgR8rvK9z5LNL
s1V6NoT5GvSWhnun+mi30qbnXfW5L/WOale1Q1npHJSLYt5UusbiO0vZpXbE
N/hcTDzDmuUR3uqqd0a7s6fu2s5To7eo1bu8SzXv4H503+yzTDkpt5cK3xrV
VLXdV3h2ZSNb7ZT6oRqvIZ6i7ly3oXMC+YrUtGqg2/Vk7tugm/NE7hugWyD5
IrNXzXzrtGP3pt5J7aYwpwvfQMnVX81GM/Pt0X1ZDl9m7o1qmMPfVvoWaMY1
6ytT2wpDvhbwuTvxfulW3uxZ4h34D9nSzL3Qjtcz3zD50g41of9vOTZhXIP+
p+XbpBk+k3uHtEvqQYbv53PP3jtg7IZ+BowLiXe2A3351v1RDz8vnZP8aeeX
Qb9BfBcT2wwif6zpfdTfUOmbrdutG6RbpJ3X7gvzD7B3oH+6yzay3dFwLOK1
2w+0bSudT/DVk3n3dLMXdF/anjX1XLu4LzW+5lm362DhfLXT2u0b9aLSNw==

          "]]}]}, 
      {RGBColor[0.6183000000000001, 0.521, 0.4556], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VU2MFFUQLnZmp4fp6e7X/cYYvHlQZnUSYElYEyUYiIkC+z/sDCDCjnvQ
BFfdqGuCwA1FDJhoYkIIySaeOMAGPGlM5MRFSYANePRiUAPuioQTB79vv+fh
5VW/rqpX9dVX9Z7uvTsx22dm32GVsAYSs0EITez3sH+Bn8fXmD1XMbtSNZvA
97rU7Bx0E2/2StB5Hzrz2JfwPQP5+4bZetiM52Y/NGTfgTxRNxuD3mZn1oKf
C/CzEX7e6Te7WtV3D/+vwU8Hfpqw2xuZjeKsAv2v8b+omWWQr0Mnxf5EbPYj
5EeF2Z9YXej/VcjPfKRYb8L/DazbkJvQPwjfT2ZmK4lsy5CriOND6K/FfgTr
NuRj2DcghkOQJ+GvjTUNeQT2v1Xllz4nkdc4/nWRY7sunF6H/G8h2weFMOD5
bthWkMMi7D8FNqlXnHUfMIPOLugsePm+BT8nobcJcU7DbiIXLpPYL0WqAfFf
6FPM12BTg14Hsb0AnH/H3Ruhsz7R/S3YDkN/qCSMiE+vX5ivYob4v4KfAdz/
B2w7kO8WoSbMvU93kR/kxovwuw3yS9jnaopnO+QDubB7A/ss/L8Z7loHncP4
biO2QaxhnI/jzqk+cY813h4rp1+das/cd+I78+LFpkRc+yCS3xa+u9j3wc+p
svzQ39m6Yh1LxM9vInGsmSn2diwefVkWJ36GfKYsX6zDQEX1Ilf4fwv81DLp
rMUeZ7I9gHtKqbhNjpODxJxYnXeKPcFdi07+/i6U17MV1fqyU01WcH7R6exe
obzpk/bkxuWq4vKxOPgYd+axbOmDmBCPmfCPOkWs/iJXiGkayx/jGs0Vwwj2
PbnybWMvA+c56JfI/5o49QvOt6Wq+9tO/KEOObPBC9vN2COvulSwn2qoZ5ZD
n/Uife+ph16Cz58a6qke7vm8oT7bj/Nu4ESEOwe9ctqaqEeHQp77cvF5by5+
Em/ygzxgDR8m6iv2lyN3gs8yfJZQu5Oo3VRdsZE3///jzvuficWJGGdZrNqx
huQXbVfnUeAG58oMeY51Gucu1OVb6B/14ts44pnKNQs4Fz/uV23ISfYQOUp5
CHrvQZ5FDEu5ZteKUx69kGNWU9++6oQFMWF/vZxqJk/j/H4iPInrU7XQf6n6
hz5qXjWZDnVpefVqB7ZbU/UOe4i4E//nw1xcCO9C7JXva058Zy8z97FcfOU7
sDvX+YmG6kO9VXzCDPeZOLUYKe6DTrgccrKhLecE5yW5yr7hbGNdWOOmF3ac
QzudarDL6Z1gfarMN/CTPB11wrbA+VtOuTBX5jES4uebw97jXT2nmTYX5tZS
qNM/TvP/gRNexK3rxGliSe4fCb3DHmL9WMebud4/9vVnDc1I1oi9OuKFw7DX
DCY32LOMfT70Nd/hVnhLrgduLMPfcqEzvj/DYWYwF+bE3FjvSSc/H0HnE9xx
B37P1zVnec8OcPZ+oRmz+qYlqjPnZTNgz9nEt5qYk6sPC/GHfcw7xwKG5Mmd
8B5xbg2Et41cJVbM5T+1lvNL
          "]], PolygonBox[CompressedData["
1:eJwtlEto1FcUxm9mJjPJzPz/839Y0O66sCY1YFTQLgSLUqyPxLwnvk0UW0Gt
im0EtYKbKhUrKAiliBVXgq2oWxeu3FghKnbrpmrrI77X/j6+LC6cc88533l9
9342/v3AnkIIYQenxIlqIaxqCaGHyzVpCHOiELqLIYxWQvgvC+FSgg17VzmE
9djfcLcV2zz0Teg3sPdiH+PuHbY54G1BPw14rRHCe+7Gsd0E8xXYc/MQtmPf
0wom8nPsq9H7yf8C+TVnsOAcbxVbNbYwhPVjPYQJ7EvB6yC+SQ1fUMsaMC6q
Fs63YN/FnsQh5FXrd9Cr6OeJ/wesh5xDxPer57JruEBsqeFaR8jRxHeMu5PI
X3M3jvzzjBCutoWwlrseYkdT1678DXr/kDl+iLth4oeJ2U3+g5wtyBvxHyh4
pin+b5nJWfZwgnkVyT2IvWO6nj/x7697N9rJv2AvpOZzFc9wAfJI3bELsHeC
NUn87eAeD2NvBfOXkmv6hHzLOfta3NNv+C6L3Ntf+B+r+0hWzap9c+pda8fa
9ZecJrZR4ruIbQf/15LnOxvsVnJuw3YAjApyVnOsdvoC/4wd7C2YI+JKH3d/
FFzzIXa1NfGsLqN34bsT/XnRPt8h12Ln0k61a/WgXq6Sr5d83eAtxv4Depvm
Mz3/M+gT9HYf/4dgT3L3ALknd6xyLAW7I/IsNTPNboya5qOvw+dZ5p1r93oz
MfW/izwL7VC7nIq8e/WcY/8pN9eOoh9B7iX+87I5VAZ7SWQu30I/A7eGsHdi
v4ZeqZrT4pbuhlNzVNwQxtrUPvIVh/vQV2PfTm+nqKdAP1OJe73HeY08mvjt
/Y79U2JXom9rdcwq5A2pdyV+JtTfhs/1Nr+xEWz/Z/4bevF5jFzOvesH9DCT
fOtS/xWKUeybxLkfoV+hvwT/Cfybei+536T2KU5Vq8YQ1i70WejV3L6qsYYc
x37b2r/e9qLIXBKnFiO/zDwvvbGpzDvT7vSmBqitCMb+ijkirrSAd1tvG7wG
eCuod7xgnxK+7bm5JE6L25vq/ttUQ4PYV5lnpZnp72qPzQe9iSr8uZd6/uK3
3mZ3bm7rDc/PvXPtXhwVVztzc1VvdJnmH5tbwhT2UM1cEue/Qj9OfF/BHD0h
/iSenf7IwcQcEBfkU0SuxP7bhFmOvUPtsknOp8hPMsuaiWaTN9yrZpwh/z39
v6inu8hRbi5ppzHyN4lnqRlqlh8B+gK7DA==
          "]]}]}, 
      {RGBColor[0.6558599999999999, 0.5342, 0.43352], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lUtoXVUUhndzm9ybe++5OY9cm0IdqIlpfdCCKKXkoVa0mjRtTRNpbDBN
RJRCHVRsIaLWIg40DhQV7ESqqBHUiYio4Kgd2EeqLYh1bH2maVV8FdHv598O
Dnudddb+1+Nfa50rph++e09LCOEjnhLPc50hjKGYzkJYTEL4BGVeC6HcEcLc
8hB21ENoRd6yLITVfL8jDWFXawibOK8qsCmHcHkzhFHed6PfztnVCOEQ2G18
r3F3AcxeMJehn0P/XR7CDSXjv8T749z7qeSYPuU8iP5mYhrD9wz4v2P/YGq7
hzjr1RAmkPuRr02MdQ3nK+RwBP1X6BvYTCHfjnyc+x9j8zM2TWIdag/hsqZ9
KN+D+B1qsc2d5PkH9vfj90/OYfRrS457oOE4R8llCv1R5HHs+7Dt53kSm6UK
uMhPyZ5zkOdAsO6WqD+T2+ckMZ7KbbfAuYqY5tHvRr81870y8mLFPoR/vmJ7
fas2XL8Cmy9z+/iC81fy/IzYfuMsdViWrlkzj+JzLe83oW+Bo1vR72wLYQ3y
YMM8bEbup/7rwfw8N3/iMed7UTNPS2DM4nsEeSvy+cT6Xmo+yN0N1OgYd8d5
34/8Ir32F/Yr8NVPfh1gTaCfxHa8bA5Uf/EvXsTPBHbvwOMbqTlXDLpzY+q+
Vf+qH8WTOPo+N9Y5zjWJbcbB70t9byfyexVzLX97y+ZSPF6ZOGbFrh4R78I9
nTuG18HYTDw9xP8Mfrcgv43+NfQ9qeO9jbv7qN1pcPdzjmEzj83h1P0yHH3J
/4aYr3pNHClWzZNqpT4QP4pNs7Qu8b0SmGeIf5YYDvPta+GCf5bzH2q7Cv1G
fO4t/P0Q8YwgT6J/Ff1F8B9D/pBvywvXTjP9N3e70A9gcwl5JfIg8nVxvtan
nqejMaZGzXVQPUZbncsTxLlMmNonde+DXTH+cuFatxbub+XXVXWNhyJ3slXO
sj+beEY0K61Vc/Z0p/tJvgbAT4nhemK4lxhO5p6RE7lrr55U/tJpft4ilo6q
/WgPjWeexQq6mbp9K3bxo5qo1qqRavUs8sXU51Lccy+AO8P7qcw2C5l5m4v6
1YVtHq273+Vf9Xm307i/gHN17Bn1TmeczTdVZ7DWcee+uM/EnWbyg4rzVV00
H3qXvK9u35qzqdjTqmG16v2gPaE6b2p3rY9V3DPC1E5Sz6gW2m36Jr32gXzP
xx2kfbOdeC7EGDQP2g3KTXlpBjQL2zJjH4n4D9Rct8XU3O6J8zYda76C2LrB
eL9inHNxfn/MHZf8/M+Tzh2Ze1rcHs+8U5R7X+Jdq749EHtLsb8ceVE+es+a
rkPK2Vb1Th3JvL/V/3rXDIuXbxItV8f8L/FUCveFZlGzJF421nxPueuuanMh
8qK5GCt7xpXfaOwB/dPEr/gWH8pXfXky81yfyNyzPbFvfsiN0Rv3k3D0rm/d
sf7aa9pvlxLvGu2ce8BZWXUv6J+seqt31Z9F7I0G+uHMOEnN86n+aS/8P9H/
TFjf5s5lW93/H/2HlHMndbyLehZN9/7zsf+7C8uP1D2L2lniTPwITxzpfTbO
l3JVzqqhdowwNYv/AfzgBMs=
          "]], PolygonBox[CompressedData["
1:eJwtlFuIlHUYxt92dvbbnZlvdr5vZjTBLipztdNGUUjt7K5GYWm72robbi65
GmEEdqGkYHSyAyTbRVCBkdGBSi/qpiJU6CovSl3LoLLr6KibER20qN/DMxd/
eN//e3re48WbHrxza0dEbOd18t6qRYxeEHFNV8TGLKIP/nAhYhilxdCb+Bvv
sE6jHDGXWv5Bd8SeRkR3b8RzOPqYv3nIb8VmY5GHzS3Q59B/gTgz6CToTlTs
T/oF+L/yiHsT/12P/t3Euwos7+P/WfwPYL8T2Wbi3wR9LTpj+H8P+dPIW/CT
8JPoDED/U43Y3WmMdfCsrzj2dfBXYD8f+XTb39XIbybeQuItB8MKdCcrzkf6
V6L/Bj4PFK3zbyliaT1iQ5cx7UD3nsy1Uz16kG/gPUq+NyK/BPvXsN+P/QJ0
ziP7g3w3J65nk/iD2F+IrMXfMP7Op85FNVPtWsjnI1+GvIV8DX8jYDsAxr3w
Q5l9DyFfXvGfZD+j0yLXvl7zshnF9ilq9i5YVxHjSejBirEeRH40d01V20X4
XI3vleCfBv8MeHrB/xX8J/BHeN9AT1WMdxb7MrG+bstVoxXk923qWdqN/Sno
Huq3DawT5N8N3cG7odDuCb5exf6domtyjnivwL9ddA3+hj8Mvl+73ZOT4D0I
fwb+cfyvAe+LvP1hDC9B34H/j+CnsB+BPsbfLugvsenH32n87wHLw/ydQDab
mT4Lxn1110i1WtkTkTWZl7J9yb9yrTUt6yeHxeQ3VnbtVXPV/iLkM4kxLYTu
wufL4Rok0KdqruVn4NlLrGPkNJA4Z+Uun/K9ihhN7C9PPZuaUe3eUfC+3uEc
7iu754r/CPZbau65en8SnzuI90vqXmsGiuT/ae7Z0sxqduc1HWs1PnPo+2v2
pRoO4fsQGOewfQJ+gtj72v25jJpUib8O/oGic1yAv5/wP4H/28D3I/Sb7X3S
jtfQX5J6F7T/S6Fz/g4VvMPa5azq2dKOV/AX8EcKvjHVkm+OboluyJ/4n27v
o3ZsnHn6PbVc9dJup2XPtjAL+3/YbE08g/2pb5Zul/6Cei2rud7ax1LJO65d
1305k7pn6p1qPgi2BvItRWMW9kLds64d6qz7pum2KcfTqWdQs6ge7Sr5psq/
clAu6zPXWjWbhH6m4Vo/xl8X+usyz75uzDj0VMm7ph3RrtyVWaaeqXdrM++X
dka7M5LZl/5Gobfr/iWe2UvBu1b3OvHN1e39PvctUE9/gH4I+fOJez5W843W
bdXfEuyrVddON6IX+jd0PmzP61novN1f1Wy05psse2FYhH1f6tkRhu9y3zjd
ukHeCfg6M3p7j2dCs7Gz7lnXTmyr+6brtg/zvkD/89y0aqLbrJur26udO557
5jX78tmAns0dS/XRbZpr3wvdkOPU63+wNONT
          "]]}]}, 
      {RGBColor[0.69342, 0.5474, 0.41144000000000003`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lktsFlUYhk+LdOj8/7Qz0/8HY2QhIjVcqiRegF4opaLCQhQREQXFqDu5
KGhIRBNhQ5TEBYgUMIqoicW4UHRhiNFoIkGKBUTAlbpSJMGF3MX3yXtcTM6Z
M9/1/b7vPXPD8hUPPNsYQvhTzwg9h8sQunQwqxpCjw52XBPCGr0fLkIYGhnC
X3kI47IQJuvbo2kIo1tCGNZ+SiWEF9pCWN8Qwn36vqDZ+ugeiet22Z+gb/dI
Jq+HUEh3q85qsnNjm2Wel9/ntD+UhPCi1pv0rNX5Gp1365mufbdiWR1lbpad
W2RzoWxeVexPSmaVzhvj92E938nHe6NCuFcxvab9z5L7SLnsUS4t0r9buhXF
v0KySxttK9X5S5JdotgGpdsv3RkNxgV8ZiqG8dKfKzs/yd446fZq3ymZr5Xv
Isnc3+B4wYrzLZJ/VzKTpfuVbD7S5Nze0vsS7bdp7c0dwxPyE5TDMsnfpbNp
OpsuH+t13Kn3xTq/KL+dwvAP2e/S+q3WuTH+PaOcM7ntluxmxd/d4HWXntXY
kezr2q/S/nbZXCi587K5S36P6WxI8eyVzW7J9TRYdmeUZ49+l84/Thz/Jmot
/T69f1lzbuS4EtwqXo/Kz5uFz7cW1lkSZegb+qe91bEPNLtXOhPnDoZ7db6j
2TXh+44o8/87NaOP6En6jVptjvluzY3FVPkNLe6FNupcM16t2h9T/L30kure
UXHvjpHsndLdr/3ZzDWfk1jupN4/0fkprUcz43Uscy0eTFwPHuqAP3T7db4h
9iR+iZk8BmJe19c9P2O1nmmxn39T12efvm8Mrv8ziXuMfqF3yZe+4b0j83zS
eweUU3Nqn8uUe0+jazRTuhdK27i24v4dkP2VwTOETXoJX08lntUTuWt1XOvY
Js8RdpFdGWPAP/mj21d1/8wujNPsxP7nJcZzfoN7in5iNsiRb5xT8xmx5+ES
ZoaeGsyNZ1UxH4i8dDr3fIMp/XCiNE5LlXdjq3McUzGPYGNL4dkG+8vSOxXl
f81cY2L7O7MfbFK7s1qnxpzXNdkv3DIQ/WKruW6uqGi9GvugL/c8gPlj8vlq
6vmalnoW6U/68vHCtt+X/MXMPHJJ67nSeIxW/GtrrtEarb+X7rHfSmMHhszj
/sg/6FBTOIjZOZO5VvTCG4kxBYtzqbmtqpivyMYHsv+y7PfDRdKfrXVW5CX4
6Z3cfPCj/D5dMRYHFfvF1Bzzdu45pZep3Su12HOF80QGDrmQOt6dkj8fY+iU
zPaaeeFk7vmdmNgfM0089NgXpWf6YentK21vkfa3Ft5zBi/CTZsiB2AL3/Tp
kcgPl1LbJqcJbcalXeunpefgodR8BC8tUK6DI8z14DmpsAyyZd39N7oe+T7K
9MeZpjfonbNxfqkXuaM/XHpGmBVyJU5yO1i6/3t0/qH0rmuyHDnAveR5PDO2
YHyo9Hlv1fNAf57JPXN9ce7Gtzl3uG1S5j5ZLPnPYg9xR8Fh+MNXLeZFfuRB
jajpUGJ8wYU7Co5jRqgfMvTUBNmap2/tWv+Jvu7Q/vPSfQAfEysx9xTmwL1x
fke1un8nSm9kap+nte9rNkbgwzop9saswvj0as3iDDKLjRXzVH9hvmSm4IL2
umd3XeqHfUfqeOdGTptStb+muv8P4AK4pyV1rtwhtYrrurwwN7Onvtwf8Db8
vaHmvDbWzLP4h5P4PwFHMOyKd3p3bizBFP68Ld7Lv5SeY+aZngF7+hrdpNV5
wRlwxPyIX0+LZZgn/uOG438YPEwv9EaOnRb5oV439vyj8d/EXIMLGNMT4My9
hz6632SuA7PInQbO4Eb9sUnNjmSemWGtRd04gMf6eOdy9zL/zMIPslNNfc/w
b8h/DzjMyc1J2MFuR6zX98L8cup7bFtu7gb7E3Ge6Ae+dcX/MHCDm5ifIclc
ibq74//VYPxP+w+B7FTH
          "]], PolygonBox[CompressedData["
1:eJwtlUtsVGUUx09bhsHpTLlzO5eHgYW8SiggJIDQdoY+JoAtCxEqLymkgC5I
aEEoxoS6UDaEDQt5iLKAoCSAcSNs0BiMJjyL0xYQ2MGKAAku5FEe/v45d/Hl
nvOdc/7fed93Ors+3FpuZl2cYZxVKbPtfI++ZdYemT0KzPoSZl8MN/uk0mx1
2mwlBhcqzJIjze6FZiuSZn/Cv8mYFbNm49EtcteC7ktwdoN3YoRZb85sMnit
4LVxpkB3otONbhenrNqsBMZpsH5E/xW2A+C3IPuZu9vIFmGzHtt9YFbh60ec
bugj6PeA/zF4n6K/Gp0GdG9z9uJvd5nZP9Cjq8z6K/xNvf1lzt+aj04Dvtdy
NyHpPvTz3kz4WvhpnPP4UoRflPQYFMtxzkKwm7nrRz4v8Pz8hv17geegGOtP
gr+S9VyWuDuiXOL/Nvz/nlhXkO8G/HuAbR/yw8jXpRxbOVAuCtzVQS/gXIY/
BN5a8H6CX0r+FiKvh54OxgT8/5y7a/C9+LgLejQ1XFbmPv6HvA/7QfMaX4ee
Grn+X9zVQDdy9zb4J8nRa3wcynjtlWPl+lAcv3Sa0L2YdVvhXcp6TpXbOnSe
Ect6+K+Rn0K+AbqDuz3wT8D/lVpMA/+D2L9a6PH4sJx3d8JPVHzChC6gM4Rt
Ab4ePg//IuU9pF7axtmIfy3I8+Xu4yvkefgFqjX885T3uHr9OP6cI5+XQs+d
dPLYB8iXoHsG/7LQM/GpA9m3+LwJ+3TksRXByEReA9VCNaynlntybtuLfgL9
F6H3pmrwPPSYFbvycQu+E/9mk8uz3O1DlqZei9Ft5c02ZDvSngv18CTeeoZN
e8Jz9hR6IPBeV08cRv8AZw307+CN4f2bsVx3B7NeU9X2DHgDxJYP3L8D+JtW
7wU+24q5Cfpu/J5qdgd6LDvgOxZHAZ067Ksjn833wc1F3tPq7WPY/BJ6z6p3
1aPq1RDMxoTPnGZvMOO+aOY0eyMj3x3KQVXkOVAutHPug9WKTlvSfZoD1vJK
73XNfIH8P473l3r8K+L5N+OzKRvZ/hB47pXzHLYzOKUKj0mxaeY1+83EMAP9
hxmvpWbwCrItKY9dPToO/77Bv5543zSBVV7tvdgO/y62NfD7k64zGXpnzneX
cqBcKIfCk84U5M3gFeL+fclbs7Peq9oZs6BbsOlIuM+jiPdEHI92cDnv3wh9
9zRiPwhdGXmvaienoO9kfLdqp2m3aedo92gHbK/2HVWK+c/gawLf3Zrhx9i+
Tjm2fLwJPyry2mtmIujhkedO/5Q/kL8JPRfa4QZeX+izq5m+Dn019NnUTF8L
fcY0a4qxGPhMaDZU77nw07PeW/oH1EL/Hfpu0MyXQu959b5yqlqtJZ7N8f+h
Hvv/AbqB2L4=
          "]]}]}, 
      {RGBColor[0.7309800000000001, 0.5606, 0.38936], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVltsVFUUPTPTmTu9M3d6z50ZiCFR2pnpFEofJraE0oBteWSKCDQVrVab
kOKHUYgt1JgQ/TDxQ00wGmM1JsZEjcYIKiGND4wEDYg/KhRBSYwUjU2IHyQ+
UKCuxTofk7PvPvu59uNM447dQ7vixpjz+CXwuxIZ86BnzL84L+eM6YuBmTHm
QNKYxpQx+/B5MKnvZ0E/VjCmGQY6rDHHodMF3XTRmEtpY5ZA/k3IxTOy81Zo
TM7xJqG7APuH4TSJ+/nAmKfBuwbeOfw6If+rb8y7zs4e3MWcHcbVC3+LwH+y
IB3qjkHeh+/19QgZ52++7NDe64hxHr5mIDcJ+jvQO2LyzRjm4L8nJ5kh8BYC
5TeHnJpSype5d2aNmapDfpAdg53bcDcMO18FivFzyLeA/0ZCvv8E/wvQsQbg
aiW/E+eSjPRmgMmBhPKk/qAVzj7uV8blm343U6ZOeRxBzhuB8wPIrwz9teAN
IK6L8F2C/CbYaE1IfxV8DOJuAPRlxFLzpEscBz3lzrtR5FeLK+cCbKzA/W7Q
zbgvg9+G71OB6FbY64Dfo7i7At4vkXS3gL8cv6Wwewi81ZAZAf8+8KqecCEm
RyL1wMuhsGT+zP2mBtWkDbl/gxweRxxTeWP6wX8G/J3gnw7UO9dR4x8C6V4H
Dn85nBdDporaj+K+pSgsiEkW/Dvyqv806xAqb2KzNav4mccWR49D5pWs8O5F
rU2Deox92uNy/xv06pxs0jZjYmy3Q/eki/9rnO+HmpkLsP8UYv0W9B/kwUYt
qfp9HAmjT3HO4FcBfRfiP8yagh4GvRI62yHfjbMOtkuuLn34vh/8fpzdcdWe
db/XV+/8h7jWJnVHfimU3wXwZ0F/CfpMKPxon3mejdQn7DXqUX8X+M+DNwLf
7xjF8GpacfQEqh1ruAy49cF2EjE/DPmuhHq95vqM9EO+bCzGuS6UzDjoCfib
hs1HcW4LNatrQvUUY2D8PCnDeCYh1wSZpcB5vSdMiWeTw4Y97CHOCr7bY4qV
Pc27Y4HmNIU4zwbSPYezxdOeYi0rqOt+fFdx5iC3EXk1FJXLQbcDiffbac3b
EwXRVyF3rV7+v4fNYk47ZyhU37B/OEMXfM3ah8B7PKM+Z79vDjTzdwbChfi0
B5rNYkq5c//xmz5akH8KdBVnO371oNus8iWfuROH19LCYqogHLb7qv+xpPqY
fTTq8ppzsd1iVXPKsGY3e/LLGC5CpgMyz4WyS7/8LkEnAbrJqhakifnJtPzR
F3PiDmU/cL9yTuk3AL4bgF0WZ3tWe2M2cDvEU1345nBG6Iv3VcfnzJB/j6/e
YrwvWPVpys0Ma97sycYa12MT7NmM8nzJao9zJ434yoHx7ynofWOdOVfMl7NJ
bDO4L3vi8Q1hnsyReNe7/qMP+lqFXD6JtAv5Rp0A3Q3d3qzwJl6saZ/Vnpzm
3POtBP89yHzm3hhiw37kG8GYjgbKiW8ye5azyvw3ZLX3f4z0NrJfOdP7Cnpr
+ObcwMTtZ2JTcfhc9fX+9nMfWvXAacTT6Kl/iKdXFB7cN+VAe7UGnz9FemPO
40w77IlV2Wp3VKx24c9p5caeYm8RA+4P0uwx7j7ifDfs/+5rNrusdjxnhDua
uO53+S5yb/MA4nzE05s75vZB2WH7osvlFGRmI+2OMzjbXL8R44yrG3uMtumD
O26Z1Swtt5pF9irx/MfXTPK/CWeIu2/YzQ9z4qy3WmGxwmofjDmb/M/FncD3
kpgQD+4C9lTJ9dXevHjcE+xD9gz3YadVrLc626zNjT2Xl23uZtbwkvuPwV7p
crp8y4lJFOo/BHfnOpcXcyL+vKPMXvTLRF54823k/5F5h/9Hker1QaS8iDtz
+x9a+BpO
          "]], PolygonBox[CompressedData["
1:eJwtlX1o1WUUx5/dO3d3X37b797dWSCEc9vdfJlOcLM5QedrCxY1ajWyJCn/
iFJyblTYCwQRFRSFNSMIoSKptLe1LILEorJ/qrmpJQTOoGAIBc0sc32+fO8f
D5zznHO+5/U5T8OO3f27EiGEJzmVnCuZEA4nQ3gQ5kJNCG35ENJVIbxaHcLF
dAjPxiGsqPDdcmS5+hC2cF8PfxHbLPxm+E5A09BL0ElJF5sS9JVCCPenQvgB
H/XgL+OuuizfD/btYCxNGiOD/Z3wW9G/jnMG2zfQ6anw3Wn4TDaEBuwPzwvh
bWTN4FXCt6HTAL2Sk61yzC/FxhDWGD7ORehhvwPZduKdTzzX4u8Xcv0evCeg
Q9b+1iE/i/4gd3u5nkHnaDGEVmLcRqyvId9TF8LL+Hgd2xp8/obucs4Eun34
e1g8GB3Q9xHDXbkQbuFuF3ij6OwB72DR+g9h/13eOSm3I5x3oR8oWncdfB6+
F4yNCeczV+OclXsS+0boYeTP4+s5TnOde6ReFTndyN8p4y+Cz5LrPPLpSTsm
xaaclXsvOo3ojmIzjuw4/AHoFzhvlfkXoVdwSgnX+zz2LfBVYL9CzLPgbs65
/urfKXqxKW981TiB/7U1rqV8dEP/i82+4B7vI/eROtfmafSHoRdivwj9ZfDT
+DsZO5ZBdHrAmyjzX3ImoVvqXAv1vAS9Hvuh4J715B2TYuvlbMm5R+rVNuTr
Y8+wZlU5tUJv4O4OZM+AMUetfiWG9grX4Bj8P+DtxH4QvhvdvUX3RjEPFV1z
1X4redZQ+z8iv8UBMFfH9inf8tEDXY1OR8o1SUE/AsZqsN6kvo9CH+CcgP6d
eVij90X8rei3cI4SyxRnc8o1b4r9pvW29UYXk8+HyBci7yKHWXK5nDa23qTe
5oXYb0P1n4Hen3etNWOatRsiz7pmWLP8WcG+VZNPoR/jbj76u4n/P7BniHGk
0m/qK2ynYvdKOSiXjrzfknJQLpohzZLeeBOytdx1plyTr8Hvj71bhsjvJugc
9W0s7wfN+p+R34tqrFp/hE1DyjtoKXhdkW010/eS793c9cLfTPwLwJouuNfC
PA/9CaeE/UF8Ho9cM9VOMX2D7KeCZ0nzXYH9+wXP6jXcfVDwTtJbaYYfh78V
+0boJs7HBR/R2mHtee9IzZ90xpDdlrGtYlAsZznXp5zjqtg7R/3QjmphXqYi
73fVvJ3aJWpDeAr6GHdXZ91T9VZv7ETeO1y7XDs+gr4UWVc2fdhXYP9F0vUM
0OcK3lWq2Y3IH6eHh6rt8xS2/VnP5iHsS7XewdpdivlnbL/N27fmR7tTMcmf
3tAl5LX1fiuaec3+HDpHkp7pSeRXZR2P4lNu2pHalZrpJcRzJrK+/reV8KPl
fb0An5cz3onajZrRvzPOUVjC/Avbe7Kuzxj+B5jdAXRKSc+QZmlD3ljKWbm/
V3CvtVMXgzVdzlc7ULtwGJ2mhDFGoH+M/DZ0NxG5RqqVetgX+c/R36OYPwe7
qt6z14p+W85/tnJTjqrNeOzZXUVMO4ltLu1dLvlp8LZn3DvNSxN8V+xdpZqv
iV0j4al/mp3JyL60M0+qHnlj60/X374x9l+qP24TdGfsXab6zaL/P4xZAdI=

          "]]}]}, 
      {RGBColor[0.76854, 0.5738, 0.36728000000000005`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VltsVFUUPdPO9E7v3BnvvZ0aLdhpQ98PoEADbTCKhvqAEhjEFx9QEKM1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          "]], PolygonBox[CompressedData["
1:eJwtlXto1WUYx99zzs4529k5Z+d3dlak5GbbcpvOeZmow7KMtIuVzjKqP5q3
CANXNhO6/NOVWgWpZYMyQQhqWGlWzmpWEBpRaVJkEJLr5qo/CgZJrfX59j1/
vPA873P/vs/zvFPX9nZviocQ+jkVnEmFEPYnQmjn8jzok7kQpkNvQfYNdDEb
QjKNLmdbMYSeTAhPIBusDOGhEnZRCGvhX0iGMBO6v2D6LOcEus3cxVMhrEGn
CfpozrHk/wj0s/isxHdDLIQv0b+kOoRe6MfR2YF+Bn4p/Dz4q+Df5fTi7xg2
fbUhjBDvgZjv3pMcf63IpqE/BP0ZPqfEXMN2+DZ0kinn3Ao9A/9rkPehfy/8
JPg5yA+Q/9v4frJcT4a7H/B1ouD8boTfjn49ZwJ5DH4E+W/5EPYkjOEssNsW
WfcweJ2L/FVhimwd8V+BXk+8f9A/Tn5bqOck9rfzMLu5+wn9JPHmJ21TAf0a
NdRDv1wVwuq6EC7m7hbkGzkroe/kTXYSawo6vdDriT+X+N34v458NnP607aR
7RDnLeiD2DyF/mjebzON+L9C/02cPcja4G8mnzeI34DvenzsL/pN9DbSuR/7
W9FpR/dhahjHfiE1XpRwTMWO1YTwGLLLsRlD9iY+BpFPhW9DvipvPIbRGYYf
Redg2d+yrHtQvdhFXhH8tch3x90D10B/XXDv6I2+gn4m8tuKXwzWHZHf8kXy
3Uq+DZHfbgD+bvh9RdcWuDtNLXeVnFszOWyGPidyb6fRKRG/u2DsBzCpI/e+
kn31wF+A7nP4q0q7hzQbE1XGdx/+GuFfR96U8Ju2ZO1TvlOcHUX3gHpBPX0I
/qOcefXEH1XuUfXq/28I/XzRvaWYA9A7uZtN7TPg34cf5rSn3aMf5zxDmiVh
3k3+cXqqATpLPrXkclPGtrKR7QfY7Eq4x8aI/yPylxLuWfXuJ+jMR3dI/YPu
COdSfC3RDIL/PbXudb3Zp+CziBidcffAUWzPlN9bPRLoldPcrUp7B+wt2Kd8
d1NvBbEbc+63R9C/Al+h2tjeB/8n+VyY9SwI4wpqS1Q7F+V0KuceUC+ohg/h
/6KmXZXGWFgHbBZVuWbV/m/eseSjAl/HM95defzVUc8cTjZlH/L1dBl/3c1F
FnFyce+kz7FdCF+bMmbCboy7BcjOx/ZMyTtDu0MztDHjGdWsan4X47uZnJbF
vZO1mzVzmhVhKCw1M+KFkbASJsJGOz9G/gsix1IOXdClyLXUk8Mx/HXCt8Zd
w8/wleBxWZXf7Aj5bojc++rB27QLS+4dYRZD9xB3m1KeT+1qzaxmVz1WIp8N
5DBenvclNd5p2m3CQFhohjRL+kMaoa/E/tFyPU3Yf1t0LXrPpcimRf5rtONb
Is+wZlk7Wrt6JjmsSHr/tBeMobC8A/x7sL8+73wOEKOzxjtTu3Ml53vtO/p3
b9o1DUX+o7RvdHc1snmR/x7h9Qux3ynPp3bwZGo9XPTsCdMOfE/OedduJd7v
ec+8Zl9/Yh3y8aJz0x81vdo7WLtYb5AGqy8yfiv1VG1kH/KlGKPIZhc8K+qR
WdBnc65dGHQUXJNq04ytyHpG1dvCeAJfD5b81+tPXBd5J+uthNENyLur/bbC
oAt+MGvsJF+d95tKX/tFf93yrOOrP08VPYN6u+Xk00I+IWNab/odsmSdd6/+
nFZs/wMA+ggU
          "]], 
         PolygonBox[{{2571, 1368, 4154, 3575, 3576}, {3576, 3575, 4143, 1360, 
          2563}}]}]}, 
      {RGBColor[0.8060999999999999, 0.587, 0.34520000000000006`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV1tsVUUUnT5ue++597TnnN4WLRRFA0HEoi1QkCggICgoLyX6AUHQBBIV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          "]], 
         PolygonBox[CompressedData["
1:eJwtlltsVlUQhXdpS/vfyn9OTwu2VMQErYpFqdwkCkqJSMtdjTEB8ZaIiaAx
XILGGC8BE4UIiIBR8AFRE/VBg5RLgAgq9QpifAIx0SgUg7WFFtui38r6H3Yy
66zZs2dmz8w+wx9cMnfxgBDCZlYJKxuF0F0UQsTamw7hWD6Eg6Uh7IR7EtxW
GUJ1Od/ZdDgbQgP8LPhV8MXwW+MQbgM/An4b+VAuhGvRHY290/A3oj8H/mmd
B96CTrYshCvhfwKfQf929KeAyzMhXKoI4dNif5vGeSn8uwCXZ+1Gf8qgEPbh
eBv8fvjl2GsfGEIMvwx5N/ptBf9bkUs5fyz4YXBHilj4Noi9w9H/EXs18E3w
y+BP4Msh8G7wDvAi+FbwfPTnob8L+XXO6Cm1jSrO7wc3DbTOQnBLVQirU87Z
EXLXTTzPltj+19j/EP1a4q9j1aM/OrJvb2GzEXkHOnlsjQEP4LwifJhR6pyc
gjuXMrcWvB38eyF/0rkG/TpszMfeNvDlyN+y/x/kDlYevDNybpSjz5C/hz+P
3MWKwWsix64aWIs8nXhWpRyTYlvOt03BOVqB/BXnb8eXlcTYSDxd2BtHrhrx
aRz8uQrHXo/O38gj0G9AnkX8M9EfmPHdKwbFUly4L9XIYPjanGtJNTUUeTw2
Y/I9FP50EsLxtGtJOVPuNsa+W+E3kJ9hdaI/Fv97Oevzwv3qzq4DV7KnDv0M
+glynLWsnK1n79FCP9yD/iT0Kzj/L/BZcA/4IjE9V+L7KQEnefdDA/6NwtbY
rPlP4E8qvoxlfdPePPwEfBvH6iOeOWn3Ujv1swv8DXhokXUuga9Gf3LKNaRa
qlG/wU/iWwn3c1XW8kb2L0H/t7zvWneou1zBt63l9lG+FvPtVrj1fBvB3j3E
dzhYvxnu8cSc7rQTX+bh8xHy8zL8DPgnEp+1gD3n+RaqLE9ELkLuSdy7jeCL
yC2yAf8ne3aCOypcO6qhs5oH4KUF/CWx/ZpzbpUv5bIm416chg8PRd4j3VHk
40DsGpQ91dsw9t7PGS9y1hjO7864hlRLOqO9wjWv2r/A+gFbq8nJllL3+DHw
uzn3Whf33cf+NXn3ag78R9o9pd7qZH0HDmnXu+64Ht074IehOxWf3wOvy7s3
31F95X3nuvvxrEFZz0D1w0zi+YV4FsGvKXePVmKrJWtOM/h69teC4zLfZyW4
WTOowI8EDwHnytxTJeDHsLcWe93gKuwtBL9U7hwpV0+h/wr6U/F5JXwz8cwK
1nkAfgH8IvhHWb2xe1i9rBl/A/ZP8W02+BDx9+f8Bqh/5eM2uP7EsWpGzYZb
Vci3emo/eEiVbWvGDEaeEPntaGXPfeCPY89O1bxq/2Dsu9edVmNrf+ze05ln
0q5h1bJ6YG/kO9BdXEF8d4IHwN+S8gzQLPgvce3qWyWxfcC3dcXOoXIpH+SL
ZtDNkXtAvaCemUs9TYtsWzlQLqo1Twr512y7lHNulEPlchM66TKf8T5cb+JZ
pR5ZB74Lm8eDe+5u5L6832K9gf3IE7OetaqxL7C1Ie/a2sB9LcZWDf70ldoH
+fJR7NmpGaJZsiftt19vbAbd5xP3lmb0C8hR5NpWDaoWD2T99vazmniLk8i9
o5pSbb0WeVaqhlRL+9J+m/WPkYs8A9UbehPHZN2j6lW9wZfh+02Re0szSrNK
M1yzXDnaHHvmavbqzV8ae4ZolqiGVoD/TdzrmpmanZqhmqXq2Tdj97B6WW+C
3obplX4P7wU3I0/OWNbM1+yvK/inmaJZpZwqt5qZmp1H0+4lna/Z8WphPijn
P8ONzLiX9Obo7elOPAvVUxfgTsbuVfX8CeT/AUqKNcg=
          "]]}]}, 
      {RGBColor[0.84366, 0.6002, 0.32312], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV2lsFVUUni6vrzNv3nsz03m0UHbjjyIJoogmxg0wgiCyaWIkgsaYGBSD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          "]], PolygonBox[CompressedData["
1:eJwtlllslFUYhk9Lp+1MZ9qZ6V9K2USMJkWMGy7RaCKgSMTIZqKRCwRjYkSM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          "]]}]}, 
      {RGBColor[0.88122, 0.6134, 0.30104000000000003`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH1s1lcVx2/f+3te+rz0eda1nRtlLEKJszBC1AQi0vmSCJNiwZdEjcEs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          "]], PolygonBox[CompressedData["
1:eJwtlUts1GUUxT/svF/MTKeWabEyqAnURKEhBhcStUVhgdCprdGFGENi1Ihh
qUDjI74aEqkbJGi04obauDAx1p0vMNGYUjVGhUpbSqnBtlgoJqU+fsfTxc3c
+7/3nu++p/Lo09Xd14QQ9kMR6GIphJuSIRTg96RDuBX54UQIj0CzmRC21oXw
Ivpt6P/gdwtyN7/rkH/jtxX5QWw3I98NP4l/I983SQ/eC/kQDkVDOAMdToXQ
js0b6CPL+Ia+E/u9+CeQB9D35UK4i8B+jIUwjn4C/bXYt4B3Fv4l8A6DNQF9
iH0SmzZ8W0hqM0m0F411FqrCf4LP7+Afwf455DPIRfDWKz74HcRzIOkY16Bf
X3LuP4B3gvyfRO5F3og+ztsR3hiFH4c+4P1NyoFYK2BMYztWMrZiHod/tWjf
Lr69Aj+3PIS1yJ3Ik9gMI69AbkPuzYbwDvlPEPsQdBzsvfjMol9AXkAeRL8I
PwWdQz5dci+U0wj8Beh6+CfivJN2TIqtB/kO5AHeKJHbjfj/TPzz8k+6B6Po
v0F/C/oN6KfR35tyb8+j/xjbbSnnopqqtl3QvoQxhDUL3QA/wHs7wIsXXCvZ
yHYnNd2O/j6oTO2bsWmNOWbFfr7kWWtAnoIfoj71UdfopGpFD1rh14HfAtYC
9eivoebEvBH5WXz6EraR7aqsc1FOFfgy8VyNuqfqbWfRs6SajxFLBZ8tUeOt
gr+a9ywMQwvw+7G/GHUP/sb+BJjv1/hNva0ZUb/zxFcmng7q9Rj51ONfj+2n
OfdS/ZvEfw821aRr8Ayx5ZAblnnntHtt+G8InlHN6vxSvv/3CNvnoQeSnsGD
+C8W3XvVWLVeXeve6w29tbXWvZGPfF8n3jXKhZhX4n8K/EM1npEG9NPYHSC3
Jr5tT3mntdvaYe3yVxnX5jswvwa7sWAs+ch3JO1d7166Hf1F90Y1OQb/D/or
Me/En/T3rbx3+TZ8jsC/mTH2U9gMgl1f8O5on1fAn855livENwL/LfbL4U9y
QzrAu4KcQd5FPJfhowXfEu1wDH5K9UfXDl1H/9rTfkszrFn+jJxnor45LxNP
NeW3Hgf/V92qOvuqR3fCf1H0bGrmZrA9V/Is6yYOIs8hN8PfDB1NG1PY2vHP
0b+Hf23c81KH7u2iZ0k5/iK8pG+FYtoF1lzKtVqpmhW8o9pVYXbh21jnXati
0wB/e8azrRk6jr6ctu4evi0yn00Zv62ZPlp0zVS7ndpxsGcy5vUfof8K3Sjd
KtWwqeSbrdutndXudoDxfcw3/d2cb7Jus77dD/9R1vOmnPuQi1nPmnZAu6Ad
0a5oRrrR9+cdq27+sbxvmGrzL/oe9JGMee1gDH1v3rXRjB+E78l7dnQDfsL3
tSVZO/1lyjdCu7WPeC/n3GP1WjEq1gvgP5Twf97akm+w4tO35pJnTrOnmZvH
dirreuumrOatS3wbinhG/4IfBX/3Ev4p3r+U89vqz3DWN0P9kM0Yugo+5bh3
qD7vG61Z07cB8v8PtEQKDw==
          "]], 
         PolygonBox[{{3559, 3558, 4130, 1352, 2554}, {2562, 1358, 4139, 3558, 
          3559}}]}]}, 
      {RGBColor[0.903, 0.6275, 0.2993], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVVtoVFcUPc6MY+bOvXemNzcNiq9YSxKNFlHBRym2ttWfUmvRCi0KIoFq
oiYfaisBCYhG8EPEVlvaQkVjVdSPJJNKUaiJpXFSaCUiBrQSfCM+UIMlAddy
7eLH4ey7zz77sfY6+1as3rB0fcI514WVxHqOj1IIsyFXZpxrzUhfjb0Kq9T0
lCPIP2d1NpiQrtJsuqB/C3JxhHNTYPhr2rmp2I+YT97l4p1HsXOflemMOp5T
/gZ3UxaPOUzjORSTIf8HeQv2W4Fz3bg0c5Rzc33n1kE/qcS5Zzgbm3fug5Go
CbqvLTf6WwX7Kugf5BSLcej/Gb4d6kjCzwTcXQSbLtiew5oNm4eeczex96GW
DPbh15TPV6i1PZZ+kSc72t8JnXsdPs6a/axI8h+wb8T6Frq/fGFErFhXOer4
DsmMRh5rsPfibMgpF9ZIvzvgZxh+dmI/hVhbYLcC8hXIb+K8iLhXE8LgLlZD
VjU+jJVPU4n6uz7Q/gPs3wP+m5HDQuxzsOohv439TFp3aHfNU26dgfKZMUo9
OJ+V3Uzk8Aa+OyBXQv4TdodhHwLLi+aHONRk1EvWOz2j7++hv+/Jvgf3DsJn
AbrHyLkB5x1YG41n1caxp2n1sQx2tagBpm4ucp4O3d6kerkJtrVJ8boN8m8Z
2fXju4i121PdxHAooZiMQf8OvXmOGM2oZUFKPoiDn1d/JuJ8ICGs98DPdeQw
CX7KA3GC3KiD7npW9S+Dn3ReeaV85cC77BH7T9yIyQXLje9yCeopQP++Jy5Q
Jh8OeNqb8+oV66rLiNPE5ItIPvrN/2VPmBxHbu0Wi71i3ZfS4nXRbBmXmHWm
FXNFrPNm3O1FPftwdjIQTsSLvWJv2gzbOpN5Rj3jMdaCMvXjXeyBYUgse1Ka
OcSXvN5uvWuzntMP8203nvTaOyf2p+19ELd24wltOiwu7x/KimdPkNzfvnIk
X+YZz8n3VpsPnD9LU+LCh9YLvh2+IfZqwN4V5wnfL3lyPBJvyd9jkd4I30qY
1H3i2e2prv3A7YSnd7AdtQ9nxeOmSBy6aj1jvTX2RhqsDub9P6bEc3mkmcPZ
UxWJG+QLOc1eMvb8MuXJebMNNoOwKcD+Hegb4ecfX1g1GG7cG03+3dPbWol7
O3PCuhV+sL2csX0o/kZWeHUCz602Zzlj2RPONeZPHhWMS4zNHD6C7x9D9X3Y
F2cKhuc5i9uS13znjElAVwjVk8WQx8d6k92I/2WgWbkrp2/qfwr1dhmLvogF
+8FesofkD/tI7vcZ/y/mtJPvfEMtJYpXY++FmBy2HJhLuXG4wlcNrGXI19zn
nH6APHdFend8fy2GIbGsjsWxe7BvicQNcmQWvpuQ/9NQ8+O0Ycge1tnc+zxS
Dsxlov2nKvKaAW02B36J9C85Gklfb/wpjng1P8Yg1lrE6A+FS5DUf5A7sSJv
+d+utf9QvflmLgPZV5jxf0LMORvHwWc95Guhds5D/pMqjRulNnMu2Buj7x6b
rTzfav7Zz00livtxLPkSzu5kNN8Hc8oxsJ7yP0H+8F1MicVJcrPf/on/hsKS
fln/uFgxbxsG+yxPzm7m/CnufZJTnktymne0ORGIF/TPHrwAUyM6Bg==
          "]], 
         PolygonBox[CompressedData["
1:eJwtlGtoz2EUxw+bXf63zW+3XMamZJtbYmluuc8bucUUIaEwEy9mpYVFzFu5
NKHkPsYrGy/IPeO/QrywckmJvDCXjWmLz9f5v/j1O+c55znf77k9hWu3Lq7q
a2Zr+JL5puSYbUk3O9rHbDJyRWD2KsWsJslsb9SsM2ZWi2Mp9m8hszrOPiKn
811BnxgxG5dqVt7PbGimWYzvHHcHABJFvkS8vFTX89D/hs1+E/8X3y5sewLX
93HnKLHfgTec2MPQ3yMvCblcCYc36D+yzUbBdwzfWWLND3ksxVCsejBy+vjZ
bvQWYjYk7g+G62X0Q+hl8E3D92vIc1OOXcSfQQ2qid0N33ywCiLOXTEaibc8
8NqoBh/AP4DeC5bhk0K8Cu7UppnlEr8tAxzuj0/UpwD7KTCmJ7uPfMVJ3JRj
btRzlC68ZvR29E3JXpN2uM7jmwtcj/Cwn4fDTWwBPr39vSfqzW04TYBbD/Gz
iNWKfQF89mW6/SX2ZdgPcrYuyWPUI5eT/850n407/L9EHGsxByXwPRb1Xqne
6mVjop5jyO8z/o/Cjq3848RLjnht5HNQs4VPdZpjbuTuSM5u4B8H/yr+J8i3
1JzzSeTykHPVTGo2vyX6pZo+QP8U8V6ppkOyfabU+271BFsHZ0fwvwBuBbl1
85/Tz2f0MfgdYBahd+LfG/aeifsL9Pdhr7Hyf0L8RRk+M5qdw9y/hq0p6rLO
vhO7AX4bkjynEvEFv4jzYr7TxKuMea9Go59BX5jhsTVT17jbGnVu4jgIrKWB
c1HPmkK+k/Ldwf2ZOV4z1U41XQDWqsDnXzmtDpyj+GmGBkZ8xjRrW9Dz0Qsz
fTZrKNcfYt4PXFeN7yEXa4dSPKfN3F0PRn2ax1ftkhL91UzU4zsrx7mpZsXa
hcBrK0734P80sd/iFEdui/jbo5nT7FVTk+Po29GnobfEfPaEKeznEbdt45uK
/W3Mc1HM1yGfOfXvFpgPw/6miJt2dH/gNVft9YboLfmZ7W+JMIVdmNh39eAy
/mVg4PL/jZyEXBf4bCmfuyHnIC7yeaZdDxxbM1wF9srAa6WdXRH4jGhWtA/a
nRGcXcd/rGof9h3VrqremqXmxPulN/Ri4D2QTW/UdLBnyyfFe6Re1dHPHvOz
Iu1Chu+metSF/DKL/lPLzdyPw/cfuzPMNw==
          "]], 
         PolygonBox[{{3830, 1149, 3124, 3533, 3534}, {3534, 3533, 4123, 1349, 
          4124}}]}]}, 
      {RGBColor[0.909, 0.6425000000000001, 0.3179], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VVlsTVEU3e17fe279917X6+2KjGGStQYhKjpA+GP+kGMkUgUqRjSLyFp
JQ0JX4bG9GOqiOmvhkQMIURblVBjJGiFn4pKRSnWso6Pl7PfOXuvvffawx22
dvPi6lwzO4lfAr/hBWYfcdGQY3YpMkvlmY2OzT6lzZbg/Xxg9tXJFyH/gE4u
9CPIu6D3G3Z/fLMxkK+lzCbgfJox2wab2cXAAl5dQnotsGmE3BOaDcJ9LeTP
uN8M3XTSrAO4Q7LAwDkVGFOBdRuYD4F/D7826DbD/yHYVcC+BHrrILfgvs+E
R3/0dRq2MyD7Wf0oN+JuPGOG7jEPPrPC6Yb/mXnSWY+3j7AvBZaH8z38tiOG
pbCbmG92LqH4ymP5PAIcH7FXpxU/YyQPU0w5fcAdYO0BcG7xHnavcM5LKvcw
Kf5BlQ3IU770W1EszGk4K5OKh3FVuXyZQy44+gn93cAchTo25QjnKs4u2JzA
eSNHNS0zcZWfJ/vLkeR2+HgaCXtZkdmXpGypT+yx5BlvJYH4Hgifp3z52hTq
P++b8P4urbq+AF6QFachzrueMK6x7k6feM3Q74av/ZF4JJ8LId9xXN+NFQvz
YTwLi5QL+5T9xz5MAa8q0Psz4B0M1G8HAvUB5RLHA/Onj391SqrnyfnOAtVr
Nfy9Qc6rYvUSZdZoYFZ9y/4lR+SqDvIHXzL5a8uojjNRgOeR7D7hPRWodgs8
+alJyFdnoVk98LdDZ0ugu7HwW+jyZe3YL4yPb+1OZm9ML9bMzMB52tWiG3Ht
iVS/vZHyIz5zrI+EOQc6t9LqyfmwHedmlrPLuNi79NU/Kb7K3Jyw1/aHqhU5
5Fub60W+XfYU1yL4meywLri56HC7hXUl978yiq3DzcVw/N+K/52h+OM++t/D
/V0fMsY21/NngD8S8htPM8TZYA3O+LJhruzZ3pR21mPglwHzeT/sqUJh7oDu
rGLNXg3kuUXifQNiGJzVjLcGyoG51EJ+EGg3/EiLO3LYAuyXnvbRW9i2hort
Ne4qI9Wd9V8ZK9YW+GqGzhrIj0LF+Tul/twXiddzvjgY4XhocjuCMu2Jswx4
e2LZJjLav+z1Bvha7vbLili50fYb8quLxUkO9KsD1W5SLC7IyS9wYxnhcK+T
C3KyMdTM3XA7lvFw17A/WUPuONbxtqeZqYVteYFsqdPeT7m0ZjSrnNljgb4P
o1yOjGV2UnuJfcY6H/VUY/JJXk+E0jkeak+X5uuN++FwSr44e+yhJ/DTV6j7
s76+Geyf+5B7XH98x7muQL3I+Nkj5L3BzRLz5J4jnu92BeMtd7nzu8j+4reR
3zPuhy7EeyVQP/RG6iH20uNAPU4d9tD1UHvpoNNlP5CXm67HToHD87FyHIpc
/gLiwAlf
          "]], PolygonBox[CompressedData["
1:eJwtlVlIlWEQhkezU+ec/5yjf2oF2UIZZFTSYntdVNBdC0FFK4WVFUoZQTdd
aFAGdVOUYHmVlgQtELRCtFPYYtFuCGWJ3Si0kaX1vIwXH8z3z/bOvDPfP2JD
2dLSdDPbyMngtMTMRqeZDepndjY0+xY1m9HX7Fgfs4sJs4a42Q30AzH+l2V2
iW+56W4TzTR7mzLLQ/6KzRvkDuKdwXcX9u1Js2ucXHSVfLuO3Eb8sdhXcD9C
rK2cYuRv2D9GNzxwLLOwCYi/mJgx4cNmCfIrbPLBHUG/KNtsO/5P0PfjfgH9
E/xbwRcl3k6wfyHnTuQt+NxM+DfpyogzM8fsddR9hUFYNmPPZxvVH90As1Oh
+wpPHfJdzkTwFZJjWKbXqFob8O+k9knoS5CbwHSfXCvAuJdYg/F/Ab5N2Mex
b8O/CaxXevspDsRFNfeeNO/ZPe7NYBiDfzk4X2L/PHDfJDHmAPQ0OY5H6Dv3
A8R/Gjj2kZxX+G4jXxa6At3RtcedqwV8WwPWZfg0IRejnwLWE+RPJ/5yaq5B
PpxybjQDh5APcjoznIMS9LNyvJef8ZmW4z7y7QJTJfHn5jh29VS9TQtcN45+
/Eg5JmFTjap1YayXa3Jcxn475wq5azl7wL4ydOxt3Fu5jw19FrqJX4C8mvM+
4jV2EP9B3LnYTczJofdIvVINVcjPU87NLXweYluRcFtxJu7EgbjoQV8VekzF
/sB9HfdnCedeMzCKWs711q8enkdeG7qt5v12zGdaszSbk0Begf51xGf8Qsx3
QrbaqY/0rSXpu6gZySP++Zjb3sZnKr7dgc//XPLXYvso7jrVpNoKsbnGvQdM
E5DzMn12hXkocp/AaxMfP7H/m+W7fpWY9cSal+2yZmg+8j5i/Il4T+7GnCNx
JU7qkd/AYT69q0ZfHvcZ1Czq2zNyVSacO9WgWopC730R+HagGxe6LMzjQ++h
erle70PScyiXOF6F/nu274JmpI580xm00qjvmHZNM6nZ1LcZyI1Jj6WeviP/
r5TXLs7aselKuU45f6d8Z9VLcfSJ+DUx76V6rrdHnIt7vXmN3P8GPovSi5tk
pnOtN+ShuA2dX+24oT8T+jxo/+uRjyb8rdQbqbdSb4q40ptzB/3vqMdSviHE
3gWm/RHfYe2ydkS7ojehO8t3TPWJs/TAORE38vmC/mTSZ0dvVim5m3v/B5o3
vfWqSbn0ho7E/z9IAtrS
          "]]}]}, 
      {RGBColor[0.915, 0.6575, 0.3365], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VEtsjGEUvX1NZ+aff6b9ZzRSpai0NrQk1aWF11akCyQWmqhH6xWSLixE
vAXxinguSjUkEoRYmGJjoeLRtNpOq4iqPkIsiAVpcE7P18Xk3u/O/c4999z7
/bPqtq/alm1mh/HLwe98yOx7rllzltnphNkT2Nue2VPf7CoShuNmn6LyB+H3
J80qwmZdMbMe+MMAexOT7QTOJdwfQHwM5x7EzzhMYjcDczVqPgfOM2AeAOaB
wKwBdgnudiHvvK/4R+Sncf7huLV64jpeaFYfVi0c7S1qzMX5HWqOIqcfwbXA
XJbS/R2oNR/nNOLzYB8A/wLwB1B/Hc4DiI954lsOnCJgluFucR6wwaHdE69O
+I9D4tqBcxv8Tc5fEOi/hYF4UQtyG8LdDJw1iIfBcz3+ew0+74H1Dfe+4v/K
QFhVsE05qlVj6ol8qOcr5HXDzgYv3+EzPhIxW4Hcc+jpWlz3lqGvO1Fh7Ud8
BHodAX6Tp37Y10zgDLq7Z33NvyosnalfSZ7qfXA8yZd9FLs451Obq//ScfmP
YE8kNK+TsB0418GPoO/SlLidimsnqHUD/FL4U+G3+dKNPNlXPfKPgc8oOG71
pfPZhOoy/g85O33NYhF06wVOJeJD2IGWuHbpOmwmoV76YGcUmC2HPx32PvTZ
g7tHgfEZeZvBrRaxaIH4PHS7vws403CeE5PtQHw0rvgIbJmLv0S8GrGNOdp1
zq3C7VKjr/jlqLS5GJLO99xb+BmRHr57Ozc97e1xcO5NKr4xrhltd5h7w5ov
NeVOcZ+Jxb2IunfBWTGvxs2Ys+a+HHfvavJ9lCC/nHcLdXcX6te4XeQetcIv
ygcv2OyYtP8FjMvAPIycK7605C6wxoZAZ2r8KiLsLcjpCynOnKUp9bIENjsQ
h32e7IR+pnmyZ/bLGDVkfH+guqzfDl1K4MfhRwqkA983+ZFnFvkWSvNbnvRP
O3zuHGfNmd9NCL/R7RS/FXzXX5J6F5mYZjy5C/wW8J2+AGaH+/bxWzgeEjfW
nuznb6H2nnPgGz0YKO9QIL0vZmle3PFq139VnvriTLm//Ebx3XW7t8Pva21C
d3d7utsUFueJfQ9JZ86SNTJJzYB990a0T9yrxVO051PypcWNQH4L7O+EePxJ
SF/y8X3t9pj7/lSnxIFcVqbEIQP8/w4z5XY=
          "]], PolygonBox[CompressedData["
1:eJwtlElI1XEQx8eX2tv+vXw9JUuyEqpDpQXpsYMt1wiDFCISskXKosKDQQdN
K8hDi7TYIbIy6NACHbLlEpRFKZn4NCkKc6HoUF2KsD5f5h3+MPObme9s3/kv
qm3YvD9kZjV82XyjUbMLM8xqUfpmme3lK+C9IWy2LmX2MmY2kGXWiE9F0uwz
9ivIcwEpjpu9QN+KfxFvvchB4PJ28F6hv59jtgysS2AcAWsYfUnY394R/yth
9g/bKfQ68j2nnjbi/+aaHSdfGv8oWOPk68f/NhhP8C/iLYT9ADl60K/yNWEb
w7807D3swdYG/nd8O8C7gX0IvSjHbAR9En0QfR56Gn0MvYr8e4idT75CevkZ
8f40o8hss5O8NSEP4z+B/2TEa2/hrQPbeuIrzGc2Tb3Ngc/uGD7V9FeZ8tmq
JtU2nee9qIdu8LLiPg/NoJn+Fqa8PmEWI3fzVjDT5x+jnmv0WEl8Pf5XyN0X
eP0biFmAvTXpsxSmZt2O/xr8d+PfGfUaVaswurC90UzQR4nZRmwZ3yPkft6W
I0fizhXN4z65VvP2OGO/B/4K9J5cr+cg9vKky8rRG3MM+cpnJfKDwHtRTzfR
u/jyZzrHnmKrp6apkO9T3LwFxkVif1DD6YRzStw6oX0wy795vmvx4Si2CWIO
ZTvep6i/ySaMf/ieTfgsxKkzyB8Tvstv6B+QG2OO/RaMLeg1SeeOZvQa29p8
OJ/tNQ7GfSfqRz1cx3dxyn21wxLk/sC5pR1pV+KQuCROipvKoVx1cKQc/6mY
70L2NLbqpHNVmNqVOCVuCV9cHqCGpWG/Md3aYc0rK3ND9Ps15r2JwzuTfiOa
rWJG8E8TX5bhZyt4nYFzUfeci+0c+kZzjPPIb4jfke03cjXwG9R8hfEFvPaE
72oJ9tfcynDm/oTxGb0l6fMWP0PgD0XcdxdvdxLOUe1HHCxNOsfEn0bwN6W8
BtVSpRuilvHM/0kzLgHv4Sy3KcezqP+T1It60r9GPUnXPysB1uWo59aN6FYK
M/sShybR0xHPrZr2BX5z4rduYBX1/aG+shyfx13sfXH/d4kjQ3N8ppqt/lFD
cb8h3ZJmGI57DapFGL/x/Q+OVcz2
          "]], 
         PolygonBox[{{2782, 2781, 3791, 1122, 3792}, {4775, 1814, 4774, 2781, 
          2782}}]}]}, 
      {RGBColor[0.921, 0.6725, 0.35509999999999997`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVE1LVFEYfscZp5m5d67OnUsmLUZz4aI2fbqPgpZl2SIIyihIsJlNFETL
hGrTB0T5QVhC0RdYEdkfSIsiStKs1AllRgaKoCJaaM/DcxaX8973POc578fz
ntbuYueJOjM7iy+Ob3dklqo3e9xgdtIz8xNmn/Nm3aGZF4M/Y9YJTA/AxaxZ
FYc/ADOEPR/ndsD+B9/zBq1LvtkT8HTAvxUcw0nxt5vWW/hfgd2YEBd5irAH
wN8Oe29KZ8k1lBH2dmA2GQgzhhiOIZ4N4PqFO//iiwHbD/9T2O/BsQf7H2Gv
BaacFo74vlDx0r8E3M2szpLjC74C/EeAmYXdAnsO60xaeY7BnnYxvMiqFqxJ
CeunvKsLcq8Bvxn4FeCrnu6Zgn3aU67VnNk53NEE+yXyq+BsE3Isgns7Yovi
yqEG/xbUYgack774ec8Z8KwGrgT88UB1XIC/C3cM4twp10Paq0zn+E+7kpPN
Ps9nVO8pcMzCvoF77yCuxaRqtcuUB/0JcJQdvgJ8a6Qesc9rkH8bMIvw14Bb
n1I+SznpZH+DfDXX64v4/8neI+YpX/4++C7j7jiCvIR1Pi8sazYSqCbL1FVW
saRZj0D3NsN3Ia6z3GNcrCNrOOz23gL7xlPvD4TSOrW4CXZvVtqcRt8mMsK/
Av4+8AOoRQyYiuvjeWCP4r8Mfw2+a1nVqYqzBn8//Pfgfx2ov1nsX08q35GY
uA8mpLm7nvaWc7rnt8OMBuI8BL6HgWZwNKN98jNW8pVcnQ+H0i31uzHUvHBu
3gXqHXvL+rLO067ejW5+C5HmrSUSH3VFzh6nQXJRE+R5hlwmAsU/jnXcE4Yz
x7p2pTSzM3nxU5vNThv7EMNiXvzUL98U5sX8OBusLWtc8PUWfAuU72BSNaGG
qKWOSHNZcPrkyl6Qi5qtJFX33lD2D3DWheJ54OaG+TPHR57epjT2v+al0TLW
755moAf+hUCa56zMOQyxVxDPH3BddXFxxjhffBf4PvCt2hZpBruc3jnLzCXl
S6fUMjmYJ3vaFqmG6yK9kewB61/vSy98q/hGMPbZvOaBc7Ezo3eEeVN37Enk
zv4Hc2DUrg==
          "]], PolygonBox[CompressedData["
1:eJwtlEtI1FEUxs+MM9OMM/P/6zhk0MLXwkVtetGiXSS0LKtNEJSRC8Gcndta
JPRYjAVRagvNICoKiSKhVYvQoIiUFCPNUhwZKKLHooX2+zj/xYVzz+O73/nu
ubelq6/zfNzMjrISrItZs/GY2UjKLF4wy+fNGtnHSAqwHxAfIvaH5HJoNlFr
liW+zhog/oT4GPF0khjxcmC2n9xjabOmolk3Oe3mGAb+coPZDmJ3qP+CfRLf
oYTjVcBaxNdonrOEvQRmM9iH8d0E6yVruMasj5qmnNlZ6puSzqkLe4C1M+k9
XMLepH4P+wT9bGBPwe8UtVfAGAVrMsI7QM7vDLrA+QO1Pfg6sZ8Rv13jGFXi
g6Fr8Zd1PfSe1fso/T2Gf3PRe//HebPEYnAYTrnGF4jfCL1WmvSCfTnvvYv/
U7QtwW8r8RIYHWBVMt67eupmP0/P1bjnrKLPCqsu4b45YqcLni9NzmB/DVyr
dvCXwZ/P+NnifAS8Sfjkks73BfZGvdmtiK9m4zg1bfRfAuMbWG8C107zkeS8
u+w3wSviG8euwOdnwu9wrcE1EPYJ+mnjvH0Fnw9pPAX+WuDcdEYFu0y8Zouf
Mc3Z10LHE6f75LcWHUsz8zbrd6q7Vc0gtauBYwlzBbs159zl24bWHbXO9SC+
MeJz0fmagXnsTM7xdOfv2fcIM+WaTrB/Hs2D5qW2Dk3Rc3vS+dxT//U+2zOa
6XrPUa7wNbuaMe2Fodma4bxK3O9wAb2G8q6t5vc1XD/hyyU8Z5bcd5H+4phm
v8Dam3aNroY+Y7o7+aoN3qN6leZ6m+IorrrzBbj0kz8S8zPW4Ftlv5zy+fkM
3u6Cz4rueBf2r9BnUZp8z/qMlqLzdVfl6H1o5h8S/6E7TnmNatWTepOvF7xS
3t+a/hD9JZmCvyXNqP6Ogeh9SOOPob8RvRVxPKdZKrrWXL+9yvifJf30xqcD
70G96A9ZxF7P+TxKjxZqH2X97xNnve3/jY+yCw==
          "]]}]}, 
      {RGBColor[0.927, 0.6875, 0.3737], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlM1LVWEQxse8Xr0d7zl27hEs21ibFtXCiOw/aNMiaVNCpGVK3636oEUr
MywyqE1krdokFBZBLgy7StgHQUQZBppp5fWSLXIV9PEbnrN4eefOmXnmmeed
uU0dJ1qPrzCzTk4l50vBbHON2Rz3ImcLdom7PzIbqTC7F5hVxWYDWeK56zOK
+QFIOWe2B4zHebNN+CK+LeIvrTK7RPwC94uVZg3g9JMbVJntJq5YISzHrObu
i4Q3VWt2n3qjfB/Ct4hdxv6EPUWtFmrdDc3Gs8JynGZuqxaPB2nuSfh8p4dm
ai1wjxKfS+PnwFmPPQ9mX6zcaur+jYT1LxKGc9vA50eRclcn1Od0gzkGRl2d
2S0EHKGWgdOOfQj7LRx2oMMgPAsZaXIHvPf4d2IfJHYi1eQZMUWwusDcBnYD
+WvQYR18hkLFHyZ+HvsU9tdQfY9lpUVDIo7n8bfE8r+izgz3uUppVwXWPnJf
htLO82Zz8vVWiodjey9euynRG5XImwik3Vawj3F6iHkO98FAs+EzksX/G8wb
+F8Hepvtsfr2GfDe2xLxuUh/t/OqO8DdwzmLPUTuR7h1kTMZSj/3O1d/C9fW
a9TCqZNv70LVc99p7CXqLhH3K9Jx+2eg9/d59dlyjVyrDNzKzEQj/gvEtPN7
Gp77Y+n9Lav8a7HmwediMqN4xymG4u99eG3ncB0uTyK9zXCkPr3f3rzyljPS
qyPW2xxI92hjjfZlpiB7mvtoLA5HuK9Gyn2Tk+6u/828eDtuRayZc31ysfa4
Pt1B30nfiWVyx3PqoQ28tYnm2efa98Axvd+HgfajMZEOrkk53QN/A+/zcqx5
8fn1ufeZeZrWH0ljWsk/A49difbWMfZify7oP2K2oN12TN/XD5He2mfBeXmu
v9OfdB+vxOrBexnOa666U93+AzZtrfQ=
          "]], PolygonBox[CompressedData["
1:eJwtlMtLVVEUxtete69er+ccO+cElk2kiYMeYET2H0QQkURRQpQZSmkWTsx5
YVhU0KRIHDRLCrSgHBRmDnoR9BSkfKQ9VLJJgwiifh/rDjZnrb3W/tb3rb32
qW3ubDy5wsx2s7KszsCsjm93uVljalaIzY6sNBvNmN0pms1HZutzZsv4c9jX
yT9HfDN7v/Ef4d/AbwUsqDT7lJgtUmADeNPYc6xN5b63n/wFcvbiFzn/AP8u
NcYyvldL/anEz64GrzM0e8s6hn0AjjepdYv8hxnnaHDdkzr3Anj3wBskfwf5
DYS7yP+Cfxp/LfWr8Z/jH8KvBuNZhVkGjJqsYw6CfSpw7XWl3lwkXp/z/AvY
B6nxA6wt0gTXj/hLxKbycFI8db8Hfk3Yh2OP7aLGELUXEj8rfT3U+xc5vvQt
Fcy+rzI7T35EvLvomqRtlL2n+BOh91o9n4H/UfCn815TXLSnmDTPk3s89tq6
v2XON5EzkXUN0pKNXWs/GDnsbXBuhd8A+fsiX7LFaQFuUZX3UjWqsHsD17oT
zDfg16R+n+K8LnWN0qoZ+Jy4JmnbiD+DP1npXHQHS/htoccTVgf2bOK5mh/N
VktJj/QugtUV+llpGqd/P4uuVTPaQe5V+vHH/H5b4Dpb8Nk4Q/xD5DMmfvXU
+JZ4jnJ/sXeJ+KuC26qhWsMVrlc9bwZ/O2s875qHqT0S+WyrxiRnr5Xei97Q
HH5Z7L0Wpzz27dB7J0xh642J/1dy2om/APNJ3jHvRz7TwtZeQ+xvSr1pg38D
/d4a+6yIj97W2cC16k28FlbBc9Vj9fpx6LPdS85Y6DVUS5peFv1OxU8Ywhqq
cFt74j4Q+Fm9qRx32V/y9X9Y1Dwn3lvdcR/YI4HPut70O86XccbK/A38JX45
dj7yr2CvSX2WNKPVqf8DdF5n+mL/B6mWaoqLaspXz9X7E7H3UjPzHi3/ASFM
r3s=
          "]], 
         PolygonBox[{{3085, 1127, 3800, 3514, 3515}, {3515, 3514, 3796, 1125, 
          3084}}]}]}, 
      {RGBColor[0.933, 0.7025, 0.3923], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVE1LVGEUPjNe58M7995pvIFZhElSv0Acg5aFG4laVOMiE1PBNMJNtamN
0IflphYG1VALw2jTpkVQ9LUqIms0plU4kThMEK0iinqenjdcvJxzz3s+nvOc
895tQyf2TybNbBynCedTymxrs1k1YbbSalaGPOObTYZmsWd2EnIMJwPf51mz
O4HZDALfw1aGfgH6WmTWAd8j0OcRfxbx7fj+gnwTLvZfDvh/w/133PfhfiP8
P+C7kZR/G/zaY7Mu6Bfh09gg+/98zE2fj5Ewd8H3GvQnsO+BPhYLD3HN4fTB
tw7MlwrCTOxt8OkHoE2Qj/CdQu0gZ3bfVx7mK+Eso94AZA9iJxA7FQjXzZT8
mgvSPcjZSL0Pw2cAec8hfwlyDvYfyL+aE6fkdg2cTAfq+x1svbF4Jt+3E9Lp
9yKrXqdgP44anei3FokD1uIdeVt2/nuRZxD2Y8h9APppYKgix85YXJGzoy5+
EPJuKP4t0D0xF009MP/VFrNkWrw1JYWt4mmW1ZxqH450P+KJxxHgXAEnDfT1
FrV/wn4dPou++mXf5JKz53e9VfjJN2fAHI8D1WG9ssNKzNO+doIzyBQ0D+a6
hz66PfVbgd/DSPKVL+7I05useCE/Q7h/4Cum6HglZu7Kkq93MA77qUB8zIea
E/Geh217LDvvf0fiJp3TbJjrM+QvZx+Fby2r3NxH7h3xcydSqHELddNOEhv3
ajXSG+Fb6cXdS9ztgqw4bDuQM5HWnrNGTyy+DkY61Gvgte7rbQ9z9wuKuezy
kTdyxNlzBxZCzYEzJV+v/XUuv0KvIWYUsfm82W70GOW1p/TnjMjlvoz64k7Q
XgSuLbHsm2Pl6HT/GXLJukX3PsnPDTefDvfOF9x+/gG3i9BL8OlvUd+HvPX/
COUMYp+Fsj9lL6F2cinUDnY7znNux/jurxS037OQfwGyj6s/
          "]], 
         PolygonBox[CompressedData["
1:eJwtk81LlGEUxa8z44wzYzP6zhuYRVQk9ReEGQRtCjcStYlcVBIa9EWrCAra
RIWWm1oUpNHGoNoUtKvoCwIjitSQNjETiWLQMqKo3+nM4oX7cZ5zz7nP864f
OrnnRCYidvDl+EaSiEY+Yr4lYqYccTRxvKE14hjx2IqIH+T9YEeJt1LbwsEZ
am/Bj1ec/+J7X4y4KAzY820Rg2nEBTBTYLvpL3fSo7aMgJS8j/gS+E8tPqOz
m1LPX8v8zcSPq551Br695Kv4Boh/wvGIXqNGH67bYOrEs+gZJh/LRkyXIu6R
H896xge0dDIjnzFmjt4T8v3M3s68jg7i1No1/zP8h/H7pbmfWc7PF61FnuVd
GqRlN7U1nF2dOlb/IfjFmrXNkS/VvEPtsg7nMNyDVfe6qL2Cexu113l7lvfl
srG6jzp5T2pt2tdG4ndFnz2Ax3H6AyX7kUd5nSzZvzj7EnOIS3f+He6dcDxj
1kEwu4gX6V/O+s4XiG819SqfIH7a3J9maHcL7fbfg4duzk9VrG0lHHeJvzbn
iaOB1jcl87cUuCP0PAezL+eaet9qzbcC5zzcbYm5pfFB2Xequ81w/iq9Aphs
xrVR8o8Vx9LYTu9m1W9TGm8QT5e9W+2kF3yObyLvGWc5e63kXa4jP01+veTd
TILJgx1PPFszf8N3JbEX5X/Ih6rG680fIn6JZ57D/zfam/pN6f70ppbK3ql2
qx28YN6piv+NO9TO0f/b7l32U7tPr5BYi/aRTaxRWjVTWkdSa9E+j6TGCCuP
rYk5xCX/ehvyLO/6p7rA/wOmRY0T
          "]]}]}, 
      {RGBColor[0.9390000000000001, 0.7175, 0.4109], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1k09IVVEQxiczed2r7/LOvUEGLgStXLrM9koRCQXpwohE/LMpzQha2K5F
GLppU5uCF5RWYBvbSLqujUgG2qoIJXsvdz7MoH7Dd1scZs7cb7755szc1sGb
l27UmVkv5zDnTWz2rMGsEMyqqdlmvdm1xGyR+BzxQHz1qFkH2Nmi2XST2RSJ
D7GdR7gXzM7z7UNk1nzIbBL8aKb4CLYKT5X4Nzg/5pj1oupMw1/m/hy7z30e
fwr8cfwJMF/qhWuGv0zuOHXvUrdSUu59sDNBnM79NhZXTCzilPEXiHWhYww9
Z7Al8lvguRippmO8t4NE/dwK6tNjG/T9iHgNXI23GQ7q3d/A38i17RK/nkjr
ILafs44/gI3gewW/oW+bezv3H9gV+PvALGPjRrMh/DX8riDs00hv7/mu41gQ
zzt6GcX/jj+GvZwJswjnBTj66fGA4Z7O5J/CPk7U5xPsTJNmtUSt8SDfY23g
roBvx57g9OJvNyrP/flck2t7Te7JTLPwmWyA6wSzlUqH6zkbVMP5z4F5id8N
1wvsn/ydZ8FczaR7oag3niho1j2Z/O5M3xyzQt4q/ffgzxH7FCs+EqTd9Xjv
v1Nx+dxcq2v+m2v0ufi+/SzJ/z8r3w1GbcuJON4n2lff2wp19lLpugPf7SD9
vi8+N98l3z//5pgK2Hux6uyU9G/V8t3+XBTed9Bn6LvkNb7mtQbo91eqXOd4
ECtvP5Um17ZDL/8AgQ+JeA==
          "]], PolygonBox[CompressedData["
1:eJwtkjtoFWEQhSeahHt3c/fG3RVUsBB8limN2CYooqDgAyJofCRpYmIstBCx
sNCIVoJaiKAgiQhaRMvY2Nj4wAiJlSA+4o2ChcEH6Hc4t/iXmZ0zM2fOzJr+
E7uHl0TEVl4r72Eacac94hfO9XrEId4c9jveYez5ZcRbImbwv2J/6ojYVTH+
BvGBMmIcv6st4i9+X93YKrWf8fmCv47YdvzbtYh/5Af1esFMZhHTvH3YZ5dG
TCURlRwcfCbBXEr9ZKvnKnrdA98DfgT86ZprqrY4DBK/Rr/FVtd4QO4Y9Va2
mN8p7C28pM0curG3Jc4Xx8/kXq6Zizj9IP9WYux96i0H/yS1rRpT4M/DZ1NY
w4R4o6BfWMOFwppKq7vEH5Gbg5lod45yE/Q4Qnw1PTvp/ZGcroo1Pwd+APwO
1cJfwN/MjEMVa3yA2sOZtda/7tIaiv8HegzmxgirmrP0msP/wwHsx98Ifmfi
3uLwKjMH+UfxU/CLhfXUTD+x++u+DfnHwN5szqd5XlbNWdzH6d/gXr4X1kL/
vhXemXa3l/5r6X8y9260gxHsUTisaN6PZttQmqs0eEPtNLeWuomL+BdS91IP
3e5Q7tml13vdXulemlmzz3fYFof1xGar5q597sFvpM6VhsepdabJVzf3IvXO
hdUOH+P3lcaL30Hsicy3rZvR7UgjaTUKh17irzNrq5t8Tnwmsy3N32I/rbuW
OE5L28Kzage/sXtK15KvW7/a1E81rmD/BxNWh0g=
          "]], 
         PolygonBox[{{3337, 3336, 3058, 1111, 3776}, {3023, 1094, 3752, 3328, 
          3329}, {3329, 3328, 3754, 1095, 3024}, {4072, 1317, 4071, 3336, 
          3337}}]}]}, 
      {RGBColor[0.945, 0.7324999999999999, 0.4294999999999999], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkjtolFEQhWfzYvM/suv/r4WVBMTCXguTiKURsRDUJlrYJAFRWdOIIARs
ok1IZeULUmilRRSEmAjaCBKxECUI2uka1yj4BMHvcP7iMnPnnjkzc+YOnzp7
5ExPRBzm9HLaQxHb+iJmsGtpxOtaxIU84mXl1/Cb/RENzl7wn7dEXBmI6GCf
JxFXIXlF7scGPPjjifmEWST/dm5Ml/djfcZkxMcL813ifYH8GrGb5N6n7hP8
a+AHc+PF/Z4zTA8HydsFz134n4JrFfZL7O8yYjtvl+FIKtws3D+4fwc7n/tN
mE2wj+DM4VwfZAbOP+I3iI22PIO0+QJudz1iA3u613jpcj3x/Q6YJrz9iJpk
Ed9Sz/mY+HLDuu0v3If6KfCfUesN/kQ104sBa3KSexeekZZ1Vx3t5FBhzFv8
NHMt1ZR20nCU96XEHCvSsmnNpf1F7juoNQ33FGeT3EnsSsN7XcVuLTyLZnqQ
Wtcl4qtD1l97mEvNk4L9UPU9jX8r8e60w2XOUWkLdqNhzVNy9xXGCDtSr/Tv
sZW2mlk44bUr7V5/4B7+DLkdZj+P3VP3XoTfiUbHuXcy96qeH6bua7ZuXTJy
FsnNsX/Z3xjxP9huaa6v2BMt4yewP0v396v0rMKrz7HCe9Q+JysN32WOqQfN
NlVYf+1B/0h6qiftQf1rtgPUaINfY//nwH8i3i5cS3HNvJ55Pv0F9a4/o/h/
QpN8oQ==
          "]], PolygonBox[CompressedData["
1:eJwtkjtoFWEQhefqJiZ37+4mu5silQTEwl5Bk4ilESvBRxERrBIQxWsURBC0
U5sUgp0KIYVWEURBJFGwCoiSQpQgaGmM8WrhE8HvcG4xMOefxzkz84+cPHPo
9KaI2I0l2IEyYqQnYg/+BH4b+9Qb8b0R8beI2MBubDZex/9ZRYz2RXRochO8
lEe0iA2T8wx/mrdtieNT+Glp/JycB2nElsy5R3j7Br4IfkOsgc01IzLy53ud
f4v6RaxA3wC2VPhNsTYa9tdwFo5J/0Juk3+F+HHir/qdKw2XiN1tmkuc5+Fe
zK1FMzwkNt3dh/AU/iwadyTW1AJ/Zf5d9NtgvhNwTzQ9z2FyntJrsja3enws
nKPcnbx9ofYYeJ7e1+n3eTBiX+n5pGkvfid1L/XUri6Dh5MuZ2WN0vaS+oPk
v0vti+8DvddaEUf73FO7m+vOq7ftaLvN2wvwfWpq6kdr6xPHWO2b6nbj5P+B
bzbz7fUnzpb+E8Jr4BnwudK+/sgyXCu5/R56pGhZSH0v7bCp3EHPLj7N1oFj
a2INq+Q/Tq3vFD2GSt9It8qY5wnc71vWp5pf1I6VvrfmHce/kDumP/qD+Exu
Lu38Kr1jwNqksYG/Xvk2qlFtVXo30qvbr/abW3ramU3+P+IrxO7lxtL4mvxJ
NL7t8unWvyvvUv/vGvE7hWs1o25RluYSfkT8P9d+ek4=
          "]], 
         PolygonBox[{{3471, 3470, 3772, 1109, 3773}, {4721, 1769, 4720, 3470, 
          3471}}]}]}, 
      {RGBColor[0.951, 0.7474999999999999, 0.44809999999999994`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1kj1MVFEQhQ8s4sLuvqdvtzKhsCKxNlHiaiQ0Ala2RgtJjFAs8S8kYEIC
HY0YCzqwgkoqaPixMS6FhYk2kI2iiYWFIAgFhYXfySzFzZw7d+bcOefeiw9G
79RaJfWxcqxGUbqSlw7KUrUijYCvEedS6aRNKmXSPPgfeIF4j7UDHiL2c/ax
XRogXmfVwVXiDdYW+Cbxc4d0iXuelKSH9Hyj95i76ol0F/whCY6nDNNokV6z
7yG/UeAsjdw2eJz8BXgO6Z2Aa5v8OucTzfwn7nkPHgQPdEqz9LylpswM35s8
O+R+g7vPSPvEVnT2ofcHHpyF8w81B9T05kO7ee2N9S5yVoPrF7OOEv+WQ4s1
3Wb/gvlXOiNO5YPLtZO5wOawt5TocRb5We68X4n6n8x/4jcAfy0Gt7HvPSpH
nGa2lnPSZeYXcZX9EnekWXhhT8bgrDf12j+f++3shTVZr/HprO+S8N5v5/7d
trjb2r8UIme/i1n02dfBLHqW4Ng/H9r8LzaT0PWS+t1i+Cjro6eLmmdJzLLY
Hn+iksXe/yvJIr9C7aM05hgmrrO/Cn5F72EhvPRb+T+Zo9ERvtifPWa5VQmd
/r/uq+Wi7nkp8BtmnimF9q00NFjLMvxradS41hqsxW/1H19uez0=
          "]], 
         PolygonBox[CompressedData["
1:eJwtkj1IlXEUxo92e7nX9973rffeSWhoCloLKryR0lLm5Co41FA5XKGEoKJA
gqAlbXALxcGmmpKg1M3r4BDUYkhZINGiaR/g0NDv4bnDH87Hc55zznP+x6+O
D7e6I+IUr8SbqEW0DkWcxXmXRmxWIk6GY2/ziFdZxG3sja6Ij+RrRcQB2Jf4
Veynqe2L5YjuRsRNarbI98Jxj9ogNlC2fxd/kJr1hD7UfAU71+Ne56h5Rn4j
dU49r4D9DuYn/iQco3DdAkNJjOE38fsatj9RPwr2EfUL4JvEDuoRM7nn1Qxb
1Yjtirnuw/+E3XN6vEi8g3a5Dv5LyTvcwP5cNZdiyv2p21aP39jXcvfWTG24
p+B8CPcIsb/wfataG82gWXZ5Jw6zG/h5sGu5Z9HObex+5llLrPcy/mpmLnG+
oclzYv9KnnkR/r3U+ii/DHYlM59i++SmM99WN32MPcE71plXWo7T70divLSu
F9ZCPRqFe4pbmBb++4pvqX0uof1sZx7xfyDXBNNOfL8H7LdfN16a/cLe450p
Wz/dain17fUH9BdVo1r9kcuFZxb3An6G/zq1rZ7SQhpJK/U8X1hTaXsajbuO
8N967EvzHd2q87+k0VDhP6P7aaZNbrVz1LMptot9p2Z+3eQC+P8GR3x+
          "]], 
         PolygonBox[{{4077, 1319, 4076, 3339, 3340}, {3340, 3339, 3061, 1115, 
          3782}, {4671, 1735, 4670, 2721, 2722}, {2722, 2721, 3730, 1081, 
          3731}}]}]}, 
      {RGBColor[0.957, 0.7625, 0.46669999999999995`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkjtoVGEUhCcbI9ls9l7z321MIYg2VraK+MZCgw8sLSwU26ygoljZKSKI
iHY2EiGVNj4K00VXCxtJY7Gg4qOLYoy93zBb/Pznnn9mzpxz7tZz/dPzLUkH
OOOcz9PSGomHtTTdlWZJrhJXRdq5QbpZSft60hbiK8Q/eNs+IZ3g/TL4wZi0
1JFOleT9/oizTP45+TG42+DeIn7flr4RX+T9bC/4n8SvO9Gx3iZ0FjdKM9zH
OXvweIO8wPbHg2vB3YHOXXgvOqnlmtZ23v38baTdk9J6E9/2f61Kb+7x2FQ8
2du/Jj7sp0/No+hfgvsRvw25MhEfS54L8bAdj56Paz9Bq8X9YFTnDm+LfF+v
oq9evNpbjf7+kl6udsMxdwGNlXb6XKDOoZK6y8QD8kO45+vsw3Xvcd/uxtd3
3u9X0XyMzpCd/mYGF+p8O++ac5wPePuEl18z8bnKPUv+GfHmEo/u3X2tgJvj
++mopjGev3Wtv7eX3djDQbjr4M+AewP+JXW7YE+WzGDXZDjeiWfkeL4E82oq
vdpba/Tt/Fv3VGefX+hpUGcf77gPl2A9e9f0Ts3xvKx1pOSfNveruVUw/sfX
mvj5w/0fyP9kYQ==
          "]], PolygonBox[CompressedData["
1:eJwtUj1IW2EUPYlJifl5r3kvSzMIYpcudrVICyoOGrTSrQU7VHA0hYIWJ0Fw
EBcRnLoZMJMutkvc0kaHLsXFIWCLXVVM4u45nAwf3P9z7rnf8Kfqu5UkgFG+
FN9hFkgmgN9PgEoEvOUr0H+eBhZo/x8ExmH/Ywl4xtgxa1+yeT8HtJkPmKsO
AKsFYDEE6uzfYc1tEbjMeXbEml/M7QbubbGmwdxBaFszy5wNYoww3yHJqzww
ERlf/ZO0b4qePcSaTfb/zbtWPYmSY8q9ygDdmJiB9ymTX4t2l/n3KftZ8p3N
2lasyXwvdu8dZy6T2xlfnDaHbdZ/o9/kvC+smSFejT7S3kG7SBPtVyfHp+Rb
6+tbYeyY80PGXqQ84ztrq5G1FccV2vN9X3hztP8MGks9G+y/J7+xjPddD7yD
+H+g3+O8r4H31w226C+RU7vv6zZHgbmIk24/HVlb+VORMYR1zXdO7IfYWNKj
nbcmssWhw9y/vv7qSVKPz6F7FauGvrnmS8MW7bWC/4r+TCP0n5EvDS+Id5qz
lortkcvrkvG00xvaJzlrJ40D8v0ZeHfp94P7FCNrrxrd6hEjz1xx
          "]], 
         PolygonBox[{{3759, 1099, 3027, 3451, 3452}, {3452, 3451, 4027, 1294, 
          4028}}]}]}, 
      {RGBColor[0.963, 0.7775, 0.48529999999999995`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFkr0vQ2EUxk9Vmra37tXbG4LJ7B8QQqKIGHzEnyAmkpaBGERZmGx0YdOl
CWFqSITFgAgRg6VNxGpAMPn8HaeJ4c157/M+53mf87y3dTw7lqkRkXZWmNXg
i+xERA4ckbU6kUXAS09km/VTK1KgluKGn7oinymRB/AMeBF8FnwAjbOYSAt6
S3DS+o1mD/UN3ZeQSBztO/bn4H3guxHT3+esQp2KinD8p6Way/Bv0WwDm2Nf
cg3XO8sJkQ7473g5pqmD/nXOL/BUQS8M/9CxOxrR+4JXBF8FW2G1wp93zZN6
ewVbYD+D/p5rs15HTGswEPmAv4W2V91vsm/2zb/mpD3aW4ibV/Vcxvuobzoj
1OekzTnhmV/lK6/Xt0z6qd2B5dBFffTMh76JZq2Zf6dsNvVVdiwD1dTZ1J96
S6Kz4ViubmB96ej//Fqf8DIE74p7h6mhwDj3CcM0Z70jz1yd9J849q76vjcx
m1v/GfWfrXqb9iwX9ZBAL1/10OTbzOpzkuoEppNDr943jnJzVf0PZjzyLB99
k1+4LmUY
          "]], PolygonBox[CompressedData["
1:eJwtUk0rRGEYPcN0M5/X3JkIq1lY+Qcjip2Fj/wEZUMZFlOyEDsLS/MHZKMo
q4kSG2WSSMpqpqRsWKBYja9zOrN467zPPR/P87y3OFeeXeoAMMgT5zlPAcME
K53AWgaYD4Em76UuoJEG3nLAfsy1d+LVLFAkpgwV4lYeGCB+Yu2beJf6P+LD
ADghaaHtJ/5lgp4ETfpVmFej/pj3g8AaabdZG4JrPRGww3sp7pq+TbF2E9jj
mfy7hPNb5EwUgBGexS5napYLataZ9UH+J7OuQ9+lvyJOF6yVR4r4K+/ZNfNW
yhni3jJzhtm5yPwj1rojc8QdpyZG/V57fvV7z95+896NOD/EvZF3I32V2unI
3uqplqQ+6bfQm1TZ+2Pa3vIo03sj491pB5PUjvHUA9f0rZFwtjxOyX8JPbv8
X0O/md5COxplv9mCe9FMIfFy6Czto57wPyEvvcEZhX2R+Zqxn3iz3Y96eOD3
fyZSW3E=
          "]], 
         PolygonBox[{{3030, 1736, 4674, 4035, 4036}, {2726, 2725, 3733, 1083, 
          3734}, {4036, 4035, 4677, 1737, 3031}, {4676, 1737, 4675, 2725, 
          2726}}]}]}, 
      {RGBColor[0.969, 0.7925, 0.5039], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUjsvBGEUPeySnZ3dmZgZj9ZKRCUSrViFrFcj4hcoJUg07CYKjQoV2yko
FHReQUFDyEaLRBCFigKJzvPcnCm+nO+799xzz70zzWNTI5PVADp4EjwNAdCZ
BBY94MwH7qqAGxd4zAAfJE4wduEAT+SM++IZf4XoRkBfCsgQN9PANAV7qZfl
u42cZeokahS/pG6e3FxSuq/UamXuhThEfjvjC9T8CcX7DdVnt1a1lh9g/JO1
RU86c8RZX7EZ4ih1SuQ8OHpb/Jlz+JFqPeIRPZ1Tb4P5Ck89PVz58mqe/9i3
7MmzzdQTqZf1vHY0z5avvPWyfRU4c4U++wPty+bLs64lkP8ccYf1Xdx3Ia2d
WS/zZ9idUs17HbBE/hvxgPxh5u7pq5TVDk5d+Tb/h7yfuIpbfs3VvprY6zie
cZ3c71D6X6HmMP3t+Bub93nW7se99oi3cdz+Bfsetvci76uu7o2BdE1/kDP+
AxH8U2c=
          "]], PolygonBox[CompressedData["
1:eJwtkD0rhnEUxs/zQrjfct+3lxUlk8UqDPJ42eQTyGR4lAn1JJNBz4ZFPgBG
CwZKKWGVUmSwGVA2r7/TZfj3P+dc1znXdU7X7MJ0tWhm3bwy77XVrN5ITrIe
mO0lZpcFs0NqPanZOfk9+UqT2UwOLxU2AH8X/ij5Ykmcu0AzfNYw/O+Mn573
omojxD+ZMK9VmT3HOyjIwxtefsH7ysIfQ7Md8A/iCXoS+h+a5cU1a5HZJLUL
+vvpmSLuSBV77Rgva5G8XTG/AjaeKvaa73YUiOv7tIM9h9JzDxHzlhPN89pS
Is/ubQgPX3jdJy816GZ+uzp6g9y1l9pLIo/u1Tm3eK/FuoXvvIH2aiytCvMC
9MJcsev57vO8p3++32ozllfXO6V/rEV6bcy/Bj8LhLnmNtzOVHzf8QTsJhHX
e9xrnOu2vuMW+Gem3dyTe/sDnN9L3w==
          "]], 
         PolygonBox[{{3332, 3331, 3036, 1104, 3765}, {4043, 1301, 4042, 3331, 
          3332}, {2730, 2729, 4679, 1738, 4678}, {3764, 1104, 3766, 2729, 
          2730}}]}]}, 
      {RGBColor[0.975, 0.8075, 0.5225], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUT8vQ3EUPdrXKq/t856nkSiJf53EV9BJGgaJ+AQmCSEREoZuNj4CiZFG
LNXFpkazSUgkwswHwDk5b/jl/jv33Hvub3pzb303B2CRL88XVIAanacIOKkC
deVT4JLxbwDE9F9CYI1+l/UK41YJ+CgDcwmwQPwWOR6IjwvAfOK+g5K5Zhnn
mL+OjBN+grnPwDw3A8Bh5HiQ3Nv03+nv055zbpf1MeaX2ZOn3xkGNlLP6hNz
FZl/ivWz0Hzfsecp36G9yHhmiDml3yB/m1oKqfHqq6XeW7rr2c7iHkmtQ7fR
DXQr7fFG/U3u/zcKPA9ZV5v6bovm0bzJxFY6+tl9Wok1iOOOnD+x9Uq3/kD8
y6z3qvb1P6up77lC+xX4VtpJ89UrDU3Wdhgv0R5Fxh1nM3tFz7sPvd84dwhS
8+j2jcSYx9B84ilneqTrlfr+AfhlREI=
          "]], PolygonBox[CompressedData["
1:eJwtUb1KA2EQnOQuMT/mzjvPIBiFaEzlO5gqBAUF8Qms/QERNIWtpW9gYSci
FsY0dmLlA9goCoJorQ+gzjApPpjdnZ3Z3a+5tbexmwfQ5Av5nqvAGkE9API1
YDEFkgKwxFqL+DJmfhQ/lYFzxr/kXxeBO/YGGdBg7ZO5kPg7Aa5ywDvjH+Lj
CGgTj5PTJ96PXVP8SL251PoD9swS74zqnRLwRtIte4Kc5xtG1lDvNusd+i1n
xupR7wrjg5Jn1Kx9vq/QM55E3lFa68y9cP5uxbFucMP6Yexd1HNEPIjM1QwX
FWtISx6r9Eoyeyk3QfzB4Xola0jrgR7Dom96z3g+9a7aeYF4OvUtlTsj97Xs
W4u/mdlT3tJok9sb/Y9yXeLTqu8tzxr5Y5m9lSsQ/036lorFnUmtL/8G8VRm
b+1QJ/4HEvE+aw==
          "]]}]}, 
      {RGBColor[0.981, 0.8225, 0.5411], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkD8vRFEUxMfueqy39tmXR+NPSJZO4zPQyGp8BHoSUSMSjUIiCo1aNITQ
KlBs1kdAhw+AqDR+k/OKmzn3nJm5c8/M2ubqRkVSm1PlzOXSNsXFkNRfSEuD
0gC4k0m/ED8b0gj3Zfot8Jx+t0/qFKGx9rYpvTdCm9A/475O/5T57nBwrtDV
mc3XpAPml9yf8flD95pKb9QVuGNwOviMgiucBfiHzXjfWmfaK7M5o/X2eUyD
Z/5+Fmgf8+6SyGOeM7me5t/fLemI2Rd4k4SmW+Zwnhc8J/OYTYE/Jf+Y/kka
efynCWbX9MfBdh7vzYI1ZotkqIK9LPbgfdyn8Y53+VDu4YleUe7H3r269EG9
lUVe+1vzD+quO0o=
          "]], PolygonBox[CompressedData["
1:eJwtULuuQVEUHI/cSA42J4fGIyToNL5BJTQ+gUZF4wNE+AuFUkMI7S3uVXj8
ApXEJ+jNZJ1iJbNnzZo1a1cHk/44CiDHirOOaWAaA54R4OGRD4BuAmixufKs
hA8/QMkH3kngQ4MmuUBa1iVimh5xltVJmGbtgGXatG1yL85ene3Szhvxmf73
8N2g/yLUyyNDrwK5PXcP2R+lrIRP5Grs/Yfz4lac3TnzErcl3jjLJ48i9XNn
WZVvRlz3zUv6P74rvnlp5pfeZd9u11teukmz+qM888UCu02Zlf0LFswuhQ==

          "]], 
         PolygonBox[{{3958, 3957, 5127, 2117, 3299}, {3948, 3947, 3954, 1252, 
          3953}, {2957, 2956, 4593, 1678, 4595}, {2961, 1678, 4594, 3947, 
          3948}, {5126, 2117, 5125, 2956, 2957}, {3298, 2116, 5124, 3957, 
          3958}}]}]}, 
      {RGBColor[0.987, 0.8374999999999999, 0.5596999999999999], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtjr0OAVEUhAe7smvFxrqVhq0U4hUkGo2fwiOo/URBjUSp0Il4BVvoNSo/
rScgKuU2dObm3GIyJ3O/e+aE/XFvlARQpFLU1QeUDVzoNj1gWGNesYChA8SE
Tx5wTAPlADgYLqKvPeHSCnCoJvkMfZeTPd8sMCf3IbOklwLZE9KrlvyNEsDM
l54n+a35++Mc54XRPXvmdc5nTzjNr5h12Ddlb5uuqBbnN98bSu6/uUDB5AH9
Zf7qTt2hu/S9d1fuXDDvmp0PZhNfbhz4Ij1veMMfzVcquQ==
          "]], 
         PolygonBox[{{2506, 2157, 1063, 3710}, {3717, 755, 2118, 5129}, {3010,
           1086, 786, 3323}, {5130, 2118, 755, 3956}, {3320, 786, 1086, 
          3739}, {3455, 45, 1300, 4041}, {3323, 786, 1285, 4013}, {3735, 45, 
          786, 3736}, {3956, 755, 2157, 5185}, {5126, 1063, 755, 3299}, {4014,
           1285, 45, 3455}, {2961, 430, 1063, 4595}, {3710, 1063, 1067, 
          3714}}], 
         PolygonBox[{{3739, 1086, 3740, 2711, 2712}, {4007, 4006, 5196, 2165, 
          5198}, {3967, 3966, 3301, 2123, 5139}, {4641, 1714, 3005, 4006, 
          4007}, {3723, 3722, 3970, 1259, 2507}, {5138, 2123, 5140, 2963, 
          2964}, {2964, 2963, 5129, 2118, 5128}, {2516, 2165, 5197, 3722, 
          3723}, {3969, 1259, 3968, 3966, 3967}, {2712, 2711, 4640, 1714, 
          4639}}]}]}, 
      {RGBColor[0.993, 0.8525, 0.5782999999999999], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUDFOAlEUHHAlu3zcZdffCtl7aOEFKDyCB4CGGgItBWuCcYGCUFlyBltt
vYIJsVZC3MZ5mS1+/n/zZubN+/nj6GHYBNDjueD5CoBlCzg0gG4IrPi+If7m
gDv21jHwROw7EGecSNP2wG8KFOytyd2SV1F37gAbJ82J/ZL4LfkvvKeJfGa8
d06z/shZxJr5GQEfkd6G9TN5lm2gcQk8t1S/Jqpz9o+B8lwRr1Jx9vS+98It
r2W03cx35bRH5jXffAwPvXDrX3vltLyTWN7vkbCi/h/LZFls759Uf1hSO6/5
pht4+Vvef5qYNKU=
          "]], PolygonBox[CompressedData["
1:eJwlUDsOAQEUnBU27C7L7rYiexCFCygcwQEodBKFE/gEsduIQu0OSlpXkIga
ERozecVL5r03b2by0v6wNygAiFlFVhoBTgn4EbeI3w1g4QJHB1j6wCgEbiTe
WWPiL/cr7utl4BQAG89u15z9uNv7hqV5IH/LfuaahrQy9nP2D/aT0DjiSnPn
m6e8dfOk3rUCNGGcbgJ4iWmJUyb+BObf5iyvWSZlk8eL99PQvKRxoVZWM65u
lP3MWRWm2Uksk/j6Qc4sUWJemsXEfwTOL1Y=
          "]], 
         PolygonBox[{{3008, 1084, 3736, 3321, 3322}, {3322, 3321, 3738, 1085, 
          3009}}]}]}, 
      {RGBColor[0.999, 0.8674999999999999, 0.5969], EdgeForm[None], 
       GraphicsGroupBox[{
         PolygonBox[{{3009, 457, 3322}, {3964, 1068, 3715}, {3965, 434, 
          2969}, {4601, 434, 3963}, {4005, 437, 2977}, {2710, 866, 3737}, {
          3431, 866, 3973}, {3972, 437, 5057}, {5057, 437, 2976}, {3962, 433, 
          3955}, {3266, 718, 4602}, {3955, 433, 2968}, {4341, 718, 3721}, {
          4596, 1068, 2962}, {4597, 718, 3266}, {2971, 434, 4601}, {4012, 866,
           3431}, {2962, 1068, 4598}, {3322, 457, 3008}, {2970, 434, 3965}, {
          3715, 1068, 3720}, {2975, 437, 4005}, {4603, 866, 2710}, {3725, 718,
           4341}}], 
         PolygonBox[{{3973, 866, 437, 3972}, {2977, 437, 866, 4603}, {3721, 
          718, 434, 2971}, {4011, 457, 866, 4012}, {2968, 433, 1068, 4596}, {
          4598, 1068, 434, 2970}, {2969, 434, 718, 4597}, {4602, 718, 437, 
          2975}, {3720, 1068, 433, 2967}, {3963, 434, 1068, 3964}, {2976, 437,
           718, 3725}, {3737, 866, 457, 3009}}]}]}, 
      {RGBColor[1., 0.886, 0.63], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFUDFOAlEUHGUxBHQ3y35aE6yVSMIJTLyANRUHgANopyRaSGNBQWLstaRU
MRptLcQb0JhgDaUzmZ9Y/My8tzPvzdtmb3DS3wSwx1fiey6AnQrwSBzXgMME
uEyBhwxIysA98Zb96QawyoFz1ktqjgJwRv5Dfhp74rRiVlgv382W+6qFy8i7
3PlL/skwHeI3dy3obSf2SPMV3BtVrZVnl/Vxw3w/WK/80gnbcf4HM9RZvxIv
MvuHme+U7qXwXPmeCmeQXnneto3v7OcVf1OtGXnUXKfu3/HGde679G8mNWe4
Sn2TuHYoqzK3gjNp1zwYO1FzEP73/wH2Yj3+
          "]], 
         PolygonBox[{{3963, 1257, 1683, 4601}, {5166, 2140, 719, 5165}, {5061,
           719, 2066, 5062}, {3715, 14, 1257, 3964}, {2976, 1076, 2065, 
          5057}, {4341, 1493, 1076, 3725}, {3973, 1261, 30, 3431}, {4599, 436,
           1260, 4600}, {5053, 228, 2061, 5054}, {5332, 2066, 228, 5331}, {
          3721, 1073, 1493, 4341}, {4601, 1683, 1073, 2971}, {5056, 2061, 436,
           5055}, {5444, 30, 2140, 5445}, {5057, 2065, 1261, 3972}, {3720, 
          1072, 14, 3715}, {5186, 1260, 14, 2508}, {3431, 30, 1284, 
          4012}}]}]}, 
      {RGBColor[1., 0.9051999999999999, 0.6659999999999999], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNUbtOQkEUPBEv2WsIj+z6ATQmxmijX0CgUwp7Ch41NpD4Gcb/8QVipYkJ
xPgTJGghdDiTOQXFzZmdnTNnzt567+Z6uGdmx/gK+Cb7Zl+ZDiE36+P7hOC3
BBzMLpI0KYg/x7kH/IP7aTSLwCfgWodmt+hton5n6qH+Cvdj8H/AK/RkmNOu
mL0Af4C7BO4E6Znhvqge6rqolR3Mueyh38g931GH4BtJHDF55h34LszIvbbA
dwfKt65KTy/O5H1wzZFznMt75uH5EfuWgR9QlyVpW8j/FJXzGfUtavbMOXrR
Z1OTx7qmvrLvwrnR33aelGGR1Nt1TZ5Lz76+8/R89ffnfxh4fvqcJr3pmfvl
vtc/qCNAdw==
          "]], PolygonBox[CompressedData["
1:eJwlkLtKQ2EQhAfjkXM0eJTzi2BnY+OlUJ9ASCpjkT6F0To2Fvb2Kj6AT+I1
XjpBUMQnsAuoRWKn37DFwP7/zszO7mL3oN0bk7QAxsHFlLRUSGUu3VTScEZ6
gVDxfuD9CBJ1H/J9XTqZlAr4OXhN0hro0FdNWqFulNIf+mdwB3+dv136e+CH
9yn69yz8mmVorD3CrzEnjZj/kUUGZxnNSucTkdFZncFaz1xFe4zHYRGcX7h9
8u4Xkfmpihnm2/OM2fNoWvSG+H/idQVnOo+dvNsO/KwWHHO3QC+PGZ61XcZu
Xf426C2nuJV3HuD3luI2zuAsmyl2t+cX/dsqbm2PS+rvenj5Rr6V/9xzpmvq
f3OlOg8=
          "]]}]}, 
      {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
       GraphicsGroupBox[{
         PolygonBox[{{732, 243, 239}, {3302, 1225, 5143}, {243, 732, 235}, {
          1223, 774, 732}, {3312, 1230, 5172}, {732, 774, 235}, {5170, 774, 
          3313}, {247, 1495, 239}, {3265, 1217, 3909}, {1217, 732, 239}, {
          5060, 1495, 4342}, {3309, 2139, 5163}, {5143, 1225, 3918}, {2704, 
          229, 3910}, {3314, 774, 5170}, {5171, 1223, 3916}, {774, 1230, 
          235}, {1217, 1223, 732}, {239, 243, 15}, {247, 239, 15}, {1495, 247,
           229}, {3910, 229, 2703}, {1230, 1225, 235}, {2139, 1217, 239}, {
          4342, 1495, 4343}}], 
         PolygonBox[{{3313, 774, 1223, 5171}, {5172, 1230, 774, 3314}, {3918, 
          1225, 1230, 3312}, {3909, 1217, 2139, 3309}, {5059, 239, 1495, 
          5060}, {3916, 1223, 1217, 3265}, {5163, 2139, 239, 5059}, {4343, 
          1495, 229, 2704}}]}]}}, {{}, 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2703, 3910, 2704, 4343, 4342, 5060, 5059, 5163, 3309, 3909, 
          3265, 3916, 5171, 3313, 5170, 3314, 5172, 3312, 3918, 5143, 3302}]},
        
        "0.912`"],
       Annotation[#, 0.912, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2508, 5186, 3971, 4600, 4599, 2974, 5055, 5056, 5052, 5054, 
          5053, 2702, 5331, 5332, 5058, 5062, 5061, 3267, 5165, 5166, 5164, 
          5445, 5444}]},
        "0.864`"],
       Annotation[#, 0.864, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2967, 3720, 3715, 3964, 3963, 4601, 2971, 3721, 4341, 3725, 
          2976, 5057, 3972, 3973, 3431, 4012, 4011}]},
        "0.8160000000000001`"],
       Annotation[#, 0.8160000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3008, 3322, 3009, 3737, 2710, 4603, 2977, 4005, 2975, 4602, 
          3266, 4597, 2969, 3965, 2970, 4598, 2962, 4596, 2968, 3955, 3962}]},
        
        "0.768`"],
       Annotation[#, 0.768, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3714, 3710, 2506, 5185, 3956, 5130, 5128, 2964, 5138, 5139, 
          3967, 3969, 2507, 3723, 2516, 5198, 4007, 4641, 4639, 2712, 3739, 
          3320, 3738, 3321, 3736, 3735}]},
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3953, 3948, 2961, 4595, 2957, 5126, 3299, 3958, 3298, 3717, 
          5129, 2963, 5140, 3301, 3966, 3968, 3970, 3722, 5197, 5196, 4006, 
          3005, 4640, 2711, 3740, 3010, 3323, 4013, 4014, 3455, 4041, 4040}]},
        
        "0.672`"],
       Annotation[#, 0.672, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2505, 3954, 3947, 4594, 4593, 2956, 5125, 5127, 3957, 5124, 
          5123, 3716, 5136, 5137, 4000, 5142, 5141, 2972, 4637, 4638, 4008, 
          4636, 4635, 3432, 4644, 4645, 4033, 3011, 4646, 2728, 3763, 3035, 
          3330, 3034}]},
        "0.624`"],
       Annotation[#, 0.624, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2955, 3709, 3705, 5184, 5183, 3949, 3294, 5119, 2958, 5133, 
          3300, 3959, 3960, 3961, 3718, 5195, 5194, 4001, 3002, 4632, 2973, 
          4642, 4643, 4009, 4010, 2517, 3453, 2525, 5204, 4034, 4680, 4678, 
          2730, 3764, 3765, 3332, 4043, 2630, 3762}]},
        "0.5760000000000001`"],
       Annotation[#, 0.5760000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2503, 3946, 3940, 4592, 4591, 2951, 5117, 5118, 3950, 5116, 
          5115, 3711, 5131, 5132, 3995, 5135, 5134, 2965, 4631, 3001, 4002, 
          3000, 4630, 3724, 3732, 3006, 3450, 3007, 3734, 2726, 4676, 3031, 
          4036, 3030, 3457, 4679, 2729, 3766, 3036, 3331, 4042, 4044, 3469, 
          4075, 4074}]},
        "0.528`"],
       Annotation[#, 0.528, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2950, 3704, 3701, 5182, 5181, 3941, 3292, 5109, 2952, 5121, 
          3296, 3951, 3952, 2504, 3712, 2513, 5193, 3996, 4625, 4624, 2966, 
          4633, 4634, 4003, 4004, 2515, 3446, 2524, 4028, 3452, 3759, 2724, 
          3733, 2725, 4675, 4677, 4035, 4674, 4673, 3456, 4685, 4686, 4069, 
          4688, 4687, 2742, 3780, 3060, 3338, 3059}]},
        "0.48`"],
       Annotation[#, 0.48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2502, 3939, 3933, 4590, 4589, 2947, 5107, 5108, 3942, 5106, 
          5105, 3706, 5120, 3295, 3990, 3297, 5122, 2959, 4623, 2997, 3997, 
          2996, 4622, 3719, 3729, 3003, 3444, 3004, 3731, 2722, 4671, 3447, 
          4027, 3451, 3027, 3758, 2727, 4683, 3032, 4037, 4038, 4039, 3466, 
          2532, 5214, 4070, 4719, 4718, 2743, 3781, 3782, 3340, 4077, 2634, 
          3779}]},
        "0.432`"],
       Annotation[#, 0.432, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2946, 3700, 3698, 5180, 5179, 3934, 3291, 5104, 2948, 5112, 
          3293, 3943, 3944, 3945, 3707, 2511, 5192, 3991, 4621, 4620, 2960, 
          4627, 4628, 3998, 3999, 2514, 3442, 2523, 4026, 3445, 2720, 3730, 
          2721, 4670, 4672, 4029, 4669, 4668, 3454, 4681, 4682, 4064, 3033, 
          4684, 2740, 3774, 3057, 3335, 3056, 3773, 3471, 4721, 3472, 3061, 
          3339, 4076, 4078, 3490, 4097, 4096}]},
        "0.384`"],
       Annotation[#, 0.384, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2501, 3932, 3928, 4587, 4586, 2942, 5102, 5103, 3935, 5101, 
          5100, 3702, 5110, 5111, 3988, 5114, 5113, 2953, 4619, 2993, 3992, 
          2992, 4618, 3713, 4626, 2998, 4021, 2999, 4629, 2718, 3753, 3024, 
          3329, 3023, 3449, 2723, 5158, 3306, 4030, 4031, 4032, 3760, 5213, 
          5212, 4065, 4713, 4712, 2741, 3775, 3776, 3337, 4072, 2633, 3772, 
          3470, 4720, 4722, 4091, 4724, 4723, 2762, 3794, 3083, 3344, 3082}]},
        
        "0.336`"],
       Annotation[#, 0.336, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2941, 3697, 3694, 5178, 5177, 3929, 3289, 5094, 2943, 4588, 
          2949, 3936, 3937, 3938, 3429, 5191, 5190, 3989, 2989, 4616, 2954, 
          5146, 3303, 3993, 3994, 2512, 3727, 2521, 5203, 4022, 4667, 4666, 
          2719, 3756, 3327, 3754, 3328, 3752, 3751, 3448, 5156, 5157, 4058, 
          5160, 5159, 3028, 4711, 3053, 4066, 3052, 4710, 3467, 3468, 3058, 
          3336, 4071, 4073, 3488, 5224, 5223, 4092, 4751, 4750, 2763, 3797, 
          3798, 3345, 2638, 3793}]},
        "0.28800000000000003`"],
       Annotation[#, 0.28800000000000003`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVz7suhFEUhuFPHCaYMRMUhMZdjHtQaSQznUwhcSqmkIhWSBANhYJGqaNQ
CIlDISESRKUzGv89SDyKN+9ea39rZe+p+dXZla4kM1geShZw35/UR5O5atIZ
Sb6wPpj8cIGGfhMPcm35F95XtyrJwUCypnfIfcNJCd3oRQ823I3ZPY4LM5M8
gXP7p90/86X+E9fVbTvPzLyqN53feJu30DTXwKd8od+S/+BFXkJH//v/D953
JF/wMZ/gzs5bPHrnruwefmVL5WTH+VTm3X1ZfeVc4Ru+Rq2WVPEHVpwuHg==

          "]]},
        "0.24`"],
       Annotation[#, 0.24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzjkvhGEUhuFHoRhrLIV2/AfxO4xEbUkUEkapVGk0o9WoNAQZS2KUCkEt
iFhmEmImEgoKFS7Fnfs7zznnPV9xulxaaEsyjtNCMjqYTPQmrb6kiaXOpD6Q
NPCAJzyi3JO8chOr5u+6kjffy+bb+pNtrsi3OOrZ7qTAu+qqfI8XZWWU3BzD
ofxcPmLugIuylneP5bX/G/5v090GX6tX7FY7kh3ZPk/bm8G93hRPoqo3x+/e
+5R/8Lz6zPy6/W/ZBre7c2n2Ql7RX8OP3i/e3Dsy88U1vjJ3wrd8g7qdZ37B
kHzYW38BKTwc
          "]]},
        "0.192`"],
       Annotation[#, 0.192, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNzjlLg1EQheHRykQT18YqLr9AC/9BehEttBQULNQ0wcLKwoBg4QJ2Fi6g
RSoDVvYqoggG4oIRN76AbergUxzeOTNn5t7h+dWplbaImKXvbMR0OmIwE9FQ
J/TJf2GuK+JKP90TcYlnfRF1s0ezlFlFrwMf+CP1Dd5SVp2hO/W1/Ka9EjW7
IxYHvJOKODD/4Ov0Tn+dEQsyFfkts4Sv6TdwTv8eR+yOUlV/CHO0441jyttr
+cup+oQO+TF743QhPyn77N1lt/f5PdqlsrvtMhvY6o04x239vHzBnXX+t9+u
2yX9Gv7wS2av+MS/YBXfsCifuLOGM/IT7vwDTPw7wA==
          "]]},
        "0.14400000000000002`"],
       Annotation[#, 0.14400000000000002`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNz70vg2EUhvFTg8RnfY4kwuhrwWjgLxBLBwOLpIQIo43EpAumdkSYkJgY
LBaCNhJtJbWIVMxiIBJ+w5XrOec5537et2dueWopERGz6GqJ6Ea+KaKAvsaI
O+7lanPElfN+W8QBGswd8SFe6u24r/C5mTp3n3URZ84/yYhvJJ1r5eQ4iw17
CfWXuxreVF/bv5BziT0zu3iXs8Ov/Gy2jI+GiBnzD5ziN37ST3XINXsiZ0z/
Vv9R/4ZH1SvuBngQ/RjGEHLmM97M8qKZUzsl76Wd7zmj3saxnL/WiHX+5UPe
0p/w7iTSMhZQ9D+Vdt/E450R83oldV5d5AKXedV+Vc4aT8sZkfEP0rs/fA==

          "]]},
        "0.096`"],
       Annotation[#, 0.096, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzrsrxXEcxvGPlHI5bmEirIyUu5XNZVJEGUSJMiiTMjn+Aikml0EuG6t7
ylEog+UMpjMdIVLEy/Du+X6e5/N5fr/68dnBmZyImMRJfkRPZcRtUcRcYUSH
dyda0Y42TBRH3Mm7vO9pN523+14RsUXf6CadtrdAf8oiduhySUQSK5hKRDz6
Vp/dA3NjeUQD1gp45m+9P9jQsY4Z+03ySz0p+RVtNu/ZX5IN6XngP/OH+If8
fvMA8uS95iM92xiWjyArG6OjOP3voeGbi/RXz6q7C37SnMv/sP+JjP/elb3S
fXqAlN4bPNlP0xr7VfxqekzT/F09deai0ogEinEt+9JT7X3r/eE2azdDX+iZ
m3PUylvc/gFA70Fm
          "]]},
        "0.048`"],
       Annotation[#, 0.048, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzbsrBQAUBvBDkjd5pIjcDFyzxeZVJiXi7sqkyB+gEHmUwSSTYqKbLGLn
Lrg2pW7JTaKkUFJK+RlO3+uc7yQmZ0dnCiJiyvzjbV1EtiLisTBiqywiBzfh
FZwrj3ivj0g1RNTa/cD3eN+yffhJt/M7hBf0tcIdt0s1EZ28EXeDdBKfrozo
pftMi7sXP1thxt1ulR/4TXVEnh63f+RuRc8EfiIbolP4sp5+HQMmyX/V0wWf
3J3pmcLf9fzS8/bP3a3rWcBPZcP0Ir6tZxWumWJ5kZ4N/E6elpXwjmETP6c3
x3+AedPIH6Pv8VP8wN2haXSTsJ/G3+SXsmZeFnbzv+x/8DPyHrrtf9/8lEY8
2ymU/QG/1j1h
          "]]},
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0D1I1XEUxvETZGKZlnXRmyHplhK9DBFCbUFOda8VboG0FUVjCoEEDS3p
VmiQGdjb1HTbKsKGhnIJKq+WLzdJvZVv2U2iz3/48pzzPOec/49/Y+fl7KUN
EZHDUmXEb2RTEW9pe3XESqL6VbqMAzsjinQ//UEP0hH6d1tECWt4rX+zI+I2
zW2PyGwxa+4ULdI2WY+sV3aMt8A7Sudpk+yK7KqsmTfH20u/0/WaiHOytPfU
Yxf2bY2o9M60mXV1j7nH3vAIw6jgH3ermz+g78cdLG6OOMy/yO/T9+IWdvPq
sVARcdJMjZtVvtnmW/O8B/pVO98wixnkzBXouG9lzE3QMnN5ekI/bm9Mnsdn
TCSzifK/0kl8wTSmkppf5g2bsBFP3C+nZ2UrSe5uh7tn1E9l1707499kcRrt
uFcVMYhJs+/8n/cYRZ93zbh/3m61my/s37D/knbbK5nvon/oc/sFek3/j/6y
v4iC/Yfu/KS1btThphsf3EirL7hdrk/7b3ftfuSPuZVHyl5W/0n9TD0ov4+U
+QbzQ+o5+Yisy506/iH+K36Rv2Zvj6wRy+oljKpL9Ii5aXUrnaVNdgu0hTbj
PyIcd+s=
          "]]},
        RowBox[{"-", "0.048`"}]],
       Annotation[#, -0.048, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0DtI1XEYxvHXDmTeNUujUGgwCFqrwUmMzMtQbS1ZOjWoNJgKjUJTCdZ0
lGrRWlrTrl6wmzVEGE6Kig6CZFJ46Zwjfc7w5Xnf53l/7+//+59s67ramRMR
I2gujDhTGrF4OGIBuQURqeKIg3StKOK0LCc/Ykm9jHPmF+lZumPuq3qT/ka1
ugpb6g1nJu2bQoUdfUciZmTr/Ke8E86X85+oH+OFbJhekY+bHVLfl8/rj5fZ
YT6hr6RJ2U/+J/fM0WfOHpBt5nmTehRp33/XXCr7HvsGeX36FvMv9b3qe85M
6Ivt3zXXzevBHbzn98vf0SJ5uzOF9K0+n76hBbSNn0df6w/RV3SXt4cdbNvb
zLupvoHWrM/7R7/x92mpN6VpCc3Qy/xf3lJlXzUGfcdDPEKnPHE0osbsNdqh
/2M+KftLz5uvlX30hovqBjyXNdJLWOJn/It9XDeX0h+zpxLt2beix1wvpp2b
wS1eBR7wBvCd9wO3eaey/5M3hhXeKprsasGX8ojPmMUHd+3J0sigriSiHhP8
BjpJL9AN+h+kp2aS
          "]]},
        RowBox[{"-", "0.096`"}]],
       Annotation[#, -0.096, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0btLFmAUx/GjvoFpF99b6JsQEZqQmaaDuuiW2GWwy+AkNtWgQg7RWIsQ
CqWp/QkK6iaaUaKDNZi3ORwaolcaHAQbND8OP77n/M75Pc8Dz9Xe/q6+gogY
p9KSiMPzEUVYVxZxk+6di9hNRRSXRuTN7uivYQceX4hI8P9hEe7ya2RC/qc6
p66gK+pG+99wjfL296hSfZn+qvMyX91zy15G5mUmoikZ8Zs/om9U36bDsxEr
Mvt4hp+gcplp3hRNOuMjTdA4vTXfccYl2Yy9MV4WP+A2f8h8C7Pmz92ZwU19
Cjcwjc/4SfyhL8N1HJVPOec9Jk/f7O40FWZR/1+mQB20zD/w3gFeP1WbJ/g5
/px8jX4Gr+MsPjE7cMcfu83ua6VuXgt+N9+TS5g3eHs9PZCr4vXw3si8pqd2
c/5k3nyBFmmY34Y99o+cc8N8VV+Lr+y/4L/DNv0Wvx3H9HfTEZ20qP5Ev8w+
n/retISDZl3+8L7+IX5xzmN8RE0XI04AkhFMXA==
          "]]},
        RowBox[{"-", "0.14400000000000002`"}]],
       Annotation[#, -0.14400000000000002`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0T1I1AEYx/HnhkO77MVMHBry8rq8o9IGhzukQUhIqOygoJYgrgYHpbOX
xd3FqYZwdD4CtSEyFBpCoTGyTlq6q0hwCjqJSPvc8OX3vPye5/m/pO9OlSYT
ETGLakfEzcMR9w5GjByJKNNHXRGP8b4zYuF4xNVDEVeQ1S/pF/nn1TePRnzE
BzzjfYqeVMQECvwVuy/qXUcJ3eb2jrnFdx+v1E7YVxZf4/2qN07r9IVeFSn9
Mf0Z9/4eiLhtd1t3RDvW+Yb5N2hT/SXNyzvNPeCv4IZ6kjenvqi/jCXU1U/a
26C9dJr3IU6J+5DGaWTQdPcM7UcWeeSwq36Onsecm9/sGhA/seet9/8ur3nn
H3TFzTd4jbOeZYjvp/pzc6utuplb8jXxO7M75gb5NsUXaI1+xr6bfWa+iMO3
+cWXoFvmRvk+0Uu0oZ9U39e/LM/I79j/T77dmvUvE/jd+rf6f+iAvbu0SAv4
D5CxSyc=
          "]]},
        RowBox[{"-", "0.192`"}]],
       Annotation[#, -0.192, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVkTsvQ3EYxh8dJO05bSmKUYJKqieVCOJ06G3CJG5JEwkxk0hqkJQmPkOl
/QC2jmgHJhMjrUuYMIqEwS2lfmf45b08z/P+e+lb3Zhdb5GUhwmPtAevbdIL
XLRL52Cx24ZQlzQEmx1SyZRiPsmGGeYivhLUyCUMqUCfxTOAFoJBmPRKvX4p
gh4kl8KbhjVuW2gr+ONOHpLQZPcUkJ5hmnsmuTJ7g+rjc/gh1yntQMMtZbjj
YWeAG7xgwid7m/wXNUbdxf+L/5L7VxDm3QB3s+y3YAHfIW+G8Q5DAe2IeY5b
i2jH9FH2I7CPVmGeR1tCq9KfcbOVOcLdE2aLWmdXgz/ejZNLQJFsg0ySPs+7
N47u/P78Nk1qnew19ONLcSONz8V3P2C+ZX9KZhnfHf0j2XvqA4yiT+F/Z/cG
48xj8EHfTd7Ff9BD/cb7AzZaBv8/CvVFrg==
          "]]},
        RowBox[{"-", "0.24`"}]],
       Annotation[#, -0.24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0MsqhWEUgOFFyfmwt20zYOBcFCMztrOpYqSItjJRDCgugJkxRUjKVbgC
p+1Uwi1g6pR4DN7WWu+31vq//2vMLk8s5UXEKlIlEYmKiDKxryqiF9NlEd/l
EV8orIyYUnfKO1CkTpdGvCcjPtCjfysVkU3YxZ+o5+SzKLbzzUw714ZWjNj1
zD3h3vyMnlPzd/Jj5z/qYbND+m65Gxzx33w/P8hfczkc8l98hh/gr7hL7POf
///D9/Fn3LS6yTf71efqjHghvnAFzjbdYQOJmogqtPE1YhpJpFCN8FYV+sd8
YxRRHfFrT7f+fPm8vXliVqzV2+VNWtSr6maxwY56LNpRh2133MGDXY94wq57
ZMxOmm333uN2r5ldxwr2/u9uZsH5q/5reQ4Hzv4AjAw63w==
          "]]},
        RowBox[{"-", "0.28800000000000003`"}]],
       Annotation[#, -0.28800000000000003`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0Lsvw2EYxfGncWmVXrQkjCYkEmKSIBIGBrdSFRUDE4tuDHYSRptBRKz+
Af4GZv+AayLiEpPBp8M3533OOb/nfduerdrSbiIialjIRxSyEb2tEa25iI22
iJw5i2I6Ik3TdERvIBNRlf/QbzToV8z9zn1oMnfa81uIWOFvtkecdER8yIr8
P7sK9N18zF+X581Xdled15ByV4XeylfppWyFlpGULdIbWYleyBboPJplR/w5
56yd57IMnTUf8ofNJW969LZe97/SNzzhBc9IeF/OnhndaTQW/UYM6adoC5qQ
RDO69Lv1y7rL2LO/jz+qP4ZT91b4+/X/iD/pPQ/mKXpWfzdvDhP27PC3Me58
pr/o+wO7B3Gne48P+Se+cG33P00fMaY=
          "]]},
        RowBox[{"-", "0.336`"}]],
       Annotation[#, -0.336, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0DlKg1EUxfHrgJrBjIJoZyEIBhwCWglip4JgEkkKp6SyimDrUFjpJgQ3
ICIuwC047MIpTr2/FH/Od8877953v4nWYaXdExEHaKcjFocjFjCajZhKRRRo
EblMxEYuIkUn+QleEgn1EArJiAE6iIY+/bTeVZmOfn+FiJbMw0jEr+97vXbz
ETv4Vv/gCx3cOcubse2spscn7wO3/Cy/wa/y33lvuOFXeRW8qpvmXJpzgbKz
imyf9/RiXb2G1e4uRTtgzvuyNIc0MhjGmPy4Xg3ZOkq8aSzJz9MyZrr3MYuS
/L7cHrZwbu6K7JEeLXUTyzI1O0z5L5vOTt07wzGu5E/ooz2e0JF/oc+45v8D
xrYuwA==
          "]]},
        RowBox[{"-", "0.384`"}]],
       Annotation[#, -0.384, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNzz8vQ3EUxvFjYECrV3sNWv0TjSBpCZpY8QakiMUkqhSt1CSx2SXMLHZE
xMqr8H58hm+e3znPuc85t3Y8aPdHIqKD+njEYjYipbu5iM1MxGAyoqCXR24q
IkFLfwOp98JERIbXM1fOR1zQGq3rj/Hn6Sj/qRBxk/DU37KrdKh+1E/sG3j/
el/TL36fXiHHO6c/vB795JV9e+b9oNelc+oP/RKdtrvjhoSe0HV3rmFGfarO
0xQFlNxVkj9Li8i6N4MVOQ1+E8uopHbi0mwRDbNNVM1WsCN/39wB2ri3Z49u
mdnGi/pW/UyX5NzJWEXPzYf8rn0tOUdyXs29m/vzX2/0H+3oJPE=
          "]]},
        RowBox[{"-", "0.432`"}]],
       Annotation[#, -0.432, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzskuA2AUxfFrSylRUUPnIm1ISIyx1K2gK5WwkNCK1hDDws6wZ2HPA3gC
ESHivfws/rn3nnPu/b7C/mn9pCsi9rDSHfGA6aGIGbwMRrwlIhp9Edu4Nb+a
b9R73KHeG1FJRlRRk1nDlBsXKLlRxobcFjZR64lYUpfR6I94TkVkZDvIyxYw
z1vEAmblk27PqRm3d+xkZbP6HJr+s057dOcJB7xhe8cDEW2889Lmb94hb0Tf
snPOy7n5wR+ljeGIfkkv0j/p47Qfe017Gf0V7xpfvJz5l9f6/7c+4S8p/2y7
kdd31LJaRElmQp3EGT0tt+qNinnXrT/qsCUv
          "]]},
        RowBox[{"-", "0.48`"}]],
       Annotation[#, -0.48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwN0MsrxGEYxfFj6y6XDcWMpFihMCg2dlaKXDeyHhsLYgyaIaxdimLF1l4S
8X/5LE7f9zznvE+/31vY2VsuNyRZoWpzstCSzFNfWzLXlPTiiflwa7LVngxi
ybzHfBoL/ENXctORTPLfOtfOV1RsTC7wV36JX7I61qggO8Mf2Tl+yk6xSgOy
e/MT5wk7P2TjWOHvzJf4Q99U7E5mO5M//lh2RCW+7H4/3epuyg50Z8wX7VjD
Or+KNRyyY1/3SfeRdvUvzNflK/qn+MxXcVR3hCr6Y7Th3zdpyltM0rZ3e9V7
oxd6d+8fhjUpvw==
          "]]},
        RowBox[{"-", "0.528`"}]],
       Annotation[#, -0.528, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzk0rBFAUxvHH1luED2ChRNiY1MQwzAw7hVJiFmwUzVh7KcVkiE/Axsja
tyCUz+Q3i3/PPf97zr1n/LC51ehJsomZ3qQwmEzI+lBSHkiu+5NpbgobI8mZ
u5/RZN35T0+xL3kaTq701bgqfvkF/pG/5CvcGr75At/mL/hVrowvfp6/4ZfU
i2j6p+T/c30l9QqWMWePSXfPej/t8dJN8zXz++7b+vfknayar6CuflDvynt5
0N3TO6fmTnCEV/6W39a/g463G3yHb/HH3n+XH+q37h5jySxadiniH6TfJt4=

          "]]},
        RowBox[{"-", "0.5760000000000001`"}]],
       Annotation[#, -0.5760000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3250, 5028, 3251, 5036, 3422, 5033, 3249, 4205, 4220, 2619, 
          3676, 5001, 5002, 5000, 5004, 5003, 3413, 4998, 4999, 4207, 4208, 
          2610, 3654, 4963, 3212, 4955, 3213, 3398, 2677, 5414, 3211, 4959, 
          4962, 4961, 2887, 3866, 2888, 3632, 5277, 5278, 4509, 4510, 4296, 
          4512, 5319, 4511, 2601, 4514, 4515, 4298, 4518, 5320, 4516, 2602, 
          4519, 4520, 4301, 4524, 5321, 4522, 2603, 4527, 4528, 4303, 4531, 
          5323, 4530, 2604, 3635, 3636, 3870, 3869, 2894, 3638, 4197}]},
        RowBox[{"-", "0.624`"}]],
       Annotation[#, -0.624, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2620, 2694, 5424, 5425, 5032, 5035, 5034, 2921, 5005, 5006, 
          4209, 5283, 2611, 2686, 3883, 3884, 3655, 2902, 3887, 3414, 5007, 
          5008, 4210, 4211, 2612, 3656, 4966, 3214, 4960, 3215, 3399, 2678, 
          4964, 4965, 4513, 2889, 4315, 4967, 4968, 3216, 3633, 2890, 3874, 
          3400, 4970, 3217, 4517, 5279, 4521, 2891, 4300, 2892, 4523, 5280, 
          4529, 3220, 4973, 2893, 4320, 4974, 4975, 3221, 3640, 2895, 3876, 
          3402, 3403, 3222}]},
        RowBox[{"-", "0.672`"}]],
       Annotation[#, -0.672, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2615, 3663, 4199, 4198, 3404, 3223, 3641, 3639, 4977, 2681, 
          5326, 4976, 4319, 4533, 4532, 4972, 2680, 5325, 4971, 4317, 4526, 
          4525, 4969, 2679, 3401, 3219, 3634, 3218, 3873, 3660, 2613, 4542, 
          5324, 4543, 4316, 2904, 4541, 5286, 4214, 5011, 5010, 3415, 3889, 
          2903, 3657, 3886, 3885, 2687, 5285, 5284, 4213, 3235, 5009, 2922, 
          5039, 3253, 5037, 3252, 5426, 2695, 4222, 4221}]},
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3255, 5038, 3256, 5041, 3423, 5040, 3254, 4212, 4223, 4224, 
          3677, 3678, 3236, 4216, 5287, 5288, 2688, 3888, 3658, 3659, 3891, 
          3890, 3416, 3417, 3237, 4545, 3238, 5013, 2905, 3875, 2906, 3661, 
          5290, 4547, 2907, 4318, 2908, 4548, 5291, 4550, 2910, 4321, 2911, 
          4551, 5292, 3662, 2913, 3877, 2914, 3664, 4219}]},
        RowBox[{"-", "0.768`"}]],
       Annotation[#, -0.768, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2621, 2696, 3896, 3679, 3680, 3899, 3898, 3424, 5042, 3257, 
          4215, 4225, 3681, 2923, 5014, 3239, 4218, 5289, 2614, 2689, 5012, 
          4544, 4546, 4325, 5015, 5327, 2690, 5016, 5017, 4549, 2909, 4327, 
          5018, 5019, 3240, 4552, 2912, 4329, 5020, 5021, 3241, 3665, 2915, 
          3912, 3418, 3419, 3242}]},
        RowBox[{"-", "0.8160000000000001`"}]],
       Annotation[#, -0.8160000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2622, 2697, 3897, 3682, 3683, 3901, 3900, 3425, 5044, 3258, 
          4217, 5294, 4566, 2924, 4326, 2925, 4567, 5295, 2624, 4570, 4571, 
          4328, 4574, 5328, 4572, 2625, 4575, 4576, 4331, 4579, 5329, 5455, 
          5454, 2626, 5297, 5298, 5067, 5070, 5069, 3271, 5073, 5074, 5072, 
          5300, 5299, 2627}]},
        RowBox[{"-", "0.864`"}]],
       Annotation[#, -0.864, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2623, 2698, 5043, 4568, 4569, 4339, 5045, 5046, 3259, 3684, 
          2926, 3904, 3426, 5048, 5049, 4573, 5296, 4577, 2927, 4330, 2928, 
          4578, 5068, 5071, 5427, 3272, 4351, 5333, 5334, 3913, 4353, 4352, 
          5076, 3276, 3915, 3914, 3922}]},
        RowBox[{"-", "0.912`"}]],
       Annotation[#, -0.912, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3902, 3903, 3685, 3260, 3427, 2699, 5047, 4580, 4581, 4340, 
          5050, 5330, 2700, 5051, 3261, 5075, 3273, 4350, 4354, 4355, 3274, 
          5428, 5429, 5335, 5336, 2706, 3917, 2707, 5338, 5337, 5431, 5430, 
          5446}]},
        RowBox[{"-", "0.96`"}]],
       Annotation[#, -0.96, "Tooltip"]& ], {}, {}}}], 
   {GrayLevel[0], PointSize[Large], 
    PointBox[NCache[{Rational[1, 2], Rational[1, 3]}, {0.5, 
      0.3333333333333333}]]}, {{{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxFxW0w03EcAPCNdZRrjMr9adxE5SlOUlKpuMhDneHk8nRCWk/InXR1WrdJ
nua6nZTnh5R2jGyuMnHsdDnPo1GzMUtj83RndnRZ9cL39+JzH0r8XWqiHg6H
C/7n/wGJypGu+fAz2xN8LFJkmLv39kcrS8paMV84cED8vhwLgyMStB3PsQR4
yuWpTwGWDlftvZydizFgumHroWcYG74SWc1dWa2DjXT0KD8rLmwXsqTsyePB
GYOe3iVrH2FzHkmKx3fCbXKf/qFT3XA3rdwyUi2ENQdPGzfe/gLrbXBMLO36
YA9dXFtoUz/cz3Af7HUYgq2LVBsNS8OwSiuTjruOwnUL7X3EQhFMJL9ZVijG
4Pwb/KQq22/w+lmOIjlLDKe7CXn7eiZgWZMwb4TyHf5NGyu1f/ADdjxnsJXU
LoH9aijXW8ylcAY51mYmSgY7qcONxMHTsJnxiqFwE03oLOUeKJuBb7q3T+4M
lMOci/FVn9fRGpWFyVzxLMwP9dNn+yrgLH9mJW8OTZkKmKhl/oRPHmewMbc5
OMpqaAMvQmv6CuQp9F9wCSEmnWqrhM2k/Bo9IXrHI3qYZ+o8jGuI4cpNF+C0
V9wC0250h2OOIemOCiYFpDk9IaphifOwKFOAbq7wtlXELMLRXA8SeQv9mFlN
l7xbghuV5FJi0DKcU86Mk15CJ1AX7ZpC0PsFgubgCHQu62pvfjw62ePl6q5M
tA1jj79BPXrrxMPd4rfoycXZ0XoOuiiiNfpCC1rnQL3HFKAlI6wKfRH6Q7b2
mmgczfaKta+dQAe+PsI7L0V/uj/wlT6PLnY+xgpRo1PlZWGUZfThoFuyrjU0
AT9WV6RFT/O9aHGbaAGt1sX1D/qFtZFGp0P/BaO4ekM=
       "]]}}, {}, {}}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJxdlnk0lG8fxkkyUgqlLC2WhFJKpRRXZKlkTRtGIUneJFlqqFCS5SfiR6KS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      "]]}}, 
   {RGBColor[0, 0, 1], 
    ArrowBox[NCache[{{Rational[1, 2], Rational[1, 3]}, {
       Rational[1, 2] + 2 5^Rational[-1, 2], Rational[1, 3] - 5^
        Rational[-1, 2]}}, {{0.5, 0.3333333333333333}, {
      1.3944271909999157`, -0.11388026216662461`}}]]}, 
   {RGBColor[1, 0, 0], 
    ArrowBox[NCache[{{Rational[1, 2], Rational[1, 3]}, {
       Rational[5, 6], Rational[-2, 3]}}, {{0.5, 0.3333333333333333}, {
      0.8333333333333334, -0.6666666666666666}}]]}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.685112311875354*^9, {3.685112342183234*^9, 3.6851123656888*^9}, {
   3.6851139068541117`*^9, 3.685113914239356*^9}, 
   3.685113996874155*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
\[LineSeparator]\[LineSeparator]\[LineSeparator]Try this to find the exact \
coordinates of the maximum point along the border:\
\>", "Text",
 CellChangeTimes->{{3.685110945633534*^9, 3.68511095669711*^9}, {
  3.685111237680983*^9, 3.685111241536875*^9}, {3.685114015105061*^9, 
  3.685114015504019*^9}, {3.6851144583849077`*^9, 3.685114459687808*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "We already have ",
 StyleBox["parametric equations",
  FontSlant->"Italic"],
 " for the bottom boundary: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"x", "(", "t", ")"}], "=", "t"}], ";", " ", 
    RowBox[{
     RowBox[{"y", "(", "t", ")"}], "=", 
     RowBox[{
      SuperscriptBox["t", "2"], "."}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"]
}], "Item",
 CellChangeTimes->{{3.6851110076185703`*^9, 3.685111089609096*^9}}],

Cell[TextData[{
 "Substitute these into the expression for temperature ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"T", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     SuperscriptBox["x", "2"], "-", 
     RowBox[{"2", "x", " ", "y"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", to find ",
 Cell[BoxData[
  FormBox[
   RowBox[{"T", "(", "t", ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "."
}], "Item",
 CellChangeTimes->{{3.6851110076185703`*^9, 3.6851111833929663`*^9}, {
  3.685114682568516*^9, 3.6851146833009853`*^9}}],

Cell[TextData[{
 "Find the value of ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " which maximizes ",
 Cell[BoxData[
  FormBox[
   RowBox[{"T", "(", "t", ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "."
}], "Item",
 CellChangeTimes->{{3.6851110076185703`*^9, 3.685111225272438*^9}}],

Cell[TextData[{
 "Substitute that back into expression ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "(", "t", ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "(", "t", ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " to find the coordinates of the maximum."
}], "Item",
 CellChangeTimes->{{3.6851110076185703`*^9, 3.685111289472191*^9}}]
}, Open  ]],

Cell["\[LineSeparator]\[LineSeparator]\[LineSeparator]\[LineSeparator]\
\[LineSeparator]\[LineSeparator]\[LineSeparator]\[LineSeparator]\
\[LineSeparator]\[LineSeparator]", "Text",
 CellChangeTimes->{{3.685114710912899*^9, 3.685114712492876*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "2"}], "-", 
    RowBox[{"2", 
     RowBox[{"t", "^", "3"}]}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.685114496850751*^9, 3.68511452811307*^9}, {
  3.685114676729844*^9, 3.685114677818582*^9}, {3.685114722440819*^9, 
  3.685114750179101*^9}, {3.685114780293633*^9, 3.685114784257265*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwdl3k8VV0Xx5EeKgn1VERkSqYkUar700OlDMlUCplS1FNSiAbKUMnQcJPZ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      "]]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {-0.9999999183673491, 0.03703701439932758}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.685114529062872*^9, 3.685114687076806*^9, {3.685114741546032*^9, 
   3.6851147511087217`*^9}, 3.6851147849824133`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "2"}], "-", 
    RowBox[{"2", 
     RowBox[{"t", "^", "3"}]}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", ".1"}], ",", ".1"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwVl3k8VV0XxyVFJaGRiEwVkiRK3J9eKmVIplLIlKKBZG6gDJUMDTeZ3XtC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      "]]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 0.9999999795918367}, {-0.1, 0.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.68511477750554*^9}]
}, Open  ]]
},
WindowSize->{808, 879},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"11.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 28, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 1652, 51, 159, "Input"],
Cell[2235, 75, 261281, 4495, 371, 172526, 3038, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[263531, 4573, 932, 18, 141, "Text"],
Cell[CellGroupData[{
Cell[264488, 4595, 445, 13, 56, "Input"],
Cell[264936, 4610, 208, 8, 52, "Output"]
}, Open  ]],
Cell[265159, 4621, 770, 19, 110, "Text"],
Cell[CellGroupData[{
Cell[265954, 4644, 357, 9, 32, "Input"],
Cell[266314, 4655, 235, 8, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[266586, 4668, 385, 10, 32, "Input"],
Cell[266974, 4680, 207, 6, 49, "Output"]
}, Open  ]],
Cell[267196, 4689, 438, 12, 56, "Input"],
Cell[267637, 4703, 221, 7, 54, InheritFromParent],
Cell[267861, 4712, 119, 5, 65, "Text"],
Cell[CellGroupData[{
Cell[268005, 4721, 1608, 45, 186, "Input"],
Cell[269616, 4768, 264597, 4551, 371, 172991, 3047, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]],
Cell[534228, 9322, 362, 6, 83, "Text"],
Cell[CellGroupData[{
Cell[534615, 9332, 477, 16, 31, "Item"],
Cell[535095, 9350, 584, 19, 31, "Item"],
Cell[535682, 9371, 340, 12, 28, "Item"],
Cell[536025, 9385, 416, 13, 28, "Item"]
}, Open  ]],
Cell[536456, 9401, 246, 3, 209, "Text"],
Cell[CellGroupData[{
Cell[536727, 9408, 454, 11, 32, "Input"],
Cell[537184, 9421, 8392, 151, 263, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[545613, 9577, 373, 12, 32, "Input"],
Cell[545989, 9591, 7422, 134, 234, "Output"]
}, Open  ]]
}
]
*)

