(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      5971,        183]
NotebookOptionsPosition[      5208,        154]
NotebookOutlinePosition[      5659,        172]
CellTagsIndexPosition[      5616,        169]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["13.1 Visualizing Vector Fields", "Section",
 CellChangeTimes->{{3.545580350064847*^9, 3.545580355422383*^9}, {
  3.5456160119392223`*^9, 3.5456160130780244`*^9}, {3.5777802843481092`*^9, 
  3.577780289066533*^9}, {3.656339893758664*^9, 3.656339919486145*^9}}],

Cell[CellGroupData[{

Cell["Sketching Vector Fields w Mathematica", "Subsubsection",
 CellChangeTimes->{{3.54558037419226*^9, 3.545580407059546*^9}, {
  3.5455813969603415`*^9, 3.545581481369241*^9}, {3.5455816001643605`*^9, 
  3.5455817108252935`*^9}, {3.545581859264413*^9, 3.5455818822987165`*^9}, {
  3.5777818924964*^9, 3.5777818975664*^9}, {3.609116000369258*^9, 
  3.6091160034361963`*^9}}],

Cell[TextData[{
 "\[LineSeparator]Sketching a vector field in 2 dimensions: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["F", "\[RightVector]"], "=", "y", " "}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["i", "^"], "-", 
    RowBox[{"x", " ", 
     OverscriptBox["j", "^"]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"]
}], "Text",
 CellChangeTimes->{{3.656340079706918*^9, 3.656340189793762*^9}, 
   3.656340301326724*^9}],

Cell[BoxData[
 RowBox[{"VectorPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "x"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.577781921138*^9, 3.5777819351312*^9}, {
  3.5777820605552*^9, 3.5777820701336*^9}, {3.577782153968*^9, 
  3.5777821739672003`*^9}, {3.5777822219684*^9, 3.5777822252444*^9}, {
  3.57778225685*^9, 3.5777822597827997`*^9}, {3.656339947127808*^9, 
  3.656339956491577*^9}, {3.65634056120647*^9, 3.6563405974218493`*^9}}],

Cell[TextData[{
 "\nDoes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " display the correct length of the vectors? Use the following plot to \
decide: Calculate the length of at least one vector and compare to your \
estimate of the length that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " plots."
}], "Text",
 CellChangeTimes->{{3.656340830329739*^9, 3.6563408752324*^9}, {
  3.656341033412838*^9, 3.6563410873318233`*^9}}],

Cell[BoxData[
 RowBox[{"VectorPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"0.5", "*", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.577781921138*^9, 3.5777819351312*^9}, {
  3.5777820605552*^9, 3.5777820701336*^9}, {3.577782153968*^9, 
  3.5777821739672003`*^9}, {3.5777822219684*^9, 3.5777822252444*^9}, {
  3.57778225685*^9, 3.5777822597827997`*^9}, {3.656339947127808*^9, 
  3.656339956491577*^9}, {3.656340344579711*^9, 3.6563403542097807`*^9}, {
  3.656340646915934*^9, 3.656340763652643*^9}, {3.6563409346953*^9, 
  3.656340939014624*^9}}],

Cell["\<\
If it *doesn\[CloseCurlyQuote]t* display the correct length, what other \
information does it use to hint at the relative length?\[LineSeparator]\
\[LineSeparator]\[LineSeparator]\
\>", "Text",
 CellChangeTimes->{{3.656340967741602*^9, 3.656341016714172*^9}}],

Cell["\[LineSeparator]Vector fields in 3 dimensions:", "Text",
 CellChangeTimes->{{3.656340217502389*^9, 3.656340229026773*^9}, {
  3.656340306511505*^9, 3.656340312396474*^9}}],

Cell[BoxData[
 RowBox[{"VectorPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", ",", "z", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5777796197182493`*^9, 3.5777796679260283`*^9}, {
  3.5777822979560003`*^9, 3.5777823009824*^9}, {3.609115599964473*^9, 
  3.609115639317049*^9}}],

Cell[BoxData[
 RowBox[{"VectorPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.609115659269738*^9, 3.609115689244185*^9}, 
   3.6563402708639317`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{716, 730},
WindowMargins->{{25, Automatic}, {Automatic, 26}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.5,
FrontEndVersion->"10.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 6, \
2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 265, 3, 95, "Section"],
Cell[CellGroupData[{
Cell[869, 29, 375, 5, 52, "Subsubsection"],
Cell[1247, 36, 514, 16, 82, "Text"],
Cell[1764, 54, 665, 16, 43, "Input"],
Cell[2432, 72, 442, 12, 164, "Text"],
Cell[2877, 86, 769, 18, 43, "Input"],
Cell[3649, 106, 269, 5, 164, "Text"],
Cell[3921, 113, 177, 2, 76, "Text"],
Cell[4101, 117, 575, 16, 69, "Input"],
Cell[4679, 135, 501, 15, 69, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
