(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    211967,       4314]
NotebookOptionsPosition[    209650,       4239]
NotebookOutlinePosition[    210102,       4257]
CellTagsIndexPosition[    210059,       4254]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Lab 08 - Gradient fields and level curves \n",
 StyleBox["[Names...]", "Subsubsection"]
}], "Section",
 CellChangeTimes->{{3.545580350064847*^9, 3.545580355422383*^9}, {
  3.5456160119392223`*^9, 3.5456160130780244`*^9}, {3.5777802843481092`*^9, 
  3.577780289066533*^9}, {3.656339312239959*^9, 3.656339326120943*^9}, {
  3.656358487020174*^9, 3.656358489932745*^9}, {3.656371652800416*^9, 
  3.656371662805306*^9}, {3.656371707647746*^9, 3.6563717126938667`*^9}}],

Cell[TextData[{
 "Consider a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]]],
 " of two variables.  The gradient of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 " is a vector field ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["\[Del]", "\[RightVector]"], "f"}], TraditionalForm]]],
 "=",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["F", "\[RightVector]"], "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["f", "x"], 
      OverscriptBox["i", "^"]}], "+", 
     RowBox[{
      SubscriptBox["f", "y"], 
      OverscriptBox["j", "^"]}]}]}], TraditionalForm]]],
 ". The gradient at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]]],
 " is "
}], "Text",
 CellChangeTimes->{{3.5455826289363728`*^9, 3.545582646663145*^9}, {
   3.5455826768881674`*^9, 3.5455827588263607`*^9}, {3.656339453660355*^9, 
   3.6563397095899363`*^9}, {3.656339849901436*^9, 3.656339863395121*^9}, 
   3.65635643750189*^9, {3.656356485045575*^9, 3.65635654800352*^9}, {
   3.6563565851436253`*^9, 3.656356719484592*^9}, {3.656356754884363*^9, 
   3.656356813880569*^9}, {3.656357575512457*^9, 3.656357733214164*^9}, {
   3.656357905015839*^9, 3.6563579326820917`*^9}, {3.65635796424817*^9, 
   3.656358009034677*^9}, {3.6563717490683804`*^9, 3.656371751251749*^9}}],

Cell[CellGroupData[{

Cell["\<\
a vector pointing in the direction of maximum increase of the function.\
\>", "Item",
 CellChangeTimes->{{3.656357907904604*^9, 3.656357909899267*^9}}],

Cell[TextData[{
 "perpendicular to the contour line (level curve) of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 " which passes through ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]]],
 ", that is, perpendicular to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", "k"}], TraditionalForm]]],
 "."
}], "Item",
 CellChangeTimes->{{3.656357907904604*^9, 3.656357922137479*^9}, {
  3.656358035126507*^9, 3.656358039040176*^9}}],

Cell["\<\
Its magnitude is the slope (directional derivative) in that direction,\
\>", "Item",
 CellChangeTimes->{{3.656357907904604*^9, 3.656357970833547*^9}, 
   3.6877368295709333`*^9}],

Cell[TextData[{
 "so, as the curves (contour lines) get further apart, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftDoubleBracketingBar]", 
    RowBox[{
     OverscriptBox["\[Del]", "\[RightVector]"], "f"}], 
    "\[RightDoubleBracketingBar]"}], TraditionalForm]]],
 " should get smaller."
}], "Item",
 CellChangeTimes->{{3.656357907904604*^9, 3.656357966707345*^9}}]
}, Open  ]],

Cell["Check this out for a particular function:", "Text",
 CellChangeTimes->{{3.65635798765906*^9, 3.656357995685988*^9}, {
  3.65637178753053*^9, 3.65637179461045*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{GridBox[{
        {
         RowBox[{
          RowBox[{"f", "(", 
           RowBox[{"x", ",", "y"}], ")"}], "=", 
          FractionBox[
           SuperscriptBox["x", "2"], "4"]}]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}], "+", 
      FractionBox[
       SuperscriptBox["y", "2"], "9"]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.6563568409915667`*^9, 3.656356848676772*^9}, {
  3.656356896522317*^9, 3.656356958918716*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myf", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "/", "4"}], "+", 
   RowBox[{
    RowBox[{"y", "^", "2"}], "/", "9"}]}]}]], "Input",
 CellChangeTimes->{{3.656357011022684*^9, 3.656357062101321*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["x", "2"], "4"], "+", 
  FractionBox[
   SuperscriptBox["y", "2"], "9"]}]], "Output",
 CellChangeTimes->{3.6563570666296043`*^9, 3.656364073130101*^9}]
}, Open  ]],

Cell["\[LineSeparator]The gradient of this function is...", "Text",
 CellChangeTimes->{{3.6563569942003937`*^9, 3.6563570009054337`*^9}, 
   3.6563580786997843`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myGradf", "=", 
  RowBox[{"Grad", "[", 
   RowBox[{"myf", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.656357072197816*^9, 3.656357082862822*^9}, {
  3.656357175284408*^9, 3.656357182204315*^9}, {3.656357252077417*^9, 
  3.656357258310945*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["x", "2"], ",", 
   FractionBox[
    RowBox[{"2", " ", "y"}], "9"]}], "}"}]], "Output",
 CellChangeTimes->{3.656357083468433*^9, 3.656357183072921*^9, 
  3.656357261052652*^9, 3.6563640773626204`*^9}]
}, Open  ]],

Cell[TextData[StyleBox["\[LineSeparator]Overlaying Vector Fields/Gradient \
Fields", "Subsubsection",
 FontWeight->"Bold"]], "Text",
 CellChangeTimes->{{3.545586896615*^9, 3.5455869026140003`*^9}, {
   3.545588800658*^9, 3.545588804586*^9}, {3.5455899869229136`*^9, 
   3.545590002667488*^9}, 3.545617235548399*^9, {3.656357293062419*^9, 
   3.656357294966528*^9}, 3.656370081931305*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"p1", "=", 
  RowBox[{"VectorPlot", "[", 
   RowBox[{"myGradf", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"VectorColorFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"Red", "&"}], ")"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"p2", "=", 
  RowBox[{"ContourPlot", "[", 
   RowBox[{"myf", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"Contours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p2", ",", "p1"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5456172445340147`*^9, 3.5456174056510973`*^9}, {
  3.5456175477673473`*^9, 3.5456175640849757`*^9}, {3.5456178161502185`*^9, 
  3.545617897816362*^9}, {3.5456179285172157`*^9, 3.54561793084162*^9}, {
  3.5777827942855997`*^9, 3.5777828228024*^9}, {3.5777829009896*^9, 
  3.5777829099128*^9}, {3.5777829489606*^9, 3.5777829619398003`*^9}, {
  3.577783095975*^9, 3.5777831053038*^9}, {3.5777832057902*^9, 
  3.5777832150098*^9}, {3.6563573392539597`*^9, 3.6563574078988667`*^9}, {
  3.6563581081151733`*^9, 3.656358116580297*^9}, {3.6563640488516808`*^9, 
  3.656364062264409*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
    {Arrowheads[{{0.04587368524026634, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, -3.835895278030231}, \
{-4.36923562443198, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.044858698282982175`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, -3.287910238311627}, \
{-4.36923562443198, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.04398157175864748, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, -2.739925198593023}, \
{-4.36923562443198, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.04325069393287603, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, -2.1919401588744187`}, \
{-4.36923562443198, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.04267357994809448, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, -1.6439551191558142`}, \
{-4.36923562443198, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.04225653031301002, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, -1.0959700794372098`}, \
{-4.36923562443198, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.04200431300710784, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, -0.5479850397186052}, \
{-4.36923562443198, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.041919903350326, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, -8.517398515440158*^-16}, \
{-4.36923562443198, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.04200431300710784, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, 
       0.5479850397186036}, {-4.36923562443198, 0.5948721031385374}}]}}, 
    {Arrowheads[{{0.04225653031301002, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, 1.095970079437208}, {-4.36923562443198,
        1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.04267357994809448, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, 
       1.6439551191558124`}, {-4.36923562443198, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.043250693932876026`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, 2.191940158874417}, {-4.36923562443198,
        2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.04398157175864748, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, 2.739925198593021}, {-4.36923562443198,
        2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.044858698282982175`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, 3.287910238311625}, {-4.36923562443198,
        3.569232618831229}}]}}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, 3.83589527803023}, {-4.36923562443198, 
       4.164104721969767}}]}}, 
    {Arrowheads[{{0.04047441545604541, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.1120837504868746`, -3.835895278030231}, \
{-3.745059106655983, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.03932030163451397, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, -3.287910238311627}, \
{-3.7450591066559826`, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.038316601667509505`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, -2.739925198593023}, \
{-3.7450591066559826`, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.03747540306201995, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, -2.1919401588744187`}, \
{-3.7450591066559826`, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.036807848817500134`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, -1.6439551191558142`}, \
{-3.7450591066559826`, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.036323513914265956`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.1120837504868746`, -1.0959700794372098`}, \
{-3.745059106655983, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.036029787956420485`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, -0.5479850397186052}, \
{-3.7450591066559826`, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.035931345728850886`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.1120837504868746`, -8.517398515440158*^-16}, \
{-3.745059106655983, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.036029787956420485`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, 
       0.5479850397186036}, {-3.7450591066559826`, 0.5948721031385374}}]}}, 
    {Arrowheads[{{0.036323513914265956`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.1120837504868746`, 
       1.095970079437208}, {-3.745059106655983, 1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.036807848817500134`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, 
       1.6439551191558124`}, {-3.7450591066559826`, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.037475403062019984`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.1120837504868746`, 
       2.191940158874417}, {-3.745059106655983, 2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.038316601667509505`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, 
       2.739925198593021}, {-3.7450591066559826`, 2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.039320301634513964`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, 
       3.287910238311625}, {-3.7450591066559826`, 3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.04047441545604533, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, 3.83589527803023}, {-3.7450591066559826`,
        4.164104721969767}}]}}, 
    {Arrowheads[{{0.03526595043757587, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, -3.835895278030231}, \
{-3.120882588879986, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.033935159855025814`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, -3.287910238311627}, \
{-3.120882588879986, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.032766918028761666`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, -2.739925198593023}, \
{-3.120882588879986, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.031779156508910805`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, -2.1919401588744187`}, \
{-3.120882588879986, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.03098913823146652, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, -1.6439551191558142`}, \
{-3.120882588879986, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.03041227740299734, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, -1.0959700794372098`}, \
{-3.120882588879986, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.030060847857996557`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, -0.5479850397186052}, \
{-3.120882588879986, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.02994278810737572, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, -8.517398515440158*^-16}, \
{-3.120882588879986, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.030060847857996557`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, 
       0.5479850397186036}, {-3.120882588879986, 0.5948721031385374}}]}}, 
    {Arrowheads[{{0.03041227740299734, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, 
       1.095970079437208}, {-3.120882588879986, 1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.030989138231466512`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, 
       1.6439551191558124`}, {-3.120882588879986, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.03177915650891079, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, 
       2.191940158874417}, {-3.120882588879986, 2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.032766918028761666`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, 
       2.739925198593021}, {-3.120882588879986, 2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.033935159855025814`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, 
       3.287910238311625}, {-3.120882588879986, 3.569232618831229}}]}}, 
    {Arrowheads[{{0.03526595043757583, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, 3.83589527803023}, {-3.120882588879986,
        4.164104721969767}}]}}, 
    {Arrowheads[{{0.030346694363538266`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, -3.835895278030231}, \
{-2.4967060711039895`, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.02878940209373241, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, -3.287910238311627}, \
{-2.4967060711039895`, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.027402655266087518`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, -2.739925198593023}, \
{-2.4967060711039895`, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.026213534423009343`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, -2.1919401588744187`}, \
{-2.4967060711039895`, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.025249975977362584`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, -1.6439551191558142`}, \
{-2.4967060711039895`, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.02453856587833345, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, -1.0959700794372098`}, \
{-2.4967060711039895`, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.024101642526393595`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, -0.5479850397186052}, \
{-2.4967060711039895`, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.02395423048590058, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, -8.517398515440158*^-16}, \
{-2.4967060711039895`, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.024101642526393595`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, 
       0.5479850397186036}, {-2.4967060711039895`, 0.5948721031385374}}]}}, 
    {Arrowheads[{{0.024538565878333442`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, 
       1.095970079437208}, {-2.4967060711039895`, 1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.025249975977362577`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, 
       1.6439551191558124`}, {-2.4967060711039895`, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.02621353442300933, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, 
       2.191940158874417}, {-2.4967060711039895`, 2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.027402655266087518`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, 
       2.739925198593021}, {-2.4967060711039895`, 2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.02878940209373239, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, 
       3.287910238311625}, {-2.4967060711039895`, 3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.030346694363538224`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, 3.83589527803023}, {-2.4967060711039895`,
        4.164104721969767}}]}}, 
    {Arrowheads[{{0.02588208071415258, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, -3.835895278030231}, \
{-1.872529553327992, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.02403726099651346, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, -3.287910238311627}, \
{-1.872529553327992, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.022357677851958094`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, -2.739925198593023}, \
{-1.872529553327992, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.020883238021106764`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, -2.1919401588744187`}, \
{-1.872529553327992, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.019660150817257, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, -1.6439551191558142`}, \
{-1.872529553327992, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.018737701531009985`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, -1.0959700794372098`}, \
{-1.872529553327992, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.018161756957132964`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, -0.5479850397186052}, \
{-1.872529553327992, -0.5948721031385393}}]}}, 
    {Arrowheads[{{0.01796567286442543, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, -8.517398515440158*^-16}, \
{-1.872529553327992, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.018161756957132964`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, 0.5479850397186036}, {-1.872529553327992,
        0.5948721031385374}}]}}, 
    {Arrowheads[{{0.01873770153100998, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, 1.095970079437208}, {-1.872529553327992, 
       1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.019660150817256992`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, 
       1.6439551191558124`}, {-1.872529553327992, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.02088323802110675, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, 2.191940158874417}, {-1.872529553327992, 
       2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.022357677851958094`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, 2.739925198593021}, {-1.872529553327992, 
       2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.024037260996513442`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, 3.287910238311625}, {-1.872529553327992, 
       3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.025882080714152524`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, 3.83589527803023}, {-1.872529553327992, 
       4.164104721969767}}]}}, 
    {Arrowheads[{{0.02214876949551078, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, -3.835895278030231}, \
{-1.248353035551995, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.019961858738250484`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, -3.287910238311627}, \
{-1.248353035551995, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.017903956183014342`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, -2.739925198593023}, \
{-1.248353035551995, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.016024840664342316`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, -2.1919401588744187`}, \
{-1.248353035551995, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.014394701046866205`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, -1.6439551191558142`}, \
{-1.248353035551995, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.013106767211504671`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, -1.0959700794372098`}, \
{-1.248353035551995, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.012269282939166725`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, -0.5479850397186052}, \
{-1.248353035551995, -0.5948721031385393}}]}}, 
    {Arrowheads[{{0.01197711524295029, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, -8.517398515440158*^-16}, \
{-1.248353035551995, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.012269282939166721`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, 
       0.5479850397186036}, {-1.248353035551995, 0.5948721031385374}}]}}, 
    {Arrowheads[{{0.013106767211504665`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, 
       1.095970079437208}, {-1.248353035551995, 1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.014394701046866194`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, 
       1.6439551191558124`}, {-1.248353035551995, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.0160248406643423, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, 
       2.191940158874417}, {-1.248353035551995, 2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.01790395618301433, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622924`, 
       2.739925198593021}, {-1.248353035551995, 2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.019961858738250463`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, 
       3.287910238311625}, {-1.248353035551995, 3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.022148769495510718`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, 3.83589527803023}, {-1.248353035551995,
        4.164104721969767}}]}}, 
    {Arrowheads[{{0.019569862621083595`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, -3.835895278030231}, \
{-0.624176517775998, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.017055419582311163`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, -3.287910238311627}, \
{-0.624176517775998, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.014593258027120377`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, -2.739925198593023}, \
{-0.624176517775998, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.012215033817406115`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, -2.1919401588744187`}, \
{-0.624176517775998, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.009980929369125245, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, -1.6439551191558142`}, \
{-0.624176517775998, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.008012420332171161, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, -1.0959700794372098`}, \
{-0.624176517775998, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.006553383605752341, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, -0.5479850397186052}, \
{-0.624176517775998, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.005988557621475151, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, -8.517398515440158*^-16}, \
{-0.624176517775998, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.0065533836057523375`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, 
       0.5479850397186036}, {-0.624176517775998, 0.5948721031385374}}]}}, 
    {Arrowheads[{{0.008012420332171154, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, 1.095970079437208}, {-0.624176517775998,
        1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.009980929369125235, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, 
       1.6439551191558124`}, {-0.624176517775998, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.012215033817406091`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, 2.191940158874417}, {-0.624176517775998,
        2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.014593258027120377`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, 2.739925198593021}, {-0.624176517775998,
        2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.017055419582311142`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, 3.287910238311625}, {-0.624176517775998,
        3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.019569862621083522`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, 3.83589527803023}, {-0.624176517775998, 
       4.164104721969767}}]}}, 
    {Arrowheads[{{0.018631068155700484`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, -3.835895278030231}, \
{-9.701651980513714*^-16, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.015969486990600388`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, -3.287910238311627}, \
{-9.701651980513714*^-16, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.013307905825500314`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, -2.739925198593023}, \
{-9.701651980513714*^-16, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.010646324660400266`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, -2.1919401588744187`}, \
{-9.701651980513714*^-16, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.007984743495300194, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, -1.6439551191558142`}, \
{-9.701651980513714*^-16, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.005323162330200133, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, -1.0959700794372098`}, \
{-9.701651980513714*^-16, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.0026615811651000665`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, -0.5479850397186052}, \
{-9.701651980513714*^-16, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.0026615811651000605`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, 
       0.5479850397186036}, {-9.701651980513714*^-16, 0.5948721031385374}}]}}, 
    {Arrowheads[{{0.005323162330200121, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, 
       1.095970079437208}, {-9.701651980513714*^-16, 1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.007984743495300182, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, 
       1.6439551191558124`}, {-9.701651980513714*^-16, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.010646324660400242`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, 
       2.191940158874417}, {-9.701651980513714*^-16, 2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.013307905825500314`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, 
       2.739925198593021}, {-9.701651980513714*^-16, 2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.015969486990600364`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, 
       3.287910238311625}, {-9.701651980513714*^-16, 3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.018631068155700408`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, 
       3.83589527803023}, {-9.701651980513714*^-16, 4.164104721969767}}]}}, 
    {Arrowheads[{{0.019569862621083588`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, -3.835895278030231}, {
       0.6241765177759961, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.017055419582311156`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.518680625081145, -3.287910238311627}, {
       0.6241765177759961, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.01459325802712037, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, -2.739925198593023}, {
       0.6241765177759961, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.012215033817406108`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, -2.1919401588744187`}, {
       0.6241765177759961, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.009980929369125239, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, -1.6439551191558142`}, {
       0.6241765177759961, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.008012420332171153, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, -1.0959700794372098`}, {
       0.6241765177759961, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.006553383605752324, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.518680625081145, -0.5479850397186052}, {
       0.6241765177759961, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.005988557621475139, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, -8.517398515440158*^-16}, {
       0.6241765177759961, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.006553383605752327, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, 0.5479850397186036}, {0.6241765177759961,
        0.5948721031385374}}]}}, 
    {Arrowheads[{{0.008012420332171144, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, 1.095970079437208}, {0.6241765177759961, 
       1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.009980929369125225, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, 1.6439551191558124`}, {0.624176517775996,
        1.784616309415614}}]}}, 
    {Arrowheads[{{0.012215033817406086`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, 2.191940158874417}, {0.6241765177759961, 
       2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.01459325802712037, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.518680625081145, 2.739925198593021}, {0.6241765177759961, 
       2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.017055419582311136`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.518680625081145, 3.287910238311625}, {0.6241765177759961, 
       3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.019569862621083515`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.518680625081145, 3.83589527803023}, {0.6241765177759961, 
       4.164104721969767}}]}}, 
    {Arrowheads[{{0.022148769495510773`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, -3.835895278030231}, {
       1.2483530355519932`, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.019961858738250477`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, -3.287910238311627}, {
       1.2483530355519932`, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.01790395618301433, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, -2.739925198593023}, {
       1.2483530355519932`, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.016024840664342305`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, -2.1919401588744187`}, {
       1.2483530355519932`, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.014394701046866193`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, -1.6439551191558142`}, {
       1.2483530355519932`, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.013106767211504658`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, -1.0959700794372098`}, {
       1.2483530355519932`, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.01226928293916671, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, -0.5479850397186052}, {
       1.2483530355519932`, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.011977115242950278`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, -8.517398515440158*^-16}, {
       1.2483530355519932`, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.012269282939166709`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, 0.5479850397186036}, {
       1.2483530355519932`, 0.5948721031385374}}]}}, 
    {Arrowheads[{{0.013106767211504654`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, 1.095970079437208}, {
       1.2483530355519932`, 1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.014394701046866186`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, 1.6439551191558124`}, {
       1.2483530355519932`, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.016024840664342288`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, 2.191940158874417}, {
       1.2483530355519932`, 2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.01790395618301433, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, 2.739925198593021}, {
       1.2483530355519932`, 2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.019961858738250456`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, 3.287910238311625}, {
       1.2483530355519932`, 3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.02214876949551071, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, 3.83589527803023}, {1.2483530355519932`,
        4.164104721969767}}]}}, 
    {Arrowheads[{{0.025882080714152562`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, -3.835895278030231}, {
       1.87252955332799, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.02403726099651344, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, -3.287910238311627}, {
       1.87252955332799, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.022357677851958073`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, -2.739925198593023}, {
       1.87252955332799, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.02088323802110674, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, -2.1919401588744187`}, {
       1.87252955332799, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.01966015081725697, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, -1.6439551191558142`}, {
       1.87252955332799, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.01873770153100996, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, -1.0959700794372098`}, {
       1.87252955332799, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.01816175695713294, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, -0.5479850397186052}, {
       1.87252955332799, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.017965672864425405`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, -8.517398515440158*^-16}, {
       1.87252955332799, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.018161756957132937`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, 0.5479850397186036}, {1.87252955332799, 
       0.5948721031385374}}]}}, 
    {Arrowheads[{{0.018737701531009957`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, 1.095970079437208}, {1.87252955332799, 
       1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.019660150817256968`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, 1.6439551191558124`}, {1.87252955332799,
        1.784616309415614}}]}}, 
    {Arrowheads[{{0.020883238021106726`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, 2.191940158874417}, {1.87252955332799, 
       2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.022357677851958073`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, 2.739925198593021}, {1.87252955332799, 
       2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.02403726099651342, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, 3.287910238311625}, {1.87252955332799, 
       3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.025882080714152506`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, 3.83589527803023}, {1.87252955332799, 
       4.164104721969767}}]}}, 
    {Arrowheads[{{0.030346694363538256`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, -3.835895278030231}, {
       2.4967060711039872`, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.028789402093732385`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, -3.287910238311627}, {
       2.4967060711039872`, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.027402655266087494`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, -2.739925198593023}, {
       2.4967060711039872`, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.026213534423009315`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, -2.1919401588744187`}, {
       2.4967060711039872`, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.02524997597736256, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, -1.6439551191558142`}, {
       2.4967060711039872`, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.02453856587833342, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, -1.0959700794372098`}, {
       2.4967060711039872`, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.02410164252639357, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, -0.5479850397186052}, {
       2.4967060711039872`, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.023954230485900556`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, -8.517398515440158*^-16}, {
       2.4967060711039872`, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.02410164252639357, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, 0.5479850397186036}, {2.4967060711039872`,
        0.5948721031385374}}]}}, 
    {Arrowheads[{{0.024538565878333418`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, 1.095970079437208}, {2.4967060711039872`, 
       1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.025249975977362553`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, 1.6439551191558124`}, {
       2.4967060711039872`, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.02621353442300931, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, 2.191940158874417}, {2.4967060711039872`, 
       2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.027402655266087494`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, 2.739925198593021}, {2.4967060711039872`, 
       2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.02878940209373237, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, 3.287910238311625}, {2.4967060711039872`, 
       3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.030346694363538203`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, 3.83589527803023}, {2.4967060711039872`, 
       4.164104721969767}}]}}, 
    {Arrowheads[{{0.03526595043757583, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, -3.835895278030231}, {
       3.120882588879984, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.03393515985502577, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, -3.287910238311627}, {
       3.120882588879984, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.03276691802876162, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, -2.739925198593023}, {
       3.120882588879984, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.03177915650891077, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.5934031254057275`, -2.1919401588744187`}, {
       3.120882588879984, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.030989138231466467`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, -1.6439551191558142`}, {
       3.120882588879984, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.03041227740299731, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.5934031254057275`, -1.0959700794372098`}, {
       3.120882588879984, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.030060847857996533`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.5934031254057275`, -0.5479850397186052}, {
       3.120882588879984, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.029942788107375693`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.5934031254057275`, -8.517398515440158*^-16}, {
       3.120882588879984, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.03006084785799651, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, 0.5479850397186036}, {3.120882588879984, 
       0.5948721031385374}}]}}, 
    {Arrowheads[{{0.030412277402997286`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, 1.095970079437208}, {3.120882588879984, 
       1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.03098913823146646, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, 1.6439551191558124`}, {3.120882588879984, 
       1.784616309415614}}]}}, 
    {Arrowheads[{{0.03177915650891075, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, 2.191940158874417}, {3.120882588879984, 
       2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.03276691802876164, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.5934031254057275`, 2.739925198593021}, {3.120882588879984, 
       2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.03393515985502576, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, 3.287910238311625}, {3.120882588879984, 
       3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.035265950437575785`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, 3.83589527803023}, {3.120882588879984, 
       4.164104721969767}}]}}, 
    {Arrowheads[{{0.04047441545604536, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, -3.835895278030231}, {
       3.745059106655981, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.03932030163451397, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, -3.287910238311627}, {
       3.745059106655981, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.038316601667509505`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, -2.739925198593023}, {
       3.745059106655981, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.03747540306201995, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, -2.1919401588744187`}, {
       3.745059106655981, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.036807848817500134`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, -1.6439551191558142`}, {
       3.745059106655981, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.03632351391426591, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, -1.0959700794372098`}, {
       3.745059106655981, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.036029787956420485`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, -0.5479850397186052}, {
       3.745059106655981, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.03593134572885083, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, -8.517398515440158*^-16}, {
       3.745059106655981, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.036029787956420485`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, 0.5479850397186036}, {3.745059106655981,
        0.5948721031385374}}]}}, 
    {Arrowheads[{{0.03632351391426591, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, 1.095970079437208}, {3.745059106655981, 
       1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.036807848817500134`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, 1.6439551191558124`}, {
       3.745059106655981, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.03747540306201994, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, 2.191940158874417}, {3.745059106655981, 
       2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.038316601667509505`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, 2.739925198593021}, {3.745059106655981, 
       2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.039320301634513964`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, 3.287910238311625}, {3.745059106655981, 
       3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.04047441545604533, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, 3.83589527803023}, {3.745059106655981, 
       4.164104721969767}}]}}, 
    {Arrowheads[{{0.04587368524026634, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, -3.835895278030231}, {
       4.369235624431978, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.044858698282982175`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, -3.287910238311627}, {
       4.369235624431978, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.04398157175864748, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, -2.739925198593023}, {
       4.369235624431978, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.04325069393287603, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, -2.1919401588744187`}, {
       4.369235624431978, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.04267357994809448, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, -1.6439551191558142`}, {
       4.369235624431978, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.04225653031301002, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, -1.0959700794372098`}, {
       4.369235624431978, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.04200431300710784, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, -0.5479850397186052}, {
       4.369235624431978, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.041919903350326, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, -8.517398515440158*^-16}, {
       4.369235624431978, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.04200431300710784, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, 0.5479850397186036}, {4.369235624431978,
        0.5948721031385374}}]}}, 
    {Arrowheads[{{0.04225653031301002, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, 1.095970079437208}, {4.369235624431978, 
       1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.04267357994809448, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, 1.6439551191558124`}, {
       4.369235624431978, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.043250693932876026`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, 2.191940158874417}, {4.369235624431978, 
       2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.04398157175864748, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, 2.739925198593021}, {4.369235624431978, 
       2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.044858698282982175`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, 3.287910238311625}, {4.369235624431978, 
       3.569232618831229}}]}}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, 3.83589527803023}, {4.369235624431978, 
       4.164104721969767}}]}}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "TransparentPolygonMesh" -> True},
  PlotRange->{{-4.404061017820885, 4.404061017820885}, {-4.404061017820885, 
   4.404061017820885}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.545617328399762*^9, 3.5456173861978636`*^9}, 
   3.545617566128579*^9, {3.5456178186618233`*^9, 3.545617900499567*^9}, 
   3.545617932417223*^9, 3.5777828248616*^9, 3.5777829107864*^9, 
   3.5777829631722*^9, {3.5777831071602*^9, 3.5777831380550003`*^9}, {
   3.5777832103454*^9, 3.5777832386594*^9}, 3.60911556494733*^9, 
   3.656357309961537*^9, 3.656357355258143*^9, {3.656357394052951*^9, 
   3.6563574091575317`*^9}, {3.656358110031333*^9, 3.656358117650107*^9}, {
   3.656364066976273*^9, 3.656364086096344*^9}}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFnQm4jlX3/4/jzCMpkkQIZSqp9IZ7JxmikuaigRSaRLxJIk0nEYqURKIM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   "], {{
     {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmFtsVWUWx3c5e5991Jk3fRjnRYhg8GUeCphxvGQK1ERjIiC+mNgLNZrM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         "]], PolygonBox[CompressedData["
1:eJwllEtsjGEUhr/pzPf/vwQrG7XRxCVjYzG0IUIoFmxkFl2Q6ChJJWQajUuE
calqtDqMEZdEU7eFCEmliU1LaV2qF5FIqQ0RrVtcYtNEsfC8OYuTOe933nO+
7z/nPVNWU5fOljjn0lgCe+id64vzi90JnbsLXhxzrhO7BV4eOFeLfx1yU+Tc
FHAqYTmdxDfDT1HnImdHiZ/CBvErOPvr7Uwx1fwDfoyNkHsJK5DfCp4HtwEc
wn0KfoP/GhsmvgW8gXgPuEOY+8epVeQsg19Dzi7qzwenwDvgZ53dMQR/AfFR
1SJnGvEj4CL8heBfcNdz1hWzOwrgt+SMxeybX4K/ge8Rm6TGd/wi1oaf4yxL
vMfb21qxRmJrqV9F/Sz5a/CnU39Fwr7puWphg3HroXqZ9/b2Rs4ykdVQrTx2
HH8jnHSJvTHjbSaaTZL8WZH1SL3SNz4hfgF8Te+hZj24Es59Z29ajd8UWu1q
zmqJP8KGwANYN7GlcNYlrAfqRU53wr3B2YnIcpTbD7+L+AB4HP+DZgZORTYb
nS3CP8bZHN5fTr0G/BbOblOrA85hcpvBN8Hd4EPgssB6J464MwPjDoNPg8sD
09YLcAG8j5yP8Cu5ox3/n7e7pEFpcQ/8Kvhzie/Fn/Q2+37ieeJlWG/cOLPx
l8FJwt2N7QTnAvPVkyXgrVhbzDS3LbI7dbc0OUN69HZXnWqADwQ2C9U8GNgO
aZfU0/1wf4amLc3oB/7V0LSgnbiC/xWbiJsGv+A3S4Pgs1gL/qfQeifO59C+
Sd+mnfztbce0a9LsmdBmrFlLg33eZqbZjWHPvP0H6L9APXkAnhrY7kgjSWpv
0vc52yHtkjQhbUzAWQn3cmi7LE47/qrAYpqxZj1C/vaYzewd8ZOhfYt2Vrt7
Tj2Im4bP45dGpnXtgHah15v21AP1QjuoXXwPfhVaz9V7aa5aXG8x1VRtaUha
0htKA9OQtKSZVoBHQ+uFdla7+x8qCrv5
         "]]}]}, 
     {RGBColor[0.5237980769230769, 0.48778846153846156`, 0.5111538461538462], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mXnUlVUVxu99730H19JMLcUyxWQpVpQ4pAiCKeKEQ44fYCRoaipiMqmA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         "]], PolygonBox[CompressedData["
1:eJwtl2dwVVUUhV+59577Q0cBxY7gOIqKBcUSBRQCQXooCiEaktgQNEQCQSWh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         "]]}]}, 
     {RGBColor[0.7946634615384616, 0.5829807692307692, 0.3519230769230769], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXv0llWVx9/f+z43wTuaAi4RRy7eUFERbfACGmDKVS1QbIl5QxER0Z+a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         "]], PolygonBox[CompressedData["
1:eJwtlwuQz1UUx3//x+93f2ubsIisaa2EGPIodnqwbbFIu3YXrbWYdj1X3qxH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         "]]}]}, 
     {RGBColor[0.9264423076923077, 0.6861057692307692, 0.37197115384615376`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXmwVcURxu+95545RzZREVFADYvbk+UhWCJqIDGR3SWCJoBJKYK4BitG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         "]], PolygonBox[CompressedData["
1:eJwtl3mwz1UYxn/b95xfV7Yml+i2ScoVUZQsudNCaCFLhWrIkkS3ERdNk8yk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         "]]}]}, 
     {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lltsVVUQhvc+PWfvUi4tl1MoUEi5JF5ARCGAFn3yQcEHJWgCookJKqYR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         "]], PolygonBox[CompressedData["
1:eJwtlEtIVVEUhvc917vPxUSKHiaocCuhgqDoQUTWqEFqg1IhMhOCXiRZNAhL
etigmpU9LEPI1B5EWlGTEHpRWpBhDTKTAq0oMbyUGQk9vp/V4Of8/1pr773O
WmvvxMbKNTsC51wxSAEL486tgNTBf3nnBkLndkecGyXoA7wTWw16DJ2OTg3N
lxV1bhH8B/gLzyJmJDSbfGXEbGbtTdAEP8L+9THn0vBPRieIWQxfi205fAm2
Y/BrxDfA1xFfi25DN6K3oU+jN5BvgrPyWFMO38Iem+BJYmLwezoTfgvch18E
dfCzoAl+gT1anK3ZSvwl0AoPQBu+Zm+xRej1+N5gq+C8L8Cjb6AfBbZGa++i
OwI7Q2e1oLvZ/wD+ffingjz0DGo8hXz/hPavtew3SOwJbMkU+6er6JfsUUh8
JzGv4OfAbHzt6GfwOayfGLWejUdnhharM3RWDugObI9seADOwK9ji8Kng9fw
UmzT4BFvuemfXsDTyScTHeGMSfjPq38Ry6Ee3gHSiK1GP4G3kvM8eCvoQvej
D0Wsx+r1gtB6kcSWgz/DWy2HsM3FV4ye4GwYv6MHYsY1U9/QveBz1P75Ob6S
0HqlnEbQ+XHLpZQ1BfD5oZ01Dl8dOh99PGI1Vq1lk08z3sf3qbfaagY1i++8
1UY1fA+vZv3BqP2z/r0rZrkrJ+W2CiyDZ7NmO/5K9G/23kPMTvhHb7OsGf4E
fwsKnM14HzyXmD54lWYEXoPtsbM9DsNLvM2KaqRa3QGXA+tpg2rlrfaawQzW
n/J291LBSXhR3GZxP6jCv1fzDL+NvxG+2lusZlazWxba7CtH5boybrVVTrno
Wfj7iT+KngkvCO0uqgaF8Ife9tadeaBee7u7PdgGvb0xemu0xxi8J2Z3V3dW
d7fd26zqjuquDnmrTS+2r/BRb2+JavATPuwtF9UwCd8FKgKbYc2yeqLeJJST
7mdos62ZbdZ8+v8+sFSzE1qtNMPD6r23Xqpmqt2VmL11ehP1Nv4DCVuyjA==

         "]]}]}}, {{}, 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], LineBox[CompressedData["
1:eJwVz0krhWEYBuAHHYSsDCvK2o5jKH6BYYGFjaGUKTJsZPgVppQ6Jc5ZOOqg
2KD4BdaKjTFssGHJZXF138/zvuc731c3Mts7kxcR4/QnIjqKIlaLI/b1lJ6V
Q+ZhOs1ddDNVGDFNE23mpGyX87Lc3Qq9kgxpcp5z7exXVplDr5Zn5l19jzQD
doPc6ndkOWDNvVGe9RdyHLJpN8mb/s4rix5/JI/ZdjbHt/7DCaek7BbI918F
nNtdsGM3YR4nwY350v6KpLlWNsga2Si3fOudO4/6E6WU0MyYOxus/78/9fSQ
cX/F+TJ9fr8kP/ng3tmXfJBlspUW/gDREjjq
         "]], 
        LineBox[{2188, 106, 1771, 1773, 1772, 2092, 1828, 1829, 1774, 1776, 
         1775, 2095, 1832, 1833, 1784, 1786, 1785, 2101, 1552, 1837, 2196, 
         1485, 2010, 1486, 1840, 1559, 1839, 1897, 1798, 1497, 1729, 1730, 
         1441, 1402, 1664, 1904, 1903, 1681, 1571, 1667, 1666, 1573, 2121, 
         2123, 2122, 1502, 1733, 1734, 1735, 1916, 1415}], 
        LineBox[{1805, 1806, 1736, 1448, 1687, 1688, 2036, 2037, 2034, 1507, 
         2035, 1620, 1621, 1515, 1809, 1514, 2046, 1417, 1368, 1737, 1738, 
         1689, 1690, 1691, 1878, 2063, 1524, 1877, 1455, 1958, 1456, 1743, 
         1537, 2070, 1816, 1817, 1745, 1747, 1746, 2077, 1821, 1822, 1757, 
         1759, 1758, 2083, 1826, 1827, 1767, 2188}]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], LineBox[CompressedData["
1:eJwVzr8rxHEcx/EPxd3mTMQgkoGSyaJDIVY3kMhgMJzcdRaO6UodNzCILmGw
UCY//gNnotyAgRUTIwviYXj2fL9e7/fn27d5Jp1IVYQQ0khUoTqEUe6PhNCH
Z/Mnj+hj/CrX8AuP6U44REN451/9GxcwgWv7G+xhHwcYdxNz/2Ff5CP51HzM
Z1x2U4k6uwZdI+7kB9yjSZ7kKUTR4i7CW97O4tz+AnmsYUeXRMl8hQ1soqib
x7S3GV71nR7zMrLoktvddeBL/sE3uvW13KnfNt96+2Quc1zeRb19UjeHCB7t
LnUlHJpXkDPneME+gwE55W0r5zGIuH6Ie7nt/9/sh3mRs1jCulzAH69QOl4=

         "]], LineBox[CompressedData["
1:eJwV0EsrBGAYhuFvymkGKYcVGwuEGlEWrFihFGaBSEooCilj5g+QlbJRSo3D
Ags/gHJeK6cSNlixtibXLO7u533e95uZpnpiITEfCSEsYi03hAPE80IYKgih
iYf5XZfKD2FLbtAlOG3ul/swYK7npG4Zq+6nzK1yAaL4xAfe7DbdN8uVbjrk
Ku7kcz7Ds5sc+ylMI2M+1Z8gYg5I6rbRqyvBivdL5nE5Lj+6ecIdHnCPRv01
3+ACV7hEnX7Mu1qOcQ0XchopTPrcDRzJh3jFC0a9HcGuvINM9je6q/D+j8v5
l2/1x7zndh9lKEWx/ZxdLPt9iOLHXRF/86xdj7s2tMjt/KUfy/5/5i5zNwZ1
M+Z1/APcqTb0
         "]]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], LineBox[CompressedData["
1:eJwVzzkvRFEYBuAzjKVFQyKWRFCMgobOUkgoSCgsiUbP2COxjIKQEIQG/0Cj
EVuorZVKdPgBBImxx6N48n7n/c69N7e4N97WHwkhjBFLD2GJRSYzQ5higgTT
lOlH5RgjNDovMGAeJM4wQxTqE9EQ+sx15lnmqGVeN5nmneZxuZURwiYbXDvX
2OfYVcts+cuV/tb+Uq7rY+YqWcmL/SvPlOlLqdBf/N/nlHPOKNcfyiP2OGCf
Ev295x+4o1hXRMH/v3CjO/HtHd2xXNPlm1P1ueaozJMzugS77mzLHrnMG1n2
SdnlbidR50fnVPkk02SzPiJTaPF8K912HfpP8xcf/PBNkz4p36mngXb32/Wr
rPAHPdk+xA==
         "]], LineBox[CompressedData["
1:eJwV0LsvQ2EYB+DP4DKTmCxMFomRRBhcB9cqcYuhdSmpVlKD0WKikyJidFt0
IdEu9RcIE7FIJSR2Yebp8OT3fb/3PTknpzmWjqSqQgjbtNeEkGWVaHUIfbUh
9DJXF8IsX7p5uUC/foApXcL+gpxwH2fFfJlv3apMENFPEiVtf5NO1sw65LrM
yHrZQN5ewfPXsiibdNXmM+6zvDqX9BfykisW9XHdh/Mn1+TJVb6Rkvk9+2Q5
1iV5dH7igBwnujQ/nv3lhltOdRlidv7cH5zvZIEiS5X30+jc5XufzcvuL/Jd
9ui6iZvv6PacW5xHOXNP2dkgyZDZIG/6ETnKMK12z3W7bNnLVP65foyybkpO
E6Wt8m90R/KQf6x2P+k=
         "]]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], LineBox[CompressedData["
1:eJwl0jlMVGEUhuHfwhlI1EoLoZFSW4xEXBLXxthQaiIMklhAxsS4hCCggET2
0QQsNKitmoBGLIC4KxqlcUELtVPcg52Chc+JxZv3fOece+fOf29Z7cGq/KKU
0hguZlNqRrYopd7FKRXxJfkyWlAj9+nnOJ9JqRy16jrsxy+zCr2Ceh0fwoJe
v/yXb+Gk+7ShHdXy4bgHt9upVB/FEaySy3Dd3h3zUb7LN7jYfJLvyxP8gFfb
XaJfLefiWbFUXqP/yPy5/JineZn+G34iz/BTfstr7ZajxjyHFdggL+dhO8fw
wd4rPs8XUGI2YGdl/A+0mnXHs6t3Y4d6J7ZiO7bFeel32Pvh+p/4iu/4Fuei
/5m/4CNm8SnOTL/TdS3cFfeLM8IWnJab9VvVjbEnb1a/VL9z7Qt+z5X662PX
rIE3cj1v4uNoindm95zdIQxiSn7NeT7LZ1DAQ/kZ13MPd6ML9+RxPhDPwafQ
gdvySLwbLmCX38qgLc5b3qMuUZfiqr0xvSt8k+fju9HfxwP4jT75D1/DHE7I
e+NZkFEPZ/9/z/8AqXRkPw==
         "]]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], {}, {}}}],
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{-4, 4}, {-4, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.545617328399762*^9, 3.5456173861978636`*^9}, 
   3.545617566128579*^9, {3.5456178186618233`*^9, 3.545617900499567*^9}, 
   3.545617932417223*^9, 3.5777828248616*^9, 3.5777829107864*^9, 
   3.5777829631722*^9, {3.5777831071602*^9, 3.5777831380550003`*^9}, {
   3.5777832103454*^9, 3.5777832386594*^9}, 3.60911556494733*^9, 
   3.656357309961537*^9, 3.656357355258143*^9, {3.656357394052951*^9, 
   3.6563574091575317`*^9}, {3.656358110031333*^9, 3.656358117650107*^9}, {
   3.656364066976273*^9, 3.656364086351911*^9}}],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJyFnQm4jlX3/4/jzCMpkkQIZSqp9IZ7JxmikuaigRSaRLxJIk0nEYqURKIM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    "], {{
      {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmFtsVWUWx3c5e5991Jk3fRjnRYhg8GUeCphxvGQK1ERjIiC+mNgLNZrM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          "]], PolygonBox[CompressedData["
1:eJwllEtsjGEUhr/pzPf/vwQrG7XRxCVjYzG0IUIoFmxkFl2Q6ChJJWQajUuE
calqtDqMEZdEU7eFCEmliU1LaV2qF5FIqQ0RrVtcYtNEsfC8OYuTOe933nO+
7z/nPVNWU5fOljjn0lgCe+id64vzi90JnbsLXhxzrhO7BV4eOFeLfx1yU+Tc
FHAqYTmdxDfDT1HnImdHiZ/CBvErOPvr7Uwx1fwDfoyNkHsJK5DfCp4HtwEc
wn0KfoP/GhsmvgW8gXgPuEOY+8epVeQsg19Dzi7qzwenwDvgZ53dMQR/AfFR
1SJnGvEj4CL8heBfcNdz1hWzOwrgt+SMxeybX4K/ge8Rm6TGd/wi1oaf4yxL
vMfb21qxRmJrqV9F/Sz5a/CnU39Fwr7puWphg3HroXqZ9/b2Rs4ykdVQrTx2
HH8jnHSJvTHjbSaaTZL8WZH1SL3SNz4hfgF8Te+hZj24Es59Z29ajd8UWu1q
zmqJP8KGwANYN7GlcNYlrAfqRU53wr3B2YnIcpTbD7+L+AB4HP+DZgZORTYb
nS3CP8bZHN5fTr0G/BbOblOrA85hcpvBN8Hd4EPgssB6J464MwPjDoNPg8sD
09YLcAG8j5yP8Cu5ox3/n7e7pEFpcQ/8Kvhzie/Fn/Q2+37ieeJlWG/cOLPx
l8FJwt2N7QTnAvPVkyXgrVhbzDS3LbI7dbc0OUN69HZXnWqADwQ2C9U8GNgO
aZfU0/1wf4amLc3oB/7V0LSgnbiC/xWbiJsGv+A3S4Pgs1gL/qfQeifO59C+
Sd+mnfztbce0a9LsmdBmrFlLg33eZqbZjWHPvP0H6L9APXkAnhrY7kgjSWpv
0vc52yHtkjQhbUzAWQn3cmi7LE47/qrAYpqxZj1C/vaYzewd8ZOhfYt2Vrt7
Tj2Im4bP45dGpnXtgHah15v21AP1QjuoXXwPfhVaz9V7aa5aXG8x1VRtaUha
0htKA9OQtKSZVoBHQ+uFdla7+x8qCrv5
          "]]}]}, 
      {RGBColor[0.5237980769230769, 0.48778846153846156`, 0.5111538461538462],
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mXnUlVUVxu99730H19JMLcUyxWQpVpQ4pAiCKeKEQ44fYCRoaipiMqmA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          "]], PolygonBox[CompressedData["
1:eJwtl2dwVVUUhV+59577Q0cBxY7gOIqKBcUSBRQCQXooCiEaktgQNEQCQSWh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          "]]}]}, 
      {RGBColor[0.7946634615384616, 0.5829807692307692, 0.3519230769230769], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXv0llWVx9/f+z43wTuaAi4RRy7eUFERbfACGmDKVS1QbIl5QxER0Z+a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          "]], PolygonBox[CompressedData["
1:eJwtlwuQz1UUx3//x+93f2ubsIisaa2EGPIodnqwbbFIu3YXrbWYdj1X3qxH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          "]]}]}, 
      {RGBColor[0.9264423076923077, 0.6861057692307692, 0.37197115384615376`],
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXmwVcURxu+95545RzZREVFADYvbk+UhWCJqIDGR3SWCJoBJKYK4BitG
QCulMYsQS0XFuC+IEcpSICQaUCOLuCUsAQSVrVS0hGgQFY3iku/H1xT5Y97M
nTPTM9PT/fXX875z/hVnXV6rVCrn6U+meprqF1X6qP18vVJ5pVqpXKz2SWqv
0IDl+n121fUE9Z+s/vUav0K/F6m9VvVk9edFpfK+2mNVj1C9SWWa+ofmlcoQ
le4qhb5tU/8lqvtq7gbJX6PffctKZbvqtqlS6af+jTXLHaZyZM3yL1O7i9pP
0da8CTX/7i9Zx+v3aaoHaY2BKseofKvxH6u8qPGj9P2tmtc6R+031H5Z7aV1
rztPYy6oev8z1P5N6XXHS87PNH5bLc6j/lb63VVrbaj6nJzxa+17i8bsUj0p
eW6fZN321piBGnO22i+p3V+lg+QsUl1qzFqVV9lb8pl61Lzve1X3U/1jzZ2j
NZfq9wsqT6i9SPVClau0j1L10Zo7VvWDGj+V+9K5Ds58LvZ9QexzX51nqsY1
xNl3qn2l2t9Kzh2qP9T3/ipz9O1Qzd+l77eotNe3Aeqfpb5n9HuJvm9W312S
uST5bt7U9xMk5wt9b6a6vX63U2mq33017znV0zSuARtT+2m1n6u7HlLxWRfG
eYfWvJ/91d5V9R4XV6y7l2JMJ8l8OM77x9LnPU7rNkrmKs1frP7h6ltbs1zu
4am4i5a5dTFDv7+JfR1esR88UbUvHCI5gzQ/U1lQ91rHqr9N3brm9zNqz1Z9
ivpXJLerqtfhF3Xfx1Nhp+ioq75t0tjHtPaGun2B/ovDL9ro+5QYjw2crzHX
Zr6LSSoja77vJ2u2Ve71tOhbKbmf12z32PwUzZ2sUlFfW839tGZd/iFq9HlC
3XaJL3Qurdsm2sOh2t9XmnO4yt3qv0b11dpj/5rvc1LVe0EO7Y4qN8R9ce52
Nd8LftlL5Wa1W2j+fNaS/GXoDT2qfFx47ju5z3RJ+OCy5Lv4Wv2DVbZKzn80
f3ryXS5Q3xj1HajyYfgnfopOPk/298+SfZ42vtoqxmK3+xTWSal6E5ijskO/
6/q9XfU6yU+F+95Q+0vJekftL5Jtn/bIqsuWkLnbvsOW2Hv3sKVWpX9/Izk7
uJOwXe4Yf+e+Jpa+s6tVf5SMgdtVZ4XPVVM9Obfsc1WfodIYOrg97LCHyuya
948OwVDkgKPvJfvCu6q3JWPg1uS7pz00/I8x/cNXVgYGbU72qU3JfkX7e1X7
HBgyL/z008CTDclz16s+sWp8w8e7aL/1zDi2OhkHViXPQQ42SVwhvpxeNTYw
BhkfJvd/oPrU3LKQ0zU3NuKDK5Pbf85ts+cHjp1c2nZW5p57R91+3Sd8H/ud
qjF91DdQen487AgdzkmOf8S+YTVjO/qckOwvTVW3yax3bPfWzDF0QNV2MjJw
En32C/xZnlnv6Py3pWPJvpJTjbXnJ2Mstjoa/SXj9t3JWAT2Y1vPJ6/5em68
7Bg+uKBmn2teMUa9GjokXm8JuwV7iUHc45vJ8Wam6r+rv3nmex5Ss28id3rg
BLbRL/CVuavBW5WjNaeq+taYMy8wj3jNPZ4YOL9TY4rM9vp0zfj0GjE0c+z4
r8rb4Zv4KDGkDMx5ILAcPc6IeM7dbNTcFpltB91jO3CY5aFj7u5Lrdsk817u
jrGMGx5ywIeq1mqZ2W/W/x/32cNF4CEzA2tGhL+gD+IR+see0NWBpWPJ/Nz7
gVdhDwMlc1rdfnq96iMz+/4YjT0iM2aepDN3Vrun7qIhuEw7jbm0bjzlXing
KvcL37ksMPfcwIdXkuMjcohZyO4U8sHn3TIDy9Evui2jTRzhTo/JHPfPxGfV
d1ZyH/fM71O0z6PU/kEylnWKtbhTzlWJ+qhofz8Z68YX3jtnaVaxnafcvjK4
8L4GFY7R+wVe3FQ3NlbCXohr2ExvfTsxs36Iua/X3UbnKzPfLzo/JPyd+4TT
YhMtS8f/c7TWypC/lpgYMjtEfULI/2lpPZ9Xuq8h7mVsxLLN4Xcd4o7m1s2j
rqtaTu+QCY9iPmPZb++Q/6uabQJ74Nwtg58Q/4gdxJA5sRYy4VfEaWI0/XMD
6zgnvKVbxfYI9wLj4MbsGf52UcReuAh+SPwAP1kPXkQMGyO9jNbcC1Wfq7XH
aUy3iN0XxR56BVfEZ9Ej8x/QmJGF8W5GMicZWTcvaR/7xcZG5/abq5M5yWHZ
Xh+Hty0MHV4T/GdQaTkDS+P37eFH3QLPiQXoo31wTubNjX0SDzkLeA5ujIq8
o10y/yf/uCo3R64UxnM4NHGNs47bc4/61lHfeiTfZce4a7jSoflef2offgRm
o0/uAr+/I/YMlp6T7c1Bytz7AHv6RU51fOF42ARfCM7RpTD+kJOAQcfl1g1r
4dPHhk1O1Jj2mflF2zhjo+Z2L41hE5NjAXjHWmsK52KrC+uFNrgHt7goOBZ7
YzyxY3DwDuITsYiYhO9fEjwWPgvWgrnEiLEh57GK8Zbcb03EoC8jB8AP8IcL
a+ZjY2M8fAn5xDswnvwT7IZXkwfClcFq8tXdOap+/yIz1lxZuH196Ona0NWk
3HHpuuT4uDP4E3HymfAF+mgTt34uOeM194rCsRve/HLg+sLAds7xXJyX/e6I
nGFJ5phKvJxe+BxP5I69jCcmEm8bY0zzGI/Mm0qvQSyDm8wK3BgZnB7ORQ6J
rJHBfTrH/tF/Q+i2aXAVOP6fCtvgnNxcADvAJg4qPbeWfM/0c9c7A4fAS+4b
vIbPYMvTAlfBb/rhKnAB4gexgzi/M3QIv1saPsX50AtnJJ4wJ4ucZWXkLXDM
ZzPr8y+Fx88rbOPYOnEMbrspc2ymf13gP8J2hM3gv8vqe3F6WfjyksKxYHFh
u9oYcohxq4PPwPc2BldYWjimvFA4J14VZ8Sux4StwlXnZz7vmsjr2xbO1zvW
nQuAf3AdMJNcD7vCFskn3s2s8x658xFkfpI7j9wnctxPMutyS+H2O4XP2ybs
Db/Bf8hbyFNb1z3/wYj9cABiKm8KYCbYw73AwVuU9uPxyW8Z2EeD5L9Z+G6X
595b98hf4XjU8DzW2xh96LAW+vmscHuL5lxQN1aCk+RiWwND8Pl1sc+mpffc
pLS8TaEH7rlF3NG+ER/B1Rz7y5wT7h+6OED1acm8YVLpmHt6xN0NufXIm0Fj
5FHkBgfE3EcKv1cNjf7GaHPmWbn9kFzhPbW/1veWhXG4f2AM8ZC4iK3BO+Ea
7xMvCvt2R95GAh8PLYylZwSedgpb7FxYN3xDPyty64v3p4Y4C3F8bvCjx+Bi
hTH66MJ4Aff5N7m8yiHq71l4j+wV22tM5pSjSvOF22rWJ7GfuAWPfCRybXLu
+5O/3Zesc962sOez1L6z5rxmTs150O64Wfid4qHc36fFGLj7vdEmd+sWeRz5
FrkPMXhp5HX0gzOnRpv8oGfsn37mwgNmRv4yi1ysMO4crHpiYZv7UXC3gaG3
qcE9Rsc9IXNzcMhjA1vQa5ewMXIszgV/+EnhM48ovDb7BG8fzf0+cqb2cHry
u8wZqj+I3Iw3trOTc6phqh/P/c41XO2tuX2gmfZ5W24O9Lj6f5f73eeXmntM
MqfhPeaLeIvopfa03Hxitvpux+bRDXlhcl4xRHO/W9gn+6p+Sf1/U/+15BnJ
vGyA5BQRR3ibXB/5+yjiZ+78lDyVvJQ7WpCcr9I/OPmtk7yYd9NOyVz2crXv
zJ0P3yg5d+XOu25R+57cPGxusm81hq/hY/geHALf7xE4g28wBhxYGDF4UeFv
3WM8PjQ45PyrMCdYVdgf+4fNdA/8Qs428kp9+4Zcs3DuuhOsTsawxarvSfaL
e1U/lGzHD6ueUfgd9lHV9+fmZH9NtqNesRZ2j/0/m4zrLQPbXwz9cw/bC+Ph
R6qn5+Y0L5CDJ/tSv8g1OkTc/zR3PjOs8Dsa72kz1Xdp3DV3DjYMCDu/ONmu
tka+xxjwH27EHZFr7I4Z0Q+Xgj/BG7GLidEel5yrDQcHtXZr7eGgZJ+AK+Pv
NySP/7Xq34cNYAuTk/OqCTrLzSFnXGASc3e/X9Tte+y1S8RFYiJYNyjifbN4
W347N7edEnvD3skf4MrwI86Orva8dZJTTIk9sJcxyWPh131Cr+TRjYHx2MZu
uwgMJHeiTV4PHsB3wASwn/dxYlzLwGH66fuq5ncYYj5YCU5iG+wfnDku8iDs
BHvpGTiE/FNjDXAf3k3cJaf+PO4LHM0j3vG9dYxZnswznszNyRcFPoORXQMn
4WvYD/LR6cCwC873bZzxoMLxtJLMbcYG/5+dmzfCH1sV5gnwhfW5ucNbwYt2
xdl54ya/vDE3JyqCF41I5ryHFc5L5kS8QGdDYy7vBk/HeRfGG9fz4YtTI04d
UfrtelQyB28efPKaeKcGjyulZYK1+BwyeTcAW/bwl4cjF5gUOEd+wtsO3LNJ
8E+4HmdDLbxt3Rr7pL4l2vtpHz/UuONL5wbsjbehjcEj4S0Dw57xzTNLxwhi
xX25495VYRfYB3kK+QpjaMNlF8adkiv3D9vG3xuC22Cr/J+FOM17zsgYw90O
iftdltte4HTsF14Bn/9n8tx/8M5TOCcgX/yk8FxiV+vS90iM5T2oTvzPfZfc
6WvJ+pgfuiKe8FaIDv8HpG2NfQ==
          "]], PolygonBox[CompressedData["
1:eJwtl3mwz1UYxn/b95xfV7Yml+i2ScoVUZQsudNCaCFLhWrIkkS3ERdNk8yk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          "]]}]}, 
      {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lltsVVUQhvc+PWfvUi4tl1MoUEi5JF5ARCGAFn3yQcEHJWgCookJKqYR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          "]], PolygonBox[CompressedData["
1:eJwtlEtIVVEUhvc917vPxUSKHiaocCuhgqDoQUTWqEFqg1IhMhOCXiRZNAhL
etigmpU9LEPI1B5EWlGTEHpRWpBhDTKTAq0oMbyUGQk9vp/V4Of8/1pr773O
WmvvxMbKNTsC51wxSAEL486tgNTBf3nnBkLndkecGyXoA7wTWw16DJ2OTg3N
lxV1bhH8B/gLzyJmJDSbfGXEbGbtTdAEP8L+9THn0vBPRieIWQxfi205fAm2
Y/BrxDfA1xFfi25DN6K3oU+jN5BvgrPyWFMO38Iem+BJYmLwezoTfgvch18E
dfCzoAl+gT1anK3ZSvwl0AoPQBu+Zm+xRej1+N5gq+C8L8Cjb6AfBbZGa++i
OwI7Q2e1oLvZ/wD+ffingjz0DGo8hXz/hPavtew3SOwJbMkU+6er6JfsUUh8
JzGv4OfAbHzt6GfwOayfGLWejUdnhharM3RWDugObI9seADOwK9ji8Kng9fw
UmzT4BFvuemfXsDTyScTHeGMSfjPq38Ry6Ee3gHSiK1GP4G3kvM8eCvoQvej
D0Wsx+r1gtB6kcSWgz/DWy2HsM3FV4ye4GwYv6MHYsY1U9/QveBz1P75Ob6S
0HqlnEbQ+XHLpZQ1BfD5oZ01Dl8dOh99PGI1Vq1lk08z3sf3qbfaagY1i++8
1UY1fA+vZv3BqP2z/r0rZrkrJ+W2CiyDZ7NmO/5K9G/23kPMTvhHb7OsGf4E
fwsKnM14HzyXmD54lWYEXoPtsbM9DsNLvM2KaqRa3QGXA+tpg2rlrfaawQzW
n/J291LBSXhR3GZxP6jCv1fzDL+NvxG+2lusZlazWxba7CtH5boybrVVTrno
Wfj7iT+KngkvCO0uqgaF8Ife9tadeaBee7u7PdgGvb0xemu0xxi8J2Z3V3dW
d7fd26zqjuquDnmrTS+2r/BRb2+JavATPuwtF9UwCd8FKgKbYc2yeqLeJJST
7mdos62ZbdZ8+v8+sFSzE1qtNMPD6r23Xqpmqt2VmL11ehP1Nv4DCVuyjA==

          "]]}]}}, {{}, 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], LineBox[CompressedData["
1:eJwVz0krhWEYBuAHHYSsDCvK2o5jKH6BYYGFjaGUKTJsZPgVppQ6Jc5ZOOqg
2KD4BdaKjTFssGHJZXF138/zvuc731c3Mts7kxcR4/QnIjqKIlaLI/b1lJ6V
Q+ZhOs1ddDNVGDFNE23mpGyX87Lc3Qq9kgxpcp5z7exXVplDr5Zn5l19jzQD
doPc6ndkOWDNvVGe9RdyHLJpN8mb/s4rix5/JI/ZdjbHt/7DCaek7BbI918F
nNtdsGM3YR4nwY350v6KpLlWNsga2Si3fOudO4/6E6WU0MyYOxus/78/9fSQ
cX/F+TJ9fr8kP/ng3tmXfJBlspUW/gDREjjq
          "]], 
         LineBox[{2188, 106, 1771, 1773, 1772, 2092, 1828, 1829, 1774, 1776, 
          1775, 2095, 1832, 1833, 1784, 1786, 1785, 2101, 1552, 1837, 2196, 
          1485, 2010, 1486, 1840, 1559, 1839, 1897, 1798, 1497, 1729, 1730, 
          1441, 1402, 1664, 1904, 1903, 1681, 1571, 1667, 1666, 1573, 2121, 
          2123, 2122, 1502, 1733, 1734, 1735, 1916, 1415}], 
         LineBox[{1805, 1806, 1736, 1448, 1687, 1688, 2036, 2037, 2034, 1507, 
          2035, 1620, 1621, 1515, 1809, 1514, 2046, 1417, 1368, 1737, 1738, 
          1689, 1690, 1691, 1878, 2063, 1524, 1877, 1455, 1958, 1456, 1743, 
          1537, 2070, 1816, 1817, 1745, 1747, 1746, 2077, 1821, 1822, 1757, 
          1759, 1758, 2083, 1826, 1827, 1767, 2188}]},
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], LineBox[CompressedData["
1:eJwVzr8rxHEcx/EPxd3mTMQgkoGSyaJDIVY3kMhgMJzcdRaO6UodNzCILmGw
UCY//gNnotyAgRUTIwviYXj2fL9e7/fn27d5Jp1IVYQQ0khUoTqEUe6PhNCH
Z/Mnj+hj/CrX8AuP6U44REN451/9GxcwgWv7G+xhHwcYdxNz/2Ff5CP51HzM
Z1x2U4k6uwZdI+7kB9yjSZ7kKUTR4i7CW97O4tz+AnmsYUeXRMl8hQ1soqib
x7S3GV71nR7zMrLoktvddeBL/sE3uvW13KnfNt96+2Quc1zeRb19UjeHCB7t
LnUlHJpXkDPneME+gwE55W0r5zGIuH6Ie7nt/9/sh3mRs1jCulzAH69QOl4=

          "]], LineBox[CompressedData["
1:eJwV0EsrBGAYhuFvymkGKYcVGwuEGlEWrFihFGaBSEooCilj5g+QlbJRSo3D
Ags/gHJeK6cSNlixtibXLO7u533e95uZpnpiITEfCSEsYi03hAPE80IYKgih
iYf5XZfKD2FLbtAlOG3ul/swYK7npG4Zq+6nzK1yAaL4xAfe7DbdN8uVbjrk
Ku7kcz7Ds5sc+ylMI2M+1Z8gYg5I6rbRqyvBivdL5nE5Lj+6ecIdHnCPRv01
3+ACV7hEnX7Mu1qOcQ0XchopTPrcDRzJh3jFC0a9HcGuvINM9je6q/D+j8v5
l2/1x7zndh9lKEWx/ZxdLPt9iOLHXRF/86xdj7s2tMjt/KUfy/5/5i5zNwZ1
M+Z1/APcqTb0
          "]]},
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], LineBox[CompressedData["
1:eJwVzzkvRFEYBuAzjKVFQyKWRFCMgobOUkgoSCgsiUbP2COxjIKQEIQG/0Cj
EVuorZVKdPgBBImxx6N48n7n/c69N7e4N97WHwkhjBFLD2GJRSYzQ5higgTT
lOlH5RgjNDovMGAeJM4wQxTqE9EQ+sx15lnmqGVeN5nmneZxuZURwiYbXDvX
2OfYVcts+cuV/tb+Uq7rY+YqWcmL/SvPlOlLqdBf/N/nlHPOKNcfyiP2OGCf
Ev295x+4o1hXRMH/v3CjO/HtHd2xXNPlm1P1ueaozJMzugS77mzLHrnMG1n2
SdnlbidR50fnVPkk02SzPiJTaPF8K912HfpP8xcf/PBNkz4p36mngXb32/Wr
rPAHPdk+xA==
          "]], LineBox[CompressedData["
1:eJwV0LsvQ2EYB+DP4DKTmCxMFomRRBhcB9cqcYuhdSmpVlKD0WKikyJidFt0
IdEu9RcIE7FIJSR2Yebp8OT3fb/3PTknpzmWjqSqQgjbtNeEkGWVaHUIfbUh
9DJXF8IsX7p5uUC/foApXcL+gpxwH2fFfJlv3apMENFPEiVtf5NO1sw65LrM
yHrZQN5ewfPXsiibdNXmM+6zvDqX9BfykisW9XHdh/Mn1+TJVb6Rkvk9+2Q5
1iV5dH7igBwnujQ/nv3lhltOdRlidv7cH5zvZIEiS5X30+jc5XufzcvuL/Jd
9ui6iZvv6PacW5xHOXNP2dkgyZDZIG/6ETnKMK12z3W7bNnLVP65foyybkpO
E6Wt8m90R/KQf6x2P+k=
          "]]},
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], LineBox[CompressedData["
1:eJwl0jlMVGEUhuHfwhlI1EoLoZFSW4xEXBLXxthQaiIMklhAxsS4hCCggET2
0QQsNKitmoBGLIC4KxqlcUELtVPcg52Chc+JxZv3fOece+fOf29Z7cGq/KKU
0hguZlNqRrYopd7FKRXxJfkyWlAj9+nnOJ9JqRy16jrsxy+zCr2Ceh0fwoJe
v/yXb+Gk+7ShHdXy4bgHt9upVB/FEaySy3Dd3h3zUb7LN7jYfJLvyxP8gFfb
XaJfLefiWbFUXqP/yPy5/JineZn+G34iz/BTfstr7ZajxjyHFdggL+dhO8fw
wd4rPs8XUGI2YGdl/A+0mnXHs6t3Y4d6J7ZiO7bFeel32Pvh+p/4iu/4Fuei
/5m/4CNm8SnOTL/TdS3cFfeLM8IWnJab9VvVjbEnb1a/VL9z7Qt+z5X662PX
rIE3cj1v4uNoindm95zdIQxiSn7NeT7LZ1DAQ/kZ13MPd6ML9+RxPhDPwafQ
gdvySLwbLmCX38qgLc5b3qMuUZfiqr0xvSt8k+fju9HfxwP4jT75D1/DHE7I
e+NZkFEPZ/9/z/8AqXRkPw==
          "]]},
        "1"],
       Annotation[#, 1, "Tooltip"]& ], {}, {}}}], {{}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.04587368524026634, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, -3.835895278030231}, \
{-4.36923562443198, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.044858698282982175`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, -3.287910238311627}, \
{-4.36923562443198, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.04398157175864748, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, -2.739925198593023}, \
{-4.36923562443198, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.04325069393287603, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, -2.1919401588744187`}, \
{-4.36923562443198, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.04267357994809448, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, -1.6439551191558142`}, \
{-4.36923562443198, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.04225653031301002, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, -1.0959700794372098`}, \
{-4.36923562443198, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.04200431300710784, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, -0.5479850397186052}, \
{-4.36923562443198, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.041919903350326, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, -8.517398515440158*^-16}, \
{-4.36923562443198, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.04200431300710784, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, 
        0.5479850397186036}, {-4.36923562443198, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.04225653031301002, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, 
        1.095970079437208}, {-4.36923562443198, 1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.04267357994809448, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, 
        1.6439551191558124`}, {-4.36923562443198, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.043250693932876026`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, 
        2.191940158874417}, {-4.36923562443198, 2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.04398157175864748, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, 
        2.739925198593021}, {-4.36923562443198, 2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.044858698282982175`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, 
        3.287910238311625}, {-4.36923562443198, 3.569232618831229}}]}}, 
     {Arrowheads[{{0.04587368524026631, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, 3.83589527803023}, {-4.36923562443198,
         4.164104721969767}}]}}, 
     {Arrowheads[{{0.04047441545604541, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.1120837504868746`, -3.835895278030231}, \
{-3.745059106655983, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.03932030163451397, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, -3.287910238311627}, \
{-3.7450591066559826`, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.038316601667509505`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, -2.739925198593023}, \
{-3.7450591066559826`, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.03747540306201995, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, -2.1919401588744187`}, \
{-3.7450591066559826`, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.036807848817500134`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, -1.6439551191558142`}, \
{-3.7450591066559826`, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.036323513914265956`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.1120837504868746`, -1.0959700794372098`}, \
{-3.745059106655983, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.036029787956420485`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, -0.5479850397186052}, \
{-3.7450591066559826`, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.035931345728850886`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.1120837504868746`, -8.517398515440158*^-16}, \
{-3.745059106655983, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.036029787956420485`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, 
        0.5479850397186036}, {-3.7450591066559826`, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.036323513914265956`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.1120837504868746`, 
        1.095970079437208}, {-3.745059106655983, 1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.036807848817500134`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, 
        1.6439551191558124`}, {-3.7450591066559826`, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.037475403062019984`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.1120837504868746`, 
        2.191940158874417}, {-3.745059106655983, 2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.038316601667509505`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, 
        2.739925198593021}, {-3.7450591066559826`, 2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.039320301634513964`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, 
        3.287910238311625}, {-3.7450591066559826`, 3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.04047441545604533, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, 
        3.83589527803023}, {-3.7450591066559826`, 4.164104721969767}}]}}, 
     {Arrowheads[{{0.03526595043757587, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, -3.835895278030231}, \
{-3.120882588879986, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.033935159855025814`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, -3.287910238311627}, \
{-3.120882588879986, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.032766918028761666`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, -2.739925198593023}, \
{-3.120882588879986, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.031779156508910805`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, -2.1919401588744187`}, \
{-3.120882588879986, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.03098913823146652, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, -1.6439551191558142`}, \
{-3.120882588879986, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.03041227740299734, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, -1.0959700794372098`}, \
{-3.120882588879986, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.030060847857996557`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, -0.5479850397186052}, \
{-3.120882588879986, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.02994278810737572, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, -8.517398515440158*^-16}, \
{-3.120882588879986, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.030060847857996557`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, 
        0.5479850397186036}, {-3.120882588879986, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.03041227740299734, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, 
        1.095970079437208}, {-3.120882588879986, 1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.030989138231466512`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, 
        1.6439551191558124`}, {-3.120882588879986, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.03177915650891079, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, 
        2.191940158874417}, {-3.120882588879986, 2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.032766918028761666`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, 
        2.739925198593021}, {-3.120882588879986, 2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.033935159855025814`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, 
        3.287910238311625}, {-3.120882588879986, 3.569232618831229}}]}}, 
     {Arrowheads[{{0.03526595043757583, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, 
        3.83589527803023}, {-3.120882588879986, 4.164104721969767}}]}}, 
     {Arrowheads[{{0.030346694363538266`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, -3.835895278030231}, \
{-2.4967060711039895`, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.02878940209373241, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, -3.287910238311627}, \
{-2.4967060711039895`, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.027402655266087518`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, -2.739925198593023}, \
{-2.4967060711039895`, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.026213534423009343`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, -2.1919401588744187`}, \
{-2.4967060711039895`, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.025249975977362584`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, -1.6439551191558142`}, \
{-2.4967060711039895`, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.02453856587833345, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, -1.0959700794372098`}, \
{-2.4967060711039895`, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.024101642526393595`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, -0.5479850397186052}, \
{-2.4967060711039895`, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.02395423048590058, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, -8.517398515440158*^-16}, \
{-2.4967060711039895`, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.024101642526393595`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, 
        0.5479850397186036}, {-2.4967060711039895`, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.024538565878333442`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, 
        1.095970079437208}, {-2.4967060711039895`, 1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.025249975977362577`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, 
        1.6439551191558124`}, {-2.4967060711039895`, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.02621353442300933, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, 
        2.191940158874417}, {-2.4967060711039895`, 2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.027402655266087518`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, 
        2.739925198593021}, {-2.4967060711039895`, 2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.02878940209373239, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, 
        3.287910238311625}, {-2.4967060711039895`, 3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.030346694363538224`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, 
        3.83589527803023}, {-2.4967060711039895`, 4.164104721969767}}]}}, 
     {Arrowheads[{{0.02588208071415258, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, -3.835895278030231}, \
{-1.872529553327992, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.02403726099651346, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, -3.287910238311627}, \
{-1.872529553327992, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.022357677851958094`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, -2.739925198593023}, \
{-1.872529553327992, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.020883238021106764`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, -2.1919401588744187`}, \
{-1.872529553327992, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.019660150817257, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, -1.6439551191558142`}, \
{-1.872529553327992, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.018737701531009985`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, -1.0959700794372098`}, \
{-1.872529553327992, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.018161756957132964`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, -0.5479850397186052}, \
{-1.872529553327992, -0.5948721031385393}}]}}, 
     {Arrowheads[{{0.01796567286442543, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, -8.517398515440158*^-16}, \
{-1.872529553327992, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.018161756957132964`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, 
        0.5479850397186036}, {-1.872529553327992, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.01873770153100998, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, 1.095970079437208}, {-1.872529553327992,
         1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.019660150817256992`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, 
        1.6439551191558124`}, {-1.872529553327992, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.02088323802110675, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, 2.191940158874417}, {-1.872529553327992,
         2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.022357677851958094`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, 2.739925198593021}, {-1.872529553327992,
         2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.024037260996513442`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, 3.287910238311625}, {-1.872529553327992,
         3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.025882080714152524`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, 3.83589527803023}, {-1.872529553327992, 
        4.164104721969767}}]}}, 
     {Arrowheads[{{0.02214876949551078, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, -3.835895278030231}, \
{-1.248353035551995, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.019961858738250484`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, -3.287910238311627}, \
{-1.248353035551995, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.017903956183014342`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, -2.739925198593023}, \
{-1.248353035551995, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.016024840664342316`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, -2.1919401588744187`}, \
{-1.248353035551995, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.014394701046866205`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, -1.6439551191558142`}, \
{-1.248353035551995, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.013106767211504671`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, -1.0959700794372098`}, \
{-1.248353035551995, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.012269282939166725`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, -0.5479850397186052}, \
{-1.248353035551995, -0.5948721031385393}}]}}, 
     {Arrowheads[{{0.01197711524295029, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, -8.517398515440158*^-16}, \
{-1.248353035551995, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.012269282939166721`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, 
        0.5479850397186036}, {-1.248353035551995, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.013106767211504665`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, 
        1.095970079437208}, {-1.248353035551995, 1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.014394701046866194`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, 
        1.6439551191558124`}, {-1.248353035551995, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.0160248406643423, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, 
        2.191940158874417}, {-1.248353035551995, 2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.01790395618301433, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622924`, 
        2.739925198593021}, {-1.248353035551995, 2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.019961858738250463`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, 
        3.287910238311625}, {-1.248353035551995, 3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.022148769495510718`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, 
        3.83589527803023}, {-1.248353035551995, 4.164104721969767}}]}}, 
     {Arrowheads[{{0.019569862621083595`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, -3.835895278030231}, \
{-0.624176517775998, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.017055419582311163`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, -3.287910238311627}, \
{-0.624176517775998, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.014593258027120377`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, -2.739925198593023}, \
{-0.624176517775998, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.012215033817406115`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, -2.1919401588744187`}, \
{-0.624176517775998, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.009980929369125245, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, -1.6439551191558142`}, \
{-0.624176517775998, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.008012420332171161, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, -1.0959700794372098`}, \
{-0.624176517775998, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.006553383605752341, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, -0.5479850397186052}, \
{-0.624176517775998, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.005988557621475151, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, -8.517398515440158*^-16}, \
{-0.624176517775998, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.0065533836057523375`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, 
        0.5479850397186036}, {-0.624176517775998, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.008012420332171154, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, 
        1.095970079437208}, {-0.624176517775998, 1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.009980929369125235, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, 
        1.6439551191558124`}, {-0.624176517775998, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.012215033817406091`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, 
        2.191940158874417}, {-0.624176517775998, 2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.014593258027120377`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, 
        2.739925198593021}, {-0.624176517775998, 2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.017055419582311142`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, 
        3.287910238311625}, {-0.624176517775998, 3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.019569862621083522`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, 3.83589527803023}, {-0.624176517775998,
         4.164104721969767}}]}}, 
     {Arrowheads[{{0.018631068155700484`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, -3.835895278030231}, \
{-9.701651980513714*^-16, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.015969486990600388`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, -3.287910238311627}, \
{-9.701651980513714*^-16, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.013307905825500314`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, -2.739925198593023}, \
{-9.701651980513714*^-16, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.010646324660400266`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, -2.1919401588744187`}, \
{-9.701651980513714*^-16, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.007984743495300194, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, -1.6439551191558142`}, \
{-9.701651980513714*^-16, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.005323162330200133, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, -1.0959700794372098`}, \
{-9.701651980513714*^-16, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.0026615811651000665`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, -0.5479850397186052}, \
{-9.701651980513714*^-16, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.0026615811651000605`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, 
        0.5479850397186036}, {-9.701651980513714*^-16, 
        0.5948721031385374}}]}}, 
     {Arrowheads[{{0.005323162330200121, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, 
        1.095970079437208}, {-9.701651980513714*^-16, 
        1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.007984743495300182, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, 
        1.6439551191558124`}, {-9.701651980513714*^-16, 
        1.784616309415614}}]}}, 
     {Arrowheads[{{0.010646324660400242`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, 
        2.191940158874417}, {-9.701651980513714*^-16, 
        2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.013307905825500314`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, 
        2.739925198593021}, {-9.701651980513714*^-16, 
        2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.015969486990600364`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, 
        3.287910238311625}, {-9.701651980513714*^-16, 
        3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.018631068155700408`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, 
        3.83589527803023}, {-9.701651980513714*^-16, 4.164104721969767}}]}}, 
     {Arrowheads[{{0.019569862621083588`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, -3.835895278030231}, {
        0.6241765177759961, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.017055419582311156`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.518680625081145, -3.287910238311627}, {
        0.6241765177759961, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.01459325802712037, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, -2.739925198593023}, {
        0.6241765177759961, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.012215033817406108`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, -2.1919401588744187`}, {
        0.6241765177759961, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.009980929369125239, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, -1.6439551191558142`}, {
        0.6241765177759961, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.008012420332171153, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, -1.0959700794372098`}, {
        0.6241765177759961, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.006553383605752324, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.518680625081145, -0.5479850397186052}, {
        0.6241765177759961, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.005988557621475139, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, -8.517398515440158*^-16}, {
        0.6241765177759961, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.006553383605752327, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, 0.5479850397186036}, {
        0.6241765177759961, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.008012420332171144, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, 1.095970079437208}, {0.6241765177759961,
         1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.009980929369125225, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, 1.6439551191558124`}, {
        0.624176517775996, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.012215033817406086`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, 2.191940158874417}, {0.6241765177759961,
         2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.01459325802712037, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.518680625081145, 2.739925198593021}, {0.6241765177759961, 
        2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.017055419582311136`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.518680625081145, 3.287910238311625}, {0.6241765177759961, 
        3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.019569862621083515`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.518680625081145, 3.83589527803023}, {0.6241765177759961, 
        4.164104721969767}}]}}, 
     {Arrowheads[{{0.022148769495510773`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, -3.835895278030231}, {
        1.2483530355519932`, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.019961858738250477`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, -3.287910238311627}, {
        1.2483530355519932`, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.01790395618301433, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, -2.739925198593023}, {
        1.2483530355519932`, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.016024840664342305`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, -2.1919401588744187`}, {
        1.2483530355519932`, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.014394701046866193`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, -1.6439551191558142`}, {
        1.2483530355519932`, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.013106767211504658`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, -1.0959700794372098`}, {
        1.2483530355519932`, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.01226928293916671, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, -0.5479850397186052}, {
        1.2483530355519932`, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.011977115242950278`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, -8.517398515440158*^-16}, {
        1.2483530355519932`, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.012269282939166709`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, 0.5479850397186036}, {
        1.2483530355519932`, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.013106767211504654`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, 1.095970079437208}, {
        1.2483530355519932`, 1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.014394701046866186`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, 1.6439551191558124`}, {
        1.2483530355519932`, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.016024840664342288`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, 2.191940158874417}, {
        1.2483530355519932`, 2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.01790395618301433, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, 2.739925198593021}, {
        1.2483530355519932`, 2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.019961858738250456`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, 3.287910238311625}, {
        1.2483530355519932`, 3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.02214876949551071, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, 3.83589527803023}, {
        1.2483530355519932`, 4.164104721969767}}]}}, 
     {Arrowheads[{{0.025882080714152562`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, -3.835895278030231}, {
        1.87252955332799, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.02403726099651344, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, -3.287910238311627}, {
        1.87252955332799, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.022357677851958073`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, -2.739925198593023}, {
        1.87252955332799, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.02088323802110674, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, -2.1919401588744187`}, {
        1.87252955332799, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.01966015081725697, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, -1.6439551191558142`}, {
        1.87252955332799, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.01873770153100996, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, -1.0959700794372098`}, {
        1.87252955332799, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.01816175695713294, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, -0.5479850397186052}, {
        1.87252955332799, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.017965672864425405`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, -8.517398515440158*^-16}, {
        1.87252955332799, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.018161756957132937`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, 0.5479850397186036}, {1.87252955332799,
         0.5948721031385374}}]}}, 
     {Arrowheads[{{0.018737701531009957`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, 1.095970079437208}, {1.87252955332799, 
        1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.019660150817256968`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, 1.6439551191558124`}, {
        1.87252955332799, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.020883238021106726`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, 2.191940158874417}, {1.87252955332799, 
        2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.022357677851958073`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, 2.739925198593021}, {1.87252955332799, 
        2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.02403726099651342, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, 3.287910238311625}, {1.87252955332799, 
        3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.025882080714152506`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, 3.83589527803023}, {1.87252955332799, 
        4.164104721969767}}]}}, 
     {Arrowheads[{{0.030346694363538256`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, -3.835895278030231}, {
        2.4967060711039872`, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.028789402093732385`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, -3.287910238311627}, {
        2.4967060711039872`, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.027402655266087494`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, -2.739925198593023}, {
        2.4967060711039872`, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.026213534423009315`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, -2.1919401588744187`}, {
        2.4967060711039872`, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.02524997597736256, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, -1.6439551191558142`}, {
        2.4967060711039872`, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.02453856587833342, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, -1.0959700794372098`}, {
        2.4967060711039872`, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.02410164252639357, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, -0.5479850397186052}, {
        2.4967060711039872`, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.023954230485900556`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, -8.517398515440158*^-16}, {
        2.4967060711039872`, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.02410164252639357, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, 0.5479850397186036}, {
        2.4967060711039872`, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.024538565878333418`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, 1.095970079437208}, {2.4967060711039872`,
         1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.025249975977362553`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, 1.6439551191558124`}, {
        2.4967060711039872`, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.02621353442300931, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, 2.191940158874417}, {2.4967060711039872`,
         2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.027402655266087494`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, 2.739925198593021}, {2.4967060711039872`,
         2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.02878940209373237, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, 3.287910238311625}, {2.4967060711039872`,
         3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.030346694363538203`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, 3.83589527803023}, {2.4967060711039872`, 
        4.164104721969767}}]}}, 
     {Arrowheads[{{0.03526595043757583, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, -3.835895278030231}, {
        3.120882588879984, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.03393515985502577, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, -3.287910238311627}, {
        3.120882588879984, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.03276691802876162, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, -2.739925198593023}, {
        3.120882588879984, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.03177915650891077, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.5934031254057275`, -2.1919401588744187`}, {
        3.120882588879984, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.030989138231466467`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, -1.6439551191558142`}, {
        3.120882588879984, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.03041227740299731, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.5934031254057275`, -1.0959700794372098`}, {
        3.120882588879984, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.030060847857996533`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.5934031254057275`, -0.5479850397186052}, {
        3.120882588879984, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.029942788107375693`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.5934031254057275`, -8.517398515440158*^-16}, {
        3.120882588879984, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.03006084785799651, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, 0.5479850397186036}, {3.120882588879984, 
        0.5948721031385374}}]}}, 
     {Arrowheads[{{0.030412277402997286`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, 1.095970079437208}, {3.120882588879984, 
        1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.03098913823146646, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, 1.6439551191558124`}, {3.120882588879984,
         1.784616309415614}}]}}, 
     {Arrowheads[{{0.03177915650891075, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, 2.191940158874417}, {3.120882588879984, 
        2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.03276691802876164, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.5934031254057275`, 2.739925198593021}, {3.120882588879984,
         2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.03393515985502576, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, 3.287910238311625}, {3.120882588879984, 
        3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.035265950437575785`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, 3.83589527803023}, {3.120882588879984, 
        4.164104721969767}}]}}, 
     {Arrowheads[{{0.04047441545604536, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, -3.835895278030231}, {
        3.745059106655981, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.03932030163451397, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, -3.287910238311627}, {
        3.745059106655981, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.038316601667509505`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, -2.739925198593023}, {
        3.745059106655981, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.03747540306201995, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, -2.1919401588744187`}, {
        3.745059106655981, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.036807848817500134`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, -1.6439551191558142`}, {
        3.745059106655981, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.03632351391426591, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, -1.0959700794372098`}, {
        3.745059106655981, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.036029787956420485`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, -0.5479850397186052}, {
        3.745059106655981, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.03593134572885083, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, -8.517398515440158*^-16}, {
        3.745059106655981, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.036029787956420485`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, 0.5479850397186036}, {
        3.745059106655981, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.03632351391426591, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, 1.095970079437208}, {3.745059106655981,
         1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.036807848817500134`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, 1.6439551191558124`}, {
        3.745059106655981, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.03747540306201994, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, 2.191940158874417}, {3.745059106655981,
         2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.038316601667509505`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, 2.739925198593021}, {3.745059106655981,
         2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.039320301634513964`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, 3.287910238311625}, {3.745059106655981,
         3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.04047441545604533, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, 3.83589527803023}, {3.745059106655981, 
        4.164104721969767}}]}}, 
     {Arrowheads[{{0.04587368524026634, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, -3.835895278030231}, {
        4.369235624431978, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.044858698282982175`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, -3.287910238311627}, {
        4.369235624431978, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.04398157175864748, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, -2.739925198593023}, {
        4.369235624431978, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.04325069393287603, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, -2.1919401588744187`}, {
        4.369235624431978, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.04267357994809448, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, -1.6439551191558142`}, {
        4.369235624431978, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.04225653031301002, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, -1.0959700794372098`}, {
        4.369235624431978, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.04200431300710784, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, -0.5479850397186052}, {
        4.369235624431978, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.041919903350326, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, -8.517398515440158*^-16}, {
        4.369235624431978, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.04200431300710784, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, 0.5479850397186036}, {
        4.369235624431978, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.04225653031301002, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, 1.095970079437208}, {4.369235624431978,
         1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.04267357994809448, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, 1.6439551191558124`}, {
        4.369235624431978, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.043250693932876026`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, 2.191940158874417}, {4.369235624431978,
         2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.04398157175864748, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, 2.739925198593021}, {4.369235624431978,
         2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.044858698282982175`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, 3.287910238311625}, {4.369235624431978,
         3.569232618831229}}]}}, 
     {Arrowheads[{{0.04587368524026631, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, 3.83589527803023}, {4.369235624431978, 
        4.164104721969767}}]}}}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{-4, 4}, {-4, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.545617328399762*^9, 3.5456173861978636`*^9}, 
   3.545617566128579*^9, {3.5456178186618233`*^9, 3.545617900499567*^9}, 
   3.545617932417223*^9, 3.5777828248616*^9, 3.5777829107864*^9, 
   3.5777829631722*^9, {3.5777831071602*^9, 3.5777831380550003`*^9}, {
   3.5777832103454*^9, 3.5777832386594*^9}, 3.60911556494733*^9, 
   3.656357309961537*^9, 3.656357355258143*^9, {3.656357394052951*^9, 
   3.6563574091575317`*^9}, {3.656358110031333*^9, 3.656358117650107*^9}, {
   3.656364066976273*^9, 3.656364086524691*^9}}]
}, Open  ]],

Cell[TextData[{
 StyleBox["1.)",
  FontColor->RGBColor[1, 0, 0]],
 " Hopefully at any point the vectors should appear to be perpendicular to \
the contour lines.  \n",
 StyleBox["But...",
  FontWeight->"Bold"],
 "this only holds when the size of one unit in the x-direction on screen \
measures the same as one unit in the y-direction.\n\nYou can control this in \
two ways:"
}], "Text",
 CellChangeTimes->{{3.6563581799385366`*^9, 3.656358458182705*^9}, {
  3.656358509990416*^9, 3.6563587532459393`*^9}, {3.656371894194461*^9, 
  3.656371917031529*^9}, {3.6563719679205723`*^9, 3.656371982574153*^9}, {
  3.6877838129960957`*^9, 3.687783872383662*^9}, {3.687783973513506*^9, 
  3.6877841043677692`*^9}, {3.687784286911612*^9, 3.687784333919442*^9}, {
  3.687784694228362*^9, 3.687784732591193*^9}, {3.687784784911396*^9, 
  3.687784786119377*^9}, {3.687784914049508*^9, 3.687784949333891*^9}, {
  3.687785063130488*^9, 3.6877850641125193`*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "If your x-range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubscriptBox["x", "max"], "-", 
        SubscriptBox["x", "min"]}], ")"}], TraditionalForm]],
     FormatType->"TraditionalForm"]]], " "}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "is the same as your y-range, the aspect ratio is usually right in 2-D plots."
}], "Item",
 CellChangeTimes->{{3.6877843640888844`*^9, 3.687784476582884*^9}, {
  3.687784960559293*^9, 3.687784967447338*^9}}],

Cell[TextData[{
 "Using the AspectRatio->Automatic option. Execute the 2 examples below to \
see Mathematica\[CloseCurlyQuote]s interpretation of AspectRatio. ",
 StyleBox["What is the same in the horizontal and vertical direction when \
\[OpenCurlyDoubleQuote]AspectRatio->1\[CloseCurlyDoubleQuote] is set?",
  FontWeight->"Bold"],
 " (*not* the relative sizes of x- and y-units...)"
}], "Item",
 CellChangeTimes->{{3.687784492439423*^9, 3.6877846309189167`*^9}, {
  3.6877848208638144`*^9, 3.68778484307122*^9}, {3.6877849797024527`*^9, 
  3.687785035079369*^9}, {3.687785071799211*^9, 3.6877851189193983`*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.687784113592153*^9, 3.687784120455556*^9}, {
  3.6877842196115*^9, 3.687784239550664*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6877846572577467`*^9, 3.6877846587443047`*^9}}],

Cell[TextData[{
 "\[LineSeparator]\[LineSeparator]",
 StyleBox["2.)",
  FontColor->RGBColor[1, 0, 0]],
 " Below, replot the vector field and contours from the same function above, \
but with ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]]],
 " intervals which are *quite different* from each other.  Do the vectors \
still appear perpendicular to the contours?"
}], "Text",
 CellChangeTimes->{{3.6877847442479362`*^9, 3.6877847536411667`*^9}, {
  3.687785146481015*^9, 3.6877851673354*^9}}],

Cell[CellGroupData[{

Cell["\[LineSeparator]\[LineSeparator]\[LineSeparator]\[LineSeparator]When is \
a vector field a gradient vector field?", "Subsubsection",
 CellChangeTimes->{{3.5455885641289597`*^9, 3.545588579646408*^9}, {
  3.687784756751328*^9, 3.687784757343322*^9}}],

Cell[TextData[{
 "For a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]]],
 ", we saw the order of differentiation for the ",
 StyleBox["second",
  FontSlant->"Italic"],
 " derivatives doesn\[CloseCurlyQuote]t matter (Clarault\[CloseCurlyQuote]s \
Theorem), that is:"
}], "Text",
 CellChangeTimes->{{3.5455886259709997`*^9, 3.5455886387539997`*^9}, {
  3.656358971728907*^9, 3.6563590754384336`*^9}, {3.6877854595031*^9, 
  3.687785467999352*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{
          SubscriptBox["f", "xy"], "=", 
          SubscriptBox["f", "yx"]}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           FractionBox["\[PartialD]", 
            RowBox[{"\[PartialD]", "y"}]], 
           SubscriptBox["f", "x"]}], "=", 
          RowBox[{
           FractionBox["\[PartialD]", 
            RowBox[{"\[PartialD]", "x"}]], 
           SubscriptBox["f", "y"]}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]],
 TextAlignment->Center]], "Text",
 CellChangeTimes->{{3.656359084786682*^9, 3.656359115483788*^9}, {
  3.656359152304276*^9, 3.65635917561523*^9}}],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]]],
 " be functions of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]]],
 ", and consider the vector field ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["F", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{"P", " ", 
      OverscriptBox["i", "^"]}], "+", 
     RowBox[{"Q", " ", 
      OverscriptBox["j", "^"]}]}]}], TraditionalForm]]],
 ".   \[LineSeparator]\[LineSeparator]*If* ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["F", "\[RightVector]"], TraditionalForm]]],
 " is the gradient of some function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 ", then it must be the case that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "=", 
    SubscriptBox["f", "x"]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", "=", 
    SubscriptBox["f", "y"]}], TraditionalForm]]],
 " and therefore it must be the case that"
}], "Text",
 CellChangeTimes->{{3.656359733290038*^9, 3.656359962848568*^9}, {
  3.656364135027217*^9, 3.656364153861373*^9}, {3.687785491135751*^9, 
  3.687785491567677*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {GridBox[{
          {
           RowBox[{"\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              FractionBox["\[PartialD]", 
               RowBox[{"\[PartialD]", "y"}]], "P"}], "=", 
             RowBox[{
              FractionBox["\[PartialD]", 
               RowBox[{"\[PartialD]", "x"}]], "Q"}]}]}]}
         },
         GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.6563599688825274`*^9, 3.656360009542758*^9}}],

Cell["When this is true, we say that", "Text",
 CellChangeTimes->{{3.6563594491616364`*^9, 3.6563595129327383`*^9}, {
   3.656359569879016*^9, 3.656359626986392*^9}, {3.656359675039352*^9, 
   3.656359676471216*^9}, {3.656364223349599*^9, 3.656364292925514*^9}, 
   3.6563643522907753`*^9, 3.6563644324760303`*^9}],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   OverscriptBox["F", "\[RightVector]"], TraditionalForm]]],
 " is ",
 StyleBox["conservative",
  FontWeight->"Bold"],
 "."
}], "Item",
 CellChangeTimes->{{3.656364328061962*^9, 3.656364361100679*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   OverscriptBox["F", "\[RightVector]"], TraditionalForm]]],
 " is the gradient of a \[OpenCurlyDoubleQuote]",
 StyleBox["potential",
  FontWeight->"Bold"],
 "\[CloseCurlyDoubleQuote] function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 "."
}], "Item",
 CellChangeTimes->{{3.656364328061962*^9, 3.656364417298711*^9}}]
}, Open  ]],

Cell[TextData[{
 "\[LineSeparator]\[LineSeparator]",
 StyleBox["For each of the vector fields below:",
  FontWeight->"Bold"],
 "\[LineSeparator]"
}], "Text",
 CellChangeTimes->{{3.656364336445902*^9, 3.656364336780198*^9}, {
   3.656364436476096*^9, 3.656364487870029*^9}, {3.656368661346973*^9, 
   3.656368734944528*^9}, {3.656368774033456*^9, 3.656368792360135*^9}, {
   3.656371198554747*^9, 3.65637120048291*^9}, {3.65637218644664*^9, 
   3.656372193407119*^9}, 3.6563722942974243`*^9, {3.656372520444907*^9, 
   3.656372552654418*^9}, {3.687785215615368*^9, 3.687785409463917*^9}, {
   3.687785514880048*^9, 3.6877855623911867`*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 StyleBox["VectorPlot[ ]",
  FontFamily->"Courier New"],
 "for each of the following vector fields. "
}], "Item",
 CellChangeTimes->{{3.687785575227766*^9, 3.6877855823022947`*^9}}],

Cell[TextData[{
 "Calculate (using Mathematica) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["\[PartialD]", 
     RowBox[{"\[PartialD]", "y"}]], "P"}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["\[PartialD]", 
     RowBox[{"\[PartialD]", "x"}]], "Q"}], TraditionalForm]]],
 " for each vector field, and then, using the test above, say whether the \
vector field is conservative or not.\[LineSeparator]"
}], "Item",
 CellChangeTimes->{{3.687785575227766*^9, 3.687785588969348*^9}}],

Cell["\<\
Just for the functions that you find are conservative ones, find (guess) the \
potential function, and make a contour plot of the potential function you \
found. \[LineSeparator]Display the vector plot of the vector field and the \
contour plot of the potential function together (with appropriate x- and \
y-ranges), to verify that the vector field arrows line up with the contours \
of the potential function as they should.\
\>", "Item",
 CellChangeTimes->{{3.687785575227766*^9, 3.687785588278549*^9}, {
  3.687785632190566*^9, 3.687785749751204*^9}}]
}, Open  ]],

Cell[TextData[{
 StyleBox["3.)",
  FontColor->RGBColor[1, 0, 0]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["F", "\[RightVector]"], "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"3", "x", " ", 
      SuperscriptBox["y", "2"], " ", 
      OverscriptBox["i", "^"]}], " ", "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"], "y", " ", 
      OverscriptBox["j", "^"]}]}]}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.656370248623249*^9, 3.6563703431699963`*^9}, {
  3.656370379052232*^9, 3.656370383265421*^9}, {3.687785431791573*^9, 
  3.68778543195928*^9}}],

Cell[TextData[{
 StyleBox["4.)",
  FontColor->RGBColor[1, 0, 0]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["F", "\[RightVector]"], "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"3", "x", " ", 
      SuperscriptBox["y", "2"], " ", 
      OverscriptBox["i", "^"]}], " ", "-", 
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"], "y", " ", 
      OverscriptBox["j", "^"]}]}]}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.656370248623249*^9, 3.6563703431699963`*^9}, {
  3.656370379052232*^9, 3.656370383265421*^9}, {3.656370436613409*^9, 
  3.656370437116877*^9}, {3.656370627431078*^9, 3.6563706287172747`*^9}, {
  3.687785433903346*^9, 3.6877854341506433`*^9}}],

Cell[TextData[{
 StyleBox["5.)",
  FontColor->RGBColor[1, 0, 0]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["F", "\[RightVector]"], "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"sin", "(", 
       RowBox[{"x", " ", "y"}], ")"}], " ", 
      OverscriptBox["i", "^"]}], " ", "+", 
     RowBox[{"y", " ", 
      RowBox[{"sin", "(", 
       RowBox[{"x", " ", "y"}], ")"}], " ", 
      OverscriptBox["j", "^"]}]}]}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.656370248623249*^9, 3.6563703431699963`*^9}, {
  3.656370379052232*^9, 3.656370383265421*^9}, {3.6563706369353848`*^9, 
  3.65637070125063*^9}, {3.687785436079257*^9, 3.687785436479299*^9}}],

Cell[TextData[{
 StyleBox["6.)",
  FontColor->RGBColor[1, 0, 0]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["F", "\[RightVector]"], "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"y", " ", 
      RowBox[{"sin", "(", 
       RowBox[{"x", " ", "y"}], ")"}], " ", 
      OverscriptBox["i", "^"]}], " ", "+", 
     RowBox[{"x", " ", 
      RowBox[{"sin", "(", 
       RowBox[{"x", " ", "y"}], ")"}], " ", 
      OverscriptBox["j", "^"]}]}]}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.656370248623249*^9, 3.6563703431699963`*^9}, {
  3.656370379052232*^9, 3.656370383265421*^9}, {3.6563706369353848`*^9, 
  3.65637070125063*^9}, {3.656370741617792*^9, 3.656370755930867*^9}, {
  3.687785438807805*^9, 3.687785439071035*^9}}],

Cell[TextData[{
 StyleBox["7.)",
  FontColor->RGBColor[1, 0, 0]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["F", "\[RightVector]"], "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "x"}], "+", "y"}], ")"}], " ", 
      OverscriptBox["i", "^"]}], " ", "+", 
     RowBox[{"(", 
      RowBox[{"x", "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["y", "2"], " ", 
        OverscriptBox["j", "^"]}]}]}]}]}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.656370248623249*^9, 3.6563703431699963`*^9}, {
  3.656370379052232*^9, 3.656370383265421*^9}, {3.6563706369353848`*^9, 
  3.65637070125063*^9}, {3.656370741617792*^9, 3.656370755930867*^9}, {
  3.65637237304386*^9, 3.656372407458684*^9}, {3.656372505275714*^9, 
  3.656372505768654*^9}, {3.6877854413419237`*^9, 3.687785442599062*^9}}],

Cell[TextData[{
 StyleBox["\[LineSeparator]\[LineSeparator]\[LineSeparator]8.)",
  FontColor->RGBColor[1, 0, 0]],
 " Consider this vector function of ",
 StyleBox["three",
  FontWeight->"Bold"],
 " variables,\[LineSeparator]\[LineSeparator]",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["F", "\[RightVector]"], "(", 
     RowBox[{"x", ",", "y", ",", "z"}], ")"}], "=", 
    RowBox[{
     RowBox[{"y", " ", "z", " ", 
      SuperscriptBox["e", 
       RowBox[{"x", " ", "y", " ", "z"}]], " ", 
      OverscriptBox["i", "^"]}], "+", 
     RowBox[{"x", " ", "z", " ", 
      SuperscriptBox["e", 
       RowBox[{"x", " ", "y", " ", "z"}]], " ", 
      OverscriptBox["j", "^"]}], "+", 
     RowBox[{"x", " ", "y", " ", 
      SuperscriptBox["e", 
       RowBox[{"x", " ", "y", " ", "z"}]], " ", 
      OverscriptBox["k", "^"]}]}]}], TraditionalForm]]],
 "\[LineSeparator]\[LineSeparator]Make a conjecture about how to test such a \
3-D vector field to see if it\[CloseCurlyQuote]s the gradient of a 3-D \
potential function. \[LineSeparator]\[LineSeparator]Try out your test.  \
\[LineSeparator]\[LineSeparator]Find the potential function for this gradient \
field, if possible.\[LineSeparator]"
}], "Text",
 CellChangeTimes->{{3.656371137299534*^9, 3.6563711594742327`*^9}, {
   3.656371256295599*^9, 3.656371458091386*^9}, {3.656371492042285*^9, 
   3.656371585776613*^9}, 3.656371618306664*^9, {3.65637220243845*^9, 
   3.6563722028951597`*^9}, {3.656372508440851*^9, 3.656372514409731*^9}, {
   3.6877854457358*^9, 3.687785446255616*^9}, {3.687785790337574*^9, 
   3.68778582560785*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{716, 730},
WindowMargins->{{25, Automatic}, {Automatic, 26}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.5,
FrontEndVersion->"11.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 28, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 482, 8, 184, "Section"],
Cell[1064, 32, 1448, 42, 112, "Text"],
Cell[CellGroupData[{
Cell[2537, 78, 161, 3, 64, "Item"],
Cell[2701, 83, 542, 18, 67, "Item"],
Cell[3246, 103, 188, 4, 64, "Item"],
Cell[3437, 109, 369, 10, 77, "Item"]
}, Open  ]],
Cell[3821, 122, 169, 2, 43, "Text"],
Cell[3993, 126, 595, 18, 68, "Text"],
Cell[CellGroupData[{
Cell[4613, 148, 238, 7, 48, "Input"],
Cell[4854, 157, 208, 6, 69, "Output"]
}, Open  ]],
Cell[5077, 166, 165, 2, 70, "Text"],
Cell[CellGroupData[{
Cell[5267, 172, 327, 8, 48, "Input"],
Cell[5597, 182, 255, 7, 65, "Output"]
}, Open  ]],
Cell[5867, 192, 387, 6, 132, "Text"],
Cell[CellGroupData[{
Cell[6279, 202, 1505, 36, 173, "Input"],
Cell[7787, 240, 43327, 923, 521, "Output"],
Cell[51117, 1165, 49980, 854, 521, "Output"],
Cell[101100, 2021, 93140, 1757, 521, "Output"]
}, Open  ]],
Cell[194255, 3781, 946, 18, 202, "Text"],
Cell[CellGroupData[{
Cell[195226, 3803, 561, 15, 68, "Item"],
Cell[195790, 3820, 613, 10, 134, "Item"]
}, Open  ]],
Cell[196418, 3833, 363, 9, 80, "Input"],
Cell[196784, 3844, 312, 8, 48, "Input"],
Cell[197099, 3854, 553, 15, 178, "Text"],
Cell[CellGroupData[{
Cell[197677, 3873, 255, 3, 194, "Subsubsection"],
Cell[197935, 3878, 512, 14, 98, "Text"],
Cell[198450, 3894, 812, 24, 94, "Text"],
Cell[199265, 3920, 1230, 44, 200, "Text"],
Cell[200498, 3966, 697, 20, 92, "Text"],
Cell[201198, 3988, 314, 4, 43, "Text"],
Cell[CellGroupData[{
Cell[201537, 3996, 243, 9, 49, "Item"],
Cell[201783, 4007, 370, 12, 49, "Item"]
}, Open  ]],
Cell[202168, 4022, 639, 12, 123, "Text"],
Cell[CellGroupData[{
Cell[202832, 4038, 209, 6, 67, "Item"],
Cell[203044, 4046, 534, 16, 129, "Item"],
Cell[203581, 4064, 565, 9, 205, "Item"]
}, Open  ]],
Cell[204161, 4076, 638, 20, 52, "Text"],
Cell[204802, 4098, 738, 21, 52, "Text"],
Cell[205543, 4121, 744, 22, 52, "Text"],
Cell[206290, 4145, 793, 23, 52, "Text"],
Cell[207086, 4170, 921, 26, 60, "Text"],
Cell[208010, 4198, 1612, 37, 392, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

