(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     51993,       1134]
NotebookOptionsPosition[     50929,       1095]
NotebookOutlinePosition[     51283,       1111]
CellTagsIndexPosition[     51240,       1108]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Lab 09 - Vector Line Integrals", "Chapter"],
 "\n[Names]"
}], "Section",
 CellChangeTimes->{{3.656971013739675*^9, 3.656971032431258*^9}}],

Cell[TextData[{
 "Writing a force field as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["F", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{"P", " ", 
      OverscriptBox["i", "^"]}], "+", 
     RowBox[{"Q", 
      OverscriptBox["j", "^"]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", the vector line integral over some path ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " can be written in at least two ways:"
}], "Text",
 CellChangeTimes->{{3.6569711578243437`*^9, 3.6569711578328667`*^9}, {
  3.656971315194512*^9, 3.656971481827832*^9}, {3.656971746919779*^9, 
  3.656971759431365*^9}, {3.65697200288282*^9, 3.656972036351327*^9}, {
  3.65697307772272*^9, 3.656973088824274*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       SubscriptBox["\[Integral]", "C"], 
       RowBox[{
        OverscriptBox["F", "\[RightVector]"], "\[CenterDot]", 
        RowBox[{"\[DifferentialD]", 
         OverscriptBox["r", "\[RightVector]"]}]}]}], "=", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Integral]", "C"], 
        RowBox[{"P", 
         RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
       RowBox[{
        SubscriptBox["\[Integral]", "C"], 
        RowBox[{"Q", 
         RowBox[{"\[DifferentialD]", "y"}]}]}]}]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.656971177789153*^9, 3.656971189526705*^9}, {
  3.6569712501048822`*^9, 3.65697128780503*^9}, {3.656971504692675*^9, 
  3.6569716120906057`*^9}, {3.656971642369378*^9, 3.656971691173855*^9}, {
  3.656971721865453*^9, 3.656971735872039*^9}, {3.656972044293046*^9, 
  3.65697206512099*^9}, {3.656973064643086*^9, 3.6569730677709913`*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {GridBox[{
          {
           RowBox[{
            RowBox[{
             SubscriptBox["\[Integral]", "C"], 
             RowBox[{
              OverscriptBox["F", "\[RightVector]"], "\[CenterDot]", 
              RowBox[{"\[DifferentialD]", 
               OverscriptBox["r", "\[RightVector]"]}]}]}], "=", 
            RowBox[{
             SubscriptBox["\[Integral]", "C"], 
             RowBox[{
              RowBox[{
               RowBox[{
                OverscriptBox["F", "\[RightVector]"], "(", 
                RowBox[{
                 RowBox[{"x", "(", "t", ")"}], ",", 
                 RowBox[{"y", "(", "t", ")"}]}], ")"}], "\[CenterDot]", 
               RowBox[{
                OverscriptBox["r", "\[RightVector]"], "'"}]}], 
              RowBox[{"\[DifferentialD]", "t"}]}]}]}]}
         },
         GridBoxItemSize->{"Columns" -> {{
              Scaled[0.96]}}}]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.656973027765505*^9, 3.65697304724399*^9}}],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["r", "\[RightVector]"], "'"}], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      FractionBox[
       RowBox[{"\[PartialD]", "x"}], 
       RowBox[{"\[PartialD]", "t"}]], ",", 
      FractionBox[
       RowBox[{"\[PartialD]", "y"}], 
       RowBox[{"\[PartialD]", "t"}]]}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 ".  Use whichever of these expressions is most useful in evaluating the \
following line integrals. \[LineSeparator]\[LineSeparator]\[LineSeparator]\
\[LineSeparator]\[LineSeparator]\[LineSeparator]Write down the answers you \
get here in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook, but attach paper showing your work (and labelled according to \
question number) to a printout of the notebook.   "
}], "Text",
 CellChangeTimes->{{3.656972076088266*^9, 3.656972162994021*^9}, {
  3.656972197406622*^9, 3.6569722351643133`*^9}, {3.656973173609763*^9, 
  3.6569732897889633`*^9}, {3.656977044703743*^9, 3.656977152119116*^9}}],

Cell[TextData[{
 StyleBox["1.)",
  FontColor->RGBColor[1, 0, 0]],
 " Consider the force field ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     OverscriptBox["F", "\[RightVector]"], "1"], "=", 
    RowBox[{
     RowBox[{
      OverscriptBox["r", "\[RightVector]"], "-", 
      RowBox[{"2", 
       OverscriptBox["i", "^"]}]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"x", 
        OverscriptBox["i", "^"]}], "+", 
       RowBox[{"y", 
        OverscriptBox["j", "^"]}], "-", 
       RowBox[{"2", 
        OverscriptBox["i", "^"]}]}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "2"}], ")"}], 
        OverscriptBox["i", "^"]}], "+", 
       RowBox[{"y", 
        OverscriptBox["j", "^"]}]}]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". Evaluate the vector line integral of this force field along the path ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ": the straight line from (-1,0) to (0,1). \n\n[",
 StyleBox["Hint: ",
  FontWeight->"Bold"],
 "It\[CloseCurlyQuote]s probably easiest to do this using the first relation \
above.] "
}], "Text",
 CellChangeTimes->{{3.656972306468255*^9, 3.656972318856328*^9}, {
   3.656972363926916*^9, 3.65697240425766*^9}, {3.656972525544425*^9, 
   3.656972607964374*^9}, {3.656972640455731*^9, 3.656972675925728*^9}, {
   3.656972761893015*^9, 3.6569728618913193`*^9}, {3.656972981734935*^9, 
   3.656973001243932*^9}, {3.65697310425597*^9, 3.656973129854751*^9}, {
   3.656973163442672*^9, 3.6569731686903563`*^9}, 3.656973326652924*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C1", "=", 
  RowBox[{"ParametricPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"x", "+", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
    1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJxVjH881Hccx09KKDQzF0Zu0a/ViCkrPd6YqSUeToqWLb9qbj386OFHbGp+
lvxYFqemZh4ciZJMJpl3fsyvcHaHu9A557of7txXQ0lk2vb9Y+/H4/P4vJ+P
9+v1pAWGe51cQaFQ3Jff2//fmUJyM3+qwY5fJJaZ2nnR6GNwqtcpeDW/zAuG
y+wCSVEmDtOzJHvDSvmuWImC5GDQ4oROdfMITHj9lqNAnzUs/OkuySlgeeC3
JtsTBPr/w7nA7ZpfElapsM/rMGXqOQtiH21nmuiqMGHO9o6r2V1wMeRlXQyb
RKH7/h9bMmogv1RHPbRJidaPr0ivzjwAyS0b9ugGJfZVfXNBTQ3hoXSc2h2h
QIOAiEK2QzPUpeq0ylsn0FzeSfgqW6Eiz7I912ICvUsY47dD22GLqNP1QYwc
/c/yxcaWXXC90M/0dL8Mc89lpR+u7AY7/NrHw06G29UDitq2seHY+iWdijQp
erDVxLdUfRApTjFhSiVovPtFx4A1B6iKvJI5ewlytnJqdH/ggohOy8nKeoYO
fr8/EYv7ofjDfN7dSTHWlz32LLQYBBX8cs3NUYwWCU29Id/zwKr9SlVUwTgW
nRkqMGzhw3ya/mdUQoRrVUPRf9KGQFmuvU/hLMIt5ROpW78dhn54nnGoaAx9
E0xlpx6OgKtesM/mGSFGje2m36MKoJL+R9xluhBZftFrx/xG4TvZviV68Cg2
rwmg8NyFcKdIa2WstgDLP3q92DIvhG7n6tq69hHMF5SyNt4Ygzc+kYFKxjCq
ebf1armJ4PwOy4Ek/SF0YoQyG1+IQCH7ddaWw8f0NZtWSfLG4bTRcT1+DA8P
RnrN5biIgW81OphnM4gGIdm5NRIx5Gh4n6yb6cfahSM9xanPINBrTNl9nYvs
o5cvGdlIwDTF7YOFYxz8a9+QSo0rAcW2Xk+zxT5Mn7jGi0iUwqHw41/UhrFx
hwWD4WUhA3+thcJZohvLFh9dXdEqg/ysnifGe7sw/0bm55+ckcOdp75h0TXt
yOxgsET6EyClvjd7/2UratTXJ+k3T0Ajp1qrYX8zerrlLK4LU8BItcGMKgOR
xThHS9JVwqVcywc736/HcPfhjrgGJch0yu1GNe/jp40HjcRfTUJS2vMeql4V
TvU6aZi+mYS+SjumvVcJvltyO2akXAWUOcH8jvN56Ki5NVv3EAHm8dPOdhZ5
uCFYdkTgQYAjRTPDoYuJb/CmSSWdgATNnSZuhkxsOLvpprsPARSj5L0hlTlo
L93YmBm4zHs2xxcJstG6zUypHUf857+A5ikGB1aXkr5UXBrl6vDKSF8qCvbm
cEsrSF8y3ph+54TrPdKXgOuD9GJSG0hfDK5z1mapc8l+NBI/dzK4A2Q/Entf
pVkV88l+BGbeW/3QWUD2T6EmbRUnUU7mg1Aa33qVriTz/tjGT/6SRpD5o5iS
vUL+aIa8e2KQsqky+yV5d0XnA4lR/vMk70Iay3GP9eIy/2+m4G/cqYaH
     "]]}},
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"ScalingFunctions" -> None},
  PlotRange->{{-1., 0.}, {0., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.656972932995717*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["2.)",
  FontColor->RGBColor[1, 0, 0]],
 " Evaluate the vector line integral of the same force field, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     OverscriptBox["F", "\[RightVector]"], "1"], ","}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " but this time along the path ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ": the portion of a radius one circle, traversed in counterclockwise \
direction from (-1,0) to (0,1). \n\n[",
 StyleBox["Hint: ",
  FontWeight->"Bold"],
 "It\[CloseCurlyQuote]s probably easiest to do this one using the ",
 StyleBox["second",
  FontSlant->"Italic"],
 " relation above, and using the parameter \[Theta] instead of ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". You can use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to evaluate any trig-function-containing integrals you come up with.] "
}], "Text",
 CellChangeTimes->{{3.656972306468255*^9, 3.656972318856328*^9}, {
   3.656972363926916*^9, 3.65697240425766*^9}, {3.656972525544425*^9, 
   3.656972607964374*^9}, {3.656972640455731*^9, 3.656972675925728*^9}, {
   3.656972761893015*^9, 3.6569728618913193`*^9}, {3.656972981734935*^9, 
   3.656973001243932*^9}, {3.65697310425597*^9, 3.656973129854751*^9}, {
   3.656973163442672*^9, 3.6569731686903563`*^9}, 3.656973326652924*^9, {
   3.656973546778804*^9, 3.6569737083758717`*^9}, {3.6569769267503443`*^9, 
   3.656976974480692*^9}, {3.656977342601871*^9, 3.656977362731275*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C2", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", 
       RowBox[{"-", "\[Pi]"}], ",", 
       RowBox[{
        RowBox[{"+", "\[Pi]"}], "/", "2"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.656956090312714*^9, 3.656956271244739*^9}, {
  3.6569563347751007`*^9, 3.656956348911059*^9}, {3.65697226326414*^9, 
  3.6569722676749477`*^9}, {3.656972910779861*^9, 3.656972927464664*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
    1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJwtmnc4lm/Yx9UvbRVlpTRltUnSOIlSSWRWktIgpYgGyWpYESrZZO+9sk57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     "]]}},
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"ScalingFunctions" -> None},
  PlotRange->{{-1., 0.9999997913989683}, {-0.9999997487903937, 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.656956178115161*^9, 3.65695627180857*^9, {3.656956336206358*^9, 
   3.656956349743877*^9}, 3.656972920150062*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["\[LineSeparator]3.)",
  FontColor->RGBColor[1, 0, 0]],
 " Plot the vector field ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    OverscriptBox["F", "\[RightVector]"], "1"], TraditionalForm]]],
 " (use red arrows, see Lab 08) together with the integration paths ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]]],
 "and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]]],
 ".  Do the *signs* of your vector line integrals match your visual \
estimation of their signs?"
}], "Text",
 CellChangeTimes->{{3.656974023963484*^9, 3.6569741931006393`*^9}, {
   3.656974379577422*^9, 3.656974386969709*^9}, 3.656974675628058*^9}],

Cell[TextData[{
 StyleBox["\[LineSeparator]4.)",
  FontColor->RGBColor[1, 0, 0]],
 " Could ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    OverscriptBox["F", "\[RightVector]"], "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "be the gradient of some potential function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "1"], "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "?  Carry out the curl test to decide. (Show the results of your test).  \
Investigate how to use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s ",
 StyleBox["Curl[....]",
  FontFamily->"Courier New"],
 " function to confirm. Would you have guessed this result (well, whether it\
\[CloseCurlyQuote]s positive, zero or negative) by looking at the graph of \
the vector field arrows? \[LineSeparator]\[LineSeparator]If the field is \
\[OpenCurlyDoubleQuote]irrotational\[CloseCurlyDoubleQuote], find a potential \
function ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     OverscriptBox["F", "\[RightVector]"], "1"], "=", 
    RowBox[{
     OverscriptBox["\[Del]", "\[RightVector]"], 
     SubscriptBox["f", "1"]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " and make a plot which includes the integration paths, the vector field of \
arrows *and* a ",
 StyleBox["ContourPlot[...]",
  FontFamily->"Courier New"],
 " of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "-- all together in the same figure."
}], "Text",
 CellChangeTimes->{{3.656973806279407*^9, 3.6569738076132708`*^9}, {
  3.656973848331924*^9, 3.656973951898099*^9}, {3.656974226426752*^9, 
  3.6569743728102827`*^9}, {3.6569745393270493`*^9, 3.65697467281264*^9}, {
  3.656976213537038*^9, 3.656976241734091*^9}, {3.656976290142057*^9, 
  3.6569763078195047`*^9}, {3.656976382374201*^9, 3.65697641189095*^9}, {
  3.656976599214428*^9, 3.656976599622601*^9}, {3.656977199202482*^9, 
  3.656977235297171*^9}}],

Cell[TextData[{
 StyleBox["\[LineSeparator]5.)",
  FontColor->RGBColor[1, 0, 0]],
 " If the potential function exists, calculate the surface height difference ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["f", "1"], "(", 
     RowBox[{"0", ",", "1"}], ")"}], "-"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "1"], "(", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0"}], ")"}], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.6569744341118107`*^9, 3.656974505921797*^9}, 
   3.656974668860033*^9, {3.656976602589921*^9, 3.656976603045815*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"c1", ",", "c2"}], "]"}]], "Input",
 CellChangeTimes->{{3.6569562864141417`*^9, 3.656956289518857*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJwtmnc4lm/Yx9UvbRVlpTRltUnSOIlSSWRWktIgpYgGyWpYESrZZO+9sk57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      "]]}}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJxVjH881Hccx09KKDQzF0Zu0a/ViCkrPd6YqSUeToqWLb9qbj386OFHbGp+
lvxYFqemZh4ciZJMJpl3fsyvcHaHu9A557of7txXQ0lk2vb9Y+/H4/P4vJ+P
9+v1pAWGe51cQaFQ3Jff2//fmUJyM3+qwY5fJJaZ2nnR6GNwqtcpeDW/zAuG
y+wCSVEmDtOzJHvDSvmuWImC5GDQ4oROdfMITHj9lqNAnzUs/OkuySlgeeC3
JtsTBPr/w7nA7ZpfElapsM/rMGXqOQtiH21nmuiqMGHO9o6r2V1wMeRlXQyb
RKH7/h9bMmogv1RHPbRJidaPr0ivzjwAyS0b9ugGJfZVfXNBTQ3hoXSc2h2h
QIOAiEK2QzPUpeq0ylsn0FzeSfgqW6Eiz7I912ICvUsY47dD22GLqNP1QYwc
/c/yxcaWXXC90M/0dL8Mc89lpR+u7AY7/NrHw06G29UDitq2seHY+iWdijQp
erDVxLdUfRApTjFhSiVovPtFx4A1B6iKvJI5ewlytnJqdH/ggohOy8nKeoYO
fr8/EYv7ofjDfN7dSTHWlz32LLQYBBX8cs3NUYwWCU29Id/zwKr9SlVUwTgW
nRkqMGzhw3ya/mdUQoRrVUPRf9KGQFmuvU/hLMIt5ROpW78dhn54nnGoaAx9
E0xlpx6OgKtesM/mGSFGje2m36MKoJL+R9xluhBZftFrx/xG4TvZviV68Cg2
rwmg8NyFcKdIa2WstgDLP3q92DIvhG7n6tq69hHMF5SyNt4Ygzc+kYFKxjCq
ebf1armJ4PwOy4Ek/SF0YoQyG1+IQCH7ddaWw8f0NZtWSfLG4bTRcT1+DA8P
RnrN5biIgW81OphnM4gGIdm5NRIx5Gh4n6yb6cfahSM9xanPINBrTNl9nYvs
o5cvGdlIwDTF7YOFYxz8a9+QSo0rAcW2Xk+zxT5Mn7jGi0iUwqHw41/UhrFx
hwWD4WUhA3+thcJZohvLFh9dXdEqg/ysnifGe7sw/0bm55+ckcOdp75h0TXt
yOxgsET6EyClvjd7/2UratTXJ+k3T0Ajp1qrYX8zerrlLK4LU8BItcGMKgOR
xThHS9JVwqVcywc736/HcPfhjrgGJch0yu1GNe/jp40HjcRfTUJS2vMeql4V
TvU6aZi+mYS+SjumvVcJvltyO2akXAWUOcH8jvN56Ki5NVv3EAHm8dPOdhZ5
uCFYdkTgQYAjRTPDoYuJb/CmSSWdgATNnSZuhkxsOLvpprsPARSj5L0hlTlo
L93YmBm4zHs2xxcJstG6zUypHUf857+A5ikGB1aXkr5UXBrl6vDKSF8qCvbm
cEsrSF8y3ph+54TrPdKXgOuD9GJSG0hfDK5z1mapc8l+NBI/dzK4A2Q/Entf
pVkV88l+BGbeW/3QWUD2T6EmbRUnUU7mg1Aa33qVriTz/tjGT/6SRpD5o5iS
vUL+aIa8e2KQsqky+yV5d0XnA4lR/vMk70Iay3GP9eIy/2+m4G/cqYaH
      "]]}}},
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"ScalingFunctions" -> None},
  PlotRange->{{-1., 0.9999997913989683}, {-0.9999997487903937, 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.656956289945361*^9, 3.656956354976851*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["6-10.)",
  FontColor->RGBColor[1, 0, 0]],
 " Repeat the sections 1-5.) with the same curves ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]]],
 "and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]]],
 ", but this time with the vector field ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     OverscriptBox["F", "\[RightVector]"], "2"], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "y"}], "-", 
        FractionBox["1", "2"]}], ")"}], 
      OverscriptBox["i", "^"]}], "+", 
     RowBox[{
      SuperscriptBox["x", "3"], 
      OverscriptBox["j", "^"]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ".  (And try to find a potential called ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " if possible.)"
}], "Text",
 CellChangeTimes->{{3.656976563729374*^9, 3.656976617869164*^9}, {
  3.6569767029722557`*^9, 3.6569768881185102`*^9}, {3.656977252032057*^9, 
  3.65697728510292*^9}}],

Cell[TextData[{
 StyleBox["11.)",
  FontColor->RGBColor[1, 0, 0]],
 " Back to the first vector field, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    OverscriptBox["F", "\[RightVector]"], "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ":  Carry out a vector line integration of this vector field from the origin \
to a point with coordinates ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", "0"], ",", 
     SubscriptBox["y", "0"]}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " along a path with two segments:  \n\nFirst go along the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " axis from (0,0) to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", "0"], ",", "0"}], ")"}], TraditionalForm]]],
 ".  \n\nNext go from (",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "0"], TraditionalForm]]],
 ",0) to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", "0"], ",", 
     SubscriptBox["y", "0"]}], ")"}], TraditionalForm]]],
 ".  This second path is parallel to the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " axis. \n\nNow, replace ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "0"], "\[ShortRightArrow]", "x"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["y", "0"], "\[ShortRightArrow]", "y"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ".  Comment on the result."
}], "Text",
 CellChangeTimes->{{3.656977544117826*^9, 3.6569778417632723`*^9}, {
  3.65697788763245*^9, 3.656977922502276*^9}, {3.656977955893592*^9, 
  3.656977992307682*^9}}]
}, Open  ]]
},
WindowSize->{808, 871},
WindowMargins->{{12, Automatic}, {Automatic, 24}},
FrontEndVersion->"10.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (June 27, \
2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 165, 4, 106, "Section"],
Cell[748, 28, 760, 21, 54, "Text"],
Cell[1511, 51, 1037, 26, 40, "Text"],
Cell[2551, 79, 1184, 32, 42, "Text"],
Cell[3738, 113, 1085, 27, 79, "Text"],
Cell[4826, 142, 1626, 46, 94, "Text"],
Cell[CellGroupData[{
Cell[6477, 192, 276, 9, 28, "Input"],
Cell[6756, 203, 2265, 47, 375, "Output"]
}, Open  ]],
Cell[9036, 253, 1590, 38, 114, "Text"],
Cell[CellGroupData[{
Cell[10651, 295, 659, 17, 46, "Input"],
Cell[11313, 314, 15705, 268, 375, "Output"]
}, Open  ]],
Cell[27033, 585, 696, 20, 74, "Text"],
Cell[27732, 607, 2159, 59, 179, "Text"],
Cell[29894, 668, 650, 20, 51, "Text"],
Cell[CellGroupData[{
Cell[30569, 692, 150, 3, 28, "Input"],
Cell[30722, 697, 17319, 294, 375, "Output"]
}, Open  ]],
Cell[48056, 994, 1091, 37, 62, "Text"],
Cell[49150, 1033, 1763, 59, 176, "Text"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
