<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
11.6 - Bagels
</title>
<meta name="week" content="">

<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>
<link rel="stylesheet" href="0g/handoutprint.css" type="text/css" media="print" />
<h2>
11.6 - Bagels, bagels, bagels
</h2>
<p>See Tom Gauld's cartoon "<a href="https://www.newscientist.com/article/2419266-tom-gauld-on-a-feeling-of-inferiority/">...Torus never stopped feeling inferior...</a>".

<p>There are many ways to create bagels. Some people prefer boiling them, some prefer baking them, and some prefer defrosting then toasting them. Today we shall be creating bagels by the method of parameterizing them.
<!--
<p>In single-variable calculus, it was shown that one can compute the volume of a torus, or doughnut shape, by thinking of it as a circle rotated about a horizontal or vertical line.
-->

<ol>
<li> Parameterize a circle of radius $2$ centered at the origin in the $xy$-plane starting at $(0, r)$. That is, find $x$, $y$, and $z$ in terms of $2$ and $\alpha$.  Let $\alpha$ be the angle between the position vector and the $y$-axis.<br>
<img src="0g/10.5.bagel1.jpg"><br>


<li>Parameterize a circle of radius 1 in the $yz$-plane with center (2, 0) starting at (0, 3). Let $\beta$ be the angle between the position vector and the positive $y$-axis.<br>
<img src="0g/10.5.bagel2.jpg"><br>
<li style="page-break-before:always">
Now we want to characterize a typical point on our bagel, 
so we can write a vector function $\myv r (\alpha, \beta)$ whose range is the entire breakfast treat. To find any specific point we

(a) Move $\alpha$ radians along the horizontal curve, then (b) Rotate $\beta$ radians along the vertical curve. <br>
<img src="0g/10.5.bagel3.jpg"><br>
Find the coordinates of a point on the surface of the bagel parameterized by $\alpha\to u$ and $\beta\to v$.  That is, find $x$, $y$, and $z$ functions,
$$\myv r(\alpha, \beta)=\langle(x(\alpha,\beta), y(\alpha,\beta), z(\alpha,\beta)\rangle.$$


 Then find limits on the parameters so that we can tell GeoGebra to plot a surface like...
<tt>
Surface( myx($u$,$v$), myy($u$,$v$),myz($u$,$v$),
        $u$, ___,___, $v$, ___,___)
</tt>
Find the three coordinate functions, and fill in the min and max limits of $\alpha\to u$ and $\beta\to v$. 

</ol>

<p style="page-break-before:always">
[Here's Norm Prokup's <a href="https://www.geogebra.org/m/hbYvw5Sp">Geogebra torus</a> with major radius=5 and minor radius 2.]
<div class="justme">
My Geogebra one with major radius 3 and minor radius 2:
$$\myv r(u,v)=+(3+2\cos v)\cos u\,\uv x +(3+2\cos v)\sin u\,\uv y +2\sin v\,\uv x$$

From this, I can calculate the tangent vectors...
$$\myv r_u = \langle (3+2\cos v)(-\sin u), (3+2\cos v)\sin u), 0 \rangle$$
$$\myv r_v = \langle -2\sin v\cos u,-2\sin v\sin u, 2\cos v\rangle$$
</div>

<p>To calculate the surface area...

<ul><li>Calculate $\myv r_u$ and $\myv r_v$
<li>Notice that they are at right angles to each other!
<iframe src="https://www.geogebra.org/3d/nzy4caqp?embed" width="800" height="600" allowfullscreen style="border: 1px solid #e4e4e4;border-radius: 4px;" frameborder="0"></iframe>
<li>...So, the magnitude $|\myv r_u\times\myv r_v|=|\myv r_u|*|\myv r_v|$
</ul>


<?php include "../../classes/3.h" ?>
